/***************************************************************************
*   NAME:  SNDSYS.H $Revision: 1.2 $
**  COPYRIGHT:
**  "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: sndsys.h $
* Revision 1.2  1995/03/01 17:50:13  teckert
* Added file header
* Revision 1.1  1995/02/23 15:14:59  sdsmith
* Initial revision
***************************************************************************/
#define INI_SOUND               "sndsys.ini"
#define INI_DRIVER              "Driver"

#define INI_STR_LEFTMASTER        "LeftMasterVol"
#define INI_STR_RIGHTMASTER       "RightMasterVol"
#define INI_STR_LEFTLINEIN        "LeftLineInVol"
#define INI_STR_RIGHTLINEIN       "RightLineInVol"
#define INI_STR_LEFTDAC           "LeftDACVol"
#define INI_STR_RIGHTDAC          "RightDACVol"
#define INI_STR_LEFTWAVEADCMIC    "LeftWaveADCMicVol"
#define INI_STR_RIGHTWAVEADCMIC   "RightWaveADCMicVol"
#define INI_STR_LEFTWAVEADCLINE   "LeftWaveADCLineVol"
#define INI_STR_RIGHTWAVEADCLINE  "RightWaveADCLineVol"
#define INI_STR_WAVEADCSOURCE     "WaveADCSource"
#define INI_DEF_WAVEADCSOURCE     INI_INPUT_MIC

#define INI_STR_LEFTVOICEADCMIC   "LeftVoiceADCMicVol"
#define INI_STR_RIGHTVOICEADCMIC  "RightVoiceADCMicVol"
#define INI_STR_LEFTVOICEADCLINE  "LeftVoiceADCLineVol"
#define INI_STR_RIGHTVOICEADCLINE "RightVoiceADCLineVol"
#define INI_STR_VOICEADCSOURCE    "VoiceADCSource"
#define INI_DEF_VOICEADCSOURCE    INI_INPUT_MIC

#define INI_STR_LEFTSYNTH         "LeftSynthVol"
#define INI_STR_RIGHTSYNTH        "RightSynthVol"

#define INI_STR_DMADAC          "DMADAC"
#define INI_STR_DMAADC          "DMAADC"
#define INI_STR_IOADDRESS       "IOAddress"
#define INI_STR_INTERRUPT       "Interrupt"
#define INI_STR_MUTE            "Mute"
#define INI_STR_MUTEMSG         "StartupMuteMsg"
#define INI_STR_PATCHLIB        "Patches"

#define INI_YES                 "Yes"
#define INI_NO                  "No"

#define INI_STR_SINGLEMODEDMA     "SingleModeDMA"
#define INI_STR_ACCEPTCLOSERATES  "AcceptCloseSamplingRates"
#define INI_STR_MSFTHARDWARE      "Msft Hardware"
#define INI_STR_MSFTSUPPORT       "Msft Support"
#define INI_STR_AUTOSELECT        "Auto Select"
#define INI_STR_MIDIPLAY          "MIDI Play"
#define INI_STR_DMAPREFIX         "DMA 0"
#define INI_POS_DMAVALUE          4
#define INI_STR_DEFAULTDMA        "Default DMA"
#define INI_STR_IOPREFIX          "I/O 530"
#define INI_POS_IOVALUE           4
#define INI_STR_DEFAULTIO         "Default I/O"
#define INI_STR_IRQPREFIX         "IRQ 11"
#define INI_POS_IRQVALUE          4
#define INI_STR_DEFAULTIRQ        "Default IRQ"
#define INI_TRUE                  "TRUE"
#define INI_FALSE                 "FALSE"
#define INI_ON                    "ON"
#define INI_OFF                   "OFF"

#define INI_DEF_LEFTMASTER      32767
#define INI_DEF_RIGHTMASTER     32767
#define INI_DEF_LEFTLINEIN      32767
#define INI_DEF_RIGHTLINEIN     32767
#define INI_DEF_LEFTDAC         32767
#define INI_DEF_RIGHTDAC        32767
#define INI_DEF_LEFTADC         32767
#define INI_DEF_RIGHTADC        32767
#define INI_DEF_LEFTSYNTH       32767
#define INI_DEF_RIGHTSYNTH      32767

#define INI_DEF_DMADAC          (1)
#define INI_DEF_DMAADC          (1)
#define INI_DEF_IOADDRESS       (0x530)
#define INI_DEF_INTERRUPT       (7)

#define INI_DEF_MUTE            INI_NO
#define INI_DEF_MUTEMSG         INI_NO

/**********************************************************************
multimedia product ID specification, etc. */

#define MID_MICROSOFT      (MM_MICROSOFT)
#define DRV_VERSION        (0x200)
#define PID_WAVEIN         (MM_MSFT_WSS_WAVEIN)
#define PID_WAVEOUT        (MM_MSFT_WSS_WAVEOUT)
#define PID_SYNTH          (MM_MSFT_WSS_FMSYNTH_STEREO)
#define PID_MIXER          (MM_MSFT_WSS_MIXER)
#define PID_AUX            (MM_MSFT_WSS_AUX)

//
//  WSS specific MIXERLINE flags placed in MIXERLINE.dwUser field. these
//  flags are used by the WSS mixer application and Voice Pilot. these
//  flags are _ignored_ by any generic mixer application.
//
#define SNDSYS_MIXERLINE_LOWPRIORITY    (0x00000001L)

/***********************************************************************
Microsoft Windows Sound System specific messages */

#define MYBASE                  (0x4000)
#define WIDM_LOWPRIORITY                  (MYBASE+0x93)
#define DRV_GETWSSINFO          (DRV_USER + 0x878)

/***********************************************************************
record from */

#define INI_INPUT_LINEIN        "LineIn"
#define INI_INPUT_AUX           "Synth"
#define INI_INPUT_MIC           "MIC"
#define INI_INPUT_OUTPUT        "Feedback"

#define DATA_FMPATCHES          1234

#ifndef RC_INVOKED
#define RT_BINARY               MAKEINTRESOURCE( 256 )
#else
#define RT_BINARY               256
#endif

/* typedefs for MIDI patches */
#define NUMOPS                  (4)
#define PATCH_1_4OP             (0) /* use 4-operator patch */
#define PATCH_2_2OP             (1) /* use two 2-operator patches */
#define PATCH_1_2OP             (2) /* use one 2-operator patch */

typedef struct _operStruct {
    BYTE    bAt20;              /* flags which are send to 0x20 on fm */
    BYTE    bAt40;              /* flags seet to 0x40 */
				/* the note velocity & midi velocity affect total level */
    BYTE    bAt60;              /* flags sent to 0x60 */
    BYTE    bAt80;              /* flags sent to 0x80 */
    BYTE    bAtE0;              /* flags send to 0xe0 */
    } operStruct;

typedef struct _noteStruct {
    operStruct op[NUMOPS];      /* operators */
    BYTE    bAtA0[2];           /* send to 0xA0, A3 */
    BYTE    bAtB0[2];           /* send to 0xB0, B3 */
				/* use in a patch, the block should be 4 to indicate
				    normal pitch, 3 => octave below, etc. */
    BYTE    bAtC0[2];           /* sent to 0xc0, C3 */
    BYTE    bOp;                /* see PATCH_??? */
    BYTE    bDummy;             /* place holder */
    } noteStruct;


typedef struct _patchStruct {
    noteStruct note;            /* note. This is all in the structure at the moment */
    } patchStruct;
