;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   NAME:  VIWD.INC $Revision: 1.15 $
;;  COPYRIGHT:
;;  "Copyright (c) 1994,1995 by e-Tek Labs"
;;
;;       "This software is furnished under a license and may be used,
;;       copied, or disclosed only in accordance with the terms of such
;;       license and with the inclusion of the above copyright notice.
;;       This software or any other copies thereof may not be provided or
;;       otherwise made available to any other person. No title to and
;;       ownership of the software is hereby transfered."
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; $Log: viwd.inc $
; Revision 1.15  1995/11/24 12:44:16  teckert
; Added DriverDS field to the global data structure
; Revision 1.14  1995/11/22 14:51:42  teckert
; Added pending driver operation field to the global data structure
; Revision 1.13  1995/11/21 17:24:55  sdsmith
; Changes for new InitCallback function
; Revision 1.12  1995/11/20 16:27:05  teckert
; Added IW_KERNEL_SLEEP and IW_KERNEL_WAKE constants
; Revision 1.11  1995/10/12 19:29:04  teckert
; Added flags to support Direct Sound
; Revision 1.10  1995/09/21 14:07:38  teckert
; Added the Read_DMA_Count api call
; Revision 1.9  1995/09/08 11:04:12  teckert
; Added Windows 95 changes
; Revision 1.8  1995/09/06 13:39:44  teckert
; Added new api functions and reconfig code
; Revision 1.7  1995/05/04 17:18:50  teckert
; Added new pnp defines
; Revision 1.6  1995/04/18 15:33:36  teckert
; Updated device ID to VIWD code 33F0
; Revision 1.5  1995/04/14 10:31:43  teckert
; Revision 1.4  1995/04/10 13:45:39  teckert
; Added some sbos equates
; Revision 1.3  1995/04/06 18:43:00  teckert
; Added "Boss in a box" support
; Revision 1.2  1995/03/20 16:25:46  teckert
; Added file header and updated resource list and structures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; The version number of the driver
VIWD_VERMAJ         EQU     03h
VIWD_VERMIN         EQU     01h
VIWD_VERSION        EQU     ((VIWD_VERMAJ SHL 8) OR VIWD_VERMIN)
		       
VIWD_DEV_ID         EQU 33F0h

; DMA Buffer Allocation Parameters
MAXPHYS         EQU     0FFh
MINPHYS         EQU     0
ALIGNMASK       EQU     02h

; The dafault values for the system.ini entries
IWI_DEF_IRQ1            EQU 07h         ; default int 1
IWI_DEF_IRQ2            EQU 0Bh         ; default int 2
IWI_DEF_DMA1            EQU 05h         ; default DMA 1
IWI_DEF_DMA2            EQU 06h         ; default DMA 2
IWI_DEF_SYNTHBASE       EQU 220h        ; default synth base
IWI_DEF_CODECBASE       EQU 32Ch        ; default codec base
IWI_DEF_MPUBASE         EQU 330h        ; default MPU401 base
IWI_DEF_BUFSIZE         EQU 10h         ; default buffer size 16K


; The following Adlib ports are always at the same location
IW_PORT_UAACWR  EQU     388h
IW_PORT_UAADR   EQU     389h
		   
; The following group of ports will need to have P2XR added to them before
; the I/O handlers can be installed                   
IW_PORT_UMCR    EQU     0h
IW_PORT_U2X6R   EQU     06h
IW_PORT_UACWR   EQU     08h
IW_PORT_UADR    EQU     09h
IW_PORT_UACRR   EQU     0Ah
IW_PORT_UHRDP   EQU     0Bh
IW_PORT_UI2XCR  EQU     0Ch
IW_PORT_U2XCR   EQU     0Dh
IW_PORT_U2XER   EQU     0Eh
IW_PORT_URCR    EQU     0Fh

; The following group of ports will need to have P3XR added to them before
; the I/O handlers can be installed 
IW_PORT_GMCR    EQU     00h
IW_PORT_GMTDR   EQU     01h
IW_PORT_SVSR    EQU     02h
IW_PORT_IGIDXR  EQU     03h
IW_PORT_I16DP   EQU     04h
IW_PORT_I8DP    EQU     05h
IW_PORT_LMBDR   EQU     07h

; The following group of ports will need to have PCODAR added to them before
; the I/O handlers can be installed                   
IW_PORT_CIDXR   EQU     00h
IW_PORT_CDATAP  EQU     01h
IW_PORT_CSR1R   EQU     02h
IW_PORT_CPDR    EQU     03h

; The following group of ports will need to have PMPUR added to them before
; the I/O handlers can be installed                   
IW_PORT_MPU0    EQU     00h
IW_PORT_MPU1    EQU     01h

; The following PNP ports are fixed in these locations
; we cannot trap the PNP ports
IW_PORT_PCSNBR  EQU     0201h
IW_PORT_PIDXR   EQU     0279h
IW_PORT_PNPWRP  EQU     0A79h
; The PNP read port is configured by a write to an indexed regiser
; IW_PORT_PNPRDP        EQU     003h - 03FFh

; The following are the indexes for the VxD API Services
InterWave_API_Get_Version               EQU     0
InterWave_API_Get_Buffer                EQU     1
InterWave_API_Acquire_InterWave         EQU     2
InterWave_API_Release_InterWave         EQU     3
InterWave_API_Register_SBOS_Support     EQU     4
InterWave_API_SBOS_Functions            EQU     5
InterWave_API_Register_Driver_Callback  EQU     6

; This following API calls are available only in versions after 3.0
InterWave_API_Get_Resource_Config       EQU     7
InterWave_API_Read_Port_Byte		EQU	8
InterWave_API_Write_Port_Byte		EQU	9

; This following API call is available only in versions after 3.1
InterWave_API_Read_DMA_Count		EQU     10

; The InterWave_API_Register_SBOS_Support service registers with the VxD the functions
; to allocate a voice, free a voice, allocate memory and free memory.
; The InterWave_API_SBOS_Functions service is the entry point to the VxD that is called
; when the driver gets an interrupt generated by one of the voices owned by a VxD
; process.
 
; The following codes are used with the VxD API Services
; The acquire/release codes
IWAR_IRQ1       EQU 0001h
IWAR_IRQ2       EQU 0002h
IWAR_DMA1       EQU 0004h
IWAR_DMA2       EQU 0008h
IWAR_SOMEVOICES EQU 0010h       ; voices, cooperatively
IWAR_ALLVOICES  EQU 0020h       ; voices, exclusively
IWAR_SOMEMEMORY EQU 0040h       ; on-board memory, cooperatively
IWAR_ALLMEMORY  EQU 0080h       ; on-board memory, exclusively
IWAR_CODECPLAY  EQU 0100h       ; the CODEC's playback channel
IWAR_CODECREC   EQU 0200h       ; the CODEC's record channel
IWAR_CODECMIX   EQU 0400h       ; the CODEC mixer
IWAR_PORTIN     EQU 0800h       ; MIDI Input Port
IWAR_PORTOUT    EQU 1000h       ; MIDI Output Port
IWAR_VADLIB     EQU 2000h       ; Adlib emulation ports
IWAR_VSNDBLST   EQU 4000h       ; Sound Blaster emulation ports
IWAR_VMPU401    EQU 8000h       ; MPU-401 emulation ports

IWAR_SYNTH      EQU 00F0h       ; entire synth (voices and memory)
IWAR_IWSBOS     EQU 6150h       ; synth (cooperatively) and codec playback
IWAR_CODEC      EQU 0700h       ; entire codec
IWAR_PORT       EQU 1800h       ; Input and output port
IWAR_ALL        EQU 0FFFFh      ; All defined flags

IWAR_INTERWAV   EQU 0FFFFh      ; all resources
IWAR_RECONFIG   EQU 010000h     ; indicates dynamic reconfiguration
IWAR_DIRECT	EQU 020000h	; requestor is a Direct Sound driver

IWAR_NUMRESOURCES       EQU     16
IWAR_NUMIRQRESOURCES    EQU     2

IW_KERNEL_UNLOAD      EQU 0
IW_KERNEL_LOAD        EQU 1
IW_KERNEL_SLEEP       EQU 2
IW_KERNEL_WAKE        EQU 3
IW_KERNEL_CODEC_SLEEP EQU 4
IW_KERNEL_CODEC_WAKE  EQU 5

IWI_FLAG_ONE_IRQ        EQU     01h     ;IRQ channels are mapped together
IWI_FLAG_ONE_DMA        EQU     02h     ;DMA channels are mapped together
IWI_FLAG_SBOS_ACTIVE    EQU     04h
IWI_FLAG_IN_SBOS        EQU     08h   ; currently in sbos code
IWI_FLAG_DMA_VIRTUALIZED        EQU     10h
IWI_FLAG_SINGLEMODEDMA          EQU     20h
IWI_FLAG_MPU_ACTIVE    EQU     40h
IWI_FLAG_SHARING_CODEC EQU     80h


INTERWAVEINFO struc
	iwi_dwSize          dd      ?                   ; size of structure
        iwi_wVersion        dw      VIWD_VERSION        ; version of the VxD
	iwi_wFlags          dw      IWI_FLAG_SINGLEMODEDMA  ; flags defined below
	iwi_bIRQ1           db      0       
	iwi_bIRQ2           db      0
	iwi_bDMA1           db      0
	iwi_bDMA2           db      0
	iwi_wSynthBase2X    dw      0
	iwi_wSynthBase3X    dw      0
	iwi_wCodecBase      dw      0
        iwi_wCodecType      dw      0           ; not used
	iwi_wMPUBase        dw      0
        iwi_bMPUIRQ         db      0
        iwi_wAdlibBase      dw      0
        iwi_bSBIRQ          db      0
        iwi_wGameBase       dw      0
        iwi_wCDBase         dw      0
        iwi_wATAPIBase      dw      0
        iwi_bCDIRQ          db      0
        iwi_bCDDMA          db      0
	iwi_wDMASelector    dw      0
	iwi_dwDMAPhysical   dd      0
	iwi_dwDMALinear     dd      0
	iwi_dwDMABufferSize dd      0           ; buffer size in bytes
	iwi_dwSBOSOwner     dd      0           ; sbos VM
	iwi_bCodecIndex     db      0           ; current codec index
	iwi_bDeviceInit	    db	    0
	iwi_bPendingDriverOp db		0
        iwi_wDriverDS       dw      0
INTERWAVEINFO ends

IWINFO_DEV0_INIT	EQU	1
IWINFO_DEV1_INIT	EQU	2
IWINFO_DEV2_INIT	EQU	4
IWINFO_DEV3_INIT	EQU	8
IWINFO_DEV4_INIT	EQU	16  
IWINFO_DEVICE_ID_INIT	EQU	32
IWINFO_DEV_RECONFIG	EQU	64

IWRESOURCEINFO struc
	iwri_wStatus            dw      ?
	iwri_wAcqLevel          dw      0       ; for DOS level tracking
	iwri_dwCurOwner         dd      0
	iwri_dwPrevOwner        dd      0
	iwri_dwResourceHandle   dd      0       ; DMA handle, IRQ handle or Port 
						; table offset
	iwri_dwResourceID       dd      ?       ; DMA #, IRQ #, or lowport | hiport<<16
IWRESOURCEINFO ends

; the rsi status flags
; flags 0 and 1 indicate the type of resource
IWRIS_IRQ       EQU     0000h
IWRIS_DMA       EQU     0001h
IWRIS_PORTS     EQU     0002h
IWRIS_OTHER     EQU     0003h
IWRIS_TYPE      EQU     0003h   ; type mask
IWRIS_ACQUIRED  EQU     0004h
IWRIS_2XR       EQU     0008h   ; must be adjusted by 2XR
IWRIS_3XR       EQU     0010h   ; must be adjusted by 3XR
IWRIS_CODAR     EQU     0020h   ; must be adjusted by CODAR
IWRIS_MPUR      EQU     0040h   ; must be adjusted by MPUR
IWRIS_DISABLED  EQU     0080h   ; indicates that resource install failed
IWRIS_DMA_DTRAN EQU     0100h   ; indicates for a DMA resource that translation
				; is disabled
IWRIS_MIX_ONLY  EQU     0100h   ; system VM owns mixer only
IWRIS_SBOS      EQU     0200h   ; this port range is owned by the owner of SBOS
IWRIS_DIRECT	EQU	0400h	; this resource is owned by a direct sound driver
			   
; Access code for indexed registers in the codec (X is a mixer register)
;
; 1F 1E 1D 1C  1B 1A 19 18  17 16 15 14  13 12 11 10
;               X  X  X                               = 0 E 0 0 h
;
; 0F 0E 0D 0C  0B 0A 09 08  07 06 05 04  03 02 01 00
;                            X  X  X  X   X  X  X  X  = 0 0 F F h
;
IWCA_WINDOWS_MIXER      EQU     0E0000FFh
IWCA_DOS_BOX            EQU     (NOT IWCA_WINDOWS_MIXER)

INTERWAV_CB_DATA struc
	iwcb_dwCodecAccess      dd      0
	iwcb_bCodecIndex        db      0
INTERWAV_CB_DATA ends

; Plug and Play Direct Registers 
IWL_PNP_INDEX EQU 0279h
IWL_PNP_WRITE EQU 0A79h

; Plug and Play Indirect Registers 
IW_PCCCI  EQU   02h
IW_PWAKEI EQU   03h
IW_PCSNI  EQU   06h
IW_PLDNI  EQU   07h
IW_PUACTI EQU   30h
IW_PURCI  EQU   31h
IW_P2X0HI EQU   60h
IW_P2X0LI EQU   61h
IW_P3X0HI EQU   62h
IW_P3X0LI EQU   63h
IW_PHCAI  EQU   64h
IW_PLCAI  EQU   65h
IW_PRAHI  EQU   60h
IW_PRALI  EQU   61h
IW_PATAHI EQU   60h
IW_PATALI EQU   61h
IW_P201HI EQU   60h
IW_P201LI EQU   61h
IW_P388HI EQU   60h
IW_P388LI EQU   61h
IW_P401HI EQU   60h
IW_P401LI EQU   61h
IW_PUI1SI EQU   70h
IW_PUI2SI EQU   72h
IW_PUD1SI EQU   74h
IW_PUD2SI EQU   75h
IW_PSBISI EQU   70h
IW_PMISI  EQU   70h
IW_PPWRI  EQU   0F2h
		  
; Plug and Play Logical Devices
IWL_PNP_AUDIO  EQU   0
IWL_PNP_EXT    EQU   1
IWL_PNP_GAME   EQU   2
IWL_PNP_ADLIB  EQU   3
IWL_PNP_MPU401 EQU   4

; AX code for call to InterWave_API_Get_Resource_Config
IWGRC_SYNTH_BASE_2X     EQU     1
IWGRC_SYNTH_BASE_3X     EQU     2
IWGRC_IRQ_1     EQU     3
IWGRC_IRQ_2     EQU     4
IWGRC_DMA_1     EQU     5
IWGRC_DMA_2     EQU     6
IWGRC_CODEC_BASE     EQU        7

IWGRC_CD_BASE     EQU   8
IWGRC_ATAPI_BASE     EQU        9
IWGRC_CD_IRQ     EQU    10
IWGRC_CD_DMA     EQU    11

IWGRC_GAME_BASE     EQU 12

IWGRC_ADLIB_BASE     EQU        13
IWGRC_SB_IRQ     EQU    14

IWGRC_MPU_BASE     EQU  15
IWGRC_MPU_IRQ     EQU   16

outpb MACRO wPort, bVal
	mov dx, wPort
	mov al, bVal
	out dx, al
ENDM

inpb    MACRO wPort
	mov dx, wPort
	in  al, dx
ENDM
