/***************************************************************************
*   NAME:  WSSCANF.H $Revision: 1.2 $
**  COPYRIGHT:
**  "Copyright (c) 1994,1995 by e-Tek Labs"
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
* $Log: wsscanf.h $
* Revision 1.2  1995/03/01 17:50:22  teckert
* Added file header
* Revision 1.1  1995/02/23 15:14:59  sdsmith
* Initial revision
***************************************************************************/

// constant definitions

#define ALLOW_RANGE                        // allow "%[a-z]" - style 
                                           // scansets

#define LEFT_BRACKET  ('[' | ('a' - 'A'))  // 'lowercase' version

#define ASCII         32                   // # of bytes needed to 
                                           // hold 256 bits

// macro definitions

#define INC()            (++nCharCount, Inc( (LPSTR FAR *) &lpPtrBuffer ))
#define UN_INC( chr )    (--nCharCount, UnInc( chr, (LPSTR FAR *) &lpPtrBuffer ))
#define EAT_WHITE()      WhiteOut( (int FAR *) &nCharCount, (LPSTR FAR *) &lpPtrBuffer )
#define HEXTODEC( chr )  HexToDec( chr )

#define MUL10(x)         ( (((x)<<2) + (x))<<1 )

// function definitions

int FAR _cdecl wsscanf( LPSTR, LPSTR, ... ) ;
char NEAR HexToDec( char ) ;
char NEAR Inc( LPSTR FAR * ) ;
VOID NEAR UnInc( char, LPSTR FAR * ) ;
char NEAR WhiteOut( int FAR *, LPSTR FAR * ) ;

/************************************************************************
 * End of File: wsscanf.h
 ************************************************************************/
