;
;************************************************************************/
;*	Copyright (C) 1986-1993 Phar Lap Software, Inc.			*/
;*	Unpublished - rights reserved under the Copyright Laws of the	*/
;*	United States.  Use, duplication, or disclosure by the 		*/
;*	Government is subject to restrictions as set forth in 		*/
;*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 	*/
;*	Computer Software clause at 252.227-7013.			*/
;*	Phar Lap Software, Inc., 60 Aberdeen Ave., Cambridge, MA 02138	*/
;************************************************************************/

.twocase
include dosx.ah

_TEXT segment public byte use32 'CODE'
_TEXT ends

_DATA segment public dword 'DATA'
;
; valid segment registers
;
DSReg dw	?
ESReg dw	?
FSReg dw	?
GSReg dw	?
;
; Addresses of C Interrupt callbacks to call
;
	align  4
	public pSynthHandler, _pSynthHandler, pSynthHandler_
_pSynthHandler label dword
pSynthHandler_ label dword
pSynthHandler  dd ?
;
	align  4
	public pMidiHandler, _pMidiHandler, pMidiHandler_
_pMidiHandler label dword
pMidiHandler_ label dword
pMidiHandler  dd ?
;
; 8K stack to be switched to whenever a DDK 
; Synth IRQ occurs.
;
	align  4
        db     2000h dup(?)
TopOfStack1 label dword
;
; 8K stack to be switched to whenever a DDK 
; MIDI IRQ occurs.
;
	align  4
        db     2000h dup(?)
TopOfStack2 label dword
;
; 8K stack to be switched to whenever a DDK 
; handler gets control.
;
	align  4
        db     2000h dup(?)
ProtTopOfStack label dword

_DATA ends

	assume	cs:_TEXT,ds:nothing
_TEXT segment
;
; Entry point for Interrupt intended for IwaveSynthHandler
;
	public   _xSynthHandler, xSynthHandler_, xSynthHandler
xSynthHandler  label far
xSynthHandler_ label far
_xSynthHandler proc far
  sti                    ; re-anable interrupts
;
;
; Switch seg registers to protected-mode InterWave program
;
  mov  ds,cs:DSReg
  assume ds:_DATA
  mov  es,ESReg
  mov  fs,FSReg
  mov  gs,GSReg
  pushad                 ; save all regs
;
  call pSynthHandler     ; execute callback
;
  popad                  ; restore registers
  iretd
_xSynthHandler endp
;
; Entry point for Interrupt intended for IwaveMidiHandler
;
	public   _xMidiHandler, xMidiHandler_, xMidiHandler
xMidiHandler  label far
xMidiHandler_ label far
_xMidiHandler proc far
;
  sti                    ; re-anable interrupts
;
;
; Switch seg registers to protected-mode InterWave program
;
  mov  ds,cs:DSReg
  assume ds:_DATA
  mov  es,ESReg
  mov  fs,FSReg
  mov  gs,GSReg
  pushad                 ; save all regs
;
  call pMidiHandler;
;
  popad                  ; restore registers
  iretd                  
_xMidiHandler endp
;
; void SystemTimer()
;
	public   _SystemTimer, SystemTimer_, SystemTimer
SystemTimer  label far
SystemTimer_ label far
_SystemTimer proc far
;
; Stack Frame
;
#EAX    equ    (dword ptr [ebp-4]) ; Original EAX value
  cli                              ; enable interrupts
  push ebp                         ; set up frame pointer
  mov  ebp,esp                     ; save TNT-DOSX stack pointer
  push eax                         ; save all registers
  push ebx                         ;
  push ecx                         ;
  push edx                         ;
  push esi                         ;
  push edi                         ;
  push ds                          ;
  push es                          ;
  push fs                          ;
  push gs                          ;
;
; Switch seg registers to protected-mode InterWave program
;
  mov  ds,cs:DSReg
  assume ds:_DATA
  mov  es,ESReg
  mov  fs,FSReg
  mov  gs,GSReg
;
; Clear direction flag for C code
;
  cld
;
  mov  ecx,esp                    ; save current stack & interrupt stack frame
  mov  dx ,ss                     ;
  mov  esi,ebp                    ;
  add  esi,4                      ;
  mov  ax ,ds                     ;
  lea  ebx,ProtTopOfStack         ; switch to new stack
  mov  ss ,ax                     ;
  mov  esp,ebx                    ;
  push edx                        ; save old stack pointer
  push ecx                        ;
  push edx                        ;
  push esi                        ;
  call pMidiHandler               ; call InterWave Callback
  add  esp,8                      ;
  lss  esp,[esp]                  ; switch back to old stack
;
; Restore registers and return
;
  sti
  mov  al,20h
  out  20h,al
  pop  gs
  pop  fs
  pop  es
  pop  ds
  pop  edi
  pop  esi
  pop  edx
  pop  ecx
  pop  ebx
  pop  eax
  mov  esp,ebp
  pop  ebp
  iretd
_SystemTimer endp
;
;
; void SaveSegRegs()
;
; Save segment registers
;
	assume	cs:_TEXT,ds:_DATA
	public SaveSegRegs,_SaveSegRegs,SaveSegRegs_
_SaveSegRegs label near
SaveSegRegs_ label near
SaveSegRegs proc near
	mov	DSReg,ds
	mov	ESReg,es
	mov	FSReg,fs
	mov	GSReg,gs
	ret
SaveSegRegs endp

;
; void GetSegRegs()
;
; Get segment registers, for use by interrupt handler
;
	assume	cs:_TEXT,ds:_DATA
	public GetSegRegs,_GetSegRegs,GetSegRegs_
_GetSegRegs label near
GetSegRegs_ label near
GetSegRegs proc near
	mov	ds,cs:DSReg
	mov	es,cs:ESReg
	mov	fs,cs:FSReg
	mov	gs,cs:GSReg
	ret
GetSegRegs endp
;
; void EnterCritical()
;
; Disable Interrupts
;
	assume	cs:_TEXT,ds:_DATA
	public EnterCritical,_EnterCritical,EnterCritical_
_EnterCritical label near
EnterCritical_ label near
EnterCritical proc near
;	pushf     ; save flags
	cli       ; disable interrupts
	ret
EnterCritical endp
;
; void LeaveCritical()
;
; Restore IF
;
	assume	cs:_TEXT,ds:_DATA
	public LeaveCritical,_LeaveCritical,LeaveCritical_
_LeaveCritical label near
LeaveCritical_ label near
LeaveCritical proc near
;	popf    ; restore flags
   sti     ; enable interrupts
	ret
LeaveCritical endp
;
; BYTE PharPeek(PORT)
;
; Read a byte from a hardware port
;
	assume	cs:_TEXT,ds:_DATA
	public PharPeek,_PharPeek,PharPeek_
_PharPeek label near
PharPeek_ label near
PharPeek proc near
	push ebp          ; save base pointer
	mov  ebp,esp      ;
	mov  edx,[ebp+8]  ; get port
	in   al,dx        ; read 8-bit value
	pop  ebp          ; restore EBP
	ret
PharPeek endp
;
; WORD PharPeekW(PORT)
;
; Read a word from a hardware port
;
	assume	cs:_TEXT,ds:_DATA
	public PharPeekW,_PharPeekW,PharPeekW_
_PharPeekW label near
PharPeekW_ label near
PharPeekW proc near
	push ebp          ; save base pointer
	mov  ebp,esp      ;
	mov  edx,[ebp+8]  ; get port
	in   ax,dx        ; read 16-bit value
	pop  ebp          ; restore EBP
	ret
PharPeekW endp
;
; void PharPoke(PORT,BYTE)
;
; Write a byte to a hardware port
;
	assume	cs:_TEXT,ds:_DATA
	public PharPoke,_PharPoke,PharPoke_
_PharPoke label near
PharPoke_ label near
PharPoke proc near
	push ebp          ; save base pointer
	mov  ebp,esp      ;
	mov  eax,[ebp+12] ; get data
	mov  edx,[ebp+8]  ; get port
	out  dx,al        ; write 8-bit value
	pop  ebp          ; restore EBP
	ret
PharPoke endp
;
; void PharPokeW(PORT,WORD)
;
; Write a word to a hardware port
;
	assume	cs:_TEXT,ds:_DATA
	public PharPokeW,_PharPokeW,PharPokeW_
_PharPokeW label near
PharPokeW_ label near
PharPokeW proc near
	push ebp          ; save base pointer
	mov  ebp,esp      ;
	mov  eax,[ebp+12] ; get data
	mov  edx,[ebp+8]  ; get port
	out  dx,ax        ; write 16-bit value
	pop  ebp          ; restore EBP
	ret
PharPokeW endp
_TEXT ends

end
