/*
**  Define this if you want socks to support a default port,
**    (ie. socks/tcp is missing from /etc/services )
*/
#define SOCKS_DEF_PORT	1080

/*
**  If your local nameserver doesn't support lookups to the
**    root domain.
*/
#define NEED_REMOTE_NAMESERVER

/*
**  How long to keep a connection around one it is idle
*/
#define SOCKS_TIMEOUT	2*60*60	/* 2hr in minutes */

/*
**  Set both of these to something useful
*/
#if defined(NEED_REMOTE_NAMESERVER) && !defined(SOCKS_DEFAULT_NS)
#define SOCKS_DEFAULT_NS	"InvalidHostNameHere"
#endif

#if !defined(SOCKS_DEFAULT_HOST)
#define SOCKS_DEFAULT_HOST	SOCKS_DEFAULT_NS
#endif

/*
**  Where the config file lives for the daemon
*/
#define SOCKS_CONF	"/etc/sockd.conf"

/*
**  Response commands/codes
*/
#define SOCKS_CONNECT	1
#define SOCKS_BIND	2
#define SOCKS_RESULT	90
#define SOCKS_FAIL	91

typedef struct {
	unsigned char		version;
	unsigned char		cmd;
	unsigned long		port;
	unsigned long		host;
} Socks_t;

#define SOCKS_VERSION	3

/*
**  Simple macros that alow reading and writing of network bytes
*/
#define Write8(f, v) \
	{ unsigned char _xx_ = htonb(v);  write(f, &_xx_, sizeof(_xx_)); }
#define Write32(f, v) \
	{ unsigned long _xx_ = htonl(v);  write(f, &_xx_, sizeof(_xx_)); }
#define Read8(f, v) \
	{ unsigned char _xx_; read(f, &_xx_, sizeof(_xx_)); v = ntohb(_xx_); }
#define Read32(f, v) \
	{ unsigned long _xx_; read(f, &_xx_, sizeof(_xx_)); v = ntohl(_xx_); }

/*
**  Bold assumption that these are needed
*/
#ifndef ntohb
#define ntohb(x) x
#endif
#ifndef htonb
#define htonb(x) x
#endif
