#if BYTEORDER == 0x4321

#define ntohl(x)
#define htonl(x)
#else
#if ((BYTEORDER - 0x1111) & 0x444) || !(BYTEORDER & 0xf)
#define ntohl(x)    fatal("Unknown BYTEORDER\n")
#define htonl(x)    fatal("Unknown BYTEORDER\n")
#else
#define BYTEREVERSE(x)  {register unsigned char __t, \
		*__c = (unsigned char *) &(x); \
	__t = __c[3]; __c[3] = *__c; *__c++ = __t; \
	__t = *__c; *__c = __c[1]; *++__c = __t; }
#define ntohl(x) BYTEREVERSE(x)
#define htonl(x) BYTEREVERSE(x)
#endif
#endif


/* $Id: ntohl.h,v 1.2 92/11/03 02:48:31 genek Exp $

Then, wherever you use the value, replace:

i = ntohl(j);
 -with-
i = j;
ntohl(i);

The resulting code will be faster that using a subroutine,
 especially if these routines are called often.

--spaf
*/
