#ifndef lint
static char rcsid[] = "$Id: sigfetch.c,v 1.3 92/10/18 19:28:25 genek Exp $";
#endif

/*
 * sigfetch.c
 *
 *	generate signatures for a given file.
 *
 * Gene Kim
 * Purdue University
 * October 14, 1992
 */

#include "../include/config.h"
#include <stdio.h>
#include <fcntl.h>
#ifdef STDLIBH
# include <stdlib.h>
#endif
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef XENIX
# include <sys/time.h>
#else
# include <time.h>
#endif 	/* XENIX */
#ifdef DIRENT
# include <dirent.h>
#else
# ifndef XENIX
#  include <sys/dir.h>
# else		/* XENIX */
#  include <sys/ndir.h>
# endif		/* XENIX */
#endif	/* DIRENT */
#if (defined(SYSV) && (SYSV < 3))
# include <limits.h>
#endif	/* SVR2 */
#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif
#include "../include/list.h"
#include "../include/tripwire.h"

extern int optind;

int (*pf_signatures [NUM_SIGS]) () = {
					SIG0FUNC,
					SIG1FUNC,
					SIG2FUNC,
					SIG3FUNC,
					SIG4FUNC,
					SIG5FUNC,
					SIG6FUNC,
					SIG7FUNC,
					SIG8FUNC,
					SIG9FUNC
				      };

int printhex = 0;
int sigallget = 1;
int sigvector[NUM_SIGS] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char *signames[NUM_SIGS] = {
				"nullsig",
				"md5",
				"snefru",
				"crc32",
				"crc16",
				"md4",
				"md2",
				"nullsig",
				"nullsig",
				"nullsig"
			   };
int verbosity = 0;
int quiet = 0;

char *progname;

void
usage()
{
    fprintf(stderr, "sigfetch: usage: [-0123456789qv] [ file ... ]\n");
    exit(1);
}

main(argc, argv)
    int argc;
    char *argv[];
{
    int i, c;
    int fd;

    progname = argv[0];

    optind = 1;
    while ((c = getopt(argc, argv, "0123456789aqvh")) != -1) {
	switch(c) {
	case '0':		sigallget = 0; sigvector[0] = 1; break;
	case '1':		sigallget = 0; sigvector[1] = 1; break;
	case '2':		sigallget = 0; sigvector[2] = 1; break;
	case '3':		sigallget = 0; sigvector[3] = 1; break;
	case '4':		sigallget = 0; sigvector[4] = 1; break;
	case '5':		sigallget = 0; sigvector[5] = 1; break;
	case '6':		sigallget = 0; sigvector[6] = 1; break;
	case '7':		sigallget = 0; sigvector[7] = 1; break;
	case '8':		sigallget = 0; sigvector[8] = 1; break;
	case '9':		sigallget = 0; sigvector[9] = 1; break;
	case 'a':		sigallget = 1; break;
	case 'v':		verbosity = 1; break;
	case 'q':		quiet = 1; break;
	case 'h':		printhex = 1; break;
	case '?':
	default:
	    usage();
	    exit(1);
	}
    }

    argc -= optind;
    argv += optind;

    for (i = 0; i < argc; i++) {
	if (strcmp(argv[i], "-") == 0)
	   fd = 0;
	else
	    if ((fd = open(argv[i], O_RDONLY, 0)) < 0) {
		warn_with_err("sigfetch: open() on '%s' failed! Skipping...\n",
					    argv[i]);
		continue;
	    }
	sigfetch(fd);

	if (fd)
	    close(fd);
    }
}

int
sigfetch(fd)
    int fd;
{
    char 	sigs[NUM_SIGS][SIG_MAX_LEN];
    char	sigs_concat[1024];
    int 	i;

    /* collect signatures */
    for (i = 0; i < NUM_SIGS; i++) {
	char *pc = sigs[i];

	if (sigallget || sigvector[i]) {

	    (*pf_signatures[i])(fd, pc, SIG_MAX_LEN);
	    if (!quiet)
		printf("sig%d: %-9s: %s\n", i, signames[i], sigs[i]);
	    else
		printf("%s ", sigs[i]);

	}
    }

    if (quiet)
       printf("\n");

}
