/* data.c - table of data for HAM routines.                 */
/* color[16] - colormap containing rgb values fairly evenly */
/*             spread throughout 16x16x16 space.            */
/* near[4096] - table of distance. For each r,g,b           */
/*              address = (r<<8 | g<<4 | b) & 0xfff         */
/*              near>>4 gives the nearest color (index) and */
/*              near & 0x0f gives the distance.             */
/* nearmc[4096] - table of distance minus color             */
/*       This contains the nearest color ignoring a color   */
/*       (nearmc >> 8) & 0xf is for red,                    */
/*       (nearmc >> 4) & 0xf is for green,                  */
/*       and nearmc & 0xf is for blue                       */

#include <exec/types.h>

UWORD colortable[16] = {
        0x000,
        0x466,
        0x372,
        0xc23,
        0x3d3,
        0x32c,
        0xcc2,
        0xc3d,
        0x3cd,
        0xcdc,
        0x08a,
        0x808,
        0x880,
        0xf77,
        0x8f8,
        0x88f
};

UBYTE near[4096] = {
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 
        0x08, 0x58, 0x57, 0x56, 0x55, 0x56, 0x57, 0x58,
        0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 
        0x58, 0x57, 0x56, 0x55, 0x54, 0x55, 0x56, 0x57,
        0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x58, 
        0x57, 0x56, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x17, 0x18, 
        0xa7, 0xa6, 0xa5, 0x55, 0x54, 0x55, 0x56, 0x57,
        0x04, 0x05, 0x06, 0x07, 0x08, 0x17, 0x16, 0x17, 
        0xa6, 0xa5, 0xa4, 0xa5, 0x55, 0x56, 0x57, 0x58,
        0x05, 0x06, 0x25, 0x26, 0x17, 0x16, 0x15, 0x16, 
        0xa5, 0xa4, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8,
        0x06, 0x25, 0x24, 0x25, 0x16, 0x15, 0x14, 0x15, 
        0xa4, 0xa3, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
        0x25, 0x24, 0x23, 0x24, 0x25, 0x16, 0x15, 0xa4, 
        0xa3, 0xa2, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6,
        0x26, 0x25, 0x24, 0x25, 0x26, 0xa5, 0xa4, 0xa3, 
        0xa2, 0xa1, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5,
        0x27, 0x26, 0x25, 0x26, 0x27, 0xa6, 0xa5, 0xa4, 
        0xa3, 0xa2, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6,
        0x28, 0x27, 0x26, 0x46, 0x47, 0xa7, 0xa6, 0xa5, 
        0xa4, 0xa3, 0xa2, 0xa3, 0xa4, 0x85, 0x86, 0x87,
        0x48, 0x47, 0x46, 0x45, 0x46, 0x47, 0xa7, 0xa6, 
        0xa5, 0xa4, 0xa3, 0xa4, 0x85, 0x84, 0x85, 0x86,
        0x47, 0x46, 0x45, 0x44, 0x45, 0x46, 0x47, 0xa7, 
        0xa6, 0xa5, 0xa4, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x46, 0x45, 0x44, 0x43, 0x44, 0x45, 0x46, 0x47, 
        0xa7, 0xa6, 0xa5, 0x86, 0x85, 0x84, 0x85, 0x86,
        0x47, 0x46, 0x45, 0x44, 0x45, 0x46, 0x47, 0x48, 
        0xa8, 0xa7, 0xa6, 0x87, 0x86, 0x85, 0x86, 0x87,
        0x48, 0x47, 0x46, 0x45, 0x46, 0x47, 0x48, 0x49, 
        0xe8, 0xa8, 0xa7, 0x88, 0x87, 0x86, 0x87, 0x88,
        0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 
        0xb7, 0x57, 0x56, 0x55, 0x54, 0x55, 0x56, 0x57,
        0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x58, 
        0x57, 0x56, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x17, 0x57, 
        0x56, 0x55, 0x54, 0x53, 0x52, 0x53, 0x54, 0x55,
        0x04, 0x05, 0x06, 0x07, 0x08, 0x17, 0x16, 0x17, 
        0x57, 0x56, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0x05, 0x06, 0x25, 0x26, 0x17, 0x16, 0x15, 0x16, 
        0x17, 0xa6, 0xa5, 0x55, 0x54, 0x55, 0x56, 0x57,
        0x06, 0x25, 0x24, 0x25, 0x16, 0x15, 0x14, 0x15, 
        0x16, 0xa5, 0xa4, 0xa5, 0x55, 0x56, 0x57, 0x58,
        0x25, 0x24, 0x23, 0x24, 0x15, 0x14, 0x13, 0x14, 
        0x15, 0xa4, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8,
        0x24, 0x23, 0x22, 0x23, 0x24, 0x15, 0x14, 0x15, 
        0xa4, 0xa3, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
        0x25, 0x24, 0x23, 0x24, 0x25, 0x16, 0x15, 0xa4, 
        0xa3, 0xa2, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6,
        0x26, 0x25, 0x24, 0x25, 0x26, 0x17, 0x16, 0xa5, 
        0xa4, 0xa3, 0xa2, 0xa3, 0xa4, 0x85, 0x86, 0x87,
        0x27, 0x26, 0x25, 0x45, 0x46, 0x47, 0x17, 0xa6, 
        0xa5, 0xa4, 0xa3, 0xa4, 0x85, 0x84, 0x85, 0x86,
        0x47, 0x46, 0x45, 0x44, 0x45, 0x46, 0x47, 0xa7, 
        0xa6, 0xa5, 0xa4, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x46, 0x45, 0x44, 0x43, 0x44, 0x45, 0x46, 0x47, 
        0x87, 0x86, 0x85, 0x84, 0x83, 0x82, 0x83, 0x84,
        0x45, 0x44, 0x43, 0x42, 0x43, 0x44, 0x45, 0x46, 
        0x47, 0x87, 0x86, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x46, 0x45, 0x44, 0x43, 0x44, 0x45, 0x46, 0x47, 
        0x48, 0x88, 0x87, 0x86, 0x85, 0x84, 0x85, 0x86,
        0x47, 0x46, 0x45, 0x44, 0x45, 0x46, 0x47, 0x48, 
        0xe7, 0xe8, 0x88, 0x87, 0x86, 0x85, 0x86, 0x87,
        0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0xb7, 
        0xb6, 0x56, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x17, 0x57, 
        0x56, 0x55, 0x54, 0x53, 0x52, 0x53, 0x54, 0x55,
        0x04, 0x05, 0x06, 0x07, 0x08, 0x17, 0x16, 0x56, 
        0x55, 0x54, 0x53, 0x52, 0x51, 0x52, 0x53, 0x54,
        0x05, 0x06, 0x25, 0x26, 0x17, 0x16, 0x15, 0x16, 
        0x56, 0x55, 0x54, 0x53, 0x52, 0x53, 0x54, 0x55,
        0x06, 0x25, 0x24, 0x25, 0x16, 0x15, 0x14, 0x15, 
        0x16, 0x56, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0x25, 0x24, 0x23, 0x24, 0x15, 0x14, 0x13, 0x14, 
        0x15, 0x16, 0xa5, 0x55, 0x54, 0x55, 0x56, 0x57,
        0x24, 0x23, 0x22, 0x23, 0x14, 0x13, 0x12, 0x13, 
        0x14, 0x15, 0xa4, 0xa5, 0x55, 0x56, 0x57, 0x58,
        0x23, 0x22, 0x21, 0x22, 0x23, 0x14, 0x13, 0x14, 
        0x15, 0xa4, 0xa3, 0xa4, 0xa5, 0x86, 0x87, 0xf7,
        0x24, 0x23, 0x22, 0x23, 0x24, 0x15, 0x14, 0x15, 
        0xa4, 0xa3, 0xa2, 0xa3, 0xa4, 0x85, 0x86, 0xf6,
        0x25, 0x24, 0x23, 0x24, 0x25, 0x16, 0x15, 0x16, 
        0xa5, 0xa4, 0xa3, 0xa4, 0x85, 0x84, 0x85, 0x86,
        0x26, 0x25, 0x24, 0x44, 0x45, 0x46, 0x16, 0x17, 
        0xa6, 0xa5, 0xa4, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x46, 0x45, 0x44, 0x43, 0x44, 0x45, 0x46, 0x47, 
        0x87, 0x86, 0x85, 0x84, 0x83, 0x82, 0x83, 0x84,
        0x45, 0x44, 0x43, 0x42, 0x43, 0x44, 0x45, 0x46, 
        0x86, 0x85, 0x84, 0x83, 0x82, 0x81, 0x82, 0x83,
        0x44, 0x43, 0x42, 0x41, 0x42, 0x43, 0x44, 0x45, 
        0x46, 0x86, 0x85, 0x84, 0x83, 0x82, 0x83, 0x84,
        0x45, 0x44, 0x43, 0x42, 0x43, 0x44, 0x45, 0x46, 
        0x47, 0x87, 0x86, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x46, 0x45, 0x44, 0x43, 0x44, 0x45, 0x46, 0x47, 
        0xe6, 0xe7, 0x87, 0x86, 0x85, 0x84, 0x85, 0x86,
        0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x17, 0xb6, 
        0xb5, 0x55, 0x54, 0x53, 0x52, 0x53, 0x54, 0x55,
        0x04, 0x05, 0x06, 0x07, 0x08, 0x17, 0x16, 0x56, 
        0x55, 0x54, 0x53, 0x52, 0x51, 0x52, 0x53, 0x54,
        0x05, 0x06, 0x25, 0x26, 0x17, 0x16, 0x15, 0x55, 
        0x54, 0x53, 0x52, 0x51, 0x50, 0x51, 0x52, 0x53,
        0x06, 0x25, 0x24, 0x25, 0x16, 0x15, 0x14, 0x15, 
        0x55, 0x54, 0x53, 0x52, 0x51, 0x52, 0x53, 0x54,
        0x25, 0x24, 0x23, 0x24, 0x15, 0x14, 0x13, 0x14, 
        0x15, 0x55, 0x54, 0x53, 0x52, 0x53, 0x54, 0x55,
        0x24, 0x23, 0x22, 0x23, 0x14, 0x13, 0x12, 0x13, 
        0x14, 0x15, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0x23, 0x22, 0x21, 0x22, 0x13, 0x12, 0x11, 0x12, 
        0x13, 0x14, 0x15, 0x55, 0x54, 0x55, 0x56, 0x57,
        0x22, 0x21, 0x20, 0x21, 0x22, 0x13, 0x12, 0x13, 
        0x14, 0x15, 0xa4, 0xa5, 0x55, 0x85, 0x86, 0xf6,
        0x23, 0x22, 0x21, 0x22, 0x23, 0x14, 0x13, 0x14, 
        0x15, 0xa4, 0xa3, 0xa4, 0x85, 0x84, 0x85, 0xf5,
        0x24, 0x23, 0x22, 0x23, 0x24, 0x15, 0x14, 0x15, 
        0x16, 0xa5, 0xa4, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x25, 0x24, 0x23, 0x43, 0x44, 0x45, 0x15, 0x16, 
        0x17, 0x86, 0x85, 0x84, 0x83, 0x82, 0x83, 0x84,
        0x45, 0x44, 0x43, 0x42, 0x43, 0x44, 0x45, 0x46, 
        0x86, 0x85, 0x84, 0x83, 0x82, 0x81, 0x82, 0x83,
        0x44, 0x43, 0x42, 0x41, 0x42, 0x43, 0x44, 0x45, 
        0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x81, 0x82,
        0x43, 0x42, 0x41, 0x40, 0x41, 0x42, 0x43, 0x44, 
        0x45, 0x85, 0x84, 0x83, 0x82, 0x81, 0x82, 0x83,
        0x44, 0x43, 0x42, 0x41, 0x42, 0x43, 0x44, 0x45, 
        0x46, 0x86, 0x85, 0x84, 0x83, 0x82, 0x83, 0x84,
        0x45, 0x44, 0x43, 0x42, 0x43, 0x44, 0x45, 0x46, 
        0xe5, 0xe6, 0x86, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x04, 0x05, 0x06, 0x07, 0x08, 0x17, 0x16, 0xb5, 
        0xb4, 0xb5, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0x05, 0x06, 0x07, 0x08, 0x17, 0x16, 0x15, 0x16, 
        0xb5, 0x55, 0x54, 0x53, 0x52, 0x53, 0x54, 0x55,
        0x06, 0x07, 0x26, 0x17, 0x16, 0x15, 0x14, 0x15, 
        0x55, 0x54, 0x53, 0x52, 0x51, 0x52, 0x53, 0x54,
        0x07, 0x26, 0x25, 0x16, 0x15, 0x14, 0x13, 0x14, 
        0x15, 0x55, 0x54, 0x53, 0x52, 0x53, 0x54, 0x55,
        0x26, 0x25, 0x24, 0x15, 0x14, 0x13, 0x12, 0x13, 
        0x14, 0x15, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0x25, 0x24, 0x23, 0x14, 0x13, 0x12, 0x11, 0x12, 
        0x13, 0x14, 0x15, 0x55, 0x54, 0x55, 0x56, 0x57,
        0x24, 0x23, 0x22, 0x13, 0x12, 0x11, 0x10, 0x11, 
        0x12, 0x13, 0x14, 0x15, 0x55, 0x56, 0x57, 0xf6,
        0x23, 0x22, 0x21, 0x22, 0x13, 0x12, 0x11, 0x12, 
        0x13, 0x14, 0x15, 0x16, 0x56, 0x86, 0xf6, 0xf5,
        0x24, 0x23, 0x22, 0x23, 0x14, 0x13, 0x12, 0x13, 
        0x14, 0x15, 0xa4, 0xa5, 0x86, 0x85, 0xf5, 0xf4,
        0x25, 0x24, 0x23, 0x24, 0x15, 0x14, 0x13, 0x14, 
        0x15, 0x16, 0xa5, 0x86, 0x85, 0x84, 0x85, 0xf5,
        0x26, 0x25, 0x24, 0x44, 0x45, 0x15, 0x14, 0x15, 
        0x16, 0x17, 0x86, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x46, 0x45, 0x44, 0x43, 0x44, 0x45, 0x15, 0x16, 
        0x17, 0x86, 0x85, 0x84, 0x83, 0x82, 0x83, 0x84,
        0x45, 0x44, 0x43, 0x42, 0x43, 0x44, 0x45, 0x46, 
        0x86, 0x85, 0x84, 0x83, 0x82, 0x81, 0x82, 0x83,
        0x44, 0x43, 0x42, 0x41, 0x42, 0x43, 0x44, 0x45, 
        0x46, 0x86, 0x85, 0x84, 0x83, 0x82, 0x83, 0x84,
        0x45, 0x44, 0x43, 0x42, 0x43, 0x44, 0x45, 0x46, 
        0xe5, 0xe6, 0x86, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x46, 0x45, 0x44, 0x43, 0x44, 0x45, 0x46, 0xe5, 
        0xe4, 0xe5, 0xe6, 0x86, 0x85, 0x84, 0x85, 0x86,
        0x05, 0x06, 0x07, 0x08, 0xb7, 0xb6, 0xb5, 0xb4, 
        0xb3, 0xb4, 0xb5, 0x55, 0x54, 0x55, 0x56, 0x57,
        0x06, 0x07, 0x08, 0x38, 0x18, 0x17, 0x16, 0xb5, 
        0xb4, 0xb5, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0x07, 0x08, 0x27, 0x37, 0x17, 0x16, 0x15, 0x16, 
        0xb5, 0x55, 0x54, 0x53, 0x52, 0x53, 0x54, 0x55,
        0x08, 0x27, 0x26, 0x17, 0x16, 0x15, 0x14, 0x15, 
        0x16, 0x56, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0x27, 0x26, 0x25, 0x16, 0x15, 0x14, 0x13, 0x14, 
        0x15, 0x16, 0x56, 0x55, 0x54, 0x55, 0x56, 0x57,
        0x26, 0x25, 0x24, 0x15, 0x14, 0x13, 0x12, 0x13, 
        0x14, 0x15, 0x16, 0x56, 0x55, 0x56, 0x57, 0xf6,
        0x25, 0x24, 0x23, 0x14, 0x13, 0x12, 0x11, 0x12, 
        0x13, 0x14, 0x15, 0x16, 0x56, 0x57, 0xf6, 0xf5,
        0x24, 0x23, 0x22, 0x23, 0x14, 0x13, 0x12, 0x13, 
        0x14, 0x15, 0x16, 0x17, 0x57, 0xf6, 0xf5, 0xf4,
        0xc3, 0x24, 0x23, 0x24, 0x15, 0x14, 0x13, 0x14, 
        0x15, 0x16, 0xa5, 0xa6, 0xf6, 0xf5, 0xf4, 0xf3,
        0xc4, 0x25, 0x24, 0x25, 0x16, 0x15, 0x14, 0x15, 
        0x16, 0x17, 0xa6, 0x87, 0x86, 0x85, 0xf5, 0xf4,
        0xc5, 0x26, 0x25, 0x45, 0x46, 0x16, 0x15, 0x16, 
        0x17, 0x18, 0x87, 0x86, 0x85, 0x84, 0x85, 0xf5,
        0xc6, 0x46, 0x45, 0x44, 0x45, 0x46, 0x16, 0x17, 
        0xe7, 0x87, 0x86, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x46, 0x45, 0x44, 0x43, 0x44, 0x45, 0x46, 0x47, 
        0xe6, 0x86, 0x85, 0x84, 0x83, 0x82, 0x83, 0x84,
        0x45, 0x44, 0x43, 0x42, 0x43, 0x44, 0x45, 0x46, 
        0xe5, 0xe6, 0x86, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x46, 0x45, 0x44, 0x43, 0x44, 0x45, 0x46, 0xe5, 
        0xe4, 0xe5, 0xe6, 0x86, 0x85, 0x84, 0x85, 0x86,
        0x47, 0x46, 0x45, 0x44, 0x45, 0x46, 0xe5, 0xe4, 
        0xe3, 0xe4, 0xe5, 0xe6, 0x86, 0x85, 0x86, 0x87,
        0x06, 0x07, 0x08, 0xb7, 0xb6, 0xb5, 0xb4, 0xb3, 
        0xb2, 0xb3, 0xb4, 0xb5, 0x55, 0x56, 0x57, 0x58,
        0x07, 0x08, 0x38, 0x37, 0xb7, 0xb6, 0xb5, 0xb4, 
        0xb3, 0xb4, 0xb5, 0x55, 0x54, 0x55, 0x56, 0x57,
        0x08, 0x38, 0x37, 0x36, 0x37, 0x17, 0x16, 0xb5, 
        0xb4, 0xb5, 0x55, 0x54, 0x53, 0x54, 0x55, 0x56,
        0xc7, 0x28, 0x27, 0x37, 0x17, 0x16, 0x15, 0x16, 
        0xb5, 0xb6, 0x56, 0x55, 0x54, 0x55, 0x56, 0x57,
        0xc6, 0x27, 0x26, 0x17, 0x16, 0x15, 0x14, 0x15, 
        0x16, 0x17, 0x57, 0x56, 0x55, 0x56, 0x57, 0xf6,
        0xc5, 0x26, 0x25, 0x16, 0x15, 0x14, 0x13, 0x14, 
        0x15, 0x16, 0x17, 0x57, 0x56, 0x57, 0xf6, 0xf5,
        0xc4, 0x25, 0x24, 0x15, 0x14, 0x13, 0x12, 0x13, 
        0x14, 0x15, 0x16, 0x17, 0x57, 0xf6, 0xf5, 0xf4,
        0xc3, 0x24, 0x23, 0x24, 0x15, 0x14, 0x13, 0x14, 
        0x15, 0x16, 0x17, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3,
        0xc2, 0xc3, 0x24, 0x25, 0x16, 0x15, 0x14, 0x15, 
        0x16, 0x17, 0xa6, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
        0xc3, 0xc4, 0x25, 0x26, 0x17, 0x16, 0x15, 0x16, 
        0x17, 0x18, 0xa7, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3,
        0xc4, 0xc5, 0x26, 0x46, 0x47, 0x17, 0x16, 0x17, 
        0xe7, 0xe8, 0x88, 0x87, 0x86, 0x85, 0xf5, 0xf4,
        0xc5, 0xc6, 0x46, 0x45, 0x46, 0x47, 0x17, 0xe7, 
        0xe6, 0xe7, 0x87, 0x86, 0x85, 0x84, 0x85, 0xf5,
        0xc6, 0x46, 0x45, 0x44, 0x45, 0x46, 0x47, 0xe6, 
        0xe5, 0xe6, 0x86, 0x85, 0x84, 0x83, 0x84, 0x85,
        0x46, 0x45, 0x44, 0x43, 0x44, 0x45, 0x46, 0xe5, 
        0xe4, 0xe5, 0xe6, 0x86, 0x85, 0x84, 0x85, 0x86,
        0x47, 0x46, 0x45, 0x44, 0x45, 0x46, 0xe5, 0xe4, 
        0xe3, 0xe4, 0xe5, 0xe6, 0x86, 0x85, 0x86, 0x87,
        0x48, 0x47, 0x46, 0x45, 0x46, 0xe5, 0xe4, 0xe3, 
        0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0x86, 0x87, 0x88,
        0x07, 0x08, 0xb7, 0xb6, 0xb5, 0xb4, 0xb3, 0xb2, 
        0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8,
        0x08, 0x38, 0x37, 0x36, 0xb6, 0xb5, 0xb4, 0xb3, 
        0xb2, 0xb3, 0xb4, 0xb5, 0x55, 0x56, 0x57, 0x58,
        0xc7, 0x37, 0x36, 0x35, 0x36, 0xb6, 0xb5, 0xb4, 
        0xb3, 0xb4, 0xb5, 0x55, 0x54, 0x55, 0x56, 0x57,
        0xc6, 0xc7, 0x37, 0x36, 0x37, 0x17, 0x16, 0xb5, 
        0xb4, 0xb5, 0xb6, 0x56, 0x55, 0x75, 0x76, 0xf6,
        0xc5, 0xc6, 0x27, 0x37, 0x17, 0x16, 0x15, 0x16, 
        0xb5, 0xb6, 0xb7, 0x57, 0x56, 0x76, 0xf6, 0xf5,
        0xc4, 0xc5, 0x26, 0x17, 0x16, 0x15, 0x14, 0x15, 
        0x16, 0x17, 0x18, 0x58, 0x57, 0xf6, 0xf5, 0xf4,
        0xc3, 0xc4, 0x25, 0x16, 0x15, 0x14, 0x13, 0x14, 
        0x15, 0x16, 0x17, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3,
        0xc2, 0xc3, 0x24, 0x25, 0x16, 0x15, 0x14, 0x15, 
        0x16, 0x17, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
        0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0x16, 0x15, 0x16, 
        0x17, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1,
        0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0x17, 0x16, 0x17, 
        0xe7, 0xe8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
        0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0x18, 0x17, 0xe7, 
        0xe6, 0xe7, 0xe8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3,
        0xc4, 0xc5, 0x66, 0x46, 0x47, 0x48, 0xe7, 0xe6, 
        0xe5, 0xe6, 0xe7, 0x87, 0x86, 0x85, 0xf5, 0xf4,
        0xc5, 0x66, 0x65, 0x45, 0x46, 0x47, 0xe6, 0xe5, 
        0xe4, 0xe5, 0xe6, 0x86, 0x85, 0x84, 0x85, 0xf5,
        0xc6, 0x46, 0x45, 0x44, 0x45, 0x46, 0xe5, 0xe4, 
        0xe3, 0xe4, 0xe5, 0x96, 0x95, 0x85, 0x86, 0xf6,
        0xc7, 0x47, 0x46, 0x45, 0x46, 0xe5, 0xe4, 0xe3, 
        0xe2, 0xe3, 0xe4, 0xe5, 0x96, 0x86, 0x87, 0xf7,
        0xc8, 0x48, 0x47, 0x46, 0xe5, 0xe4, 0xe3, 0xe2, 
        0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8,
        0x08, 0xb7, 0xb6, 0xb5, 0xb4, 0xb3, 0xb2, 0xb1, 
        0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
        0xc7, 0x37, 0x36, 0x35, 0xb5, 0xb4, 0xb3, 0xb2, 
        0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0x76, 0x77, 0xf7,
        0xc6, 0x36, 0x35, 0x34, 0x35, 0xb5, 0xb4, 0xb3, 
        0xb2, 0xb3, 0xb4, 0xb5, 0x55, 0x75, 0x76, 0xf6,
        0xc5, 0xc6, 0x36, 0x35, 0x36, 0xb6, 0xb5, 0xb4, 
        0xb3, 0xb4, 0xb5, 0x76, 0x75, 0x74, 0x75, 0xf5,
        0xc4, 0xc5, 0xc6, 0x36, 0x37, 0x17, 0x16, 0xb5, 
        0xb4, 0xb5, 0xb6, 0x77, 0x76, 0x75, 0xf5, 0xf4,
        0xc3, 0xc4, 0xc5, 0xc6, 0x17, 0x16, 0x15, 0x16, 
        0xb5, 0xb6, 0xb7, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3,
        0xc2, 0xc3, 0xc4, 0xc5, 0x16, 0x15, 0x14, 0x15, 
        0x16, 0x17, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
        0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0x16, 0x15, 0x16, 
        0x17, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1,
        0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0x16, 0x17, 
        0xe7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1, 0xf0,
        0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0x17, 0xe7, 
        0xe6, 0xe7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1,
        0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xe7, 0xe6, 
        0xe5, 0xe6, 0xe7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
        0xc3, 0xc4, 0x65, 0x66, 0x67, 0xe7, 0xe6, 0xe5, 
        0xe4, 0xe5, 0xe6, 0x97, 0x96, 0xf5, 0xf4, 0xf3,
        0xc4, 0x65, 0x64, 0x65, 0x66, 0xe6, 0xe5, 0xe4, 
        0xe3, 0xe4, 0xe5, 0x96, 0x95, 0x85, 0xf5, 0xf4,
        0xc5, 0x66, 0x65, 0x45, 0x46, 0xe5, 0xe4, 0xe3, 
        0xe2, 0xe3, 0xe4, 0x95, 0x94, 0x95, 0x96, 0xf5,
        0xc6, 0x67, 0x66, 0x46, 0xe5, 0xe4, 0xe3, 0xe2, 
        0xe1, 0xe2, 0xe3, 0xe4, 0x95, 0x96, 0x97, 0xf6,
        0xc7, 0xe7, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 0xe1, 
        0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
        0x38, 0x37, 0x36, 0x35, 0xb5, 0xb4, 0xb3, 0xb2, 
        0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0x76, 0x77, 0x78,
        0x37, 0x36, 0x35, 0x34, 0x35, 0xb5, 0xb4, 0xb3, 
        0xb2, 0xb3, 0xb4, 0xb5, 0x76, 0x75, 0x76, 0x77,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0xb5, 0xb4, 
        0xb3, 0xb4, 0xb5, 0x76, 0x75, 0x74, 0x75, 0x76,
        0xc6, 0x36, 0x35, 0x34, 0x35, 0x36, 0xb6, 0xb5, 
        0xb4, 0xb5, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0xc5, 0xc6, 0x36, 0x35, 0x36, 0x37, 0x17, 0xb6, 
        0xb5, 0xb6, 0x77, 0x76, 0x75, 0x74, 0x75, 0xf5,
        0xc4, 0xc5, 0xc6, 0x36, 0x37, 0x17, 0x16, 0x17, 
        0xb6, 0xb7, 0x78, 0x77, 0x76, 0x75, 0xf5, 0xf4,
        0xc3, 0xc4, 0xc5, 0xc6, 0x17, 0x16, 0x15, 0x16, 
        0x17, 0x18, 0xf8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3,
        0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0x17, 0x16, 0xd6, 
        0xd7, 0xd8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
        0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0x17, 0xd7, 
        0xd8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1,
        0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0x18, 0xd8, 
        0xe7, 0xe8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
        0xc3, 0xc4, 0x65, 0x66, 0x67, 0x68, 0xe8, 0xe7, 
        0xe6, 0xe7, 0x98, 0x97, 0x96, 0xf5, 0xf4, 0xf3,
        0xc4, 0x65, 0x64, 0x65, 0x66, 0x67, 0xe7, 0xe6, 
        0xe5, 0xe6, 0x97, 0x96, 0x95, 0x96, 0xf5, 0xf4,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0xe6, 0xe5, 
        0xe4, 0xe5, 0x96, 0x95, 0x94, 0x95, 0x96, 0xf5,
        0x66, 0x65, 0x64, 0x65, 0x66, 0xe6, 0xe5, 0xe4, 
        0xe3, 0xe4, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x67, 0x66, 0x65, 0x66, 0xe6, 0xe5, 0xe4, 0xe3, 
        0xe2, 0xe3, 0xe4, 0x95, 0x94, 0x95, 0x96, 0x97,
        0x68, 0x67, 0x66, 0xe6, 0xe5, 0xe4, 0xe3, 0xe2, 
        0xe1, 0xe2, 0xe3, 0xe4, 0x95, 0x96, 0x97, 0x98,
        0x37, 0x36, 0x35, 0x34, 0x35, 0xb5, 0xb4, 0xb3, 
        0xb2, 0xb3, 0xb4, 0xb5, 0x76, 0x75, 0x76, 0x77,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0xb5, 0xb4, 
        0xb3, 0xb4, 0xb5, 0x76, 0x75, 0x74, 0x75, 0x76,
        0x35, 0x34, 0x33, 0x32, 0x33, 0x34, 0x35, 0xb5, 
        0xb4, 0xb5, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0x36, 0xb6, 
        0xb5, 0x76, 0x75, 0x74, 0x73, 0x72, 0x73, 0x74,
        0xc6, 0x36, 0x35, 0x34, 0x35, 0x36, 0x37, 0xb7, 
        0xb6, 0x77, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0xc5, 0xc6, 0x36, 0x35, 0x36, 0x37, 0x17, 0xd7, 
        0xb7, 0x78, 0x77, 0x76, 0x75, 0x74, 0x75, 0xf5,
        0xc4, 0xc5, 0xc6, 0x36, 0x37, 0x17, 0x16, 0xd6, 
        0xd7, 0xd8, 0x78, 0x77, 0x76, 0x75, 0xf5, 0xf4,
        0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xd7, 0xd6, 0xd5, 
        0xd6, 0xd7, 0xd8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3,
        0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xd7, 0xd6, 
        0xd7, 0xd8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2,
        0xc3, 0xc4, 0x65, 0x66, 0x67, 0x68, 0xd8, 0xd7, 
        0xd8, 0x99, 0x98, 0x97, 0x96, 0xf5, 0xf4, 0xf3,
        0xc4, 0x65, 0x64, 0x65, 0x66, 0x67, 0x68, 0xd8, 
        0xe7, 0x98, 0x97, 0x96, 0x95, 0x96, 0xf5, 0xf4,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0x67, 0xe7, 
        0xe6, 0x97, 0x96, 0x95, 0x94, 0x95, 0x96, 0xf5,
        0x64, 0x63, 0x62, 0x63, 0x64, 0x65, 0x66, 0xe6, 
        0xe5, 0x96, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0xe6, 0xe5, 
        0xe4, 0x95, 0x94, 0x93, 0x92, 0x93, 0x94, 0x95,
        0x66, 0x65, 0x64, 0x65, 0x66, 0xe6, 0xe5, 0xe4, 
        0xe3, 0xe4, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x67, 0x66, 0x65, 0x66, 0xe6, 0xe5, 0xe4, 0xe3, 
        0xe2, 0xe3, 0xe4, 0x95, 0x94, 0x95, 0x96, 0x97,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0xb5, 0xb4, 
        0xb3, 0xb4, 0xb5, 0x76, 0x75, 0x74, 0x75, 0x76,
        0x35, 0x34, 0x33, 0x32, 0x33, 0x34, 0x35, 0xb5, 
        0xb4, 0xb5, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0x34, 0x33, 0x32, 0x31, 0x32, 0x33, 0x34, 0x35, 
        0xb5, 0x76, 0x75, 0x74, 0x73, 0x72, 0x73, 0x74,
        0x35, 0x34, 0x33, 0x32, 0x33, 0x34, 0x35, 0x36, 
        0x76, 0x75, 0x74, 0x73, 0x72, 0x71, 0x72, 0x73,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0x36, 0x37, 
        0x77, 0x76, 0x75, 0x74, 0x73, 0x72, 0x73, 0x74,
        0xc6, 0x36, 0x35, 0x34, 0x35, 0x36, 0x37, 0xd6, 
        0xd7, 0x77, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0xc5, 0xc6, 0x36, 0x35, 0x36, 0x37, 0xd6, 0xd5, 
        0xd6, 0xd7, 0x77, 0x76, 0x75, 0x74, 0x75, 0xf5,
        0xc4, 0xc5, 0x66, 0x36, 0x37, 0xd6, 0xd5, 0xd4, 
        0xd5, 0xd6, 0xd7, 0x77, 0x76, 0x75, 0xf5, 0xf4,
        0xc3, 0xc4, 0x65, 0x66, 0x67, 0xd7, 0xd6, 0xd5, 
        0xd6, 0xd7, 0x98, 0x97, 0x96, 0xf5, 0xf4, 0xf3,
        0xc4, 0x65, 0x64, 0x65, 0x66, 0x67, 0xd7, 0xd6, 
        0xd7, 0x98, 0x97, 0x96, 0x95, 0x96, 0xf5, 0xf4,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0x67, 0xd7, 
        0x98, 0x97, 0x96, 0x95, 0x94, 0x95, 0x96, 0xf5,
        0x64, 0x63, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 
        0x97, 0x96, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x63, 0x62, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 
        0x96, 0x95, 0x94, 0x93, 0x92, 0x93, 0x94, 0x95,
        0x64, 0x63, 0x62, 0x63, 0x64, 0x65, 0x66, 0x96, 
        0x95, 0x94, 0x93, 0x92, 0x91, 0x92, 0x93, 0x94,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0xe6, 0xe5, 
        0xe4, 0x95, 0x94, 0x93, 0x92, 0x93, 0x94, 0x95,
        0x66, 0x65, 0x64, 0x65, 0x66, 0xe6, 0xe5, 0xe4, 
        0xe3, 0xe4, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x35, 0x34, 0x33, 0x32, 0x33, 0x34, 0x35, 0xb5, 
        0xb4, 0xb5, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0x34, 0x33, 0x32, 0x31, 0x32, 0x33, 0x34, 0x35, 
        0xb5, 0x76, 0x75, 0x74, 0x73, 0x72, 0x73, 0x74,
        0x33, 0x32, 0x31, 0x30, 0x31, 0x32, 0x33, 0x34, 
        0x35, 0x75, 0x74, 0x73, 0x72, 0x71, 0x72, 0x73,
        0x34, 0x33, 0x32, 0x31, 0x32, 0x33, 0x34, 0x35, 
        0x75, 0x74, 0x73, 0x72, 0x71, 0x70, 0x71, 0x72,
        0x35, 0x34, 0x33, 0x32, 0x33, 0x34, 0x35, 0x36, 
        0x76, 0x75, 0x74, 0x73, 0x72, 0x71, 0x72, 0x73,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0x36, 0xd5, 
        0xd6, 0x76, 0x75, 0x74, 0x73, 0x72, 0x73, 0x74,
        0xc6, 0x36, 0x35, 0x34, 0x35, 0x36, 0xd5, 0xd4, 
        0xd5, 0xd6, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0xc5, 0x66, 0x65, 0x35, 0x36, 0xd5, 0xd4, 0xd3, 
        0xd4, 0xd5, 0xd6, 0x76, 0x75, 0x74, 0x75, 0xf5,
        0xc4, 0x65, 0x64, 0x65, 0x66, 0xd6, 0xd5, 0xd4, 
        0xd5, 0xd6, 0x97, 0x96, 0x95, 0x75, 0xf5, 0xf4,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0xd6, 0xd5, 
        0xd6, 0x97, 0x96, 0x95, 0x94, 0x95, 0x96, 0xf5,
        0x64, 0x63, 0x62, 0x63, 0x64, 0x65, 0x66, 0xd6, 
        0x97, 0x96, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x63, 0x62, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 
        0x96, 0x95, 0x94, 0x93, 0x92, 0x93, 0x94, 0x95,
        0x62, 0x61, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 
        0x95, 0x94, 0x93, 0x92, 0x91, 0x92, 0x93, 0x94,
        0x63, 0x62, 0x61, 0x62, 0x63, 0x64, 0x65, 0x95, 
        0x94, 0x93, 0x92, 0x91, 0x90, 0x91, 0x92, 0x93,
        0x64, 0x63, 0x62, 0x63, 0x64, 0x65, 0x66, 0x96, 
        0x95, 0x94, 0x93, 0x92, 0x91, 0x92, 0x93, 0x94,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0xe6, 0xe5, 
        0xe4, 0x95, 0x94, 0x93, 0x92, 0x93, 0x94, 0x95,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0x36, 0xb6, 
        0xb5, 0xb6, 0x77, 0x76, 0x75, 0x74, 0x75, 0x76,
        0x35, 0x34, 0x33, 0x32, 0x33, 0x34, 0x35, 0x36, 
        0xb6, 0x77, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0x34, 0x33, 0x32, 0x31, 0x32, 0x33, 0x34, 0x35, 
        0x36, 0x76, 0x75, 0x74, 0x73, 0x72, 0x73, 0x74,
        0x35, 0x34, 0x33, 0x32, 0x33, 0x34, 0x35, 0x36, 
        0x76, 0x75, 0x74, 0x73, 0x72, 0x71, 0x72, 0x73,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0x36, 0xd5, 
        0xd6, 0x76, 0x75, 0x74, 0x73, 0x72, 0x73, 0x74,
        0x37, 0x36, 0x35, 0x34, 0x35, 0x36, 0xd5, 0xd4, 
        0xd5, 0xd6, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0xc7, 0x37, 0x36, 0x35, 0x36, 0xd5, 0xd4, 0xd3, 
        0xd4, 0xd5, 0xd6, 0x76, 0x75, 0x74, 0x75, 0x76,
        0xc6, 0x67, 0x66, 0x36, 0xd5, 0xd4, 0xd3, 0xd2, 
        0xd3, 0xd4, 0xd5, 0xd6, 0x76, 0x75, 0x76, 0xf6,
        0xc5, 0x66, 0x65, 0x66, 0xd6, 0xd5, 0xd4, 0xd3, 
        0xd4, 0xd5, 0xd6, 0x97, 0x96, 0x76, 0xf6, 0xf5,
        0x66, 0x65, 0x64, 0x65, 0x66, 0xd6, 0xd5, 0xd4, 
        0xd5, 0xd6, 0x97, 0x96, 0x95, 0x96, 0x97, 0xf6,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0xd6, 0xd5, 
        0xd6, 0x97, 0x96, 0x95, 0x94, 0x95, 0x96, 0x97,
        0x64, 0x63, 0x62, 0x63, 0x64, 0x65, 0x66, 0xd6, 
        0x97, 0x96, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x63, 0x62, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 
        0x96, 0x95, 0x94, 0x93, 0x92, 0x93, 0x94, 0x95,
        0x64, 0x63, 0x62, 0x63, 0x64, 0x65, 0x66, 0x96, 
        0x95, 0x94, 0x93, 0x92, 0x91, 0x92, 0x93, 0x94,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0x67, 0x97, 
        0x96, 0x95, 0x94, 0x93, 0x92, 0x93, 0x94, 0x95,
        0x66, 0x65, 0x64, 0x65, 0x66, 0x67, 0xe7, 0xe6, 
        0xe5, 0x96, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x37, 0x36, 0x35, 0x34, 0x35, 0x36, 0x37, 0xb7, 
        0xb6, 0xb7, 0x78, 0x77, 0x76, 0x75, 0x76, 0x77,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0x36, 0x37, 
        0xb7, 0x78, 0x77, 0x76, 0x75, 0x74, 0x75, 0x76,
        0x35, 0x34, 0x33, 0x32, 0x33, 0x34, 0x35, 0x36, 
        0x37, 0x77, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0x36, 0xd5, 
        0xd6, 0x76, 0x75, 0x74, 0x73, 0x72, 0x73, 0x74,
        0x37, 0x36, 0x35, 0x34, 0x35, 0x36, 0xd5, 0xd4, 
        0xd5, 0xd6, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0x38, 0x37, 0x36, 0x35, 0x36, 0xd5, 0xd4, 0xd3, 
        0xd4, 0xd5, 0xd6, 0x76, 0x75, 0x74, 0x75, 0x76,
        0xc8, 0x38, 0x37, 0x36, 0xd5, 0xd4, 0xd3, 0xd2, 
        0xd3, 0xd4, 0xd5, 0xd6, 0x76, 0x75, 0x76, 0x77,
        0xc7, 0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 
        0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0x76, 0x77, 0xf7,
        0xc6, 0x67, 0x66, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 
        0xd3, 0xd4, 0xd5, 0xd6, 0x97, 0x77, 0xf7, 0xf6,
        0x67, 0x66, 0x65, 0x66, 0xd6, 0xd5, 0xd4, 0xd3, 
        0xd4, 0xd5, 0xd6, 0x97, 0x96, 0x97, 0x98, 0xf7,
        0x66, 0x65, 0x64, 0x65, 0x66, 0xd6, 0xd5, 0xd4, 
        0xd5, 0xd6, 0x97, 0x96, 0x95, 0x96, 0x97, 0x98,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0xd6, 0xd5, 
        0xd6, 0x97, 0x96, 0x95, 0x94, 0x95, 0x96, 0x97,
        0x64, 0x63, 0x62, 0x63, 0x64, 0x65, 0x66, 0xd6, 
        0x97, 0x96, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0x67, 0x97, 
        0x96, 0x95, 0x94, 0x93, 0x92, 0x93, 0x94, 0x95,
        0x66, 0x65, 0x64, 0x65, 0x66, 0x67, 0x68, 0x98, 
        0x97, 0x96, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x67, 0x66, 0x65, 0x66, 0x67, 0x68, 0xe8, 0xe7, 
        0xe6, 0x97, 0x96, 0x95, 0x94, 0x95, 0x96, 0x97,
        0x38, 0x37, 0x36, 0x35, 0x36, 0x37, 0x38, 0xd7, 
        0xb7, 0xb8, 0x79, 0x78, 0x77, 0x76, 0x77, 0x78,
        0x37, 0x36, 0x35, 0x34, 0x35, 0x36, 0x37, 0xd6, 
        0xd7, 0xd8, 0x78, 0x77, 0x76, 0x75, 0x76, 0x77,
        0x36, 0x35, 0x34, 0x33, 0x34, 0x35, 0x36, 0xd5, 
        0xd6, 0xd7, 0x77, 0x76, 0x75, 0x74, 0x75, 0x76,
        0x37, 0x36, 0x35, 0x34, 0x35, 0x36, 0xd5, 0xd4, 
        0xd5, 0xd6, 0x76, 0x75, 0x74, 0x73, 0x74, 0x75,
        0x38, 0x37, 0x36, 0x35, 0x36, 0xd5, 0xd4, 0xd3, 
        0xd4, 0xd5, 0xd6, 0x76, 0x75, 0x74, 0x75, 0x76,
        0x39, 0x38, 0x37, 0x36, 0xd5, 0xd4, 0xd3, 0xd2, 
        0xd3, 0xd4, 0xd5, 0xd6, 0x76, 0x75, 0x76, 0x77,
        0xd8, 0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 
        0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0x76, 0x77, 0x78,
        0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 0xd0, 
        0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8,
        0xc7, 0xd7, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 0xd1, 
        0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xf7,
        0x68, 0x67, 0x66, 0xd6, 0xd5, 0xd4, 0xd3, 0xd2, 
        0xd3, 0xd4, 0xd5, 0xd6, 0x97, 0x98, 0x99, 0xf8,
        0x67, 0x66, 0x65, 0x66, 0xd6, 0xd5, 0xd4, 0xd3, 
        0xd4, 0xd5, 0xd6, 0x97, 0x96, 0x97, 0x98, 0x99,
        0x66, 0x65, 0x64, 0x65, 0x66, 0xd6, 0xd5, 0xd4, 
        0xd5, 0xd6, 0x97, 0x96, 0x95, 0x96, 0x97, 0x98,
        0x65, 0x64, 0x63, 0x64, 0x65, 0x66, 0xd6, 0xd5, 
        0xd6, 0x97, 0x96, 0x95, 0x94, 0x95, 0x96, 0x97,
        0x66, 0x65, 0x64, 0x65, 0x66, 0x67, 0xd7, 0xd6, 
        0x97, 0x96, 0x95, 0x94, 0x93, 0x94, 0x95, 0x96,
        0x67, 0x66, 0x65, 0x66, 0x67, 0x68, 0xd8, 0xd7, 
        0x98, 0x97, 0x96, 0x95, 0x94, 0x95, 0x96, 0x97,
        0x68, 0x67, 0x66, 0x67, 0x68, 0x69, 0xd9, 0xd8, 
        0xe7, 0x98, 0x97, 0x96, 0x95, 0x96, 0x97, 0x98
};

UWORD nearmc[4096] = {
        0x000, 0x000, 0x000, 0x300, 0x300, 0xb00, 0xb10, 0xba0, 
        0xba0, 0xba0, 0xba0, 0x5a0, 0x5a0, 0x580, 0x580, 0x580,
        0x000, 0x000, 0x300, 0x300, 0x300, 0x300, 0xb10, 0xba0, 
        0xba0, 0xba0, 0x5a0, 0x5a0, 0x5a0, 0x580, 0x580, 0x580,
        0x000, 0x300, 0x300, 0x300, 0x300, 0x300, 0x310, 0xba0, 
        0xba0, 0x5a0, 0x5a0, 0x5a0, 0x5a0, 0x580, 0x580, 0x580,
        0x000, 0x300, 0x300, 0x300, 0x300, 0x300, 0x110, 0x1a0, 
        0xba0, 0x5a0, 0x5a0, 0x5a0, 0x5a0, 0x780, 0x780, 0x780,
        0x000, 0x200, 0x200, 0x300, 0x300, 0x100, 0x110, 0x1a0, 
        0x1a0, 0x1a0, 0x5a0, 0x5a0, 0x5a0, 0x780, 0x780, 0x780,
        0xc0a, 0x20a, 0x20a, 0x20a, 0x10a, 0x10a, 0x11a, 0x1aa, 
        0x1aa, 0x1aa, 0xaaa, 0x5aa, 0x5aa, 0x78a, 0x78a, 0xf8a,
        0xc0a, 0x20a, 0x20a, 0x20a, 0x10a, 0x10a, 0x11a, 0x1aa, 
        0x1aa, 0x1aa, 0xaaa, 0xaaa, 0x5aa, 0x78a, 0xf8a, 0xf8a,
        0xc0a, 0x20a, 0x20a, 0x20a, 0x20a, 0x10a, 0x11a, 0xdaa, 
        0xdaa, 0xaaa, 0xaaa, 0xaaa, 0xaaa, 0xf8a, 0xf8a, 0xf8a,
        0xc0a, 0xc0a, 0x20a, 0x20a, 0x20a, 0x10a, 0x11a, 0xdaa, 
        0xaaa, 0xaaa, 0xaaa, 0xaaa, 0xaaa, 0xf8a, 0xf8a, 0xf8a,
        0xc0a, 0xc0a, 0x20a, 0x20a, 0x20a, 0x10a, 0x11a, 0xdaa, 
        0xaaa, 0xaaa, 0xaaa, 0xaaa, 0xaaa, 0x88a, 0xf8a, 0xf8a,
        0xc0a, 0x60a, 0x60a, 0x40a, 0x40a, 0x10a, 0x11a, 0xdaa, 
        0xaaa, 0xaaa, 0xaaa, 0xaaa, 0x8aa, 0x88a, 0x88a, 0xf8a,
        0x60a, 0x60a, 0x60a, 0x40a, 0x40a, 0x40a, 0x11a, 0xdaa, 
        0xeaa, 0xaaa, 0xaaa, 0x8aa, 0x8aa, 0x88a, 0x88a, 0x88a,
        0x608, 0x608, 0x608, 0x408, 0x408, 0x408, 0x418, 0xea8, 
        0xea8, 0x8a8, 0x8a8, 0x8a8, 0x8a8, 0x888, 0x888, 0x888,
        0x404, 0x404, 0x404, 0x404, 0x404, 0x404, 0x414, 0xea4, 
        0xea4, 0x9a4, 0x9a4, 0x9a4, 0x9a4, 0x884, 0x884, 0x884,
        0x404, 0x404, 0x404, 0x404, 0x404, 0x404, 0xe14, 0xea4, 
        0xea4, 0xea4, 0x9a4, 0x9a4, 0x9a4, 0x884, 0x884, 0x884,
        0x404, 0x404, 0x404, 0x404, 0x404, 0xe04, 0xe14, 0xea4, 
        0xea4, 0xea4, 0xea4, 0x9a4, 0x9a4, 0x884, 0x884, 0x884,
        0x000, 0x000, 0x020, 0x340, 0x340, 0xb10, 0xb10, 0xb10, 
        0xba0, 0xba0, 0xba0, 0x5a0, 0x550, 0x580, 0x580, 0x580,
        0x000, 0x000, 0x320, 0x340, 0x340, 0x310, 0xb10, 0xb10, 
        0xba0, 0xba0, 0x5a0, 0x5a0, 0x550, 0x580, 0x580, 0x580,
        0x005, 0x305, 0x325, 0x345, 0x345, 0x315, 0x315, 0xb15, 
        0xba5, 0x5a5, 0x5a5, 0x5a5, 0x555, 0x585, 0x585, 0x585,
        0x005, 0x305, 0x325, 0x345, 0x345, 0x315, 0x115, 0x115, 
        0xba5, 0x5a5, 0x5a5, 0x5a5, 0x555, 0x785, 0x785, 0x785,
        0x005, 0x205, 0x225, 0x345, 0x345, 0x115, 0x115, 0x115, 
        0x1a5, 0x1a5, 0x5a5, 0x5a5, 0x555, 0x785, 0x785, 0x785,
        0xc01, 0x201, 0x221, 0x241, 0x141, 0x111, 0x111, 0x111, 
        0x1a1, 0x1a1, 0xaa1, 0x5a1, 0x551, 0x781, 0x781, 0xf81,
        0xc01, 0x201, 0x221, 0x241, 0x141, 0x111, 0x111, 0x111, 
        0x1a1, 0x1a1, 0xaa1, 0xaa1, 0x551, 0x781, 0xf81, 0xf81,
        0xc02, 0x202, 0x222, 0x242, 0x242, 0x112, 0x112, 0xd12, 
        0xda2, 0xaa2, 0xaa2, 0xaa2, 0xa52, 0xf82, 0xf82, 0xf82,
        0xc0a, 0xc0a, 0x22a, 0x24a, 0x24a, 0x11a, 0x11a, 0xd1a, 
        0xaaa, 0xaaa, 0xaaa, 0xaaa, 0xa5a, 0xf8a, 0xf8a, 0xf8a,
        0xc0a, 0xc0a, 0x22a, 0x24a, 0x24a, 0x11a, 0x11a, 0xd1a, 
        0xaaa, 0xaaa, 0xaaa, 0xaaa, 0xa5a, 0x88a, 0xf8a, 0xf8a,
        0xc0a, 0x60a, 0x62a, 0x44a, 0x44a, 0x11a, 0x11a, 0xd1a, 
        0xaaa, 0xaaa, 0xaaa, 0xaaa, 0x85a, 0x88a, 0x88a, 0xf8a,
        0x608, 0x608, 0x628, 0x448, 0x448, 0x418, 0x118, 0xd18, 
        0xea8, 0xaa8, 0xaa8, 0x8a8, 0x858, 0x888, 0x888, 0x888,
        0x608, 0x608, 0x628, 0x448, 0x448, 0x418, 0x418, 0xe18, 
        0xea8, 0x8a8, 0x8a8, 0x8a8, 0x858, 0x888, 0x888, 0x888,
        0x404, 0x404, 0x424, 0x444, 0x444, 0x414, 0x414, 0xe14, 
        0xea4, 0x9a4, 0x9a4, 0x9a4, 0x954, 0x884, 0x884, 0x884,
        0x404, 0x404, 0x424, 0x444, 0x444, 0x414, 0xe14, 0xe14, 
        0xea4, 0xea4, 0x9a4, 0x9a4, 0x954, 0x884, 0x884, 0x884,
        0x404, 0x404, 0x424, 0x444, 0x444, 0xe14, 0xe14, 0xe14, 
        0xea4, 0xea4, 0xea4, 0x9a4, 0x954, 0x884, 0x884, 0x884,
        0x000, 0x020, 0x020, 0x340, 0x340, 0xb10, 0xb10, 0xb10, 
        0xb10, 0xba0, 0xba0, 0x550, 0x550, 0x580, 0x580, 0x580,
        0x005, 0x025, 0x325, 0x345, 0x345, 0x315, 0xb15, 0xb15, 
        0xb15, 0xba5, 0x5a5, 0x555, 0x555, 0x585, 0x585, 0x585,
        0x005, 0x325, 0x325, 0x345, 0x345, 0x315, 0x315, 0xb15, 
        0xb15, 0x5a5, 0x5a5, 0x555, 0x555, 0x585, 0x585, 0x585,
        0x005, 0x325, 0x325, 0x345, 0x345, 0x315, 0x115, 0x115, 
        0xb15, 0x5a5, 0x5a5, 0x555, 0x555, 0x785, 0x785, 0x785,
        0x005, 0x225, 0x225, 0x345, 0x345, 0x115, 0x115, 0x115, 
        0x115, 0x1a5, 0x5a5, 0x555, 0x555, 0x785, 0x785, 0x785,
        0xc01, 0x221, 0x221, 0x241, 0x141, 0x111, 0x111, 0x111, 
        0x111, 0x1a1, 0xaa1, 0x551, 0x551, 0x781, 0x781, 0xf81,
        0xc01, 0x221, 0x221, 0x241, 0x141, 0x111, 0x111, 0x111, 
        0x111, 0x1a1, 0xaa1, 0xa51, 0x551, 0x781, 0xf81, 0xf81,
        0xc02, 0x222, 0x222, 0x242, 0x242, 0x112, 0x112, 0xd12, 
        0xd12, 0xaa2, 0xaa2, 0xa52, 0xa52, 0xf82, 0xf82, 0xf82,
        0xc02, 0xc22, 0x222, 0x242, 0x242, 0x112, 0x112, 0xd12, 
        0xa12, 0xaa2, 0xaa2, 0xa52, 0xa52, 0xf82, 0xf82, 0xf82,
        0xc02, 0xc22, 0x222, 0x242, 0x242, 0x112, 0x112, 0xd12, 
        0xa12, 0xaa2, 0xaa2, 0xa52, 0xa52, 0x882, 0xf82, 0xf82,
        0xc08, 0x628, 0x628, 0x448, 0x448, 0x118, 0x118, 0xd18, 
        0xa18, 0xaa8, 0xaa8, 0xa58, 0x858, 0x888, 0x888, 0xf88,
        0x608, 0x628, 0x628, 0x448, 0x448, 0x418, 0x118, 0xd18, 
        0xe18, 0xaa8, 0xaa8, 0x858, 0x858, 0x888, 0x888, 0x888,
        0x608, 0x628, 0x628, 0x448, 0x448, 0x418, 0x418, 0xe18, 
        0xe18, 0x8a8, 0x8a8, 0x858, 0x858, 0x888, 0x888, 0x888,
        0x404, 0x424, 0x424, 0x444, 0x444, 0x414, 0x414, 0xe14, 
        0xe14, 0x9a4, 0x9a4, 0x954, 0x954, 0x884, 0x884, 0x884,
        0x404, 0x424, 0x424, 0x444, 0x444, 0x414, 0xe14, 0xe14, 
        0xe14, 0xea4, 0x9a4, 0x954, 0x954, 0x884, 0x884, 0x884,
        0x404, 0x424, 0x424, 0x444, 0x444, 0xe14, 0xe14, 0xe14, 
        0xe14, 0xea4, 0xea4, 0x954, 0x954, 0x884, 0x884, 0x884,
        0x025, 0x025, 0x025, 0x345, 0x345, 0xb15, 0xb15, 0xb15, 
        0xb15, 0xb55, 0xb55, 0x555, 0x555, 0x585, 0x585, 0x585,
        0x025, 0x025, 0x325, 0x345, 0x345, 0x315, 0xb15, 0xb15, 
        0xb15, 0xb55, 0x555, 0x555, 0x555, 0x585, 0x585, 0x585,
        0x025, 0x325, 0x325, 0x345, 0x345, 0x315, 0x315, 0xb15, 
        0xb15, 0x555, 0x555, 0x555, 0x555, 0x585, 0x585, 0x585,
        0x025, 0x325, 0x325, 0x345, 0x345, 0x315, 0x115, 0x115, 
        0xb15, 0x555, 0x555, 0x555, 0x555, 0x785, 0x785, 0x785,
        0x025, 0x225, 0x225, 0x345, 0x345, 0x115, 0x115, 0x115, 
        0x115, 0x155, 0x555, 0x555, 0x555, 0x785, 0x785, 0x785,
        0xc21, 0x221, 0x221, 0x241, 0x141, 0x111, 0x111, 0x111, 
        0x111, 0x151, 0xa51, 0x551, 0x551, 0x781, 0x781, 0xf81,
        0xc21, 0x221, 0x221, 0x241, 0x141, 0x111, 0x111, 0x111, 
        0x111, 0x151, 0xa51, 0xa51, 0x551, 0x781, 0xf81, 0xf81,
        0xc22, 0x222, 0x222, 0x242, 0x242, 0x112, 0x112, 0xd12, 
        0xd12, 0xa52, 0xa52, 0xa52, 0xa52, 0xf82, 0xf82, 0xf82,
        0xc22, 0xc22, 0x222, 0x242, 0x242, 0x112, 0x112, 0xd12, 
        0xa12, 0xa52, 0xa52, 0xa52, 0xa52, 0xf82, 0xf82, 0xf82,
        0xc22, 0xc22, 0x222, 0x242, 0x242, 0x112, 0x112, 0xd12, 
        0xa12, 0xa52, 0xa52, 0xa52, 0xa52, 0x882, 0xf82, 0xf82,
        0xc28, 0x628, 0x628, 0x448, 0x448, 0x118, 0x118, 0xd18, 
        0xa18, 0xa58, 0xa58, 0xa58, 0x858, 0x888, 0x888, 0xf88,
        0x628, 0x628, 0x628, 0x448, 0x448, 0x418, 0x118, 0xd18, 
        0xe18, 0xa58, 0xa58, 0x858, 0x858, 0x888, 0x888, 0x888,
        0x628, 0x628, 0x628, 0x448, 0x448, 0x418, 0x418, 0xe18, 
        0xe18, 0x858, 0x858, 0x858, 0x858, 0x888, 0x888, 0x888,
        0x424, 0x424, 0x424, 0x444, 0x444, 0x414, 0x414, 0xe14, 
        0xe14, 0x954, 0x954, 0x954, 0x954, 0x884, 0x884, 0x884,
        0x424, 0x424, 0x424, 0x444, 0x444, 0x414, 0xe14, 0xe14, 
        0xe14, 0xe54, 0x954, 0x954, 0x954, 0x884, 0x884, 0x884,
        0x424, 0x424, 0x424, 0x444, 0x444, 0xe14, 0xe14, 0xe14, 
        0xe14, 0xe54, 0xe54, 0x954, 0x954, 0x884, 0x884, 0x884,
        0x025, 0x025, 0x025, 0x345, 0x315, 0xb15, 0xb15, 0xb15, 
        0xb15, 0xb15, 0xb55, 0x555, 0x555, 0x585, 0x585, 0x585,
        0x025, 0x025, 0x325, 0x345, 0x315, 0x315, 0xb15, 0xb15, 
        0xb15, 0xb15, 0x555, 0x555, 0x555, 0x585, 0x585, 0x585,
        0x025, 0x325, 0x325, 0x345, 0x315, 0x315, 0x315, 0xb15, 
        0xb15, 0x515, 0x555, 0x555, 0x555, 0x585, 0x585, 0x585,
        0x025, 0x325, 0x325, 0x345, 0x315, 0x315, 0x115, 0x115, 
        0xb15, 0x515, 0x555, 0x555, 0x555, 0x785, 0x785, 0x785,
        0x021, 0x221, 0x221, 0x341, 0x311, 0x111, 0x111, 0x111, 
        0x111, 0x111, 0x551, 0x551, 0x551, 0x781, 0x781, 0x781,
        0xc21, 0x221, 0x221, 0x241, 0x111, 0x111, 0x111, 0x111, 
        0x111, 0x111, 0xa51, 0x551, 0x551, 0x781, 0x781, 0xf81,
        0xc21, 0x221, 0x221, 0x241, 0x111, 0x111, 0x111, 0x111, 
        0x111, 0x111, 0xa51, 0xa51, 0x551, 0x781, 0xf81, 0xf81,
        0xc21, 0x221, 0x221, 0x241, 0x211, 0x111, 0x111, 0xd11, 
        0xd11, 0xa11, 0xa51, 0xa51, 0xa51, 0xf81, 0xf81, 0xf81,
        0xc21, 0xc21, 0x221, 0x241, 0x211, 0x111, 0x111, 0xd11, 
        0xa11, 0xa11, 0xa51, 0xa51, 0xa51, 0xf81, 0xf81, 0xf81,
        0xc21, 0xc21, 0x221, 0x241, 0x211, 0x111, 0x111, 0xd11, 
        0xa11, 0xa11, 0xa51, 0xa51, 0xa51, 0x881, 0xf81, 0xf81,
        0xc28, 0x628, 0x628, 0x448, 0x418, 0x118, 0x118, 0xd18, 
        0xa18, 0xa18, 0xa58, 0xa58, 0x858, 0x888, 0x888, 0xf88,
        0x628, 0x628, 0x628, 0x448, 0x418, 0x418, 0x118, 0xd18, 
        0xe18, 0xa18, 0xa58, 0x858, 0x858, 0x888, 0x888, 0x888,
        0x628, 0x628, 0x628, 0x448, 0x418, 0x418, 0x418, 0xe18, 
        0xe18, 0x818, 0x858, 0x858, 0x858, 0x888, 0x888, 0x888,
        0x424, 0x424, 0x424, 0x444, 0x414, 0x414, 0x414, 0xe14, 
        0xe14, 0x914, 0x954, 0x954, 0x954, 0x884, 0x884, 0x884,
        0x424, 0x424, 0x424, 0x444, 0x414, 0x414, 0xe14, 0xe14, 
        0xe14, 0xe14, 0x954, 0x954, 0x954, 0x884, 0x884, 0x884,
        0x424, 0x424, 0x424, 0x444, 0x414, 0xe14, 0xe14, 0xe14, 
        0xe14, 0xe14, 0xe54, 0x954, 0x954, 0x884, 0x884, 0x884,
        0x0cb, 0x02b, 0x02b, 0x34b, 0x31b, 0xb1b, 0xb1b, 0xb1b, 
        0xb1b, 0xb1b, 0xb5b, 0x55b, 0x55b, 0x58b, 0x58b, 0x5fb,
        0x0c5, 0x025, 0x325, 0x345, 0x315, 0x315, 0xb15, 0xb15, 
        0xb15, 0xb15, 0x555, 0x555, 0x555, 0x585, 0x585, 0x5f5,
        0x0c5, 0x325, 0x325, 0x345, 0x315, 0x315, 0x315, 0xb15, 
        0xb15, 0x515, 0x555, 0x555, 0x555, 0x585, 0x585, 0x5f5,
        0x0c5, 0x325, 0x325, 0x345, 0x315, 0x315, 0x115, 0x115, 
        0xb15, 0x515, 0x555, 0x555, 0x555, 0x785, 0x785, 0x7f5,
        0x0c1, 0x221, 0x221, 0x341, 0x311, 0x111, 0x111, 0x111, 
        0x111, 0x111, 0x551, 0x551, 0x551, 0x781, 0x781, 0x7f1,
        0xcc1, 0x221, 0x221, 0x241, 0x111, 0x111, 0x111, 0x111, 
        0x111, 0x111, 0xa51, 0x551, 0x551, 0x781, 0x781, 0xff1,
        0xcc1, 0x221, 0x221, 0x241, 0x111, 0x111, 0x111, 0x111, 
        0x111, 0x111, 0xa51, 0xa51, 0x551, 0x781, 0xf81, 0xff1,
        0xcc1, 0x221, 0x221, 0x241, 0x211, 0x111, 0x111, 0xd11, 
        0xd11, 0xa11, 0xa51, 0xa51, 0xa51, 0xf81, 0xf81, 0xff1,
        0xcc1, 0xc21, 0x221, 0x241, 0x211, 0x111, 0x111, 0xd11, 
        0xa11, 0xa11, 0xa51, 0xa51, 0xa51, 0xf81, 0xf81, 0xff1,
        0xcc1, 0xc21, 0x221, 0x241, 0x211, 0x111, 0x111, 0xd11, 
        0xa11, 0xa11, 0xa51, 0xa51, 0xa51, 0x881, 0xf81, 0xff1,
        0xcc8, 0x628, 0x628, 0x448, 0x418, 0x118, 0x118, 0xd18, 
        0xa18, 0xa18, 0xa58, 0xa58, 0x858, 0x888, 0x888, 0xff8,
        0x6c8, 0x628, 0x628, 0x448, 0x418, 0x418, 0x118, 0xd18, 
        0xe18, 0xa18, 0xa58, 0x858, 0x858, 0x888, 0x888, 0x8f8,
        0x6c8, 0x628, 0x628, 0x448, 0x418, 0x418, 0x418, 0xe18, 
        0xe18, 0x818, 0x858, 0x858, 0x858, 0x888, 0x888, 0x8f8,
        0x4c4, 0x424, 0x424, 0x444, 0x414, 0x414, 0x414, 0xe14, 
        0xe14, 0x914, 0x954, 0x954, 0x954, 0x884, 0x884, 0x8f4,
        0x4c4, 0x424, 0x424, 0x444, 0x414, 0x414, 0xe14, 0xe14, 
        0xe14, 0xe14, 0x954, 0x954, 0x954, 0x884, 0x884, 0x8f4,
        0x4ce, 0x42e, 0x42e, 0x44e, 0x41e, 0xe1e, 0xe1e, 0xe1e, 
        0xe1e, 0xe1e, 0xe5e, 0x95e, 0x95e, 0x88e, 0x88e, 0x8fe,
        0x0cb, 0x0cb, 0x02b, 0x34b, 0x31b, 0xb1b, 0xb1b, 0xb1b, 
        0xbbb, 0xbbb, 0xbbb, 0x55b, 0x55b, 0x58b, 0x5fb, 0x5fb,
        0x0cb, 0x0cb, 0x32b, 0x34b, 0x31b, 0x31b, 0xb1b, 0xb1b, 
        0xbbb, 0xbbb, 0x5bb, 0x55b, 0x55b, 0x58b, 0x5fb, 0x5fb,
        0x0c5, 0x3c5, 0x325, 0x345, 0x315, 0x315, 0x315, 0xb15, 
        0xbb5, 0x5b5, 0x5b5, 0x555, 0x555, 0x585, 0x5f5, 0x5f5,
        0x0c5, 0x3c5, 0x325, 0x345, 0x315, 0x315, 0x115, 0x115, 
        0xbb5, 0x5b5, 0x5b5, 0x555, 0x555, 0x785, 0x7f5, 0x7f5,
        0x0c1, 0x2c1, 0x221, 0x341, 0x311, 0x111, 0x111, 0x111, 
        0x1b1, 0x1b1, 0x5b1, 0x551, 0x551, 0x781, 0x7f1, 0x7f1,
        0xcc1, 0x2c1, 0x221, 0x241, 0x111, 0x111, 0x111, 0x111, 
        0x1b1, 0x1b1, 0xab1, 0x551, 0x551, 0x781, 0x7f1, 0xff1,
        0xcc1, 0x2c1, 0x221, 0x241, 0x111, 0x111, 0x111, 0x111, 
        0x1b1, 0x1b1, 0xab1, 0xa51, 0x551, 0x781, 0xff1, 0xff1,
        0xcc1, 0x2c1, 0x221, 0x241, 0x211, 0x111, 0x111, 0xd11, 
        0xdb1, 0xab1, 0xab1, 0xa51, 0xa51, 0xf81, 0xff1, 0xff1,
        0xccc, 0xccc, 0x22c, 0x24c, 0x21c, 0x11c, 0x11c, 0xd1c, 
        0xabc, 0xabc, 0xabc, 0xa5c, 0xa5c, 0xf8c, 0xffc, 0xffc,
        0xccc, 0xccc, 0x22c, 0x24c, 0x21c, 0x11c, 0x11c, 0xd1c, 
        0xabc, 0xabc, 0xabc, 0xa5c, 0xa5c, 0x88c, 0xffc, 0xffc,
        0xccc, 0x6cc, 0x62c, 0x44c, 0x41c, 0x11c, 0x11c, 0xd1c, 
        0xabc, 0xabc, 0xabc, 0xa5c, 0x85c, 0x88c, 0x8fc, 0xffc,
        0x6c8, 0x6c8, 0x628, 0x448, 0x418, 0x418, 0x118, 0xd18, 
        0xeb8, 0xab8, 0xab8, 0x858, 0x858, 0x888, 0x8f8, 0x8f8,
        0x6c8, 0x6c8, 0x628, 0x448, 0x418, 0x418, 0x418, 0xe18, 
        0xeb8, 0x8b8, 0x8b8, 0x858, 0x858, 0x888, 0x8f8, 0x8f8,
        0x4c4, 0x4c4, 0x424, 0x444, 0x414, 0x414, 0x414, 0xe14, 
        0xeb4, 0x9b4, 0x9b4, 0x954, 0x954, 0x884, 0x8f4, 0x8f4,
        0x4ce, 0x4ce, 0x42e, 0x44e, 0x41e, 0x41e, 0xe1e, 0xe1e, 
        0xebe, 0xebe, 0x9be, 0x95e, 0x95e, 0x88e, 0x8fe, 0x8fe,
        0x4ce, 0x4ce, 0x42e, 0x44e, 0x41e, 0xe1e, 0xe1e, 0xe1e, 
        0xebe, 0xebe, 0xebe, 0x95e, 0x95e, 0x88e, 0x8fe, 0x8fe,
        0x0cb, 0x0cb, 0x0cb, 0x34b, 0x31b, 0xb1b, 0xb1b, 0xbbb, 
        0xbbb, 0xbbb, 0xbbb, 0x5bb, 0x55b, 0x5fb, 0x5fb, 0x5fb,
        0x0cb, 0x0cb, 0x3cb, 0x34b, 0x31b, 0x31b, 0xb1b, 0xbbb, 
        0xbbb, 0xbbb, 0x5bb, 0x5bb, 0x55b, 0x5fb, 0x5fb, 0x5fb,
        0x0cb, 0x3cb, 0x3cb, 0x34b, 0x31b, 0x31b, 0x31b, 0xbbb, 
        0xbbb, 0x5bb, 0x5bb, 0x5bb, 0x55b, 0x5fb, 0x5fb, 0x5fb,
        0x0cb, 0x3cb, 0x3cb, 0x34b, 0x31b, 0x31b, 0x11b, 0x1bb, 
        0xbbb, 0x5bb, 0x5bb, 0x5bb, 0x55b, 0x7fb, 0x7fb, 0x7fb,
        0x0c1, 0x2c1, 0x2c1, 0x341, 0x311, 0x111, 0x111, 0x1b1, 
        0x1b1, 0x1b1, 0x5b1, 0x5b1, 0x551, 0x7f1, 0x7f1, 0x7f1,
        0xcc1, 0x2c1, 0x2c1, 0x241, 0x111, 0x111, 0x111, 0x1b1, 
        0x1b1, 0x1b1, 0xab1, 0x5b1, 0x551, 0x7f1, 0x7f1, 0xff1,
        0xcc1, 0x2c1, 0x2c1, 0x241, 0x111, 0x111, 0x111, 0x1b1, 
        0x1b1, 0x1b1, 0xab1, 0xab1, 0x551, 0x7f1, 0xff1, 0xff1,
        0xccc, 0x2cc, 0x2cc, 0x24c, 0x21c, 0x11c, 0x11c, 0xdbc, 
        0xdbc, 0xabc, 0xabc, 0xabc, 0xa5c, 0xffc, 0xffc, 0xffc,
        0xccc, 0xccc, 0x2cc, 0x24c, 0x21c, 0x11c, 0x11c, 0xdbc, 
        0xabc, 0xabc, 0xabc, 0xabc, 0xa5c, 0xffc, 0xffc, 0xffc,
        0xccc, 0xccc, 0x2cc, 0x24c, 0x21c, 0x11c, 0x11c, 0xdbc, 
        0xabc, 0xabc, 0xabc, 0xabc, 0xa5c, 0x8fc, 0xffc, 0xffc,
        0xccc, 0x6cc, 0x6cc, 0x44c, 0x41c, 0x11c, 0x11c, 0xdbc, 
        0xabc, 0xabc, 0xabc, 0xabc, 0x85c, 0x8fc, 0x8fc, 0xffc,
        0x6cc, 0x6cc, 0x6cc, 0x44c, 0x41c, 0x41c, 0x11c, 0xdbc, 
        0xebc, 0xabc, 0xabc, 0x8bc, 0x85c, 0x8fc, 0x8fc, 0x8fc,
        0x6c8, 0x6c8, 0x6c8, 0x448, 0x418, 0x418, 0x418, 0xeb8, 
        0xeb8, 0x8b8, 0x8b8, 0x8b8, 0x858, 0x8f8, 0x8f8, 0x8f8,
        0x4ce, 0x4ce, 0x4ce, 0x44e, 0x41e, 0x41e, 0x41e, 0xebe, 
        0xebe, 0x9be, 0x9be, 0x9be, 0x95e, 0x8fe, 0x8fe, 0x8fe,
        0x4ce, 0x4ce, 0x4ce, 0x44e, 0x41e, 0x41e, 0xe1e, 0xebe, 
        0xebe, 0xebe, 0x9be, 0x9be, 0x95e, 0x8fe, 0x8fe, 0x8fe,
        0x4ce, 0x4ce, 0x4ce, 0x44e, 0x41e, 0xe1e, 0xe1e, 0xebe, 
        0xebe, 0xebe, 0xebe, 0x9be, 0x95e, 0x8fe, 0x8fe, 0x8fe,
        0x0cb, 0x0cb, 0x0cb, 0x3cb, 0x3bb, 0xbbb, 0xbbb, 0xbbb, 
        0xbbb, 0xbbb, 0xbbb, 0x5bb, 0x5fb, 0x5fb, 0x5fb, 0x5fb,
        0x0cb, 0x0cb, 0x3cb, 0x3cb, 0x3bb, 0x3bb, 0xbbb, 0xbbb, 
        0xbbb, 0xbbb, 0x5bb, 0x5bb, 0x5fb, 0x5fb, 0x5fb, 0x5fb,
        0x0cb, 0x3cb, 0x3cb, 0x3cb, 0x3bb, 0x3bb, 0x3bb, 0xbbb, 
        0xbbb, 0x5bb, 0x5bb, 0x5bb, 0x5fb, 0x5fb, 0x5fb, 0x5fb,
        0x0cb, 0x3cb, 0x3cb, 0x3cb, 0x3bb, 0x3bb, 0x1bb, 0x1bb, 
        0xbbb, 0x5bb, 0x5bb, 0x5bb, 0x5fb, 0x7fb, 0x7fb, 0x7fb,
        0x0cb, 0x2cb, 0x2cb, 0x3cb, 0x3bb, 0x1bb, 0x1bb, 0x1bb, 
        0x1bb, 0x1bb, 0x5bb, 0x5bb, 0x5fb, 0x7fb, 0x7fb, 0x7fb,
        0xccc, 0x2cc, 0x2cc, 0x2cc, 0x1bc, 0x1bc, 0x1bc, 0x1bc, 
        0x1bc, 0x1bc, 0xabc, 0x5bc, 0x5fc, 0x7fc, 0x7fc, 0xffc,
        0xccc, 0x2cc, 0x2cc, 0x2cc, 0x1bc, 0x1bc, 0x1bc, 0x1bc, 
        0x1bc, 0x1bc, 0xabc, 0xabc, 0x5fc, 0x7fc, 0xffc, 0xffc,
        0xccc, 0x2cc, 0x2cc, 0x2cc, 0x2bc, 0x1bc, 0x1bc, 0xdbc, 
        0xdbc, 0xabc, 0xabc, 0xabc, 0xafc, 0xffc, 0xffc, 0xffc,
        0xccc, 0xccc, 0x2cc, 0x2cc, 0x2bc, 0x1bc, 0x1bc, 0xdbc, 
        0xabc, 0xabc, 0xabc, 0xabc, 0xafc, 0xffc, 0xffc, 0xffc,
        0xccc, 0xccc, 0x2cc, 0x2cc, 0x2bc, 0x1bc, 0x1bc, 0xdbc, 
        0xabc, 0xabc, 0xabc, 0xabc, 0xafc, 0x8fc, 0xffc, 0xffc,
        0xccc, 0x6cc, 0x6cc, 0x4cc, 0x4bc, 0x1bc, 0x1bc, 0xdbc, 
        0xabc, 0xabc, 0xabc, 0xabc, 0x8fc, 0x8fc, 0x8fc, 0xffc,
        0x6cc, 0x6cc, 0x6cc, 0x4cc, 0x4bc, 0x4bc, 0x1bc, 0xdbc, 
        0xebc, 0xabc, 0xabc, 0x8bc, 0x8fc, 0x8fc, 0x8fc, 0x8fc,
        0x6ce, 0x6ce, 0x6ce, 0x4ce, 0x4be, 0x4be, 0x4be, 0xebe, 
        0xebe, 0x8be, 0x8be, 0x8be, 0x8fe, 0x8fe, 0x8fe, 0x8fe,
        0x4ce, 0x4ce, 0x4ce, 0x4ce, 0x4be, 0x4be, 0x4be, 0xebe, 
        0xebe, 0x9be, 0x9be, 0x9be, 0x9fe, 0x8fe, 0x8fe, 0x8fe,
        0x4ce, 0x4ce, 0x4ce, 0x4ce, 0x4be, 0x4be, 0xebe, 0xebe, 
        0xebe, 0xebe, 0x9be, 0x9be, 0x9fe, 0x8fe, 0x8fe, 0x8fe,
        0x4ce, 0x4ce, 0x4ce, 0x4ce, 0x4be, 0xebe, 0xebe, 0xebe, 
        0xebe, 0xebe, 0xebe, 0x9be, 0x9fe, 0x8fe, 0x8fe, 0x8fe,
        0x0cb, 0x0cb, 0x06b, 0x33b, 0x33b, 0xbbb, 0xbbb, 0xbbb, 
        0xbbb, 0xbbb, 0xbbb, 0x59b, 0x59b, 0x57b, 0x5fb, 0x5fb,
        0x0cb, 0x0cb, 0x36b, 0x33b, 0x33b, 0x3bb, 0xbbb, 0xbbb, 
        0xbbb, 0xbbb, 0x5bb, 0x59b, 0x59b, 0x57b, 0x5fb, 0x5fb,
        0x0c3, 0x3c3, 0x363, 0x333, 0x333, 0x3b3, 0x3b3, 0xbb3, 
        0xbb3, 0x5b3, 0x5b3, 0x593, 0x593, 0x573, 0x5f3, 0x5f3,
        0x0c7, 0x3c7, 0x367, 0x337, 0x337, 0x3b7, 0x1b7, 0x1b7, 
        0xbb7, 0x5b7, 0x5b7, 0x597, 0x597, 0x777, 0x7f7, 0x7f7,
        0x0c7, 0x2c7, 0x267, 0x337, 0x337, 0x1b7, 0x1b7, 0x1b7, 
        0x1b7, 0x1b7, 0x5b7, 0x597, 0x597, 0x777, 0x7f7, 0x7f7,
        0xccc, 0x2cc, 0x26c, 0x23c, 0x13c, 0x1bc, 0x1bc, 0x1bc, 
        0x1bc, 0x1bc, 0xabc, 0x59c, 0x59c, 0x77c, 0x7fc, 0xffc,
        0xccc, 0x2cc, 0x26c, 0x23c, 0x13c, 0x1bc, 0x1bc, 0x1bc, 
        0x1bc, 0x1bc, 0xabc, 0xa9c, 0x59c, 0x77c, 0xffc, 0xffc,
        0xccc, 0x2cc, 0x26c, 0x23c, 0x23c, 0x1bc, 0x1bc, 0xdbc, 
        0xdbc, 0xabc, 0xabc, 0xa9c, 0xa9c, 0xf7c, 0xffc, 0xffc,
        0xccc, 0xccc, 0x26c, 0x23c, 0x23c, 0x1bc, 0x1bc, 0xdbc, 
        0xabc, 0xabc, 0xabc, 0xa9c, 0xa9c, 0xf7c, 0xffc, 0xffc,
        0xccc, 0xccc, 0x26c, 0x23c, 0x23c, 0x1bc, 0x1bc, 0xdbc, 
        0xabc, 0xabc, 0xabc, 0xa9c, 0xa9c, 0x87c, 0xffc, 0xffc,
        0xccc, 0x6cc, 0x66c, 0x43c, 0x43c, 0x1bc, 0x1bc, 0xdbc, 
        0xabc, 0xabc, 0xabc, 0xa9c, 0x89c, 0x87c, 0x8fc, 0xffc,
        0x6c6, 0x6c6, 0x666, 0x436, 0x436, 0x4b6, 0x1b6, 0xdb6, 
        0xeb6, 0xab6, 0xab6, 0x896, 0x896, 0x876, 0x8f6, 0x8f6,
        0x6c6, 0x6c6, 0x666, 0x436, 0x436, 0x4b6, 0x4b6, 0xeb6, 
        0xeb6, 0x8b6, 0x8b6, 0x896, 0x896, 0x876, 0x8f6, 0x8f6,
        0x4c9, 0x4c9, 0x469, 0x439, 0x439, 0x4b9, 0x4b9, 0xeb9, 
        0xeb9, 0x9b9, 0x9b9, 0x999, 0x999, 0x879, 0x8f9, 0x8f9,
        0x4ce, 0x4ce, 0x46e, 0x43e, 0x43e, 0x4be, 0xebe, 0xebe, 
        0xebe, 0xebe, 0x9be, 0x99e, 0x99e, 0x87e, 0x8fe, 0x8fe,
        0x4ce, 0x4ce, 0x46e, 0x43e, 0x43e, 0xebe, 0xebe, 0xebe, 
        0xebe, 0xebe, 0xebe, 0x99e, 0x99e, 0x87e, 0x8fe, 0x8fe,
        0x0cb, 0x06b, 0x06b, 0x33b, 0x33b, 0xb3b, 0xbbb, 0xbbb, 
        0xbbb, 0xbbb, 0xb9b, 0x59b, 0x59b, 0x57b, 0x57b, 0x5fb,
        0x0c3, 0x063, 0x363, 0x333, 0x333, 0x333, 0xbb3, 0xbb3, 
        0xbb3, 0xbb3, 0x593, 0x593, 0x593, 0x573, 0x573, 0x5f3,
        0x0c3, 0x363, 0x363, 0x333, 0x333, 0x333, 0x3b3, 0xbb3, 
        0xbb3, 0x5b3, 0x593, 0x593, 0x593, 0x573, 0x573, 0x5f3,
        0x0c7, 0x367, 0x367, 0x337, 0x337, 0x337, 0x1b7, 0x1b7, 
        0xbb7, 0x5b7, 0x597, 0x597, 0x597, 0x777, 0x777, 0x7f7,
        0x0c7, 0x267, 0x267, 0x337, 0x337, 0x137, 0x1b7, 0x1b7, 
        0x1b7, 0x1b7, 0x597, 0x597, 0x597, 0x777, 0x777, 0x7f7,
        0xcc7, 0x267, 0x267, 0x237, 0x137, 0x137, 0x1b7, 0x1b7, 
        0x1b7, 0x1b7, 0xa97, 0x597, 0x597, 0x777, 0x777, 0xff7,
        0xccc, 0x26c, 0x26c, 0x23c, 0x13c, 0x13c, 0x1bc, 0x1bc, 
        0x1bc, 0x1bc, 0xa9c, 0xa9c, 0x59c, 0x77c, 0xf7c, 0xffc,
        0xccc, 0x26c, 0x26c, 0x23c, 0x23c, 0x13c, 0x1bc, 0xdbc, 
        0xdbc, 0xabc, 0xa9c, 0xa9c, 0xa9c, 0xf7c, 0xf7c, 0xffc,
        0xccc, 0xc6c, 0x26c, 0x23c, 0x23c, 0x13c, 0x1bc, 0xdbc, 
        0xabc, 0xabc, 0xa9c, 0xa9c, 0xa9c, 0xf7c, 0xf7c, 0xffc,
        0xccc, 0xc6c, 0x26c, 0x23c, 0x23c, 0x13c, 0x1bc, 0xdbc, 
        0xabc, 0xabc, 0xa9c, 0xa9c, 0xa9c, 0x87c, 0xf7c, 0xffc,
        0xcc6, 0x666, 0x666, 0x436, 0x436, 0x136, 0x1b6, 0xdb6, 
        0xab6, 0xab6, 0xa96, 0xa96, 0x896, 0x876, 0x876, 0xff6,
        0x6c6, 0x666, 0x666, 0x436, 0x436, 0x436, 0x1b6, 0xdb6, 
        0xeb6, 0xab6, 0xa96, 0x896, 0x896, 0x876, 0x876, 0x8f6,
        0x6c6, 0x666, 0x666, 0x436, 0x436, 0x436, 0x4b6, 0xeb6, 
        0xeb6, 0x8b6, 0x896, 0x896, 0x896, 0x876, 0x876, 0x8f6,
        0x4c9, 0x469, 0x469, 0x439, 0x439, 0x439, 0x4b9, 0xeb9, 
        0xeb9, 0x9b9, 0x999, 0x999, 0x999, 0x879, 0x879, 0x8f9,
        0x4c9, 0x469, 0x469, 0x439, 0x439, 0x439, 0xeb9, 0xeb9, 
        0xeb9, 0xeb9, 0x999, 0x999, 0x999, 0x879, 0x879, 0x8f9,
        0x4ce, 0x46e, 0x46e, 0x43e, 0x43e, 0xe3e, 0xebe, 0xebe, 
        0xebe, 0xebe, 0xe9e, 0x99e, 0x99e, 0x87e, 0x87e, 0x8fe,
        0x063, 0x063, 0x063, 0x333, 0x333, 0xb33, 0xb33, 0xbb3, 
        0xbb3, 0xb93, 0xb93, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x063, 0x063, 0x363, 0x333, 0x333, 0x333, 0xb33, 0xbb3, 
        0xbb3, 0xb93, 0x593, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x063, 0x363, 0x363, 0x333, 0x333, 0x333, 0x333, 0xbb3, 
        0xbb3, 0x593, 0x593, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x067, 0x367, 0x367, 0x337, 0x337, 0x337, 0x137, 0x1b7, 
        0xbb7, 0x597, 0x597, 0x597, 0x597, 0x777, 0x777, 0x777,
        0x067, 0x267, 0x267, 0x337, 0x337, 0x137, 0x137, 0x1b7, 
        0x1b7, 0x197, 0x597, 0x597, 0x597, 0x777, 0x777, 0x777,
        0xc67, 0x267, 0x267, 0x237, 0x137, 0x137, 0x137, 0x1b7, 
        0x1b7, 0x197, 0xa97, 0x597, 0x597, 0x777, 0x777, 0xf77,
        0xc67, 0x267, 0x267, 0x237, 0x137, 0x137, 0x137, 0x1b7, 
        0x1b7, 0x197, 0xa97, 0xa97, 0x597, 0x777, 0xf77, 0xf77,
        0xc6c, 0x26c, 0x26c, 0x23c, 0x23c, 0x13c, 0x13c, 0xdbc, 
        0xdbc, 0xa9c, 0xa9c, 0xa9c, 0xa9c, 0xf7c, 0xf7c, 0xf7c,
        0xc6c, 0xc6c, 0x26c, 0x23c, 0x23c, 0x13c, 0x13c, 0xdbc, 
        0xabc, 0xa9c, 0xa9c, 0xa9c, 0xa9c, 0xf7c, 0xf7c, 0xf7c,
        0xc66, 0xc66, 0x266, 0x236, 0x236, 0x136, 0x136, 0xdb6, 
        0xab6, 0xa96, 0xa96, 0xa96, 0xa96, 0x876, 0xf76, 0xf76,
        0xc66, 0x666, 0x666, 0x436, 0x436, 0x136, 0x136, 0xdb6, 
        0xab6, 0xa96, 0xa96, 0xa96, 0x896, 0x876, 0x876, 0xf76,
        0x666, 0x666, 0x666, 0x436, 0x436, 0x436, 0x136, 0xdb6, 
        0xeb6, 0xa96, 0xa96, 0x896, 0x896, 0x876, 0x876, 0x876,
        0x666, 0x666, 0x666, 0x436, 0x436, 0x436, 0x436, 0xeb6, 
        0xeb6, 0x896, 0x896, 0x896, 0x896, 0x876, 0x876, 0x876,
        0x469, 0x469, 0x469, 0x439, 0x439, 0x439, 0x439, 0xeb9, 
        0xeb9, 0x999, 0x999, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x469, 0x469, 0x469, 0x439, 0x439, 0x439, 0xe39, 0xeb9, 
        0xeb9, 0xe99, 0x999, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x469, 0x469, 0x469, 0x439, 0x439, 0xe39, 0xe39, 0xeb9, 
        0xeb9, 0xe99, 0xe99, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x063, 0x063, 0x063, 0x333, 0x333, 0xb33, 0xb33, 0xbd3, 
        0xb93, 0xb93, 0xb93, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x063, 0x063, 0x363, 0x333, 0x333, 0x333, 0xb33, 0xbd3, 
        0xb93, 0xb93, 0x593, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x063, 0x363, 0x363, 0x333, 0x333, 0x333, 0x333, 0xbd3, 
        0xb93, 0x593, 0x593, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x067, 0x367, 0x367, 0x337, 0x337, 0x337, 0x137, 0x1d7, 
        0xb97, 0x597, 0x597, 0x597, 0x597, 0x777, 0x777, 0x777,
        0x067, 0x267, 0x267, 0x337, 0x337, 0x137, 0x137, 0x1d7, 
        0x197, 0x197, 0x597, 0x597, 0x597, 0x777, 0x777, 0x777,
        0xc67, 0x267, 0x267, 0x237, 0x137, 0x137, 0x137, 0x1d7, 
        0x197, 0x197, 0xa97, 0x597, 0x597, 0x777, 0x777, 0xf77,
        0xc67, 0x267, 0x267, 0x237, 0x137, 0x137, 0x137, 0x1d7, 
        0x197, 0x197, 0xa97, 0xa97, 0x597, 0x777, 0xf77, 0xf77,
        0xc6d, 0x26d, 0x26d, 0x23d, 0x23d, 0x13d, 0x13d, 0xddd, 
        0xd9d, 0xa9d, 0xa9d, 0xa9d, 0xa9d, 0xf7d, 0xf7d, 0xf7d,
        0xc66, 0xc66, 0x266, 0x236, 0x236, 0x136, 0x136, 0xdd6, 
        0xa96, 0xa96, 0xa96, 0xa96, 0xa96, 0xf76, 0xf76, 0xf76,
        0xc66, 0xc66, 0x266, 0x236, 0x236, 0x136, 0x136, 0xdd6, 
        0xa96, 0xa96, 0xa96, 0xa96, 0xa96, 0x876, 0xf76, 0xf76,
        0xc66, 0x666, 0x666, 0x436, 0x436, 0x136, 0x136, 0xdd6, 
        0xa96, 0xa96, 0xa96, 0xa96, 0x896, 0x876, 0x876, 0xf76,
        0x666, 0x666, 0x666, 0x436, 0x436, 0x436, 0x136, 0xdd6, 
        0xe96, 0xa96, 0xa96, 0x896, 0x896, 0x876, 0x876, 0x876,
        0x666, 0x666, 0x666, 0x436, 0x436, 0x436, 0x436, 0xed6, 
        0xe96, 0x896, 0x896, 0x896, 0x896, 0x876, 0x876, 0x876,
        0x469, 0x469, 0x469, 0x439, 0x439, 0x439, 0x439, 0xed9, 
        0xe99, 0x999, 0x999, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x469, 0x469, 0x469, 0x439, 0x439, 0x439, 0xe39, 0xed9, 
        0xe99, 0xe99, 0x999, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x469, 0x469, 0x469, 0x439, 0x439, 0xe39, 0xe39, 0xed9, 
        0xe99, 0xe99, 0xe99, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x063, 0x063, 0x063, 0x333, 0x333, 0xb33, 0xbd3, 0xbd3, 
        0xbd3, 0xb93, 0xb93, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x063, 0x063, 0x363, 0x333, 0x333, 0x333, 0xbd3, 0xbd3, 
        0xbd3, 0xb93, 0x593, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x063, 0x363, 0x363, 0x333, 0x333, 0x333, 0x3d3, 0xbd3, 
        0xbd3, 0x593, 0x593, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x067, 0x367, 0x367, 0x337, 0x337, 0x337, 0x1d7, 0x1d7, 
        0xbd7, 0x597, 0x597, 0x597, 0x597, 0x777, 0x777, 0x777,
        0x067, 0x267, 0x267, 0x337, 0x337, 0x137, 0x1d7, 0x1d7, 
        0x1d7, 0x197, 0x597, 0x597, 0x597, 0x777, 0x777, 0x777,
        0xc67, 0x267, 0x267, 0x237, 0x137, 0x137, 0x1d7, 0x1d7, 
        0x1d7, 0x197, 0xa97, 0x597, 0x597, 0x777, 0x777, 0xf77,
        0xc6d, 0x26d, 0x26d, 0x23d, 0x13d, 0x13d, 0x1dd, 0x1dd, 
        0x1dd, 0x19d, 0xa9d, 0xa9d, 0x59d, 0x77d, 0xf7d, 0xf7d,
        0xc6d, 0x26d, 0x26d, 0x23d, 0x23d, 0x13d, 0x1dd, 0xddd, 
        0xddd, 0xa9d, 0xa9d, 0xa9d, 0xa9d, 0xf7d, 0xf7d, 0xf7d,
        0xc6d, 0xc6d, 0x26d, 0x23d, 0x23d, 0x13d, 0x1dd, 0xddd, 
        0xadd, 0xa9d, 0xa9d, 0xa9d, 0xa9d, 0xf7d, 0xf7d, 0xf7d,
        0xc66, 0xc66, 0x266, 0x236, 0x236, 0x136, 0x1d6, 0xdd6, 
        0xad6, 0xa96, 0xa96, 0xa96, 0xa96, 0x876, 0xf76, 0xf76,
        0xc66, 0x666, 0x666, 0x436, 0x436, 0x136, 0x1d6, 0xdd6, 
        0xad6, 0xa96, 0xa96, 0xa96, 0x896, 0x876, 0x876, 0xf76,
        0x666, 0x666, 0x666, 0x436, 0x436, 0x436, 0x1d6, 0xdd6, 
        0xed6, 0xa96, 0xa96, 0x896, 0x896, 0x876, 0x876, 0x876,
        0x666, 0x666, 0x666, 0x436, 0x436, 0x436, 0x4d6, 0xed6, 
        0xed6, 0x896, 0x896, 0x896, 0x896, 0x876, 0x876, 0x876,
        0x469, 0x469, 0x469, 0x439, 0x439, 0x439, 0x4d9, 0xed9, 
        0xed9, 0x999, 0x999, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x469, 0x469, 0x469, 0x439, 0x439, 0x439, 0xed9, 0xed9, 
        0xed9, 0xe99, 0x999, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x469, 0x469, 0x469, 0x439, 0x439, 0xe39, 0xed9, 0xed9, 
        0xed9, 0xe99, 0xe99, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x063, 0x063, 0x063, 0x333, 0x333, 0xbd3, 0xbd3, 0xbd3, 
        0xbd3, 0xbd3, 0xb93, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x063, 0x063, 0x363, 0x333, 0x333, 0x3d3, 0xbd3, 0xbd3, 
        0xbd3, 0xbd3, 0x593, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x063, 0x363, 0x363, 0x333, 0x333, 0x3d3, 0x3d3, 0xbd3, 
        0xbd3, 0x5d3, 0x593, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x067, 0x367, 0x367, 0x337, 0x337, 0x3d7, 0x1d7, 0x1d7, 
        0xbd7, 0x5d7, 0x597, 0x597, 0x597, 0x777, 0x777, 0x777,
        0x067, 0x267, 0x267, 0x337, 0x337, 0x1d7, 0x1d7, 0x1d7, 
        0x1d7, 0x1d7, 0x597, 0x597, 0x597, 0x777, 0x777, 0x777,
        0xc6d, 0x26d, 0x26d, 0x23d, 0x13d, 0x1dd, 0x1dd, 0x1dd, 
        0x1dd, 0x1dd, 0xa9d, 0x59d, 0x59d, 0x77d, 0x77d, 0xf7d,
        0xc6d, 0x26d, 0x26d, 0x23d, 0x13d, 0x1dd, 0x1dd, 0x1dd, 
        0x1dd, 0x1dd, 0xa9d, 0xa9d, 0x59d, 0x77d, 0xf7d, 0xf7d,
        0xc6d, 0x26d, 0x26d, 0x23d, 0x23d, 0x1dd, 0x1dd, 0xddd, 
        0xddd, 0xadd, 0xa9d, 0xa9d, 0xa9d, 0xf7d, 0xf7d, 0xf7d,
        0xc6d, 0xc6d, 0x26d, 0x23d, 0x23d, 0x1dd, 0x1dd, 0xddd, 
        0xadd, 0xadd, 0xa9d, 0xa9d, 0xa9d, 0xf7d, 0xf7d, 0xf7d,
        0xc6d, 0xc6d, 0x26d, 0x23d, 0x23d, 0x1dd, 0x1dd, 0xddd, 
        0xadd, 0xadd, 0xa9d, 0xa9d, 0xa9d, 0x87d, 0xf7d, 0xf7d,
        0xc66, 0x666, 0x666, 0x436, 0x436, 0x1d6, 0x1d6, 0xdd6, 
        0xad6, 0xad6, 0xa96, 0xa96, 0x896, 0x876, 0x876, 0xf76,
        0x666, 0x666, 0x666, 0x436, 0x436, 0x4d6, 0x1d6, 0xdd6, 
        0xed6, 0xad6, 0xa96, 0x896, 0x896, 0x876, 0x876, 0x876,
        0x666, 0x666, 0x666, 0x436, 0x436, 0x4d6, 0x4d6, 0xed6, 
        0xed6, 0x8d6, 0x896, 0x896, 0x896, 0x876, 0x876, 0x876,
        0x469, 0x469, 0x469, 0x439, 0x439, 0x4d9, 0x4d9, 0xed9, 
        0xed9, 0x9d9, 0x999, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x469, 0x469, 0x469, 0x439, 0x439, 0x4d9, 0xed9, 0xed9, 
        0xed9, 0xed9, 0x999, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x469, 0x469, 0x469, 0x439, 0x439, 0xed9, 0xed9, 0xed9, 
        0xed9, 0xed9, 0xe99, 0x999, 0x999, 0x879, 0x879, 0x879,
        0x063, 0x063, 0x063, 0x333, 0x3d3, 0xbd3, 0xbd3, 0xbd3, 
        0xbd3, 0xbd3, 0xbd3, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x063, 0x063, 0x363, 0x333, 0x3d3, 0x3d3, 0xbd3, 0xbd3, 
        0xbd3, 0xbd3, 0x5d3, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x063, 0x363, 0x363, 0x333, 0x3d3, 0x3d3, 0x3d3, 0xbd3, 
        0xbd3, 0x5d3, 0x5d3, 0x593, 0x593, 0x573, 0x573, 0x573,
        0x067, 0x367, 0x367, 0x337, 0x3d7, 0x3d7, 0x1d7, 0x1d7, 
        0xbd7, 0x5d7, 0x5d7, 0x597, 0x597, 0x777, 0x777, 0x777,
        0x06d, 0x26d, 0x26d, 0x33d, 0x3dd, 0x1dd, 0x1dd, 0x1dd, 
        0x1dd, 0x1dd, 0x5dd, 0x59d, 0x59d, 0x77d, 0x77d, 0x77d,
        0xc6d, 0x26d, 0x26d, 0x23d, 0x1dd, 0x1dd, 0x1dd, 0x1dd, 
        0x1dd, 0x1dd, 0xadd, 0x59d, 0x59d, 0x77d, 0x77d, 0xf7d,
        0xc6d, 0x26d, 0x26d, 0x23d, 0x1dd, 0x1dd, 0x1dd, 0x1dd, 
        0x1dd, 0x1dd, 0xadd, 0xa9d, 0x59d, 0x77d, 0xf7d, 0xf7d,
        0xc6d, 0x26d, 0x26d, 0x23d, 0x2dd, 0x1dd, 0x1dd, 0xddd, 
        0xddd, 0xadd, 0xadd, 0xa9d, 0xa9d, 0xf7d, 0xf7d, 0xf7d,
        0xc6d, 0xc6d, 0x26d, 0x23d, 0x2dd, 0x1dd, 0x1dd, 0xddd, 
        0xadd, 0xadd, 0xadd, 0xa9d, 0xa9d, 0xf7d, 0xf7d, 0xf7d,
        0xc6d, 0xc6d, 0x26d, 0x23d, 0x2dd, 0x1dd, 0x1dd, 0xddd, 
        0xadd, 0xadd, 0xadd, 0xa9d, 0xa9d, 0x87d, 0xf7d, 0xf7d,
        0xc6d, 0x66d, 0x66d, 0x43d, 0x4dd, 0x1dd, 0x1dd, 0xddd, 
        0xadd, 0xadd, 0xadd, 0xa9d, 0x89d, 0x87d, 0x87d, 0xf7d,
        0x666, 0x666, 0x666, 0x436, 0x4d6, 0x4d6, 0x1d6, 0xdd6, 
        0xed6, 0xad6, 0xad6, 0x896, 0x896, 0x876, 0x876, 0x876,
        0x666, 0x666, 0x666, 0x436, 0x4d6, 0x4d6, 0x4d6, 0xed6, 
        0xed6, 0x8d6, 0x8d6, 0x896, 0x896, 0x876, 0x876, 0x876,
        0x469, 0x469, 0x469, 0x439, 0x4d9, 0x4d9, 0x4d
 
