/* makedata.c - enhancement to basic code to create data.c HAM file */
#include <stdio.h>
printcomments()
{
  printf("/* data.c - table of data for HAM routines.                 */\n\n");
  printf("/* color[16] - colormap containing rgb values fairly evenly */\n");
  printf("/*             spread throughout 16x16x16 space.            */\n");
  printf("/* near[4096] - table of distance. For each r,g,b           */\n");
  printf("/*              address = (r<<8 | g<<4 | b) & 0xfff         */\n");
  printf("/*              near>>4 gives the nearest color (index) and */\n");
  printf("/*              near & 0x0f gives the distance.             */\n");
  printf("/* nearmc[4096] - table of distance minus color             */\n");
  printf("/*       This contains the nearest color ignoring a color   */\n");
  printf("/*       (nearmc >> 8) & 0xf is for red,                    */\n");
  printf("/*       (nearmc >> 4) & 0xf is for green,                  */\n");
  printf("/*       and nearmc & 0xf is for blue                       */\n\n");
}  

struct color {
        int red, green, blue;
};

struct color color[16] = {
        {0x0,0x0,0x0},
        {0x4,0x6,0x6},
        {0x3,0x7,0x2},
        {0xc,0x2,0x3},
        {0x3,0xd,0x3},
        {0x3,0x2,0xc},
        {0xc,0xc,0x2},
        {0xc,0x3,0xd},
        {0x3,0xc,0xd},
        {0xc,0xd,0xc},
        {0x0,0x8,0xa},
        {0x8,0x0,0x8},
        {0x8,0x8,0x0},
        {0xf,0x7,0x7},
        {0x8,0xf,0x8},
        {0x8,0x8,0xf}
};

main()
{
        int r,g,b;
        int d,dd,n,i;
        int dr,dg,db, ddr,ddg,ddb, nr,ng,nb;

        printcomments();

        printf("#include <exec/types.h>\n\n");
        printf("UWORD colortable[16] = {\n");
        for (i=0; i<15; i++)
                printf("\t0x%01x%01x%01x,\n",
                        color[i].red,color[i].green,color[i].blue);
        printf("\t0x%01x%01x%01x\n",
                color[i].red,color[i].green,color[i].blue);
        printf("};\n\n");
        printf("UBYTE near[4096] = {\n");
        for (r = 0; r < 16; r++) {
           for (g = 0; g < 16; g++) {
              printf("\t");
              for (b = 0; b < 16; b++) {
                 d = 10000;
                 for (i = 0; i < 16; i++) {
                    dd = abs(r - color[i].red) +
                         abs(g - color[i].green) +
                         abs(b - color[i].blue);
                    if (dd < d) {
                         d = dd;
                         n = i;
                    }
                 }
                 printf("0x%01x%01x",n,d);
                 if (b < 15) printf(", ");
                 else if ((r < 15) || (g < 15)) printf(",\n");
                 else printf("\n");
                 if (b == 7) printf("\n\t");
              }
           }
        }
        printf("};\n\n");

        printf("UWORD nearmc[4096] = {\n");
        for (r = 0; r < 16; r++) {
           for (g = 0; g < 16; g++) {
              printf("\t");
              for (b = 0; b < 16; b++) {
                 dr = 10000;
                 dg = 10000;
                 db = 10000;
                 for (i = 0; i < 16; i++) {
                    ddr = abs(g -color[i].green) + abs(b - color[i].blue );
                    ddg = abs(r -color[i].red  ) + abs(b - color[i].blue );
                    ddb = abs(r -color[i].red  ) + abs(g - color[i].green);
                    if (ddr < dr) { dr = ddr; nr = i;}
                    if (ddg < dg) { dg = ddg; ng = i;}
                    if (ddb < db) { db = ddb; nb = i;}
                 }
                 printf("0x%01x%01x%01x",nr,ng,nb);
                 if (b < 15) printf(", ");
                 else if ((r < 15) || (g < 15)) printf(",\n");
                 else printf("\n");
                 if (b == 7) printf("\n\t");
              }
           }
        }
        printf("};\n");
}
