*****************************************************************************
* TrackDisk.Device Hardware Replacement - By PsyKo 2/5/1993 & 19/5/1993...  *
*****************************************************************************
* Use as Follows:-                                                          *
*                                                                           *
* d0 = Mode Type (0 = Setup and find drives / 1 = Zero Drive Head /         *
*                 2 = Read Sector)                                          *
*****************************************************************************
* Setup Mode will detect for external disk drives.                          *
* This routine returns with d0 = Available drives (Bits 0 to 3 represent    *
* drives 0 to 3, and are set if a drive is present)...                      *
*****************************************************************************
* Zero Mode, call before you start loading sectors, no need to do it every  *
* time, just when a new disk is inserted, or an error occurs..              *
* Just Call with d0 = the drive u wish to zero                              *
*****************************************************************************
* Read Mode will read a set of sectors from a selected drive. This function *
* needs $3400 Bytes reserved as an MFM buffer....                           *
* It uses:-                                                                 *
* d0 = 2 (read mode), d1 = Disk drive, d2 = Start Sector, d3 = End Sector   *
* a0 = Data Address (Fast, Slow or Chip), a1 = MFM Buffer (Chip ONLY!)      *
*                                                                           *
* This routine returns an error code in d0:-                                *
* 0 = Sector read fine,  -1 = End Sector Smaller than start sector...       *
*****************************************************************************
* Copyright 1993 The Retro Corporation.                  Internal use only! *
*****************************************************************************

	Opt	c-
	Section	"PsyKos Hard-Trakker",Code_c

	IncDir	Df1:
	
DrCon	= $Bfd100
DrRDY	= $Bfe001
Mtr	= 7
Rdy	= 5

Start	Movem.l	d0-d7/a0-a6,-(sp) 
	Lea	ErrorType(pc),a6
	Move.l	#0,(a6)
		
	Lea	DriveNo(pc),a6
	Move.w	d1,(a6)+
	Move.w	d2,(a6)+
	Move.w	d3,(a6)+
	Move.l	a0,(a6)+
	Move.l	a1,(a6)
	
	Cmpi.w	#0,d0
	Beq	FindDrives
	Cmpi.w	#1,d0
	Beq	ZeroDrive
	Cmpi.w	#2,d0
	Beq	ReadoSex
	Bra	Quit
	
ZeroDrive	Moveq	#0,d0
	Lea	DriveNo(pc),a6
	Move.w	(a6),d1
	Bsr	Trakker+$20
	Bra	Quit

ReadoSex	Move.w	DriveNo(pc),d1
	Bsr	ReadSectors

Quit	Movem.l	(sp)+,d0-d7/a0-a6 
	Move.l	ErrorType(pc),d0
	Rts
			
FindDrives	Moveq	#3,d6
	Lea	DriveID(pc),a6
	Lea	DrCon,a0
	Lea	DrRDY,a1

GetDriveID	Moveq	#15,d7
	Moveq	#0,d0
	
	Bclr	#Mtr,(a0)
	Bclr	d6,(a0)
	Bset	d6,(a0)
	Bset	#Mtr,(a0)
	Bclr	d6,(a0)
IDLoop	Bset	d6,(a0)
	Bclr	d6,(a0)
	Asl.w	#1,d0	
	Btst	#Rdy,(a1)
	Beq	SetBit
	Bclr	#0,d0
	Bra	NoSet
SetBit	Bset	#0,d0
NoSet	Bset	d6,(a0)
	Dbf	d7,IDLoop
	Move.w	d0,(a6)+
	Addq	#1,d6
	Cmpi.b	#7,d6
	Bne	GetDriveID

ZeroDrives	Lea	DriveID(pc),a4
	Moveq	#0,d1
	Moveq	#0,d3
ZeroLoop	Move.w	(a4)+,d2
	Cmpi.w	#-1,d2
	Bne	NoZeroDrive
	Bset	d1,d3
NoZeroDrive	Addq	#1,d1
	Cmpi.b	#4,d1
	Bne	ZeroLoop
	Lea	ErrorType(pc),a6
	Move.l	d3,(a6)
	Bra	Quit

ReadSectors	Cmp.w	d2,d3
	Bge	CorrectSec
	Bra	WrongSecs
	
CorrectSec	Moveq	#1,d0
	Moveq	#0,d1
	Move.w	DriveNo(pc),d1
	Bsr	Trakker+$20
	
GetNextSec	Moveq	#2,d0
	Move.w	CurrentSec(pc),d1
	Lea	DataBuffer(pc),a6
	Move.l	0(a6),a0
	Move.l	4(a6),a1
	Bsr	Trakker+$20
	
	Lea	CurrentSec(pc),a6
	Move.w	0(a6),d1
	Move.w	2(a6),d2
	Cmp.w	d1,d2
	Beq	NoMoreSex
	
	Lea	CurrentSec(pc),a6
	Add.w	#1,0(a6)
	Lea	DataBuffer(pc),a6
	Add.l	#$200,(a6)
	Bra	GetNextSec
	
NoMoreSex	Moveq	#3,d0
	Moveq	#0,d1
	Move.w	DriveNo(pc),d1
	Bsr	Trakker+$20
	Rts
	
WrongSecs	Rts
	
Set0Track0	Dc.w	0
Set0Track1	Dc.w	0
Set0Track2	Dc.w	0
Set0Track3	Dc.w	0

ErrorType	Dc.l	0
DriveID	Dc.w	0,0,0,0
DriveCount	Dc.w	0
DriveNo	Dc.w	0
CurrentSec	Dc.w	0
LastSec	Dc.w	0
DataBuffer	Dc.l	0
MFMBuffer	Dc.l	0

MSG	Dc.b	"TrackDisk.Replacement by PsyKo/Retro Corp 1993",0
	Even
Trakker	Incbin	MyMateMarmite/DTrakkerFINAL-Seg









