ORG $47000
LOAD $47000
; WRITTEN BY XYZZY FOR VORTEX 42
; Now with NEW MUSIC!
; MAIN ROUTINE

START:		JSR	TABGEN ; GENERAT COP LIST FOR COL BARS ETC.
		MOVE.W	#70,D6
GOODLOOP:	JSR	EFFSCROLL
		DBF	D6,GOODLOOP
		JSR	SPRITE_SETUP
		JSR 	COPPER ; INIT THE COPPER
		JSR 	INITALL ; INIT THE SCROLL
		JSR 	SETUP_PIC ; PUT BITPLANE ADDRS I COPPERLIST
;		JSR	$307C8
		JSR	SLUMPGEN ; GENERATE SLUMP FOR THE STARS
		MOVE.L	$4,A6
		JSR	-132(A6)
		MOVE.W	#%1000010111101111,$DFF096 ; DMA CONTROL
;		MOVE.W	#%0000000100100000,$DFF096 ; TEST (NO BPLDMA)

MOUSE:		ANDI.B	#64,$BFE001 ; LEFT MOUSE BUTTON
		BEQ	EXIT ; YEPP??
		JSR	SCROLL ; HANDLE THE SINE SCROLL
		JMP	MOUSE

DOWHAT:		DC.W	0	

EXIT:		MOVE.W	#$80F0,$DFF096 ; DMA CONTROL
		MOVE.W	#%1000001111110000,$DFF096 ; DMA CONTROL
		MOVE.W	#$000F,$DFF096 ; NO AUDIO DMA
		MOVE.L	$4,A6
		JSR	-138(A6)
		MOVE.L	SAVE1,A5 ; GET THE SYSTEM COPPER LIST
		MOVE.L	SAVE2,(A5) ; YEAH THE SAME HERE.
		RTS ; OK EXIT TO DOZ

COPPER:		MOVE.L	$4,A6 ; EXEC BASE ADDR
		LEA.L	GFXNAME,A1 ; 'GRAPHICS.LIBRARY'
		JSR	-408(A6) ; OPEN LIBRARY
		MOVE.L	D0,A5 ; BASE ADDR IN D0
		ADDA.L	#$32,A5 ; ADDR OF COPPERLIST IN MEM
		MOVE.L	A5,SAVE1 ; SAVE THE ADDR
		MOVE.L	(A5),SAVE2 ; SAVE THE CONTENS
		MOVE.L	#MYCOPPERLIST,(A5) ; MY NEW COPPER LIST ADDR
		MOVE.W	#$0020,$DFF096 ; DISABLE SPRITE DMA
		RTS ; OK READY

SETUP_PIC:	LEA.L 	PICCIE,A0 ; PICTURE ADDR IN MEM
		MOVE.L	A0,D0 ; CAN'T SWAP WITH A-REGS
		SWAP	D0 ; GET THE HI ADDR OF PLANE 1
		MOVE.W	D0,HI1 ; SAVE INTO COPPER LIST
		SWAP	D0 ; GET LO ADDR
		MOVE.W	D0,LO1 ; SAVE IT TOO
		ADDI.L	#8800,D0 ; NEXT BITPLANE 8000 FORWARD
		SWAP	D0 ; BITPLANE 2.LOOK ABOVE
		MOVE.W	D0,HI2
		SWAP	D0
		MOVE.W	D0,LO2
		ADDI.L	#8800,D0
		SWAP	D0 ; BITPLANE 3 LOOK AT PLANE 1
		MOVE.W	D0,HI3
		SWAP	D0
		MOVE.W	D0,LO3
		ADDI.L	#8800,D0
		SWAP	D0 ; BITPLANE 4
		MOVE.W	D0,HI4
		SWAP	D0
		MOVE.W	D0,LO4
		ADDI.L	#8800,D0
		SWAP	D0 ; BITPLANE 5
		MOVE.W	D0,HI5
		SWAP	D0
		MOVE.W	D0,LO5
		ADDI.L	#8800,D0
		SWAP	D0 ; BITPLANE 6
		MOVE.W	D0,HI6
		SWAP	D0
		MOVE.W	D0,LO6
		RTS ; ALL THIS IS NEEDED BECAUSE YOU DONT KNOW
		    ; THE LOAD ADDRESS OF THE PROGRAM

SCROLL: 	CMPI.B	#$D0,$DFF006 ; LINE ON TV SCREEN
		BNE 	DONTDOIT ; NO NOT NOW
;		JSR	$309CC
		JSR	SPR0
		JSR	EFFSCROLL
		JSR	CLIRP ; CLEAR THE OLD CHARS
		JSR	SINER ; SCROLL THE SCRLL TRACK 
		JSR	X2ADD ; THE 'X2 EFFECT'
		JSR	DOIT ; SCROLL
		JSR	DOIT ; SCROLL
		JSR	DOIT ; SCROLL
		JSR	UP ; MOVE IT UP ON THE SCREEN
		JSR	FLUSH
		MOVE.W	DOWHAT,D0
		BEQ	DOLINES
		JSR	STARS
		MOVE.W	#0,DOWHAT
		BRA	DONTDOIT
DOLINES:	JSR	MOVECENTER
		JSR	CLS
		JSR	V42
		MOVE.W	#1,DOWHAT
DONTDOIT:	RTS ; OK READY AND EXIT BACK TO MAIN LOOP

DOIT:		JSR	BLITROTATE ; ROTATE MEM W. BLITTER
		ADDI.L	#1,SCROLLCOUNT ; THE SHIFT COUNTER 
		CMPI.L	#16,SCROLLCOUNT ; IF ITS 16 PUT IN A NEW CHAR
		BEQ	INSERT ; JEPP IT is 16
		RTS ; NO.. THEN EXIT

BLITROTATE:	LEA.L	SCRPLANE,A0 ; THE PLACE THE SCROLL REALLY IS
		MOVE.W	#$FFFF,$DFF044 ; LO WORD MASK FOR BLITTER
		MOVE.W	#$FFFF,$DFF046 ; HI WORD MASK FOR BLITTER
		MOVE.L	A0,$DFF050 ; SOURCE ADDR
		SUBQ	#2,A0 ; ONE WORD
		MOVE.L	A0,$DFF054 ; DEST ADDR.
		CLR.W	$DFF042 ; NEEDS TO BE RUN FROM DOZ
		MOVE.W	#$F9F0,$DFF040 ; BLIT CTRL WORD
		;THE 'F' ABOVE MEANS 1 WORD - 15 BITS = ONE BIT SHIFT
		CLR.W	$DFF066 ; MODULO SOURCE
		CLR.W	$DFF064 ; MODULE DEST
		MOVE.W	#%0000010000010111,$DFF058
		RTS

INSERT:		CLR.L	SCROLLCOUNT ;CLR THE SHFT COUNT FOR NEXT CHAR
		MOVE.L	POSTEXT,A1 ; POSITION IN THE SCROLLTEXT
		LEA.L	SCROLLTEXT,A0 ; SCROLL TEXT ADDR I MEM
		CMPI.B	#0,(A0,A1.W) ; IS IT AN ENDMARK?
		BNE	OUTCHAR ; NO WAY
		CLR.L	POSTEXT ; JEPP
		JMP	INSERT ; GO AGAIN
OUTCHAR:	ADDI.L	#1,POSTEXT ; INCREMENT POS I SCROLLTEXT
		MOVE.B	(A0,A1.W),D0  ; CHAR TO D4
		SUBI.B	#32,D0   ; DRA IFRAN 32 FOR TABELLENS SKULL
		LSL.L	#5,D0   ; *8 FOR TECKENETS ADRESS.
		LEA.L	CHARDATA,A0 ; ADDR FOR THE CHAR DATA
		ADDI.L	D0,A0 ; CHAR ADRESS IN A0

		MOVE.W	(A0),IN1 ; PUT THEM INTO THE SCOLL
		MOVE.W	2(A0),IN2 ; ROW 2
		MOVE.W	4(A0),IN3 ; ROW 3
		MOVE.W	6(A0),IN4 ; ROW 4
		MOVE.W	8(A0),IN5 ; ROW 5
		MOVE.W	10(A0),IN6 ; ROW 6
		MOVE.W	12(A0),IN7 ; ROW 7
		MOVE.W	14(A0),IN8 ; AND ROW 8
		MOVE.W	16(A0),IN9 ; AND SO ON
		MOVE.W	18(A0),IN10 
		MOVE.W	20(A0),IN11 
		MOVE.W	22(A0),IN12 
		MOVE.W	24(A0),IN13 
		MOVE.W	26(A0),IN14 
		MOVE.W	28(A0),IN15 
		MOVE.W	30(A0),IN16

		RTS ; OK A NEW CHAR IS READY TO BE SCROLLED OUT

UP:		CLR.L	D0 ; D0 MAY CONTAIN TRASH	
		CLR.L	D1 ; SO CAN D1
		MOVE.W	#336,A2 ; THE MOST RIGHT PART OF THE SCREEN
		MOVE.L	SCROLLCOUNT,A5 ; GET THE SHIFT VALUE
		SUBI.W	A5,A2 ; CALC HOW MANY PIXELS CHAR HAVE MOVES
		LEA.L	YTAB,A3 ; GET THE YTAB (SINETAB IN THIS CASE)
		MOVE.W	#20,D7 ; LOOP COUNTER (19-0)=20 WORDS=ONE LINE
UPLOOP:		MOVE.W	A2,D4 ; SAVE SCREEN POS IN D4
		LSL	#1,D4 ; *4 TO FIND WORDS IN TABLE
		MOVE.W	(A3,D4.L),D1 ; GET THE YPOS
		ADDI.W	#60,D1 ; ADD SO IT GETS INTO THE SCREEN
		ADDI.W	ADDVAL,D1 ; ADD THE 'X2 EFFECT' VALULE
		MOVE.W	A2,D0 ; GET THE XPOS
		JSR	MOVEUP ; MOVE IT ONTO THE SCREEN
		SUBI.W	#16,A2 ; NEXT CHAR IS 16 PIXELS AWAY
		DBF	D7,UPLOOP ; LOOP?
UPEXIT:		RTS ; OVER AND OUT

;
; FLYTTAR DATA FRAN ETT STALLE TILL ETT ANNAT MED SAMMA XPOS.
;
; D0=X POS (PIXEL) SOURCE
; D1 Y POS (RAD) DESTINATION
; PAVERKADE REGISTER:
; D0,D1,D3,A0,A1,D5,D6
;

MOVEUP:		DIVU	#16,D0 ; TA FRAM WORD NR PLUS BIT NR
		LSL.W	#1,D0 ; *2
		MOVE.W	D0,D3 ; SPARA WORD ADDR
		SWAP	D0 ; TA FRAM REST (PIXELS IN I WORD)
		ANDI.L	#$0000FFFF,D0 ; TA BORT SKRAP
		LSL.W	#1,D0 ; FOR ATT HITTA I TABELL
		LEA.L	BITTAB,A0 ; GRUND ADDR TILL TABELL
		MOVE.W	(A0,D0.W),D5 ; FOR OVER TILL D3
		MOVE.W	D5,D6 ; SAVE FOR SENARE ANVANDNING
		EOR	#$FFFF,D6 ; TA FRAM MASK VARDE 2

		LEA.L	SCRPLANE,A0 ; GRUND ADDR TILL SOURCE
		ADDI.L	D3,A0 ; SOURCE ADDR I A0

		MULU	#44,D1 ; RAKNAR FRAM RAD ADDR
		ADDI.L	D3,D1 ; LAGGER TILL WORD ADDR
		LEA.L	PLANE5,A1 ; TAR FRAM GRUNDADDR TILL PLANE 5
		ADDI.L	D1,A1 ; NU FINNS DEST ADDR I A1

;
; FLYTTAR DATA
;
;  SOURCE = A0, DEST = A1
;

		MOVE.W	D5,$DFF044 ; MASK
		MOVE.W	D6,$DFF046 ; MASK 

		MOVE.L	A0,$DFF050 ; SOURCE ADDR
		MOVE.L	A1,$DFF054 ; DEST ADDR
		MOVE.L	A1,$DFF04C ; B SOURCE ADDR

		MOVE.W	#42,$DFF064 ; MODULO SOURCE
		MOVE.W	#40,$DFF066 ; MODULO DEST
		MOVE.W	#40,$DFF062 ; B SOURCE MODULO

		CLR.W	$DFF042 ; NEEDS TO BE RUN FROM DOZ
		MOVE.W	#$0DFC,$DFF040 ; BLIT CTRL WORD
			            ;      
		MOVE.W	#%0000010000000010,$DFF058
		; ABOVE MEANS THAT BLITTER SHOULD MOVE 16 VERT LINES
		; AND 2 WORDS (OR A LONG)

		RTS

;THIS ROUTINE CLEARS THE SCREEN WITH THE BLITTER
; OLD, SIMPLE AND SLOW SCREEN CLEAR

;CLIRP:		MOVE.L	#$10000,$DFF050      ;SOURCE ADRESS
;		MOVE.L	#PLANE5,$DFF054
;		MOVE.W	#0,$DFF042	; NEEDS TO RUN FROM DOS !!!
;		MOVE.W	#$0900,$DFF040  ;BLITTER CONTROLL WORD !
;		CLR.W	$DFF066    ; BILD OFFSET
;		CLR.W	$DFF064
;		MOVE.W	#8800,$DFF058 	;WINDOW SIZE - LENGTH...
;		RTS

; NEW VERSION (FASTER) NOT SO MUCH MENORY ACCESS
; COMMENTS LOOK AT UP ROUTINE (THIS ONE IS ALMOST THE SAME)

CLIRP:		CLR.L	D0	
		CLR.L	D1
		MOVE.W	#336,A2
		MOVE.L	SCROLLCOUNT,A5
		SUBI.W	A5,A2	
		LEA.L	YTAB,A3
		MOVE.W	#20,D7
CLLOOP:		MOVE.W	A2,D4
		LSL	#1,D4
		MOVE.W	(A3,D4.L),D1
		ADDI.W	#60,D1
		ADDI.W	ADDVAL,D1
		MOVE.W	A2,D0
		JSR	CLUP
		SUBI.W	#16,A2
		DBF	D7,CLLOOP
		RTS

CLUP:		DIVU	#16,D0 ; TA FRAM WORD NR PLUS BIT NR
		LSL.W	#1,D0 ; *2
		MOVE.W	D0,D3 ; SPARA WORD ADDR
		SWAP	D0 ; TA FRAM REST (PIXELS IN I WORD)
		ANDI.L	#$0000FFFF,D0 ; TA BORT SKRAP
		LSL.W	#1,D0 ; FOR ATT HITTA I TABELL
		LEA.L	BITTAB,A0 ; GRUND ADDR TILL TABELL
		MOVE.W	(A0,D0.W),D5 ; FOR OVER TILL D3
		MOVE.W	D5,D6 ; SAVE FOR SENARE ANVANDNING
		EOR	#$FFFF,D6 ; TA FRAM MASK VARDE 2

		MULU	#44,D1 ; RAKNAR FRAM RAD ADDR
		ADDI.L	D3,D1 ; LAGGER TILL WORD ADDR
		LEA.L	PLANE5,A1 ; TAR FRAM GRUNDADDR TILL PLANE 5
		ADDI.L	D1,A1 ; NU FINNS DEST ADDR I A1

;
; FLYTTAR DATA
;
;  SOURCE = A0, DEST = A1
;

		MOVE.W	D5,$DFF044 ; MASK
		MOVE.W	D6,$DFF046 ; MASK 

		CLR.W	$DFF074

		MOVE.L	A1,$DFF054 ; DEST ADDR

		MOVE.W	#40,$DFF066 ; MODULO DEST

		CLR.W	$DFF042 ; NEEDS TO BE RUN FROM DOZ
		MOVE.W	#$0900,$DFF040 ; ONLY A DESTINATION 

		MOVE.W	#%0000010000000010,$DFF058
		; ABOVE MEANS THAT BLITTER SHOULD MOVE 16 VERT LINES
		; AND 2 WORDS (OR A LONG)

		RTS


;SINER:		LEA.L	YTAB,A0 ; SCROLL TOWARDS THE SINE SCROLL
;		ADDI.W	#720,A0 ; JUST GET A VALUE IN A TABLE
;		MOVE.W	(A0),A1
;		MOVE.W	#359,D7
;SINELOOP:	MOVE.W	-(A0),2(A0)
;		DBF	D7,SINELOOP
;		MOVE.W	A1,(A0)
;		RTS

SINER:		LEA.L	YTAB,A0
		ADDI.W	#718,A0
		MOVE.W	2(A0),D0
		MOVE.L	A0,$DFF050      ;SOURCE ADRESS
		ADDI.W	#2,A0
		MOVE.L	A0,$DFF054	

		MOVE.W	#$FFFF,$DFF044 ; DON'T FORGET THE MASK
		MOVE.W	#$FFFF,$DFF046 ; SHIT, CAUSED ME 1 H TROUBLE

		MOVE.W	#2,$DFF042	; DESC MODE
		MOVE.W	#$09F0,$DFF040  ;BLITTER CONTROLL WORD !
		CLR.W	$DFF066    ; BILD OFFSET
		CLR.W	$DFF064    ;.      
		MOVE.W	#%0010110100000010,$DFF058 
		LEA.L	YTAB,A0
		MOVE.W	D0,(A0)
		RTS

;SINER:		LEA.L	YTAB,A0 ; SCROLL WITH THE SINE SCROLL
;		MOVE.W	(A0),A1 ; ALMOST THE SAME BUT THE OTHER WAY
;		MOVE.W	#359,D7
;SINELOOP:	MOVE.W	2(A0),(A0)+
;		DBF	D7,SINELOOP
;		MOVE.W	A1,(A0)
;		RTS

X2ADD:		LEA.L	X2TAB,A0 ; ADDR OF THE 'X2 TAB'
		MOVE.W	X2POINTER,A1 ; WHERE WERE WE__
		MOVE.W	(A0,A1.W),ADDVAL ; GET THE ADDVAL
		ADDI.W	#2,X2POINTER ; INCREMENT POINTER 1 WORD
		CMPI.W	#0,2(A0,A1.W) ; END OF TABLE
		BNE	X2EXIT ; NO
		MOVE.W	#0,X2POINTER ; CLEAR THE POS COUNTER
X2EXIT:		RTS ; QUIT

INITALL:	CLR.L	POSTEXT ; CLR THE POS IN SCROLL TEXT
		CLR.L	SCROLLCOUNT ; CLR THE SCROLL COUNT
		CLR.L	D0 ; AND CLEAR ALL REGISTER EXCEPT A7
		MOVE.L	D0,D1
		MOVE.L	D0,D2
		MOVE.L	D0,D3
		MOVE.L	D0,D4
		MOVE.L	D0,D5
		MOVE.L	D0,D6
		MOVE.L	D0,D7
		MOVE.L	D0,A0
		MOVE.L	D0,A1
		MOVE.L	D0,A2
		MOVE.L	D0,A3
		MOVE.L	D0,A4
		MOVE.L	D0,A5
		MOVE.L	D0,A6
		RTS

; The star routime


FNXYP:		SUBI.W	#10000,D0
		BPL.S	POSITIVE
		NOT.W	D0
		ADDQ	#1,D0
		BSR.S	POSITIVE
		SUBQ	#1,D0
		NOT.W	D0
		RTS
POSITIVE:	DIVU	D2,D0
		ANDI.L	#$0000FFFF,D0
		RTS

FN:		MOVE.W	(A0,A5.W),D0
		MOVE.W	(A1,A5.W),D1
		MOVE.W	(A2,A5.W),D2
		BSR.S	FNXYP
		ADDI.W	#171,D0
		EXG	D0,D1
		BSR.S	FNXYP
		ADDI.W	#100,D0
		EXG	D0,D1
		RTS

STARS:		LEA.L	XTAB,A0
		LEA.L	YSTAB,A1
		LEA.L	ZTAB,A2
		MOVE.W	#0,A5
NEXT:		BSR.S	FN
		CLR.L	D2
		BSR.S	PSET
		SUBQ	#5,(A2,A5.W)	; SPEED
		BGT.S	NOSTAR
		BSR.S	NEWSTAR
NOSTAR:		BSR.S	FN
		LSR.B	#5,D2
		ADDQ	#1,D2
		BSR.S	PSET
		ADDQ	#2,A5
		CMPI.W	#50,A5	; ANTAL STJARNOR
		BNE.S	NEXT
		RTS

PSET:		CMPI.W	#342,D0
		BCC.S	QUIT
		CMPI.W	#199,D1
		BCC.S	QUIT
		LEA.L	PICCIE,A4 ; PIC START ADDR
		MOVE.W	D0,D3 ; SAVE OLD XVAL (REMAINER)
		LSR.W	#3,D0 ; DIVIDE W. 8
		ADDI.L	D0,A4 ; ADD THE BYTE NR
		LSL.W	#3,D0 ; MULTIPLY W. 8
		SUBI.W	D0,D3 ; CALC REMAINER
		MOVE.B	#128,D0 ; MOVE A 1 IN THE 7TH BT POS
		LSR.B	D3,D0 ; SHIFT D0 DOWN D2 COUNTS (D2=REMAINDER)
		MULU	#44,D1
		ADDI.L	D1,A4 ; ADD IT TO PIC ==> A0 HAS THE PLOT ADDR
		MOVEQ	#2,D7
COLOOP:		LSR.B	#1,D2
		BCC.S	NODOT
		ORI.B	D0,(A4) ; OR THE SPECIFIC BIT INTO MEM
		BRA.S	WEITER
NODOT:		NOT	D0
		ANDI.B	D0,(A4)
		NOT	D0
WEITER:		ADDI.L	#17600,A4
		DBF	D7,COLOOP		
QUIT:		RTS

NEWSTAR:	MOVE.W	#20000,D3
		BSR.S	SLUMP
		MOVE.W	D0,(A0,A5.W)
		BSR.S	SLUMP
		MOVE.W	D0,(A1,A5.W)
		MOVE.W	#192,D3
		BSR.S	SLUMP
		MOVE.W	D0,(A2,A5.W)
		RTS

SLUMP:		MOVE.W	XSTORE,D1
		MOVE.W	PSTORE,D2
		ADDI.W	$DFF006,D1
		ADDI.L	D2,D1
		ADDQ	#1,PSTORE
		MULU	#23,D1
		MOVE.L	D1,D6
		DIVU	D3,D1
		ANDI.L	#65535,D1
		MULU	D3,D1
		MOVE.L	D6,D0
		SUBI.L	D1,D0
		ADDQ	#1,D0
		MOVE.W	D0,XSTORE
		RTS

SLUMPGEN:	LEA.L	XTAB,A0
		LEA.L	YSTAB,A1
		LEA.L	ZTAB,A2
		MOVE.W	#0,A5
SLOOP:		BSR.S	NEWSTAR
		ADDQ	#2,A5
		CMPI.W	#100,A5
		BNE.S	SLOOP
		RTS

EFFSCROLL:	LEA.L	COLORBARS,A0
		MOVE.W	#55,D7
COLOROOP:	MOVE.W	22(A0),10(A0) ; COLORSCROLL
		MOVE.W	18(A0),6(A0) ; HORZ SCROLL
		ADDI.L	#12,A0
		DBF	D7,COLOROOP

		LEA.L	COLTAB,A1
		MOVE.W	COLPOS,A2
		MOVE.W	(A1,A2.W),10(A0)
		ADDI.W	#2,COLPOS
		CMPI.W	#$FFFF,2(A1,A2.W)
		BNE	DOHORZ
		CLR.W	COLPOS

DOHORZ:		LEA.L	SCLTAB,A1
		MOVE.W	SCLPOS,A2
		MOVE.W	(A1,A2.W),6(A0)
		ADDI.W	#2,SCLPOS
		CMPI.W	#$FFFF,2(A1,A2.W)
		BNE	NOHRESET
		CLR.W	SCLPOS
NOHRESET:	RTS

;
; GENERAT COPPER LIST (COLOR BARS), AND THE HORZ SCROLL VALUE
;
		
TABGEN:		LEA.L	COLORBARS,A0
		MOVE.L	#$2F01FFFE,D0
		MOVE.L	#$01020000,D1
		MOVE.L	#$0192007C,D2
		MOVE.W	#56,D7
COPLOOP:	MOVE.L	D0,(A0)+
		MOVE.L	D1,(A0)+
		MOVE.L	D2,(A0)+
		ADDI.L	#$01000000,D0		
		DBF	D7,COPLOOP
		MOVE.L	D1,(A0)+

		LEA.L	SCLTAB,A0
		CLR.L	D7
LLOOPP:		MOVE.W	(A0,D7.W),D0
		CMPI.W	#$FFFF,D0
		BEQ	EXITGEN
		LSL	#4,D0
		MOVE.W	D0,(A0,D7.W)
		ADDI.W	#2,D7
		JMP	LLOOPP

EXITGEN:	RTS

MYCOPPERLIST:
		DC.W	$0180			
COL0:		DC.W	$0000 
		DC.W	$0182
COL1:		DC.W	$0FFF 
		DC.W	$0184
COL2:		DC.W	$0DDD
		DC.W	$0186
COL3:		DC.W	$0BBB
		DC.W	$0188
COL4:		DC.W	$0888
		DC.W	$018A
COL5:		DC.W	$0666
		DC.W	$018C
COL6:		DC.W	$0333
		DC.W	$018E
COL7:		DC.W	$0111
		DC.W	$0190
COL8:		DC.W	$0000 
		DC.W	$0192
COL9:		DC.W	$007C 
		DC.W	$0194
COL10:		DC.W	$0777 
		DC.W	$0196
COL11:		DC.W	$0777 
		DC.W	$0198
COL12:		DC.W	$0FF0 
		DC.W	$019A
COL13:		DC.W	$0FF0 
		DC.W	$019C
COL14:		DC.W	$0FF0 
		DC.W	$019E
COL15:		DC.W	$0FF0 

; BITPLANE CONTROL WORD SETUP

		DC.W	$0100,$6600 ;BIT PLANE CTRL REG
		DC.W	$008E,$2A81 ;DISPLAY START (VERT)
		DC.W	$0090,$F2C1 ;DISPLAY STOP (VERT)
		DC.W	$0092,$0030 ;DISPLAY START (HORZ)	
		DC.W	$0094,$00E0 ;DISPLAY STOP (HORZ)
		DC.W	$0104,$0064 ; PLAYFIELD 2 HAS PRIORITY

; START OF BITPANES IN MENORY

		DC.W	$00E0 ;	
HI1:		DC.W	$0000 ; BITPLANE 1
		DC.W	$00E2 ;
LO1:		DC.W	$0000 ;

		DC.W	$00E4
HI2:		DC.W	$0000 ; BITPLANE2
		DC.W	$00E6
LO2:		DC.W	$0000

		DC.W	$00E8
HI3:		DC.W	$0000 ; BITPLANE3
		DC.W	$00EA
LO3:		DC.W	$0000
	
		DC.W	$00EC
HI4:		DC.W	$0000 ; BITPLANE4
		DC.W	$00EE
LO4:		DC.W	$0000

		DC.W	$00F0
HI5:		DC.W	$0000 ; BITPLANE5
		DC.W	$00F2
LO5:		DC.W	$0000

		DC.W	$00F4
HI6:		DC.W	$0000
		DC.W	$00F6
LO6:		DC.W	$0000

		DC.W	$01A2	
		DC.W	$000F	
		DC.W	$01A4	
		DC.W	$00FF
		DC.W	$01A6
		DC.W	$008F

		DC.W	$01AA	
		DC.W	$000F	
		DC.W	$01AC	
		DC.W	$00FF
		DC.W	$01AE
		DC.W	$008F

		DC.W	$01B2	
		DC.W	$000F	
		DC.W	$01B4	
		DC.W	$00FF
		DC.W	$01B6
		DC.W	$008F

		DC.W	$01BA	
		DC.W	$000F	
		DC.W	$01BC	
		DC.W	$00FF
		DC.W	$01BE
		DC.W	$008F

		DC.W	$0120
SPHI0:		DC.W	$0000
		DC.W	$0122
SPLO0:		DC.W	$0000
		DC.W	$0124
SPHI1:		DC.W	$0000
		DC.W	$0126
SPLO1:		DC.W	$0000
		DC.W	$0128
SPHI2:		DC.W	$0000
		DC.W	$012A
SPLO2:		DC.W	$0000
		DC.W	$012C
SPHI3:		DC.W	$0000
		DC.W	$012E
SPLO3:		DC.W	$0000
		DC.W	$0130
SPHI4:		DC.W	$0000
		DC.W	$0132
SPLO4:		DC.W	$0000
		DC.W	$0134
SPHI5:		DC.W	$0000
		DC.W	$0136
SPLO5:		DC.W	$0000
		DC.W	$0138
SPHI6:		DC.W	$0000
		DC.W	$013A
SPLO6:		DC.W	$0000
		DC.W	$013C
SPHI7:		DC.W	$0000
		DC.W	$013E
SPLO7:		DC.W	$0000




COLORBARS:

		BLK.B	688,0

		DC.W	$0192
		DC.W	$0F33

		DC.W	$0194
VFLSH1:		DC.W	$0FFF 
		DC.W	$0196
VFLSH2:		DC.W	$0FFF

		DC.W	$FFFF,$FFFE 


SAVE1:		DC.L	0
SAVE2:		DC.L	0
GFXNAME:	DC.B	'graphics.library',0

EVEN

SCROLLCOUNT:	DC.L	0
POSTEXT:	DC.L	0
X2POINTER:	DC.W	0
ADDVAL:		DC.W	0
COLPOS:		DC.W	0
SCLPOS:		DC.W	0

XSTORE:		DC.L	27139
PSTORE:		DC.L	0

BITTAB:		DC.W	%1111111111111111
		DC.W	%0111111111111111
		DC.W	%0011111111111111
		DC.W	%0001111111111111
		DC.W	%0000111111111111
		DC.W	%0000011111111111
		DC.W	%0000001111111111
		DC.W	%0000000111111111
		DC.W	%0000000011111111
		DC.W	%0000000001111111
		DC.W	%0000000000111111
		DC.W	%0000000000011111
		DC.W	%0000000000001111
		DC.W	%0000000000000111
		DC.W	%0000000000000011
		DC.W	%0000000000000001
		DC.W	%0000000000000000

SCRPLANE:	BLK.B	44,0
IN1:		DC.W	0
		BLK.B	44,0
IN2:		DC.W	0
		BLK.B	44,0
IN3:		DC.W	0
		BLK.B	44,0
IN4:		DC.W	0
		BLK.B	44,0
IN5:		DC.W	0
		BLK.B	44,0
IN6:		DC.W	0
		BLK.B	44,0
IN7:		DC.W	0
		BLK.B	44,0
IN8:		DC.W	0
		BLK.B	44,0
IN9:		DC.W	0
		BLK.B	44,0
IN10:		DC.W	0
		BLK.B	44,0
IN11:		DC.W	0
		BLK.B	44,0
IN12:		DC.W	0
		BLK.B	44,0
IN13:		DC.W	0
		BLK.B	44,0
IN14:		DC.W	0
		BLK.B	44,0
IN15:		DC.W	0
		BLK.B	44,0
IN16:		DC.W	0

		BLK.B	440,0

SCROLLTEXT:	DC.B	'                         ................'
		DC.B	'...............       '
		DC.B	'  HELLO EVERYBODY, XYZZY SPEAKING FROM'
		DC.B	' THE VORTEX 42 MEETING IN ARVIKA     '
		DC.B	" I'M SORRY, BUT I'M NOT ABLE TO WRITE A"
		DC.B	' BIG SCROLLTEXT IN THIS, MY FIRST DEMO,'
		DC.B	"BUT I HOPE I AT LEAST CAN GIVE SOME"
		DC.B	" MESSAGES AND HI'S TO A FEW PRIVILEGED..."
		DC.B	" FIRST I'D LIKE TO THANK THE-LANDER FOR"
		DC.B	' BEGING GENEREOUS WITH HIS 3D FORMULAS.'
		DC.B	"      I'D ALSO LIKE TO THANK EVERBODY AT"
		DC.B	'THIS MEETING FOR BEING NICE AND GENEREOUS'
		DC.B	' WITH PROGRAMS AND GAMES.     '
		DC.B	' THE THIRD MESSAGE GOES TO FUZ. KEEP ON'
		DC.B	' THE GOOD WORK, HOPE TO SEE SOME DEMOZ'
		DC.B	" FROM YOU. THE LAST HI GOES TO MY FRIENDS"
		DC.B	" IN ELECTRA (OLD ONE), AND ED. YOU'RE ON"
		DC.B	' THE RIGHT WAY.....       '
		DC.B	' TO THE RIGHT SIDE OF ME SITS EARTHSHAKER'
		DC.B	', AND SHOWING THE-LANDERS NEW CP-MEGA-DEMO'
		DC.B	".... I'LL JUST SAY ONE THING ABOUT THAT: "
		DC.B	"GET IT! YOU'LL HAVE A GOOD LAUGH......    "
		DC.B	" WELL NOW I DONT HAVE ANYTHING MORE TO SAY" 
		DC.B	' ACTUALLY, SO I THINK IT ALL HAS TO END HERE'
		DC.B	' JUST ONE MORE MESSAGE, AND IT GOES TO'
		DC.B	" YOU: CALL POOR MAN'S OPUS AT THE NUMBER"
		DC.B	" 0120/10584. I'M SYSOP THERE, SO IF YOU WANT"
		DC.B	' TALK TO ME ABOUT SOMETHING, YELL OR CALL'
		DC.B	' +46 120 12971 AND ASK FOR HAKAN OR WRITE'
		DC.B	' AT THIS ADDRESS: HAKAN ETZELL       '
		DC.B	" STENHUSGATAN 13         S-597 00 "   
		DC.B	" ATVIDABERG.....   WELL THAT'S ALL FROM"
		DC.B	' ME FOR THIS TIME, SO BYEEE AND C U       '
		DC.B	'       ...    ...   ...   ...   ...   ...'
		DC.B	'                 '
		DC.B	0

			
EVEN

CHARDATA:

	DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; FOGOT TO MAKE SPACE

FONT:	BLK.W	1000,0

YTAB:
	DC.W   25, 25, 25, 26, 26, 27, 27, 28, 28, 28
        DC.W   29, 29, 30, 30, 31, 31, 31, 32, 32, 33
        DC.W   33, 33, 34, 34, 35, 35, 35, 36, 36, 37
        DC.W   37, 37, 38, 38, 38, 39, 39, 40, 40, 40
        DC.W   41, 41, 41, 42, 42, 42, 42, 43, 43, 43
        DC.W   44, 44, 44, 44, 45, 45, 45, 45, 46, 46
        DC.W   46, 46, 47, 47, 47, 47, 47, 48, 48, 48
        DC.W   48, 48, 48, 48, 49, 49, 49, 49, 49, 49
        DC.W   49, 49, 49, 49, 49, 49, 49, 49, 49, 49
        DC.W   50, 49, 49, 49, 49, 49, 49, 49, 49, 49
        DC.W   49, 49, 49, 49, 49, 49, 49, 48, 48, 48
        DC.W   48, 48, 48, 48, 47, 47, 47, 47, 47, 46
        DC.W   46, 46, 46, 45, 45, 45, 45, 44, 44, 44
        DC.W   44, 43, 43, 43, 42, 42, 42, 42, 41, 41
        DC.W   41, 40, 40, 40, 39, 39, 38, 38, 38, 37
        DC.W   37, 37, 36, 36, 35, 35, 35, 34, 34, 33
        DC.W   33, 33, 32, 32, 31, 31, 31, 30, 30, 29
        DC.W   29, 28, 28, 28, 27, 27, 26, 26, 25, 25
        DC.W   25, 24, 24, 23, 23, 22, 22, 21, 21, 21
        DC.W   20, 20, 19, 19, 18, 18, 18, 17, 17, 16
        DC.W   16, 16, 15, 15, 14, 14, 14, 13, 13, 12
        DC.W   12, 12, 11, 11, 11, 10, 10, 9, 9, 9
        DC.W   8, 8, 8, 7, 7, 7, 7, 6, 6, 6
        DC.W   5, 5, 5, 5, 4, 4, 4, 4, 3, 3
        DC.W   3, 3, 2, 2, 2, 2, 2, 1, 1, 1
        DC.W   1, 1, 1, 1, 0, 0, 0, 0, 0, 0
        DC.W   0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DC.W   0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        DC.W   0, 0, 0, 0, 0, 0, 0, 1, 1, 1
        DC.W   1, 1, 1, 1, 2, 2, 2, 2, 2, 3
        DC.W   3, 3, 3, 4, 4, 4, 4, 5, 5, 5
        DC.W   5, 6, 6, 6, 7, 7, 7, 7, 8, 8
        DC.W   8, 9, 9, 9, 10, 10, 11, 11, 11, 12
        DC.W   12, 12, 13, 13, 14, 14, 14, 15, 15, 16
        DC.W   16, 16, 17, 17, 18, 18, 18, 19, 19, 20
        DC.W   20, 21, 21, 21, 22, 22, 23, 23, 24, 24
        DC.W   24
YTABEND:

BLK.B	10000,0


X2TAB:		DC.W	2,2,2,3,3,4,4,5,6,7,8,10,11,13,14,16,18
		DC.W	20,22,25,27,29,32,34,35,34,32,29,27,25,22,20
		DC.W	18,16,14,13,11,10,8,7,6,5,4,4,3,3,2,2,2
		DC.W	0

COLTAB:
		DC.W	$0F10,$0F20,$0F30,$0F40,$0F50,$0F60,$0F70
		DC.W	$0F80,$0F90,$0FA0,$0FB0,$0FC0,$0FD0,$0FE0
		DC.W	$0FF0,$0EF0,$0DF0,$0CF0,$0BF0,$0AF0,$09F0
		DC.W	$08F0,$07F0,$06F0,$05F0,$04F0,$03F0,$02F0
		DC.W	$01F0,$00F0,$00F1,$00F2,$00F3,$00F4,$00F5
		DC.W	$00F6,$00F7,$00F8,$00F9,$00FA,$00FB,$00FC
		DC.W	$00FD,$00FE,$00FF,$00EF,$00DF,$00CF,$00BF
		DC.W	$00AF,$009F,$008F,$007F,$006F,$005F,$004F
		DC.W	$003F,$002F,$001F,$000F,$010F,$020F,$030F
		DC.W	$040F,$050F,$060F,$070F,$080F,$090F,$0A0F
		DC.W	$0B0F,$0C0F,$0D0F,$0E0F,$0F0F,$0F0E,$0F0D
		DC.W	$0F0C,$0F0B,$0F0A,$0F09,$0F08,$0F07,$0F06
		DC.W	$0F05,$0F04,$0F03,$0F02,$0F01,$0F00,$FFFF

SCLTAB:		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DC.W	0,0,0,0,0,0,1,1,1,2,2,1,1,1,0,0,0,0,0,0,1,1,1
		DC.W	2,2,3,2,2,1,1,1,0,0,0,0,0,0
		DC.W	1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	7,7,7,6,6,6,5,5,5,4,4,4,3,3,3,2,2,2,1,1,1
		DC.W	0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9
		DC.W	10,10,11,11,12,12,13,13,14,14,15,15,14,14
		DC.W	13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5
		DC.W	4,4,3,3,2,2,1,1,0,0,0,0,0,0,1,1,2,2,3,3,4,3,3
		DC.W	2,2,1,1,0,0,0,0,0,0,0,1,2,3,3,3,2,1,0,0,0
		DC.W	1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8
		DC.W	8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14
		DC.W	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
		DC.W	15,14,14,14,14,13,13,13,13,12,12,11,11,10,10
		DC.W	9,9,8,8,7,7,6,6,5,5,4,4,4,4,3,3,2,2,1,1,1,1
		DC.W	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2
		DC.W	3,3,3,4,4,5,5,6,6,7,7,6,6,5,5,4,4,3,3,2,2,1,1
		DC.W	$FFFF

FLASH:
	DC.W	$0000,$0111,$0222,$0333,$0444,$0555,$0666
	DC.W	$0777,$0888,$0999,$0AAA,$0BBB,$0CCC,$0DDD
	DC.W	$0EEE,$0FFF,$0FFF,$0FFF,$0EEE,$0DDD,$0CCC,$0BBB
	DC.W	$0AAA,$0999,$0888,$0777,$0666,$0555,$0444
	DC.W	$0333,$0222,$0111,$0000,$FFFF




PICCIE:		BLK.B	8800,0
BPL1:		BLK.B	8800,0
		BLK.B	8800,0
BPL2:		BLK.B	8800,0
		BLK.B	8800,0
PLANE5:		BLK.B	8800,0

XTAB:		BLK.W	100,0
YSTAB:		BLK.W	100,0
ZTAB:		BLK.W	100,0

CLS:		LEA.L	BUFFER,A0
		MOVE.L	#7,D5
PISSLOP:	MOVE.W	(A0)+,D0
		MOVE.W	(A0)+,D1
		MOVE.W	(A0)+,D2
		MOVE.W	(A0)+,D3
		MOVE.W	#0,D4
		JSR	LINE
		DBF	D5,PISSLOP
		RTS

V42:		LEA.L	CORDS,A0
		LEA.L	BUFFER,A4
		MOVE.W	#$FFFF,D4
		ADD.L	COUNTER,A0
		ADD.L	#8,COUNTER
		CMP.L	#3016,COUNTER
		BNE 	COUNTOK
		MOVE.L	#0,COUNTER
COUNTOK:	CLR.W	D1
		CLR.W	D3
		MOVE	#3,D5
LOPEN:		MOVE.W	XETT,D0
		MOVE.W	YETT,D2
		ADDI.W	#125,D0
		ADDI.W	#85,D2
		MOVE.B	(A0)+,D1
		MOVE.B	(A0)+,D3
		JSR	LINE
		JSR	GASLAKTUS
		DBF	D5,LOPEN
		SUB.L	#8,A0
		CLR.L	D0
		CLR.L	D1
		CLR.L	D2
		CLR.L	D3
		MOVE.B	(A0)+,D0
		MOVE.B	(A0)+,D2
		MOVE.B	(A0)+,D1
		MOVE.B	(A0)+,D3
		JSR	LINE
		JSR	GASLAKTUS
		MOVE.B	D1,D0
		MOVE.B	D3,D2
		MOVE.B	(A0)+,D1
		MOVE.B	(A0)+,D3
		JSR	LINE
		JSR	GASLAKTUS
		MOVE.B	D1,D0
		MOVE.B	D3,D2
		MOVE.B	(A0)+,D1
		MOVE.B	(A0)+,D3
		JSR	LINE
		JSR	GASLAKTUS
		SUB.L	#8,A0
		MOVE.B	D1,D0
		MOVE.B	D3,D2
		MOVE.B	(A0)+,D1
		MOVE.B	(A0)+,D3
		JSR	LINE
		JSR	GASLAKTUS
		RTS
		
GASLAKTUS:	MOVE.W	D0,(A4)+
		MOVE.W	D1,(A4)+
		MOVE.W	D2,(A4)+
		MOVE.W	D3,(A4)+
		RTS

LINE:		MOVEM.L	D0-D7/A0-A6,-(A7)
HITLER:		BTST	#14,$DFF002
		BNE	HITLER
		MOVE.W	#$FFFF,$DFF044
		MOVE.W	#$FFFF,$DFF046
		MOVE.W	#44,$DFF066
		MOVE.W	#$8000,$DFF074
		MOVE.W	D4,$DFF072
		MOVE.W	#44,$DFF060
		CMP.W	D1,D0
		BLT	LEFF
		EXG	D0,D1
		EXG	D2,D3
LEFF:		SUB.W	D0,D1
		CMP.W	D2,D3
		BLT	FJODOR
		MOVE.W	D3,D4
		SUB.W	D2,D3
		BRA	ENOK_SUROGA
FJODOR:		MOVE.W	D2,D4
		SUB.W	D3,D4
		EXG	D4,D3
ENOK_SUROGA:	CMP.W	D2,D4
		BLT	VB_IF_MAD
		CMP.W	D3,D1
		BEQ	A_LAMOR
		BGT	BIG_ASS
		EXG	D1,D3
		MOVE.W	#65,$DFF042
		BRA	GALAKTUS
BIG_ASS:	MOVE.W	#81,$DFF042
		BRA	GALAKTUS
A_LAMOR:	MOVE.W	#17,$DFF042
		BRA	GALAKTUS
VB_IF_MAD:	CMP.W	D3,D1
		BEQ	SYSMAN
		BGT	JANNE_FANCLUB
		EXG	D1,D3
		MOVE.W	#69,$DFF042
		BRA	GALAKTUS
JANNE_FANCLUB:	MOVE.W	#89,$DFF042
		BRA	GALAKTUS
SYSMAN:		MOVE.W	#25,$DFF042
GALAKTUS:	MOVE.W	D3,D4
		ASL.W	#1,D4
		MOVE.W	D4,D5
		SUB.W	D1,D4
		MOVE.W	D4,$DFF052
		ASL.W	#1,D5
		MOVE.W	D5,$DFF062
		MOVE.W	D1,D4
		ASL.W	#2,D4
		SUB.W	D4,D5
		MOVE.W	D5,$DFF064
		MOVE.W	D0,D4
		LSR.W	#3,D4
		MULU	#44,D2
		ADD.W	D2,D4
		LEA.L	BPL2,A0
		ADD.L	A0,D4
		MOVE.L	D4,$DFF048
		MOVE.L	D4,$DFF054
		CLR.L	D4
		MOVE.W	D0,D4
		AND.W	#15,D4
		ASL.W	#8,D4
		ASL.W	#4,D4
		ORI.W	#$0BCA,D4
		MOVE.W	D4,$DFF040
		ADDQ.W	#1,D1
		ASL.W	#6,D1
		ADDQ.W	#2,D1
		MOVE.W	D1,$DFF058
		MOVEM.L	(A7)+,D0-D7/A0-A6
		RTS

MOVECENTER:	LEA.L	LINMOVE,A0
		ADDI.W	LINCOUNT,A0
		CMPI.W	#$FFFF,(A0)
		BNE	NOCLRCENT
		CLR.W	LINCOUNT
		BRA	MOVECENTER
NOCLRCENT:	MOVE.W	(A0)+,XETT
		MOVE.W	(A0)+,YETT
		ADDI.W	#4,LINCOUNT
		RTS		

XETT:		DC.W	0
YETT:		DC.W	0

LINCOUNT:	DC.W	0

FLUSH:		LEA.L	FLASH,A0		
		ADDI.W	FLSHPOS,A0
		CMPI.W	#$FFFF,(A0)
		BNE	NOFLSHCLR
		CLR.W	FLSHPOS
		BRA	FLUSH
NOFLSHCLR:	MOVE.W	(A0),VFLSH1
		MOVE.W	(A0)+,VFLSH2
		ADDI.W	#2,FLSHPOS
		RTS

FLSHPOS:	DC.W	0

EVEN
LINMOVE:
        DC.W   90, 45, 89, 46, 89, 48, 89, 49, 89, 51
        DC.W   89, 52, 89, 54, 89, 55, 89, 57, 89, 58
        DC.W   89, 60, 89, 61, 89, 63, 88, 64, 88, 66
        DC.W   88, 67, 88, 68, 88, 70, 87, 71, 87, 72
        DC.W   87, 73, 87, 75, 86, 76, 86, 77, 86, 78
        DC.W   85, 79, 85, 80, 85, 81, 84, 82, 84, 83
        DC.W   83, 83, 83, 84, 83, 85, 82, 86, 82, 86
        DC.W   81, 87, 81, 87, 80, 88, 80, 88, 79, 89
        DC.W   79, 89, 78, 89, 78, 89, 77, 89, 77, 89
        DC.W   76, 90, 76, 89, 75, 89, 75, 89, 74, 89
        DC.W   73, 89, 73, 89, 72, 88, 72, 88, 71, 87
        DC.W   70, 87, 70, 86, 69, 86, 68, 85, 68, 84
        DC.W   67, 83, 66, 83, 66, 82, 65, 81, 64, 80
        DC.W   64, 79, 63, 78, 62, 77, 61, 76, 61, 75
        DC.W   60, 73, 59, 72, 58, 71, 58, 70, 57, 68
        DC.W   56, 67, 55, 66, 55, 64, 54, 63, 53, 61
        DC.W   52, 60, 52, 58, 51, 57, 50, 55, 49, 54
        DC.W   48, 52, 48, 51, 47, 49, 46, 48, 45, 46
        DC.W   45, 45, 44, 43, 43, 41, 42, 40, 41, 38
        DC.W   41, 37, 40, 35, 39, 34, 38, 32, 37, 31
        DC.W   37, 29, 36, 28, 35, 26, 34, 25, 34, 23
        DC.W   33, 22, 32, 21, 31, 19, 31, 18, 30, 17
        DC.W   29, 16, 28, 14, 28, 13, 27, 12, 26, 11
        DC.W   25, 10, 25, 9, 24, 8, 23, 7, 23, 6
        DC.W   22, 6, 21, 5, 21, 4, 20, 3, 19, 3
        DC.W   19, 2, 18, 2, 17, 1, 17, 1, 16, 0
        DC.W   16, 0, 15, 0, 14, 0, 14, 0, 13, 0
        DC.W   13, 0, 12, 0, 12, 0, 11, 0, 11, 0
        DC.W   10, 0, 10, 0, 9, 1, 9, 1, 8, 2
        DC.W   8, 2, 7, 3, 7, 3, 6, 4, 6, 5
        DC.W   6, 6, 5, 6, 5, 7, 4, 8, 4, 9
        DC.W   4, 10, 3, 11, 3, 12, 3, 13, 2, 14
        DC.W   2, 16, 2, 17, 2, 18, 1, 19, 1, 21
        DC.W   1, 22, 1, 23, 1, 25, 0, 26, 0, 28
        DC.W   0, 29, 0, 31, 0, 32, 0, 34, 0, 35
        DC.W   0, 37, 0, 38, 0, 40, 0, 41, 0, 43
        DC.W   0, 44, 0, 46, 0, 48, 0, 49, 0, 51
        DC.W   0, 52, 0, 54, 0, 55, 0, 57, 0, 58
        DC.W   0, 60, 0, 61, 0, 63, 1, 64, 1, 66
        DC.W   1, 67, 1, 68, 1, 70, 2, 71, 2, 72
        DC.W   2, 73, 2, 75, 3, 76, 3, 77, 3, 78
        DC.W   4, 79, 4, 80, 4, 81, 5, 82, 5, 83
        DC.W   6, 83, 6, 84, 6, 85, 7, 86, 7, 86
        DC.W   8, 87, 8, 87, 9, 88, 9, 88, 10, 89
        DC.W   10, 89, 11, 89, 11, 89, 12, 89, 12, 89
        DC.W   13, 90, 13, 89, 14, 89, 14, 89, 15, 89
        DC.W   16, 89, 16, 89, 17, 88, 17, 88, 18, 87
        DC.W   19, 87, 19, 86, 20, 86, 21, 85, 21, 84
        DC.W   22, 83, 23, 83, 23, 82, 24, 81, 25, 80
        DC.W   25, 79, 26, 78, 27, 77, 28, 76, 28, 75
        DC.W   29, 73, 30, 72, 31, 71, 31, 70, 32, 68
        DC.W   33, 67, 34, 66, 34, 64, 35, 63, 36, 61
        DC.W   37, 60, 37, 58, 38, 57, 39, 55, 40, 54
        DC.W   41, 52, 41, 51, 42, 49, 43, 48, 44, 46
        DC.W   44, 45, 45, 43, 46, 41, 47, 40, 48, 38
        DC.W   48, 37, 49, 35, 50, 34, 51, 32, 52, 31
        DC.W   52, 29, 53, 28, 54, 26, 55, 25, 55, 23
        DC.W   56, 22, 57, 21, 58, 19, 58, 18, 59, 17
        DC.W   60, 16, 61, 14, 61, 13, 62, 12, 63, 11
        DC.W   64, 10, 64, 9, 65, 8, 66, 7, 66, 6
        DC.W   67, 6, 68, 5, 68, 4, 69, 3, 70, 3
        DC.W   70, 2, 71, 2, 72, 1, 72, 1, 73, 0
        DC.W   73, 0, 74, 0, 75, 0, 75, 0, 76, 0
        DC.W   76, 0, 77, 0, 77, 0, 78, 0, 78, 0
        DC.W   79, 0, 79, 0, 80, 1, 80, 1, 81, 2
        DC.W   81, 2, 82, 3, 82, 3, 83, 4, 83, 5
        DC.W   83, 6, 84, 6, 84, 7, 85, 8, 85, 9
        DC.W   85, 10, 86, 11, 86, 12, 86, 13, 87, 14
        DC.W   87, 16, 87, 17, 87, 18, 88, 19, 88, 21
        DC.W   88, 22, 88, 23, 88, 25, 89, 26, 89, 28
        DC.W   89, 29, 89, 31, 89, 32, 89, 34, 89, 35
        DC.W   89, 37, 89, 38, 89, 40, 89, 41, 89, 43
        DC.W   90, 44, $FFFF

SPRITE_SETUP:	MOVE.L	#SPRITE0,D0
		SWAP	D0
		MOVE.W	D0,SPHI0
		SWAP	D0
		MOVE.W	D0,SPLO0
		MOVE.L	#SPRITE1,D0
		SWAP	D0
		MOVE.W	D0,SPHI1
		SWAP	D0
		MOVE.W	D0,SPLO1
		MOVE.L	#SPRITE2,D0
		SWAP	D0
		MOVE.W	D0,SPHI2
		SWAP	D0
		MOVE.W	D0,SPLO2
		MOVE.L	#SPRITE3,D0
		SWAP	D0
		MOVE.W	D0,SPHI3
		SWAP	D0
		MOVE.W	D0,SPLO3
		MOVE.L	#SPRITE4,D0
		SWAP	D0
		MOVE.W	D0,SPHI4
		SWAP	D0
		MOVE.W	D0,SPLO4
		MOVE.L	#ZEROSPR,D0
		SWAP	D0
		MOVE.W	D0,SPHI5
		SWAP	D0
		MOVE.W	D0,SPLO5
		MOVE.L	#ZEROSPR,D0
		SWAP	D0
		MOVE.W	D0,SPHI6
		SWAP	D0
		MOVE.W	D0,SPLO6
		MOVE.L	#ZEROSPR,D0
		SWAP	D0
		MOVE.W	D0,SPHI7
		SWAP	D0
		MOVE.W	D0,SPLO7
		RTS

SPRITE0:

VSTART0:	DC.W	$A080
VSTOP0:		DC.W	$B000

	DC.W	%000000000000000	; FORSTA BITPLANE (RAD1)
	DC.W	%011100000001110	; ANDRA BITPLANE  (RAD1)

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%001111000011110
	DC.W	%011110000111100

	DC.W	%000111100111100
	DC.W	%001111001111000

	DC.W	%000011111111000
	DC.W	%000111111110000

	DC.W	%000001111110000
	DC.W	%000011111100000

	DC.W	%000001111110000
	DC.W	%000011111100000

	DC.W	%000011111111000
	DC.W	%000111111110000

	DC.W	%000111100111100
	DC.W	%001111001111000

	DC.W	%001111000011110
	DC.W	%011110000111100

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%001100000000110
	DC.W	%010000000001000

	DC.W	%0000000000000000
	DC.W	%0000000000000000

SPRITE1:

VSTART1:	DC.W	$A090
VSTOP1:		DC.W	$B000

	DC.W	%000000000000000	; FORSTA BITPLANE (RAD1)
	DC.W	%011100000001110	; ANDRA BITPLANE  (RAD1)

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%001111000011110
	DC.W	%011110000111100

	DC.W	%000111100111100
	DC.W	%001111001111000

	DC.W	%000011111111000
	DC.W	%000111111110000

	DC.W	%000001111110000
	DC.W	%000011111100000

	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000000111100000
	DC.W	%000001111000000


	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000000011000000
	DC.W	%000000100000000

	DC.W	%0000000000000000
	DC.W	%0000000000000000

SPRITE2:
VSTART2:	DC.W	$A0A0
VSTOP2:		DC.W	$B000

	DC.W	%000000000000000
	DC.W	%011111111111110

	DC.W	%011111111111111
	DC.W	%111111111111110

	DC.W	%011111111111111
	DC.W	%111111111111110

	DC.W	%001111111101111
	DC.W	%010000000011110

	DC.W	%000000000011110
	DC.W	%000000000111100

	DC.W	%000000000111100
	DC.W	%000000001111000

	DC.W	%000000001111000
	DC.W	%000000011110000

	DC.W	%000000011110000
	DC.W	%000000111100000

	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000001111000000
	DC.W	%000011110000000

	DC.W	%000011110000000
	DC.W	%000111100000000

	DC.W	%000111100000000
	DC.W	%001111000000000

	DC.W	%001110000000000
	DC.W	%011111111111110

	DC.W	%011111111111111
	DC.W	%111111111111110

	DC.W	%011111111111111
	DC.W	%111111111111110

	DC.W	%001111111111110
	DC.W	%010000000000000

	DC.W	$0000,$0000

SPRITE3:
VSTART3:	DC.W	$A0B0
VSTOP3:		DC.W	$B000

	DC.W	%000000000000000
	DC.W	%011111111111110

	DC.W	%011111111111111
	DC.W	%111111111111110

	DC.W	%011111111111111
	DC.W	%111111111111110

	DC.W	%001111111101111
	DC.W	%010000000011110

	DC.W	%000000000011110
	DC.W	%000000000111100

	DC.W	%000000000111100
	DC.W	%000000001111000

	DC.W	%000000001111000
	DC.W	%000000011110000

	DC.W	%000000011110000
	DC.W	%000000111100000

	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000001111000000
	DC.W	%000011110000000

	DC.W	%000011110000000
	DC.W	%000111100000000

	DC.W	%000111100000000
	DC.W	%001111000000000

	DC.W	%001110000000000
	DC.W	%011111111111110

	DC.W	%011111111111111
	DC.W	%111111111111110

	DC.W	%011111111111111
	DC.W	%111111111111110

	DC.W	%001111111111110
	DC.W	%010000000000000

	DC.W	$0000,$0000

SPRITE4:

VSTART4:	DC.W	$A0C0
VSTOP4:		DC.W	$B000

	DC.W	%000000000000000	; FORSTA BITPLANE (RAD1)
	DC.W	%011100000001110	; ANDRA BITPLANE  (RAD1)

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%011110000001111
	DC.W	%111100000011110

	DC.W	%001111000011110
	DC.W	%011110000111100

	DC.W	%000111100111100
	DC.W	%001111001111000

	DC.W	%000011111111000
	DC.W	%000111111110000

	DC.W	%000001111110000
	DC.W	%000011111100000

	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000000111100000
	DC.W	%000001111000000


	DC.W	%000000111100000
	DC.W	%000001111000000

	DC.W	%000000011000000
	DC.W	%000000100000000

	DC.W	%0000000000000000
	DC.W	%0000000000000000

ZEROSPR:	DC.L	1
		DC.W	0

SPR0:		LEA.L	SPRITE0,A0
		LEA.L	MOVETAB,A1
		LEA.L	MOVETAB2,A2
		MOVE.L	MOVEPOS0,D4
		CMPI.W	#$FFFF,(A1,D4.L)
		BNE	KRYP0
		CLR.L	MOVEPOS0
		BRA	SPR0
KRYP0:		MOVE.W	(A1,D4.L),D0   ; XPOS
		MOVE.W	2(A1,D4.L),D1  ; YPOS
		ADDI.W	#205,D0
		ADDI.W	#100,D1
		MOVE.W	#16,D2          ; VSTOP
		JSR	SETSPRITE
		ADDI.L	#4,MOVEPOS0

SPR1:		LEA.L	SPRITE1,A0
		LEA.L	MOVETAB,A1
		LEA.L	MOVETAB2,A2
		MOVE.L	MOVEPOS1,D4
		CMPI.W	#$FFFF,(A1,D4.L)
		BNE	KRYP1
		CLR.L	MOVEPOS1
		BRA	SPR1
KRYP1:		MOVE.W	(A1,D4.L),D0   ; XPOS
		MOVE.W	2(A1,D4.L),D1  ; YPOS
		ADDI.W	#205,D0
		ADDI.W	#100,D1
		MOVE.W	#16,D2          ; VSTOP
		JSR	SETSPRITE
		ADDI.L	#4,MOVEPOS1

SPR2:		LEA.L	SPRITE2,A0
		LEA.L	MOVETAB,A1
		LEA.L	MOVETAB2,A2
		MOVE.L	MOVEPOS2,D4
		CMPI.W	#$FFFF,(A1,D4.L)
		BNE	KRYP2
		CLR.L	MOVEPOS2
		BRA	SPR2
KRYP2:		MOVE.W	(A1,D4.L),D0   ; XPOS
		MOVE.W	2(A1,D4.L),D1  ; YPOS
		ADDI.W	#205,D0
		ADDI.W	#100,D1
		MOVE.W	#16,D2          ; VSTOP
		JSR	SETSPRITE
		ADDI.L	#4,MOVEPOS2

SPR3:		LEA.L	SPRITE3,A0
		LEA.L	MOVETAB,A1
		LEA.L	MOVETAB2,A2
		MOVE.L	MOVEPOS3,D4
		CMPI.W	#$FFFF,(A1,D4.L)
		BNE	KRYP3
		CLR.L	MOVEPOS3
		BRA	SPR3
KRYP3:		MOVE.W	(A1,D4.L),D0   ; XPOS
		MOVE.W	2(A1,D4.L),D1  ; YPOS
		ADDI.W	#205,D0
		ADDI.W	#100,D1
		MOVE.W	#16,D2          ; VSTOP
		JSR	SETSPRITE
		ADDI.L	#4,MOVEPOS3

SPR4:		LEA.L	SPRITE4,A0
		LEA.L	MOVETAB,A1
		LEA.L	MOVETAB2,A2
		MOVE.L	MOVEPOS4,D4
		CMPI.W	#$FFFF,(A1,D4.L)
		BNE	KRYP4
		CLR.L	MOVEPOS4
		BRA	SPR4
KRYP4:		MOVE.W	(A1,D4.L),D0   ; XPOS
		MOVE.W	2(A1,D4.L),D1  ; YPOS
		ADDI.W	#205,D0
		ADDI.W	#100,D1
		MOVE.W	#16,D2          ; VSTOP
		JSR	SETSPRITE
		ADDI.L	#4,MOVEPOS4
		RTS

SETSPRITE:	MOVEM.L	D0/D1/D2/D3,-(A7) 
		CLR.L	(A0)
		MOVE.B	D1,(A0)   ; YPOS (0-255)
		ROR.W	#1,D0
		BCS	SETLO
		BRA	SPRITER
SETLO:		BSET	#0,3(A0)
SPRITER:	MOVE.B	D0,1(A0)
		ADDI.B	D1,D2     ; YSTOP (0-255)
		MOVE.B	D2,2(A0)
		MOVEM.L	(A7)+,D0/D1/D2/D3
		RTS

MOVEPOS0:	DC.L	80
MOVEPOS1:	DC.L	60
MOVEPOS2:	DC.L	40
MOVEPOS3:	DC.L	20
MOVEPOS4:	DC.L	0

MOVETAB:		
        DC.W   130, 45, 129, 46, 129, 48, 129, 49, 129, 51
        DC.W   129, 52, 128, 54, 128, 55, 127, 57, 126, 58
        DC.W   126, 60, 125, 61, 124, 63, 123, 64, 122, 66
        DC.W   121, 67, 120, 68, 118, 70, 117, 71, 116, 72
        DC.W   114, 73, 113, 75, 111, 76, 110, 77, 108, 78
        DC.W   106, 79, 105, 80, 103, 81, 101, 82, 99, 83
        DC.W   97, 83, 95, 84, 93, 85, 91, 86, 89, 86
        DC.W   87, 87, 85, 87, 82, 88, 80, 88, 78, 89
        DC.W   76, 89, 74, 89, 71, 89, 69, 89, 67, 89
        DC.W   65, 90, 62, 89, 60, 89, 58, 89, 55, 89
        DC.W   53, 89, 51, 89, 49, 88, 47, 88, 44, 87
        DC.W   42, 87, 40, 86, 38, 86, 36, 85, 34, 84
        DC.W   32, 83, 30, 83, 28, 82, 26, 81, 24, 80
        DC.W   23, 79, 21, 78, 19, 77, 18, 76, 16, 75
        DC.W   15, 73, 13, 72, 12, 71, 11, 70, 9, 68
        DC.W   8, 67, 7, 66, 6, 64, 5, 63, 4, 61
        DC.W   3, 60, 3, 58, 2, 57, 1, 55, 1, 54
        DC.W   0, 52, 0, 51, 0, 49, 0, 48, 0, 46
        DC.W   0, 45, 0, 43, 0, 41, 0, 40, 0, 38
        DC.W   0, 37, 1, 35, 1, 34, 2, 32, 3, 31
        DC.W   3, 29, 4, 28, 5, 26, 6, 25, 7, 23
        DC.W   8, 22, 9, 21, 11, 19, 12, 18, 13, 17
        DC.W   15, 16, 16, 14, 18, 13, 19, 12, 21, 11
        DC.W   23, 10, 24, 9, 26, 8, 28, 7, 30, 6
        DC.W   32, 6, 34, 5, 36, 4, 38, 3, 40, 3
        DC.W   42, 2, 44, 2, 47, 1, 49, 1, 51, 0
        DC.W   53, 0, 55, 0, 58, 0, 60, 0, 62, 0
        DC.W   64, 0, 67, 0, 69, 0, 71, 0, 74, 0
        DC.W   76, 0, 78, 0, 80, 1, 82, 1, 85, 2
        DC.W   87, 2, 89, 3, 91, 3, 93, 4, 95, 5
        DC.W   97, 6, 99, 6, 101, 7, 103, 8, 105, 9
        DC.W   106, 10, 108, 11, 110, 12, 111, 13, 113, 14
        DC.W   114, 16, 116, 17, 117, 18, 118, 19, 120, 21
        DC.W   121, 22, 122, 23, 123, 25, 124, 26, 125, 28
        DC.W   126, 29, 126, 31, 127, 32, 128, 34, 128, 35
        DC.W   129, 37, 129, 38, 129, 40, 129, 41, 129, 43
        DC.W   130, 44, 129, 46, 129, 48, 129, 49, 129, 51
        DC.W   129, 52, 128, 54, 128, 55, 127, 57, 126, 58
        DC.W   126, 60, 125, 61, 124, 63, 123, 64, 122, 66
        DC.W   121, 67, 120, 68, 118, 70, 117, 71, 116, 72
        DC.W   114, 73, 113, 75, 111, 76, 110, 77, 108, 78
        DC.W   106, 79, 105, 80, 103, 81, 101, 82, 99, 83
        DC.W   97, 83, 95, 84, 93, 85, 91, 86, 89, 86
        DC.W   87, 87, 85, 87, 82, 88, 80, 88, 78, 89
        DC.W   76, 89, 74, 89, 71, 89, 69, 89, 67, 89
        DC.W   65, 90, 62, 89, 60, 89, 58, 89, 55, 89
        DC.W   53, 89, 51, 89, 49, 88, 47, 88, 44, 87
        DC.W   42, 87, 40, 86, 38, 86, 36, 85, 34, 84
        DC.W   32, 83, 30, 83, 28, 82, 26, 81, 24, 80
        DC.W   23, 79, 21, 78, 19, 77, 18, 76, 16, 75
        DC.W   15, 73, 13, 72, 12, 71, 11, 70, 9, 68
        DC.W   8, 67, 7, 66, 6, 64, 5, 63, 4, 61
        DC.W   3, 60, 3, 58, 2, 57, 1, 55, 1, 54
        DC.W   0, 52, 0, 51, 0, 49, 0, 48, 0, 46
        DC.W   0, 45, 0, 43, 0, 41, 0, 40, 0, 38
        DC.W   0, 37, 1, 35, 1, 34, 2, 32, 3, 31
        DC.W   3, 29, 4, 28, 5, 26, 6, 25, 7, 23
        DC.W   8, 22, 9, 21, 11, 19, 12, 18, 13, 17
        DC.W   15, 16, 16, 14, 18, 13, 19, 12, 21, 11
        DC.W   23, 10, 24, 9, 26, 8, 28, 7, 30, 6
        DC.W   32, 6, 34, 5, 36, 4, 38, 3, 40, 3
        DC.W   42, 2, 44, 2, 47, 1, 49, 1, 51, 0
        DC.W   53, 0, 55, 0, 58, 0, 60, 0, 62, 0
        DC.W   64, 0, 67, 0, 69, 0, 71, 0, 74, 0
        DC.W   76, 0, 78, 0, 80, 1, 82, 1, 85, 2
        DC.W   87, 2, 89, 3, 91, 3, 93, 4, 95, 5
        DC.W   97, 6, 99, 6, 101, 7, 103, 8, 105, 9
        DC.W   106, 10, 108, 11, 110, 12, 111, 13, 113, 14
        DC.W   114, 16, 116, 17, 117, 18, 118, 19, 120, 21
        DC.W   121, 22, 122, 23, 123, 25, 124, 26, 125, 28
        DC.W   126, 29, 126, 31, 127, 32, 128, 34, 128, 35
        DC.W   129, 37, 129, 38, 129, 40, 129, 41, 129, 43
        DC.W   129, 44, $FFFF


MOVETAB2:

COUNTER:	DC.L	0

BUFFER:		BLK.W	32,0

CORDS:		BLK.B	3032,0

PROGEND: ; END ADDRESS OF PROGRAM

