#include <osbind.h>
#include <stdio.h>

int XMIN, YMIN, XMAX, YMAX;

wOnewSize(x,y, w,h)
int x,y, w,h;
{	XMIN = x;	YMIN = y;
	XMAX = x+w+2;	YMAX = y+h+2;
}

#define colors(r,g,b) 1000*(2*(r)+1)/16, 1000*(2*(g)+1)/16, 1000*(2*(b)+1)/16
int oldClut[16][3], newClut[16][3] = {
colors(7,7,7),	/* all white-ish */
colors(0,0,0),	/* black */
colors(0,0,1),	/* somewhat lighter */
colors(1,1,1),
colors(1,1,2),
colors(2,2,2),
colors(2,2,3),
colors(3,3,3),
colors(3,3,4),
colors(4,4,4),
colors(4,4,5),
colors(5,5,5),
colors(5,5,6),
colors(6,6,6),
colors(6,6,7),
colors(6,7,7)};	/* almost white */

int wHandle;
FILE *fp, *fopen();
char outname[] = "blastram";
long orig_base;
float speed = 12000.0;
long Ispeed = 12000;

#define bytesPscreen 32000

main (argc, argv) 
int argc;
char *argv[];
{	long mem_avail, l;
	char *mem_for_screen;
	char (*Pscreen)[bytesPscreen];
	int i, j, Nscreens, screens_read, delay;
	char fname[20];

	if (argc != 2)
		panic("usage: blastram <fname_prefix> (sans the XXX.PI1)\n");
	wHandle = w_open(0, "pearle", 0);	/* open window (typeless, menueless) */
	w_lClut(newClut, oldClut);
	v_hide_c(wHandle);
	orig_base = Physbase();

	mem_avail = Malloc((long)-1);
	mem_for_screen = Malloc (mem_avail);
	printf("\033E%ld bytes memory available.\n", mem_avail);

	Nscreens = (mem_avail - 0x100 - ((long)mem_for_screen & 0xff)) 
							/ bytesPscreen;
	Pscreen = (char *) (((long)mem_for_screen | 0xff) + 1);

	printf("%d screens Max.\n\n", Nscreens);

	for (i=1; i<999 & Nscreens > 0;)
	{	sprintf(fname,"%s%03d.pi1", argv[1], i);
		printf("file %s -- ", fname);
		if (f_read(fname, Pscreen+screens_read) >= 0)
		{	screens_read++;
			--Nscreens;
			printf("to screen %d.\n", screens_read);
			i++;
		}
		else
		{	printf("not found.\n");
			if (screens_read)		
			{	char key;
reask:				printf("\nType 'c', 'd' or 'e':\n");
				printf("c: CONTINUE with another diskette\n");
				printf("d: DISPLAY what's been loaded\n");
				printf("e: EXIT\n");
				key = Cconin();
				printf("\n");
				Mediach('a'-'a'); 
				if (key == 'c')
					continue;
				else if (key == 'd')
					break;
				else if (key == 'e')
					exit(0);
				else
				{	printf("\nAnswer 'c', 'd', or 'e'\n\n");
					goto reask;
	}	}	}	}
	for (i=0; 1; i = (i + kbd() + screens_read)%screens_read)
	{	Setscreen((long)-1, Pscreen + i, -1);
		for (l=0; l < Ispeed; l++)	
			delay++;
}	}

int freeze = 0;

kbd()
{	char key, fname[20];
	int found_first = 0, fr1;

	if (Cconis() == 0 && freeze==0)
		return(1);

	key = Cconin();
	while (1)
	{	switch(key)
		{   case ('?'):	/* help */
			Setscreen((long)-1, orig_base, -1);
			printf("\033E\n\n       BLASTRAM.C\n\
			\n '-' back up one frame\
			\n '+' forward one frame\
			\n ' ' freeze on frame\
			\n 'f' faster\
			\n 's' slower\
			\n <all else> play forward\
			\n use reset to exit\
			\n");
			key = Cconin();
			printf("\033E");
			break;
		    case ('-'):				/* back up one */
			freeze = 1;
			return (-1);
		    case ('+'): case ('='):		/* forward one */
			freeze = 1;
			return (1);
		    case (' '):				/* freeze on */
			freeze = 1;
			return (0);
		    case ('f'):				/* faster */
			speed /= 1.2;
			Ispeed = speed;
			return (1);
		    case ('s'):				/* slower */
			speed *= 1.2;
			Ispeed = speed;
			return (1);
/*		    case ('e'):
			Setscreen((long)-1, orig_base, -1);
			w_lClut(oldClut, (long)0);
			w_close();
			exit(0);/* the above leaves desktop in a wierd state */
		    default:
			freeze = 0;
			return (1);
}	}	}
	
panic(s,l1,l2)
char *s;
long l1,l2;
{	printf("\n***** FATAL ERROR *****\n");
	printf(s,l1,l2);
	printf("\nPress any key to continue\n");
	Cconin();
	exit();
	atoi();
}
