/* wndows.c
 *   manage the interface to GEM windows

Entry Points:
	w_open(type,name)			***
	w_close()
        w_lClut(new, old)

Outward Calls:
	wOnewSize()

 */

#include <obdefs.h>
#include <define.h>
#include <gemdefs.h>
#include <vdibind.h>
#include <osbind.h>

#define MIN_WIDTH  (2*gl_wbox)
#define MIN_HEIGHT (3*gl_hbox)
int gl_hchar, gl_wchar, gl_wbox, gl_hbox;	/* system sizes */

int	ps_handle;	/* physical screen (workstation) handle */
int	vs_handle;	/* virtual screen (workstation) handle */
int	wi_handle;	/* window handle */

int	xdesk,ydesk,hdesk,wdesk;	/* size of whole desktop */
int	xwork,ywork,hwork,wwork;	/* size of current working window */
int	xold,yold,hold,wold;		/* size of screen before FULL cmd */

int	contrl[12], intin[128], ptsin[128], intout[128];
int	ptsout[128];	/* storage for gem bindings */

char *p_menu;
int WiKind;

w_open(kind, name, menue_id)
int kind;		/* properties of window (e.g. MOVER|CLOSER|...) */
char *name;
int menue_id;		/* open menue? */
{	char n2[30];
	appl_init();
	open_vwork();
 	open_window(kind, name);
	WiKind = kind;
	sprintf(n2, "%s.rsc", name);
	open_rsc(n2, menue_id);
	graf_mouse(ARROW,0x0L);
	return (wi_handle);
}

w_close()
{	if (p_menu)
		menu_bar(p_menu, FALSE);
	wind_close(wi_handle);
	graf_shrinkbox(xwork+wwork/2,ywork+hwork/2,gl_wbox,gl_hbox,xwork,ywork,wwork,hwork);
	wind_delete(wi_handle);
	v_clsvwk(vs_handle);
	appl_exit();
}

int work_in[11];	/* Input to GSX parameter array */
int work_out[57];	/* Output from GSX parameter array */

open_vwork()
{	int i;

	ps_handle=graf_handle(&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);
	for(i=0;i<10;work_in[i++]=1);
	work_in[10]=2;
	vs_handle=ps_handle;
	v_opnvwk(work_in,&vs_handle,work_out);
	if (vs_handle == 0)
		panic("v_opnvwk couldn't open window",0L,0L);
}

open_window(kind, name)
int kind;
char *name;
{	wind_get(0/*whole screen*/,WF_WORKXYWH, &xdesk, &ydesk, &wdesk, &hdesk);
	wi_handle=wind_create(kind,xdesk,ydesk,wdesk,hdesk);

	wind_set(wi_handle, WF_NAME,name, 0,0);
	graf_growbox(xdesk+wdesk/2,ydesk+hdesk/2,gl_wbox,gl_hbox,xdesk,ydesk,wdesk,hdesk);
	wind_open(wi_handle,xdesk,ydesk,wdesk,hdesk);
	wind_get(wi_handle,WF_WORKXYWH,&xwork,&ywork,&wwork,&hwork);
	wwork--;	/* ywork--;/**/ hwork--;
	set_clip(xwork, ywork, wwork, hwork);
	wOnewSize(xwork, ywork, wwork, hwork);
	if (wdesk>500 && 2 != form_alert(1,"[3][16 Colors Required.|\
Set Preferences to Low|Resolution and Restart.][okay|ignore warning]")) 
		exit();/**/
}

open_rsc(myname, menue)
char *myname;
int menue;
{	if (menue)
	{	if (rsrc_load(myname)==0) panic("File %s missing!",myname,0L);
		if (rsrc_gaddr(R_TREE, menue, &p_menu)==0)
			panic ("AES/rsrc_gaddr() error",0L,0L);
		if (menu_bar(p_menu, TRUE)==0) panic ("AES/menu_bar() error",0L,0L);
}	}

typedef int CLUT[16][3];
CLUT (*clut_current);

w_lClut(new, old)
CLUT new, old;
{	int i;
	clut_current = new;
	for (i=0; i<16; i++)
	{	if (old)
			vq_color(vs_handle, i, 0, old[i]);
		if (new)
			vs_color(vs_handle, i, new[i]);
}	}

di_header(dx, str)
int dx;
char *str;
{	set_clip(xdesk, ydesk, wdesk, hdesk);
/*	v_gtext(vs_handle, ((dx>0)? Wx0: Wx1) +dx, Wy0-3, str);/**/
	v_gtext(vs_handle, xdesk + (dx<0)*wdesk + dx, ydesk-3, str);
	set_clip(xwork, ywork, wwork, hwork);
}

di_bg(dx, clr)
int dx, clr;
{	int pxy[4];
	set_clip(xdesk, ydesk, wdesk, hdesk);
	vsf_color(wi_handle, clr);
	pxy[0] = xdesk+dx;	pxy[2] = pxy[0] + 8;
	pxy[1] = ydesk-10/*3*/;	pxy[3] = pxy[1] + 18;
	v_bar(wi_handle, pxy);
	set_clip(xwork, ywork, wwork, hwork);
}
set_clip(x,y,w,h)
int x,y,w,h;
{	int clip[4];

	clip[0]=x;	/* set vdi's clip rectangle */
	clip[1]=y;
	clip[2]=x+w;
	clip[3]=y+h;
	vs_clip(wi_handle,1,clip);
}
