/*

 Uforce.c - read a sample set from the Uforce

 Ethan Dicks  <erd@kumiss.UUCP>

 Version 1.0  24-Mar-1992

*/

/*

The information provided about the Uforce was provided to me by Dave Capper
and Stan Axelrod, the developers of the Uforce.  I was send a multi-page
developers guide and was able to piece together the following code to
wrest the information out of the device.  I was not required to sign any
non-disclosure agreements, so I believe that I am permitted to pass along
the following information...

"Uforce 101..."

The Uforce has 9 total IR emitters and detectors of which 8 may be active
at any given time.  The four configuration switches are divided into
two functional groups.  The first three select a sample mode which determines
how the Uforce will present the data to the host and the last switch selects
which of two particular sensors is active.  Seven of the eight possible
arrangements of the first three config switches places the Uforce into
"Threshold mode" wherin the device compares the values of the various
sensors against known thresholds in ROM and provides the host with a standard
NES 8 bit packet containing up/down/left/right/select/start/A/B information.
When all three switches are down, the Uforce is placed into "Analog mode"
wherin a multi-byte packet with raw information about each IR sensor
is provided to the host.  The format is as follows... (all values in hex)

 Flag 	 S 7	 S 6	 S 5	 S 4	 S 3	 S 2 	 S 1	 S 0
FC-FF*	01-FB	01-FB	01-FB	01-FB	01-FB	01-FB	01-FB	01-FB

FF = no buttons pressed
FE = START pressed
FD = SELECT pressed
FC = START & SELECT pressed

The flag byte is easy to spot because it is always over FC.  If 00 is
ever read, it should be discarded because the Uforce is still aquiring
data (this can take up to 10 milliseconds to complete); 00 is never
valid data.  There must be a 150 microsecond delay between bytes; this
is an NES restriction.  Any routine which is able to read in a single
byte from a standard NES controller can be used to read the Uforce in
Analog mode; unlike the PowerGlove in hires mode, the Uforce uses fairly
standard techniques for sending data back to the host.

The sensor map is arranged as follows...

	+------ 0 ------+
	|   2	    1	|
	|		|
	|   3	    5   |
	+---------------+
	|   4	    	|
	|		|
	|   7	    6   |
	+------ 5 ------+

Sensor 5 is controlled by the right most config switch

*/
#ifdef AMIGA
#include <exec/types.h>
#endif

#include "UForce.h"

void query_Uforce(Uforce_data *g)
{
	register int i;
	register UBYTE j;
	register UBYTE *bp = (UBYTE *)g;

/* Sychronize the computer with the sample stream by waiting for a flag byte */
	while ( (*bp = query_NES()) < U_FLAG_LO) {
		delay(100);		/* delay in uSec */
	}	

	bp++;				/* skip past flag byte */
		
/* Now, load the eight sensor values into the Uforce_data buffer */
	for (i = 0; i < 8; i++) {
		while ( (j = query_NES()) == U_SAMPLING)
			printf("*");	/* print aquisition delay indicator */
		*bp++ = j;		/* load sample into buffer */
	}
}
