/*

NES.h - definitions for any NES device

Ethan Dicks  <erd@kumiss.UUCP>

Version 1.0  24-Mar-1992

*/

#ifndef UFORCE_H_INCLUDE
#define UFORCE_H_INCLUDE

#ifdef AMIGA
#include <exec/types.h>
#endif

#include "NES.h"


/* The flag byte format is %111111xx where the low bits are the buttons */
#define U_FLAG_HI 255
#define U_FLAG_LO 252

/* The select and start buttons are the low two bits of the flag byte */
#define U_SELECT 2
#define U_START 1

/* A valid sample value must be between 1 and 251 */
#define U_SAMPLE_HI 251
#define U_SAMPLE_LO 1

/* A zero return from the U-Force indicates aquisition is still in progress */
#define U_SAMPLING 0

typedef struct _Uforce_data {
	UBYTE f0,a0,a1,a2,a3,a4,a5,a6,a7;
} Uforce_data;

void init_device(void);
void query_device(Uforce_data *);

#endif /* UFORCE_H_INCLUDE */
