MODULE Control;

IMPORT GEMVDIbase, GEMAESbase, AESMenus, AESForms, AESObjects, AESEvents,
       AESResources ;

FROM   AESGraphics      IMPORT GrafMouse;

FROM   AESObjects       IMPORT ObjectDraw;

FROM   MYLIB    IMPORT  InitResource,Terminate,
                        DeselectObject,
                        dTree,MenuTree,x,y,w,h,InitWindow,CloseWindow;

FROM   SYSTEM   IMPORT  ADR,ADDRESS,CODE,TSIZE;

FROM   Strings  IMPORT  String, Concat;

FROM   XBIOS    IMPORT  SuperExec,SerialSpeed,ConfigureRS232,FlowFlavor;

FROM   BIOS     IMPORT  DriveSet;

FROM   GEMDOS   IMPORT  ExecMode,Exec,Open,Close,Read,Write,Create;

FROM   TextIO   IMPORT  SetDefaultIO,WriteString,WriteLn;

FROM   Streams  IMPORT  StreamKinds;

TYPE
  SequenceNr  = [0..1];
  control     = RECORD
                 magic          :       LONGCARD;
                 speed          :       SerialSpeed;
                 reset          :       BOOLEAN;
                 networkactive  :       BOOLEAN;
                 remotedrive    :       CARDINAL;
                 drivemap       :       DriveSet;
                nextframetosend :       SequenceNr;
                frameexpected   :       SequenceNr;
                sendreset       :       BOOLEAN;
               END;

  consave     = RECORD
                 magic          :       LONGCARD;
                 speed          :       SerialSpeed;
                 reset          :       BOOLEAN;
                 networkactive  :       BOOLEAN;
                END;
CONST
       resourcefilename = "ANETWORK.RSC" ;
       RTS              = 04E75H ;

CONST
      DRVD = 58 ;
      DRVF = 60 ;
      DRVE = 59 ;
     SEQUP = 62 ;
       S10 = 64 ;
       S00 = 63 ;
       S01 = 65 ;
       S11 = 66 ;
     ABOUT = 1 ;
   ABOUTOK = 1 ;
      MENU = 0 ;
      FILE = 4 ;
      DESK = 3 ;
      BAUD = 5 ;
      MODE = 6 ;
   OPTIONS = 8 ;
      DIAL = 7 ;
       SEQ = 9 ;
  ABOUTNET = 12 ;
      LOAD = 21 ;
      QUIT = 22 ;
     BAUD1 = 25 ;
     BAUD2 = 26 ;
     BAUD4 = 28 ;
     BAUD3 = 27 ;
     BAUD5 = 29 ;
     BAUD6 = 30 ;
       INT = 32 ;
     MODE1 = 33 ;
     MODE2 = 34 ;
  REBOOTOK = 36 ;
     DIAL1 = 38 ;
     DIAL3 = 40 ;
     DIAL2 = 39 ;
     DIAL4 = 41 ;
     DIAL5 = 42 ;
     DIAL7 = 44 ;
     DIAL6 = 43 ;
     DIAL8 = 45 ;
     DIAL9 = 46 ;
    DIAL11 = 48 ;
    DIAL10 = 47 ;
    DIAL12 = 49 ;
    DIAL13 = 50 ;
    DIAL15 = 52 ;
    DIAL14 = 51 ;
    DIAL16 = 53 ;
      DRVB = 56 ;
      DRVA = 55 ;
      DRVC = 57 ;

VAR    status                              : INTEGER;
       resourcename,nulls,on,off,netdrv    : ARRAY [0..16] OF CHAR ;
       tempchar                            : ARRAY [0..2] OF CHAR;
       char                                : CHAR;
       result,handle                       : INTEGER ;
       done,OK                             : BOOLEAN;
       Cptr    [0200H]                     : ADDRESS;
       Dptr    [0204H]                     : DriveSet;
       Mptr    [0208H] ,count              : LONGCARD;
       C                                   : POINTER TO control;
       CSAVE                               : POINTER TO consave;
       drvnr,i                             : CARDINAL;
       phonenumber                         : ARRAY [0..15] OF String;


  PROCEDURE DoAboutDialog ;
  BEGIN
        AESResources.ResourceGetAddr(GEMAESbase.RTree,ABOUT,dTree) ;
        AESForms.FormCenter(dTree,x,y,w,h) ;
        AESForms.FormDialogue(GEMAESbase.FormStart,0,0,0,0,x,y,w,h) ;
        AESForms.FormDialogue(GEMAESbase.FormGrow,0,0,0,0,x,y,w,h) ;
        ObjectDraw(dTree,0,10,x,y,w,h) ;
        result := AESForms.FormDo(dTree,-1) ;
        DeselectObject(ABOUT,ABOUTOK) ; 
        AESForms.FormDialogue(GEMAESbase.FormShrink,0,0,0,0,x,y,w,h) ;
        AESForms.FormDialogue(GEMAESbase.FormFinish,0,0,0,0,x,y,w,h) ;
  END DoAboutDialog ;


(* ------------------------------------------------------------------- *)


PROCEDURE Events ;
(* Handle resource events *)
VAR
  pipeBuff : ARRAY [0..9] OF INTEGER ;


  PROCEDURE SelectMenu( Menu, Item : INTEGER ) ;
  BEGIN

      CASE Menu OF
      DESK     : IF Item = ABOUTNET THEN
                   DoAboutDialog ;
                 END                        ;       |
      FILE     : CASE Item OF
                   LOAD     : C^.networkactive:=(NOT C^.networkactive); |
                   QUIT     : done := TRUE  ;                           | 
                 ELSE
                 END ;
                 IF C^.networkactive THEN 
                    AESMenus.MenuText(MenuTree,LOAD,ADR(on));
                 ELSE
                    AESMenus.MenuText(MenuTree,LOAD,ADR(off));
                 END;                                                   |

      BAUD     :  AESMenus.MenuItemCheck(MenuTree,BAUD1,0);
                  AESMenus.MenuItemCheck(MenuTree,BAUD2,0);
                  AESMenus.MenuItemCheck(MenuTree,BAUD3,0);
                  AESMenus.MenuItemCheck(MenuTree,BAUD4,0);
                  AESMenus.MenuItemCheck(MenuTree,BAUD5,0);
                  AESMenus.MenuItemCheck(MenuTree,BAUD6,0);
                  CASE Item OF
                   BAUD1    : C^.speed := BPS19200  ; AESMenus.MenuItemCheck(MenuTree,Item,1)       | 
                   BAUD2    : C^.speed := BPS9600   ; AESMenus.MenuItemCheck(MenuTree,Item,1)       | 
                   BAUD3    : C^.speed := BPS4800   ; AESMenus.MenuItemCheck(MenuTree,Item,1)       | 
                   BAUD4    : C^.speed := BPS2400   ; AESMenus.MenuItemCheck(MenuTree,Item,1)       | 
                   BAUD5    : C^.speed := BPS1200   ; AESMenus.MenuItemCheck(MenuTree,Item,1)       | 
                   BAUD6    : C^.speed := BPS300    ; AESMenus.MenuItemCheck(MenuTree,Item,1)       | 
                 ELSE
                 END ;
                 ConfigureRS232(C^.speed,NONE,136,-1,-1,-1);      |

      MODE     : CASE Item OF
                   INT        : Create("ANETWORK.INT",0,handle);
                   count:=TSIZE(consave);
                   Write(handle,count,CSAVE);
                   OK:=Close(handle);  |
                   REBOOTOK   : CODE(03F3CH,0020H,04E41H,
                                     042B9H,0,0420H,042B9H,0,043AH,
                                     02079H,0,4,04ED0H)  ;       | 
(*                 MODE2      : GIWrite(14,255)  ;  | *)
                 ELSE
                 END ;                              |

      DIAL     : CASE Item OF
                   DIAL1    : i:=0  ;       | 
                   DIAL2    : i:=1  ;       | 
                   DIAL3    : i:=2  ;       | 
                   DIAL4    : i:=3  ;       | 
                   DIAL5    : i:=4  ;       | 
                   DIAL6    : i:=5  ;       | 
                   DIAL7    : i:=6  ;       | 
                   DIAL8    : i:=7  ;       | 
                   DIAL9    : i:=8  ;       | 
                   DIAL10    : i:=9   ;       | 
                   DIAL11    : i:=10  ;       | 
                   DIAL12    : i:=11  ;       | 
                   DIAL13    : i:=12  ;       | 
                   DIAL14    : i:=13  ;       | 
                   DIAL15    : i:=14  ;       |
                   DIAL16    : i:=15  ;       | 
                 ELSE
                 END ;
                 FOR status:=0 TO 80 DO
                     IF phonenumber[i][status]=CHAR(32) THEN
                        phonenumber[i][status]:=CHAR(0);
                     END;
                 END;
                 SetDefaultIO("AUX:",READWRITE,status);
                 WriteString(phonenumber[i]);
                 WriteLn;
                 SetDefaultIO("CON:",READWRITE,status);                    |

      SEQ      : CASE Item OF
                   SEQUP    : C^.sendreset:= TRUE ; |
                 ELSE
                 END ;
     AESMenus.MenuItemCheck(MenuTree,S00,0);
     AESMenus.MenuItemCheck(MenuTree,S10,0);
     AESMenus.MenuItemCheck(MenuTree,S01,0);
     AESMenus.MenuItemCheck(MenuTree,S11,0);
     IF (C^.nextframetosend=0) AND (C^.frameexpected=0) THEN
        AESMenus.MenuItemCheck(MenuTree,S00,1);
     END;
     IF (C^.nextframetosend=1) AND (C^.frameexpected=0) THEN
        AESMenus.MenuItemCheck(MenuTree,S10,1);
     END;
     IF (C^.nextframetosend=0) AND (C^.frameexpected=1) THEN
        AESMenus.MenuItemCheck(MenuTree,S01,1);
     END;
     IF (C^.nextframetosend=1) AND (C^.frameexpected=1) THEN
        AESMenus.MenuItemCheck(MenuTree,S11,1);
     END;                                       |
    ELSE
    END ; 
    (* put header back normal*)
    AESMenus.MenuTitleNormal(MenuTree,Menu,1) ;
  END SelectMenu ;

BEGIN
  GrafMouse(GEMAESbase.Arrow,NIL) ; (* put pointing mouse *)
  done := FALSE ;
  REPEAT
    AESEvents.EventMessage(ADR(pipeBuff)) ;
    CASE pipeBuff[0] OF         (* message type *)
      GEMAESbase.MenuSelected   : SelectMenu(pipeBuff[3],pipeBuff[4]) ; |
      GEMAESbase.WindowClosed   : done := TRUE ; |
    ELSE
    END ;
  UNTIL done ;
END Events ;

(*$P- *) (* set vector to control record *)
PROCEDURE getcontrol;
BEGIN
        C := Cptr;
        CSAVE := Cptr;
        CODE(RTS);
END     getcontrol;

BEGIN
        nulls:="   ";
        on :="  ON  ";
        off:="  OFF ";
        SuperExec(PROC(getcontrol));
        IF C^.magic#324159265 THEN
           Exec(loadExecute,"ANETWORK.PRG",nulls,nulls,result);
           IF result<0 THEN HALT END;
           SuperExec(PROC(getcontrol));
        END;
        Open("ANETWORK.INT",0,handle);
        IF handle>0 THEN        (* if there is, load in init file *)
           count:=TSIZE(consave);
           Read(handle,count,CSAVE);
           OK:=Close(handle);
        END;
        Open("ANETWORK.DIL",0,handle);
        IF handle>0 THEN        (* if there is, load in dialer file *)
           count:=1;
           FOR i:=0 TO 15 DO
               LOOP
                   Read(handle,count,ADR(char));
                   IF (char=12C) THEN EXIT END;
                   IF (char=12C) OR (char=15C) THEN char:=0C END; 
                   tempchar[0]:=char;
                   Concat(phonenumber[i],tempchar,phonenumber[i]);
               END;
           END;
           OK:=Close(handle);
        END;
        resourcename:=resourcefilename ;
        IF InitResource(resourcename,MENU) THEN ;
        AESMenus.MenuText(MenuTree,DIAL1,ADR(phonenumber[0]));
        AESMenus.MenuText(MenuTree,DIAL2,ADR(phonenumber[1]));
        AESMenus.MenuText(MenuTree,DIAL3,ADR(phonenumber[2]));
        AESMenus.MenuText(MenuTree,DIAL4,ADR(phonenumber[3]));
        AESMenus.MenuText(MenuTree,DIAL5,ADR(phonenumber[4]));
        AESMenus.MenuText(MenuTree,DIAL6,ADR(phonenumber[5]));
        AESMenus.MenuText(MenuTree,DIAL7,ADR(phonenumber[6]));
        AESMenus.MenuText(MenuTree,DIAL8,ADR(phonenumber[7]));
        AESMenus.MenuText(MenuTree,DIAL9,ADR(phonenumber[8]));
        AESMenus.MenuText(MenuTree,DIAL10,ADR(phonenumber[9]));
        AESMenus.MenuText(MenuTree,DIAL11,ADR(phonenumber[10]));
        AESMenus.MenuText(MenuTree,DIAL12,ADR(phonenumber[11]));
        AESMenus.MenuText(MenuTree,DIAL13,ADR(phonenumber[12]));
        AESMenus.MenuText(MenuTree,DIAL14,ADR(phonenumber[13]));
        AESMenus.MenuText(MenuTree,DIAL15,ADR(phonenumber[14]));
        AESMenus.MenuText(MenuTree,DIAL16,ADR(phonenumber[15]));
        CASE C^.speed OF       (* PLACE CHECK IN BAUD RATE MENU *)
             BPS19200    :  AESMenus.MenuItemCheck(MenuTree,BAUD1,1); |
             BPS9600     :  AESMenus.MenuItemCheck(MenuTree,BAUD2,1); |
             BPS4800     :  AESMenus.MenuItemCheck(MenuTree,BAUD3,1); |
             BPS2400     :  AESMenus.MenuItemCheck(MenuTree,BAUD4,1); |
             BPS1200     :  AESMenus.MenuItemCheck(MenuTree,BAUD5,1); |
             BPS300      :  AESMenus.MenuItemCheck(MenuTree,BAUD6,1); |
        ELSE
        END;

        netdrv:="  DRV A = F";
        drvnr:=2;
        WHILE drvnr IN C^.drivemap DO
              INC(drvnr);
        END; (* while *)
        INC(drvnr);
        netdrv[6]:="A"; netdrv[10]:=CHAR(041H+drvnr);
        AESMenus.MenuText(MenuTree,DRVA,ADR(netdrv));
        netdrv[6]:="B"; netdrv[10]:=CHAR(041H+drvnr+1);
        AESMenus.MenuText(MenuTree,DRVB,ADR(netdrv));
        netdrv[6]:="C"; netdrv[10]:=CHAR(041H+drvnr+2);
        AESMenus.MenuText(MenuTree,DRVC,ADR(netdrv));
        netdrv[6]:="D"; netdrv[10]:=CHAR(041H+drvnr+3);
        AESMenus.MenuText(MenuTree,DRVD,ADR(netdrv));
        netdrv[6]:="E"; netdrv[10]:=CHAR(041H+drvnr+4);
        AESMenus.MenuText(MenuTree,DRVE,ADR(netdrv));
        netdrv[6]:="F"; netdrv[10]:=CHAR(041H+drvnr+5);
        AESMenus.MenuText(MenuTree,DRVF,ADR(netdrv));

        CASE C^.remotedrive OF       (* PLACE CHECK IN REMOTE MENU *)
             0    :  AESMenus.MenuItemCheck(MenuTree,DRVA,1); |
             1    :  AESMenus.MenuItemCheck(MenuTree,DRVB,1); |
             2    :  AESMenus.MenuItemCheck(MenuTree,DRVC,1); |
             3    :  AESMenus.MenuItemCheck(MenuTree,DRVD,1); |
             4    :  AESMenus.MenuItemCheck(MenuTree,DRVE,1); |
             5    :  AESMenus.MenuItemCheck(MenuTree,DRVF,1); |
        ELSE
        END;
        IF C^.networkactive THEN 
           AESMenus.MenuText(MenuTree,LOAD,ADR(on));
        ELSE
           AESMenus.MenuText(MenuTree,LOAD,ADR(off));
        END;

        AESMenus.MenuItemCheck(MenuTree,S00,0);
        AESMenus.MenuItemCheck(MenuTree,S10,0);
        AESMenus.MenuItemCheck(MenuTree,S01,0);
        AESMenus.MenuItemCheck(MenuTree,S11,0);
        IF (C^.nextframetosend=0) AND (C^.frameexpected=0) THEN
           AESMenus.MenuItemCheck(MenuTree,S00,1);
        END;
        IF (C^.nextframetosend=1) AND (C^.frameexpected=0) THEN
           AESMenus.MenuItemCheck(MenuTree,S10,1);
        END;
        IF (C^.nextframetosend=0) AND (C^.frameexpected=1) THEN
           AESMenus.MenuItemCheck(MenuTree,S01,1);
        END;
        IF (C^.nextframetosend=1) AND (C^.frameexpected=1) THEN
           AESMenus.MenuItemCheck(MenuTree,S11,1);
        END;
        Events ;
        END;
        Terminate ;
END     Control.