
#include "proto.h"

void ob_draw_chg(DIAINFO *info,int obj,GRECT *area,int new_state,boolean top)
{
	register OBJECT *tree = info->di_tree;

	if (!top && info->di_flag>=WINDOW)
	{
		register OBJECT *ob = tree + obj;
		GRECT win;

		if (area)
			win = *area;
		else
		{
			objc_offset(tree,obj,&win.g_x,&win.g_y);
			win.g_x -= 3;
			win.g_y -= 3;
			win.g_w = ob->ob_width + 6;
			win.g_h = ob->ob_height + 6;
		}

		if (rc_intersect(&desk,&win))
		{
			register int handle = info->di_handle,state = ob->ob_state,pxy[4];
			GRECT work;

			wind_update(BEG_UPDATE);
			wind_get(handle,WF_FIRSTXYWH,&work.g_x,&work.g_y,&work.g_w,&work.g_h);
			while (work.g_w>0 && work.g_h>0)
			{
				if (rc_intersect(&win,&work))
				{
					rc_grect_to_array(&work,pxy);
					vs_clip(x_handle,1,pxy);
					if (new_state>=0)
					{
						objc_change(tree,obj,0,work.g_x,work.g_y,work.g_w,work.g_h,new_state,1);
						ob->ob_state = state;
					}
					else
						objc_draw(tree,obj,MAX_DEPTH,work.g_x,work.g_y,work.g_w,work.g_h);
				}
				wind_get(handle,WF_NEXTXYWH,&work.g_x,&work.g_y,&work.g_w,&work.g_h);
			}
			if (new_state>FAIL)
				ob->ob_state = new_state;
			vs_clip(x_handle,1,(int *) &clip);
			wind_update(END_UPDATE);
		}
	}
	else if (info->di_flag>CLOSED)
	{
		if (!area)
			area = &desk;
		wind_update(BEG_UPDATE);
		if (new_state>FAIL)
			objc_change(tree,obj,0,area->g_x,area->g_y,area->g_w,area->g_h,new_state,1);
		else
			objc_draw(tree,obj,MAX_DEPTH,area->g_x,area->g_y,area->g_w,area->g_h);
		wind_update(END_UPDATE);
	}
}

int ob_radio(OBJECT *tree,int parent,int object)
{
	register int i,radio = 0,first = tree[parent].ob_head,last = tree[parent].ob_tail;
	register OBJECT *obj;

	i = first;
	while (i>=first && i<=last)
	{
		obj = tree + i;
		if (obj->ob_flags & RBUTTON)
		{
		 	if (!(obj->ob_state & DISABLED))
		 	{
				if (radio==object)
					obj->ob_state |= SELECTED;
				else if (obj->ob_state & SELECTED)
				{
					if (object>=0)
						obj->ob_state &= ~SELECTED;
					else
						object = radio;
				}
			}
			radio++;
		}
		i = obj->ob_next;
	}
	return (object);
}
