
;Ŀ
;                                                                   
;               RUTINAS EN ENSAMBLADOR PARA 2M-INFO                 
;                                                                   
;          Incluir en un fichero de proyecto con 2M-INFO.C          
;         El modelo de memoria debe ser necesariamente LARGE        
;                                                                   
;

               PUBLIC    _vgahi256     ; inicializar modo 320x400x256
               PUBLIC    _setpix       ; trazar puntos
               PUBLIC    _getpix       ; obtener color de un punto
               PUBLIC    _showpage     ; elegir pgina a mostrar
               PUBLIC    _setpage      ; pgina para setpix y getpix
               PUBLIC    _FuenteInfo   ; puntero juego caracteres 8*16
               PUBLIC    _segvideo     ; segmento de vdeo activo
               PUBLIC    _prcar        ; escribir carcter
               PUBLIC    _PintaBitMap  ; imprimir mapa de bits
               PUBLIC    _set80x30     ; modo texto VGA 80x30 (font 8x16)
               PUBLIC    _ResetVideo   ; Reset del modo de vdeo
               PUBLIC    _ptecla       ; introducir tecla en el buffer
               PUBLIC    _rnd          ; obtener nmero aleatorio
               PUBLIC    _semilla      ; para nmeros aleatorios
               PUBLIC    _EsperaDma0   ; esperar cuenta 0xFFFF del DMA
               PUBLIC    _es386        ; detectar 386+
               PUBLIC    _NuevaInt24   ; nuevo gestor errores crticos
               PUBLIC    _tiempo       ; devolver hora exacta


_TEXT          SEGMENT WORD PUBLIC 'CODE'
               ASSUME  CS:_TEXT, DS:_DATA

; ------------ Establecer el modo 320x400x256 no soportado por la BIOS
;              Declaracin:  void vgahi256 (void);

_vgahi256      PROC  FAR
               PUSH  ES
               PUSH  SI
               PUSH  DI

               PUSH  DS
               MOV   AX,40h
               MOV   DS,AX
               MOV   AL,DS:[10h]
               AND   AL,0CFh           ; por si estamos en modo 7...
               OR    AL,20h
               MOV   DS:[10h],AL       ; ...forzar modo de color
               POP   DS

               MOV   AX,13h            ; establecer modo 13h
               INT   10h

               CLI                     ; *
               MOV   DX,3CEH           ; desconectar divisin de las
               MOV   AL,5              ; direcciones de memoria en el
               OUT   DX,AL             ; registro de modo
               INC   DX
               IN    AL,DX
               AND   AL,11101111b
               OUT   DX,AL
               DEC   DX
               MOV   AL,6              ; y en el registro miscelneo
               OUT   DX,AL
               INC   DX
               IN    AL,DX
               AND   AL,11111101b
               OUT   DX,AL
               MOV   DX,3C4h           ; modificar el registro de modo
               MOV   AL,4              ; de memoria en el secuenciador
               OUT   DX,AL             ; para que no divida las
               INC   DX                ; direcciones en varios
               IN    AL,DX             ; planos de bit y determine el
               AND   AL,11110111b      ; plano actual mediante el
               OR    AL,4              ; registro de mscara de bit
               OUT   DX,AL
               STI                     ; *

               PUSH  ES
               MOV   ES,_segvideo      ; rellenar los cuatro planos
               XOR   DI,DI             ; de bit con 0 para borrar la
               MOV   AX,DI             ; pantalla
               DEC   AX
               MOV   CX,8000h
               REP   STOSW             ; cld/std indiferente
               POP   ES

               CLI                     ; *
               MOV   DX,3D4h           ; Desconectar la duplicacin de
               MOV   AL,9              ; las lneas en el registro
               OUT   DX,AL             ; maximum-Scan-Line del CRT
               INC   DX                ; y ajustar la altura de los
               IN    AL,DX             ; caracteres a 1
               AND   AL,01110000b
               OUT   DX,AL
               DEC   DX
               MOV   AL,14h            ; desconectar modo Double-Word
               OUT   DX,AL
               INC   DX
               IN    AL,DX
               AND   AL,10111111b
               OUT   DX,AL
               DEC   DX
               MOV   AL,17h            ; cambiar del modo Word al modo
               OUT   DX,AL             ; byte mediante el registro de
               INC   DX                ; de control de modo del CRT
               IN    AL,DX
               OR    AL,01000000b
               OUT   DX,AL
               STI                     ; *
               POP   DI
               POP   SI
               POP   ES
               RET
_vgahi256      ENDP


; ------------ Pintar un punto en el modo 320x400x256.
;              Declaracin: void setpix (int x, int y, int color);

x0             EQU   [BP+6]            ; para modelo LARGE
y0             EQU   [BP+8]
color          EQU   [BP+10]

_setpix        PROC  FAR
               PUSH  BP
               MOV   BP,SP
               PUSH  DS
               PUSH  DI
               MOV   AX,320/4          ; calcular offset en VRAM
               MUL   WORD PTR y0
               MOV   CX,x0
               MOV   DI,CX
               SHR   DI,1
               SHR   DI,1
               ADD   DI,AX             ; offset en DI
               AND   CL,3              ; calcular mscara para el
               MOV   AH,1              ; mapa a direccionar en AH
               SHL   AH,CL
               MOV   AL,2              ; a AL el nmero de registro
               MOV   DX,3C4h
               OUT   DX,AX             ; cargar registro de mscara
               MOV   AL,color
               MOV   DS,_segvideo      ; DS -> VRAM
               MOV   [DI],AL           ; trazar punto
               POP   DI
               POP   DS
               POP   BP
               RET
_setpix        ENDP

; ------------ Obtener el color de un punto en el modo 320x400x256.
;              Declaracin: int getpix (int x, int y);

x1             EQU   [BP+6]            ; para modelo LARGE
y1             EQU   [BP+8]

_getpix        PROC  FAR
               PUSH  BP
               MOV   BP,SP
               PUSH  DS
               PUSH  SI
               MOV   AX,320/4          ; calcular offset en VRAM
               MUL   WORD PTR y1
               MOV   SI,x1
               MOV   CX,SI
               SHR   SI,1
               SHR   SI,1
               ADD   SI,AX

               AND   CL,3              ; calcular mscara para el
               MOV   AH,CL             ; mapa a direccionar en AH
               MOV   AL,4
               MOV   DX,3CEh
               OUT   DX,AX             ; cargar registro Read-Map

               MOV   DS,_segvideo      ; DS -> VRAM
               MOV   AL,[SI]           ; obtener color del punto
               MOV   AH,0              ; (int)
               POP   SI
               POP   DS
               POP   BP
               RET
_getpix        ENDP


; ------------ Selecciona la pgina de trabajo para setpix/getpix.
;              Declaracin: void setpage (int pagina);

pags           EQU   [BP+6]            ; para modelo LARGE

_setpage       PROC  FAR
               PUSH  BP
               MOV   BP,SP
               MOV   AX,0A000h
               CMP   WORD PTR pags,0
               JE    sp_ok
               MOV   AX,0A800h
sp_ok:         MOV   _segvideo,AX      ; nueva direccin de vdeo
               POP   BP
               RET
_setpage       ENDP


; ------------ Selecciona la pgina de trabajo visualizada.
;              Declaracin: void showpage (int pagina);

pagv           EQU   [BP+6]            ; para modelo LARGE

_showpage      PROC  FAR
               PUSH  BP
               MOV   BP,SP
               MOV   AX,pagv
               AND   AL,AL             ; pgina 0?
               JZ    wp_ok             ; as es
               MOV   AL,80h            ; pgina 1, con offset 8000h
wp_ok:         MOV   DX,3D4h           ; direccionar CRT
               MOV   AH,AL             ; byte alto del offset a AH
               MOV   AL,0Ch
               OUT   DX,AX
               MOV   DX,3DAh
               PUSH  DS
               MOV   AX,40h
               MOV   DS,AX
               MOV   CX,9              ; timeout de 0.5 segundos
               MOV   AH,DS:[6Ch]
frt_vert:      CMP   AH,DS:[6Ch]
               JNE   frt_nvert
               IN    AL,DX             ; esperar primero final del
               TEST  AL,8              ; retrazado vertical
               JNZ   frt_vert
               JMP   irt_vert
frt_nvert:     MOV   AH,DS:[6Ch]
               LOOP  frt_vert
               JMP   fin_shw           ; no llega el retrazo
irt_vert:      CMP   AH,DS:[6Ch]
               JNE   irt_nvert
               IN    AL,DX             ; esperar inicio del
               TEST  AL,8              ; retrazado vertical
               JZ    irt_vert
               JMP   fin_shw
irt_nvert:     MOV   AH,DS:[6Ch]
               LOOP  irt_vert
fin_shw:       POP   DS
               POP   BP
               RET
_showpage      ENDP


; ------------ Imprimir carcter de la fuente.
;              Declaracin: void prcar (int car, int x, int y, int largo,
;                             int alto, int tinta, int papel, int pitch);

car            EQU   [BP+6]            ; para modelo LARGE
c_x            EQU   [BP+8]
c_y            EQU   [BP+10]
largo          EQU   [BP+12]
alto           EQU   [BP+14]
tinta          EQU   [BP+16]
papel          EQU   [BP+18]
pitch          EQU   [BP+20]

_prcar         PROC  FAR
               PUSH  BP
               MOV   BP,SP
               PUSH  ES
               PUSH  SI
               PUSH  DI
               MOV   AX,320/4          ; calcular offset en VRAM
               MUL   WORD PTR c_y
               MOV   DI,c_x
               SHR   DI,1
               SHR   DI,1
               ADD   DI,AX
               MOV   ES,_segvideo      ; ES:DI -> VRAM
               MOV   AL,car
               MOV   AH,0
               MOV   CL,4
               SHL   AX,CL             ; carcter * 16
               ADD   AX,OFFSET _FuenteInfo
               MOV   SI,AX             ; SI -> fuente
               MOV   CX,c_x
               AND   CL,3              ; calcular mscara para el
               MOV   BH,00010001b      ; mapa a direccionar en BH
               ROL   BH,CL
               MOV   BL,10000000b      ; pixel en curso en BL

               MOV   CX,8
pr_horiz:      PUSH  CX

               MOV   CX,largo
pr_duphoriz:   PUSH  CX
               PUSH  SI
               PUSH  DI

               MOV   AL,2              ; a AL el nmero de registro
               MOV   AH,BH
               MOV   DX,3C4h
               OUT   DX,AX             ; cargar registro de mscara

               MOV   AH,tinta          ; tinta inicial

               MOV   DX,16
pr_vert:
               MOV   AL,AH             ; tinta en curso
               TEST  [SI],BL
               JNZ   pr_tin
               MOV   AL,papel
               CMP   AL,0FFh
               JNE   pr_pap

               MOV   CX,alto
               PUSH  BX
               MOV   BL,AH
               SHL   BX,1
pr_nulvert:    ADD   DI,80             ; siguiente lnea
               ADD   BX,pitch
               LOOP  pr_nulvert
               SHR   BX,1
               MOV   AH,BL
               POP   BX
               JMP   pr_otrop

pr_pap:        MOV   CX,alto
               PUSH  BX
               MOV   BL,AH
               SHL   BX,1
pr_papvert:    MOV   ES:[DI],AL        ; trazar punto de papel
               ADD   DI,80             ; siguiente lnea
               ADD   BX,pitch
               LOOP  pr_papvert
               SHR   BX,1
               MOV   AH,BL
               POP   BX
               JMP   pr_otrop

pr_tin:        MOV   CX,alto
               PUSH  BX
               MOV   BL,AL
               SHL   BX,1
pr_tinvert:    MOV   ES:[DI],AL        ; trazar punto de tinta
               ADD   DI,80             ; siguiente lnea
               ADD   BX,pitch
               MOV   AX,BX
               SHR   AX,1
               LOOP  pr_tinvert
               MOV   AH,AL
               POP   BX

pr_otrop:      INC   SI                ; siguiente scan

               DEC   DX
               JNZ   pr_vert

               POP   DI
               POP   SI

               ROL   BH,1              ; siguiente mapa de bits
               JNC   pr_np
               INC   DI                ; siguiente direccin VRAM
pr_np:
               POP   CX
               LOOP  pr_duphoriz

               ROR   BL,1              ; siguiente pixel
               POP   CX
               DEC   CX
               JZ    pr_ex

               JMP   pr_horiz

pr_ex:         POP   DI
               POP   SI
               POP   ES
               POP   BP
               RET
_prcar         ENDP


; ------------ Imprimir mapa de bits.
;              Declaracin: void PintaBitMap (char *bitmap, int ancho,
;                                            int relx, int rely, int lx,
;                                            int ly, int x, int y, int modo);

bitmap         EQU   [BP+6]            ; para modelo LARGE
ancho          EQU   [BP+10]
relx           EQU   [BP+12]           ; coordenadas relativas sobre
rely           EQU   [BP+14]           ; el propio bitmap
lx             EQU   [BP+16]
ly             EQU   [BP+18]
p_x            EQU   [BP+20]
p_y            EQU   [BP+22]
modo           EQU   [BP+24]

_PintaBitMap   PROC  FAR
               PUSH  BP
               MOV   BP,SP
               PUSH  SI
               PUSH  DI
               PUSH  DS
               PUSH  ES
               MOV   ES,_segvideo
               LDS   SI,bitmap

               MOV   BX,320/4
               CMP   WORD PTR modo,0
               JE    bm_ini_ok
               NEG   BX
               MOV   AX,lx             ; empezar por el final
               DEC   AX
               ADD   p_x,AX
               MOV   AX,ly
               DEC   AX
               ADD   p_y,AX

bm_ini_ok:     MOV   AX,rely
               MUL   WORD PTR ancho
               ADD   AX,relx
               ADD   SI,AX             ; DS:SI -> bitmap

               MOV   AX,320/4          ; calcular offset en VRAM
               MUL   WORD PTR p_y
               MOV   CX,p_x
               MOV   DI,CX
               SHR   DI,1
	       SHR   DI,1
               ADD   DI,AX             ; offset en DI
               AND   CL,3              ; calcular mscara para el
               MOV   AH,00010001b      ; mapa a direccionar en AH
               ROL   AH,CL
               MOV   AL,2              ; a AL el nmero de registro
               MOV   DX,3C4h
               OUT   DX,AX             ; cargar registro de mscara

               MOV   CX,lx
bm_horiz:      PUSH  CX
               PUSH  SI
               PUSH  DI
               PUSH  DS
               MOV   CX,ly
bm_vert:       MOV   AL,[SI]
               MOV   ES:[DI],AL        ; trazar punto
               ADD   DI,BX             ; siguiente scan
               ADD   SI,ancho          ; siguiente punto vertical
               JNC   si_ok1
               PUSH  AX                ; desbordamiento de segmento
               MOV   AX,DS
               ADD   AX,1000h
               MOV   DS,AX
               POP   AX
si_ok1:        LOOP  bm_vert
               POP   DS
               POP   DI
               POP   SI
               INC   SI                ; siguiente punto horizontal
               JNZ   si_ok2
               PUSH  AX                ; desbordamiento de segmento
               MOV   AX,DS
               ADD   AX,1000h
               MOV   DS,AX
               POP   AX
si_ok2:        AND   BX,BX
               JNS   bm_derecho
               ROR   AH,1              ; impresin al revs
               JNC   bm_np
               DEC   DI
               JMP   bm_np
bm_derecho:    ROL   AH,1              ; siguiente mapa de bits
               JNC   bm_np
               INC   DI                ; siguiente direccin VRAM
bm_np:         MOV   AL,2
               OUT   DX,AX
               POP   CX
               LOOP  bm_horiz

               POP   ES
               POP   DS
               POP   DI
               POP   SI
               POP   BP
               RET
_PintaBitMap   ENDP


; ------------ Establecer el modo 80x30 en la VGA (fuente 8x16).
;              Declaracin: int set80x30 (void);
;              Devuelve 1 si funciona y 0 si falla (no hay VGA o
;              no estaba en modo texto de color) adems de asignar
;              en ese caso el n de lneas a 25 (por si la variable
;              de la BIOS est indefinida).

_set80x30      PROC  FAR
               PUSH  SI
               PUSH  DI
               MOV   AX,1A00h
               INT   10h
               CMP   AL,1Ah
               JNE   set80err      ; no es VGA
               MOV   AH,0Fh
               INT   10h
               CMP   AL,3
               JA    set80err      ; no es modo texto de color

set30:         MOV   DX,3D4h       ; Direccin base del CRTC
               CLI
               MOV   AX,00C11h     ; Vertical Display End (desproteger regs. 0-7)
               OUT   DX,AX
               MOV   AX,00D06h     ; Vertical Total
               OUT   DX,AX
               MOV   AX,03E07h     ; Overflow
               OUT   DX,AX
               MOV   AX,0EA10h     ; Vertical Retrace Start
               OUT   DX,AX
               MOV   AX,08C11h     ; Vertical Retrace End (y proteger regs. 0-7)
               OUT   DX,AX
               MOV   AX,0DF12h     ; Vertical Display Enable End
               OUT   DX,AX
               MOV   AX,0E715h     ; Start Vertical Blanking
               OUT   DX,AX
               MOV   AX,00616h     ; End Vertical Blanking
               OUT   DX,AX
               MOV   DX,3CCh       ; Miscellaneous Output
               IN    AL,DX
               AND   AL,00110011b  ; Cambiamos slo el clock mode a 1
               OR    AL,11000100b  ; y la VSP a negativa.
               MOV   DX,3C2h
               OUT   DX,AL
               STI
               PUSH  DS
               MOV   AX,0040h                  ; rea de la BIOS
               MOV   DS,AX
               MOV   WORD PTR DS:[004Ch],8192  ; nuevo tamao de pgina en bytes
               MOV   BYTE PTR DS:[0084h],29    ; nmero de lneas-1
               POP   DS
               MOV   AX,1          ; funcin con xito
               POP   DI
               POP   SI
               RET

set80err:      PUSH  DS
               MOV   AX,0040h                  ; rea de la BIOS
               MOV   DS,AX
               MOV   BYTE PTR DS:[0084h],24    ; nmero de lneas-1
               POP   DS
               MOV   AX,0          ; funcin con fallo
               POP   DI
               POP   SI
               RET
_set80x30      ENDP


; ------------ Restablecer el modo de vdeo normal.
;              Declaracin:  void ResetVideo (void);

_ResetVideo    PROC  FAR
               PUSH  SI
               PUSH  DI
               PUSH  DS
               MOV   DI,40h
               MOV   DS,DI
               MOV   AL,DS:[49h]
               POP   DS
               XOR   AH,AH
               INT   10h                       ; reponer modo en curso
               POP   DI
               POP   SI
               RET
_ResetVideo    ENDP


; ------------ Introducir tecla en el buffer del teclado.
;              Declaracin: int ptecla (int tecla);

tecla          EQU   [BP+6]            ; para modelo LARGE

_ptecla        PROC  FAR
               PUSH  BP
               MOV   BP,SP
               PUSH  DS
               MOV   BX,40h
               MOV   DS,BX
               CLI
               MOV   BX,DS:[1Ch]       ; puntero a la cola del buffer
               MOV   CX,BX
               ADD   CX,2              ; CX -> siguiente dato
               CMP   WORD PTR DS:[82h],0   ; ms all del fin del buffer
               JNE   test_fin
               CMP   CX,3Eh            ; BIOS obsoleta: buffer fijo
               JMP   tested_fin
test_fin:      CMP   CX,DS:[82h]
tested_fin:    JB    no_desb
               MOV   CX,DS:[80h]       ; inicio de la cola circular
               AND   CX,CX
               JNZ   no_desb
               MOV   CX,1Eh            ; BIOS obsoleta: buffer fijo
no_desb:       CMP   CX,DS:[1Ah]       ; puntero al inicio del buffer
               MOV   AX,1              ; condicin de buffer lleno
               JE    fin_ptec
               MOV   AX,tecla
               MOV   DS:[BX],AX        ; introducir carcter
               MOV   DS:[1Ch],CX       ; actualizar puntero al final
               MOV   AX,0              ; condicin de buffer no lleno
fin_ptec:      STI
               POP   DS
               POP   BP
               RET
_ptecla        ENDP


; ------------ Obtener nmero aleatorio rpido.
;              Declaracin: unsigned rnd (int unsigned);

rango          EQU   [BP+6]            ; para modelo LARGE

_rnd           PROC  FAR
               PUSH  BP
               MOV   BP,SP
               CMP   _semilla,0
               JNE   dev_rnd
               PUSH  DS
               MOV   AX,40h
               MOV   DS,AX
               MOV   AX,DS:[6Ch]       ; contador hora BIOS
               POP   DS                ; como semilla
               MOV   _semilla,AX
dev_rnd:       MOV   AX,_semilla
               MOV   BX,AX
               MOV   CL,7
               SHR   AX,CL
               XOR   AX,BX
               AND   AX,1
               ROR   AX,1
               SHR   BX,1
               OR    AX,BX
               MOV   _semilla,AX
               MUL   WORD PTR rango
               MOV   AX,DX
               POP   BP
               RET
_rnd           ENDP


; ------------ Esperar que el contador del DMA alcance el final y
;              resetear la controladora de disquetes.

unidad         EQU   BYTE PTR [BP+6]   ; para modelo LARGE

_EsperaDma0    PROC  FAR
               CLI                     ; *
               PUSH  AX
               PUSH  BX
               PUSH  CX
               PUSH  DX

               IN    AL,61h
               AND   AL,11111100b
               OR    AL,1
               JMP   SHORT $+2
               OUT   61h,AL            ; cnt2 en marcha
               MOV   AL,10010110b
               JMP   SHORT $+2
               OUT   43h,AL            ; 8254: cnt2 byte bajo
               MOV   AL,0
               JMP   SHORT $+2
               OUT   42h,AL
               MOV   AL,10100110b
               JMP   SHORT $+2
               OUT   43h,AL            ; 8254: cnt2 byte alto
               MOV   AL,0
               JMP   SHORT $+2
               OUT   42h,AL

               JMP   SHORT $+2
               IN    AL,42h
               MOV   BL,AL             ; estado de la cuenta alta
               MOV   DX,3F4h
               MOV   CX,9321           ; cte. para dos segundos

wait_dma:      IN    AL,DX             ; transferencia con DMA
               XOR   AL,11000000b
               TEST  AL,11000000b
               JZ    dma_fin           ; hay resultados del FDC
               IN    AL,5
               MOV   AH,AL
               IN    AL,5              ; contador del canal 2
               CMP   AX,-1
               JE    dma_fin           ; fin de la cuenta del DMA
               IN    AL,42h
               CMP   AL,BL
               JE    wait_dma          ; no han pasado 256/1193180 seg
               MOV   BL,AL
               LOOP  wait_dma

dma_fin:       MOV   CL,unidad
               ADD   CL,4
               MOV   AL,1
               SHL   AL,CL             ; bits motor en nibble alto
               OR    AL,unidad         ; seleccionar unidad
               OR    AL,00001000b      ; interrupciones+DMA y reset
               MOV   DX,3F2h           ; registro de salida digital
               OUT   DX,AL             ; seal de reset
               STI                     ; *
               XOR   CX,CX
pp486:         JMP   SHORT $+2
               LOOP  pp486
               OR    AL,00000100b
               OUT   DX,AL             ; fin de seal de reset
               POP   DX
               POP   CX
               POP   BX
               POP   AX
               RET
_EsperaDma0    ENDP


; ------------ Comprobar si es 386 o superior.
;              Declaracin: int es386 (void);

_es386         PROC  FAR
               PUSHF
               POP   AX
               OR    AH,70h        ; intentar activar bit 12, 13  14
               PUSH  AX            ; del registro de estado
               POPF
               PUSHF
               POP   AX
               AND   AH,0F0h
               CMP   AH,0F0h
               MOV   AL,0
               JE    fin_test_CPU  ; es 8086 o similar
               AND   AH,70h        ; 286 pone bits 12, 13 y 14 a cero
               JZ    fin_test_CPU  ; es 286
               MOV   AL,1          ; 386 o superior
fin_test_CPU:  MOV   AH,0
               RET
_es386         ENDP


; ------------ Gestor de errores crticos para mejorar presentacin.

_NuevaInt24    PROC
               MOV   AL,3      ; error en la funcin DOS invocada.
               IRET
_NuevaInt24    ENDP


; ------------ Devolver hora exacta.
;              Declaracin: unsigned long tiempo (void);

_tiempo        PROC  FAR
               CLI
               MOV   AL,6
               OUT   43h,AL       ; enclavamiento contador 0
               IN    AL,40h
               MOV   AH,AL
               IN    AL,40h
               XCHG  AH,AL
               NEG   AX           ; AX = valor del contador 0 del 8254
               PUSH  DS
               MOV   BX,40h
               MOV   DS,BX
               MOV   DX,DS:[6Ch]  ; DX = contador hora BIOS
               STI
               POP   DS
               RET
_tiempo        ENDP

_TEXT          ENDS


_DATA          SEGMENT WORD PUBLIC 'DATA'

_segvideo      DW    0A000h            ; puede variar con la pgina
_semilla       DW    0                 ; para nmeros aleatorios


; ------------ Juego de caracteres 8x16 con estilo informtico.

_FuenteInfo    EQU   THIS BYTE
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,  60,  66, 129, 165, 129
               DB    189, 153, 129,  66,  60,   0,   0,   0
               DB      0,   0,   0,  60, 126, 255, 219, 255
               DB    195, 231, 255, 126,  60,   0,   0,   0
               DB      0,   0,   0,   0, 108, 254, 254, 254
               DB    254, 124,  56,  16,   0,   0,   0,   0
               DB      0,   0,   0,   0,  16,  56, 124, 254
               DB    124,  56,  16,   0,   0,   0,   0,   0
               DB      0,   0,   0,  24,  60,  24, 102, 255
               DB    102,  24,  24,  60,   0,   0,   0,   0
               DB      0,   0,   0,  24,  60, 126, 255, 255
               DB    126,  24,  24,  60,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,  24,  60
               DB     60,  24,   0,   0,   0,   0,   0,   0
               DB    255, 255, 255, 255, 255, 255, 231, 195
               DB    195, 231, 255, 255, 255, 255, 255, 255
               DB      0,   0,   0,   0,   0,  60, 102,  66
               DB     66, 102,  60,   0,   0,   0,   0,   0
               DB    255, 255, 255, 255, 255, 195, 153, 189
               DB    189, 153, 195, 255, 255, 255, 255, 255
               DB      0,   0,  30,  14,  26,  50, 120, 204
               DB    204, 204, 204, 120,   0,   0,   0,   0
               DB      0,   0,  60, 102, 102, 102, 102,  60
               DB     24, 126,  24,  24,   0,   0,   0,   0
               DB      0,   0,   0,  62,  51,  62,  51,  48
               DB     48, 112, 240, 224,   0,   0,   0,   0
               DB      0,   0,   0,  63,  51,  63,  51,  51
               DB     51, 119, 255, 238,   0,   0,   0,   0
               DB      0,   0,  24,  24,  24, 219,  60, 231
               DB     60, 219,  24,  24,  24,   0,   0,   0
               DB      0, 128, 192, 224, 240, 248, 254, 248
               DB    240, 224, 192, 128,   0,   0,   0,   0
               DB      0,   2,   6,  14,  30,  62, 254,  62
               DB     30,  14,   6,   2,   0,   0,   0,   0
               DB      0,   0,  24,  60, 126,  24,  24,  24
               DB    126,  60,  24,   0,   0,   0,   0,   0
               DB      0,   0, 102, 102, 102, 102, 102, 102
               DB    102,   0, 102, 102,   0,   0,   0,   0
               DB      0,   0, 127, 219, 219, 219, 123,  27
               DB     27,  27,  27,  27,   0,   0,   0,   0
               DB      0, 124, 198,  96,  56, 108, 198, 198
               DB    108,  56,  12, 198, 124,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB    254, 254, 254, 254,   0,   0,   0,   0
               DB      0,   0,  24,  60, 126,  24,  24,  24
               DB    126,  60,  24, 126,   0,   0,   0,   0
               DB      0,   0,  24,  60, 126,  24,  24,  24
               DB     24,  24,  24,  24,   0,   0,   0,   0
               DB      0,   0,  24,  24,  24,  24,  24,  24
               DB     24, 126,  60,  24,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  24,  12, 254
               DB     12,  24,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  48,  96, 254
               DB     96,  48,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0, 192, 192
               DB    192, 254,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  36, 102, 255
               DB    102,  36,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,  16,  16,  16,  16,  56
               DB     56,  56, 124, 124, 124, 254, 254,   0
               DB      0, 254, 254, 124, 124, 124,  56,  56
               DB     56,  16,  16,  16,  16,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,  48,  48,  48,  48,  56
               DB     56,  56,   0,  56,   0,   0,   0,   0
               DB      0,   0,   0, 238, 238,  34,  34,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,  36,  36, 126,  36,  36
               DB    126,  36,  36,   0,   0,   0,   0,   0
               DB      0,   0,   0,  24, 126,  98,  96, 126
               DB     14,  78, 126,  24,   0,   0,   0,   0
               DB      0,   0,   0, 226, 226,   2,   2, 254
               DB    224, 224, 238, 238,   0,   0,   0,   0
               DB      0,   0,   0, 120,  96, 100, 254, 228
               DB    228, 228, 228, 252,   0,   0,   0,   0
               DB      0,   0,   0,  56,  56,   8,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,  14,  24,  24,  24,  24,  28
               DB     28,  28,  28,  28,  14,   0,   0,   0
               DB      0,   0, 112,  24,  24,  24,  24,  56
               DB     56,  56,  56,  56, 112,   0,   0,   0
               DB      0,   0,   0,   0,   0, 214, 214, 124
               DB    214, 214,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,  24,  24
               DB    126,  24,  24,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,  56,  56,   8,   8,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB    126,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,  56,  56,   0,   0,   0,   0
;               DB      0,   0,   0,   2,   2,   2,   2, 254  ; / orig.
;               DB    224, 224, 224, 224,   0,   0,   0,   0
               DB      0,   0,   0,   0,   2,   6,  12,  24   ; / modif.
               DB     48,  96,  64,   0,   0,   0,   0,   0
               DB      0,   0,   0, 254, 134, 134, 142, 142
               DB    142, 142, 142, 254,   0,   0,   0,   0
               DB      0,   0,   0,  24,  24,  24,  56,  56
               DB     56,  56,  56,  56,   0,   0,   0,   0
               DB      0,   0,   0, 254, 134,   6,   6,   6
               DB    254, 224, 226, 254,   0,   0,   0,   0
               DB      0,   0,   0, 252, 140,  12,  14,  62
               DB     14,  14, 142, 254,   0,   0,   0,   0
               DB      0,   0,   0, 140, 140, 140, 140, 140
               DB    254,  28,  28,  28,   0,   0,   0,   0
               DB      0,   0,   0, 254, 192, 192, 254,  14
               DB     14,  14, 142, 254,   0,   0,   0,   0
               DB      0,   0,   0, 254, 134, 128, 254, 142
               DB    142, 142, 142, 254,   0,   0,   0,   0
               DB      0,   0,   0, 254, 134,   6,  14,  14
               DB     14,  14,  14,  14,   0,   0,   0,   0
               DB      0,   0,   0, 124,  76,  76, 254, 142
               DB    142, 142, 142, 254,   0,   0,   0,   0
               DB      0,   0,   0, 254, 134, 134, 134, 134
               DB    254,  14,  14,  14,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,  56,  56
               DB      0,   0,  56,  56,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,  56,  56
               DB      0,   0,  56,  56,   8,   8,   0,   0
               DB      0,   0,   0,   0,   6,  12,  24,  48
               DB    112,  56,  28,  14,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0, 126, 126
               DB      0, 126, 126,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,  96,  48,  24,  12
               DB     14,  28,  56, 112,   0,   0,   0,   0
               DB      0,   0,   0, 254, 134,   6, 126, 112
               DB    112,   0, 112, 112,   0,   0,   0,   0
               DB      0,   0,   0, 254, 130, 186, 170, 170
               DB    190, 128, 254,   0,   0,   0,   0,   0
               DB      0,   0,   0, 124, 100, 100, 254, 226
               DB    226, 226, 226, 226,   0,   0,   0,   0
               DB      0,   0,   0, 252, 196, 196, 254, 226
               DB    226, 226, 226, 254,   0,   0,   0,   0
               DB      0,   0,   0, 254, 194, 192, 192, 224
               DB    224, 224, 226, 254,   0,   0,   0,   0
               DB      0,   0,   0, 254, 194, 194, 226, 226
               DB    226, 226, 226, 254,   0,   0,   0,   0
               DB      0,   0,   0, 254, 192, 192, 192, 254
               DB    224, 224, 224, 254,   0,   0,   0,   0
               DB      0,   0,   0, 254, 192, 192, 192, 248
               DB    224, 224, 224, 224,   0,   0,   0,   0
               DB      0,   0,   0, 254, 194, 192, 192, 238
               DB    226, 226, 226, 254,   0,   0,   0,   0
               DB      0,   0,   0, 194, 194, 194, 194, 254
               DB    226, 226, 226, 226,   0,   0,   0,   0
               DB      0,   0,   0,  48,  48,  48,  48,  56
               DB     56,  56,  56,  56,   0,   0,   0,   0
               DB      0,   0,   0,  12,  12,  12,  14,  14
               DB     14, 142, 142, 254,   0,   0,   0,   0
               DB      0,   0,   0, 196, 196, 196, 254, 226
               DB    226, 226, 226, 226,   0,   0,   0,   0
               DB      0,   0,   0, 192, 192, 192, 224, 224
               DB    224, 224, 224, 254,   0,   0,   0,   0
;               DB      0,   0,   0, 238, 214, 214, 214, 214  ; M orig.
;               DB    230, 230, 230, 226,   0,   0,   0,   0
               DB      0,   0,   0, 198, 238, 254, 254, 214   ; M modif.
               DB    198, 198, 198, 198,   0,   0,   0,   0
               DB      0,   0,   0, 254, 194, 194, 226, 226
               DB    226, 226, 226, 226,   0,   0,   0,   0
               DB      0,   0,   0, 254, 142, 134, 134, 134
               DB    134, 134, 134, 254,   0,   0,   0,   0
               DB      0,   0,   0, 254, 194, 194, 254, 224
               DB    224, 224, 224, 224,   0,   0,   0,   0
               DB      0,   0,   0, 254, 134, 134, 134, 134
               DB    134, 158, 158, 254,   0,   0,   0,   0
               DB      0,   0,   0, 252, 196, 196, 254, 226
               DB    226, 226, 226, 226,   0,   0,   0,   0
               DB      0,   0,   0, 254, 194, 192, 254,  14
               DB     14,  14, 142, 254,   0,   0,   0,   0
               DB      0,   0,   0, 254,  48,  48,  56,  56
               DB     56,  56,  56,  56,   0,   0,   0,   0
               DB      0,   0,   0, 194, 194, 194, 226, 226
               DB    226, 226, 226, 254,   0,   0,   0,   0
               DB      0,   0,   0, 226, 226, 226, 226, 226
               DB    226, 102, 100, 124,   0,   0,   0,   0
;               DB      0,   0,   0, 230, 230, 230, 214, 214  ; W orig.
;               DB    214, 214, 214, 238,   0,   0,   0,   0
               DB      0,   0,   0, 198, 198, 198, 214, 214   ; W modif.
               DB    214, 214, 214, 238,   0,   0,   0,   0
               DB      0,   0,   0, 194, 194, 194, 124, 226
               DB    226, 226, 226, 226,   0,   0,   0,   0
               DB      0,   0,   0, 130, 130, 130, 254,  56
               DB     56,  56,  56,  56,   0,   0,   0,   0
               DB      0,   0,   0, 254, 134,   6, 254, 224
               DB    224, 224, 226, 254,   0,   0,   0,   0
               DB      0,   0,  14,   8,   8,   8,   8,   8
               DB      8,   8,   8,   8,  14,   0,   0,   0
               DB      0,   0,   0, 128, 128, 128, 128, 254
               DB     14,  14,  14,  14,   0,   0,   0,   0
               DB      0,   0, 112,  16,  16,  16,  16,  16
               DB     16,  16,  16,  16, 112,   0,   0,   0
               DB      0,   0,  60,  36,  36,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 255,   0,   0
               DB      0,   0,  32,  56,  56,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 124,  68,   4
               DB    126, 102, 102, 126,   0,   0,   0,   0
               DB      0,   0,   0,  96,  96, 126,  98,  98
               DB     98, 114, 114, 126,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 126,  98,  96
               DB    112, 112, 114, 126,   0,   0,   0,   0
               DB      0,   0,   0,   6,   6, 126,  70,  70
               DB     78,  78,  78, 126,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 126,  98,  98
               DB    126, 112, 114, 126,   0,   0,   0,   0
               DB      0,   0,   0,  28,  16,  60,  24,  24
               DB     28,  28,  28,  28,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 126,  98,  98
               DB    114, 114, 114, 126,   2,   2, 126,   0
               DB      0,   0,   0,  96,  96, 126,  98,  98
               DB    114, 114, 114, 114,   0,   0,   0,   0
               DB      0,   0,   0,  24,  24,   0,  16,  16
               DB     24,  24,  24,  24,   0,   0,   0,   0
               DB      0,   0,   0,  24,  24,   0,  16,  16
               DB     24,  24,  24,  24,   8,   8,  24,   0
               DB      0,   0,   0,  96,  96, 100, 100, 100
               DB    126, 114, 114, 114,   0,   0,   0,   0
               DB      0,   0,   0,  48,  48,  48,  48,  48
               DB     56,  56,  56,  56,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 254, 146, 146
               DB    218, 218, 218, 218,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 126,  98,  98
               DB    114, 114, 114, 114,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 126,  98,  98
               DB    114, 114, 114, 126,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 126,  98,  98
               DB    114, 114, 114, 126,  64,  64,  64,   0
               DB      0,   0,   0,   0,   0, 126,  98,  98
               DB    114, 114, 114, 126,   2,   2,   2,   0
               DB      0,   0,   0,   0,   0, 126,  96,  96
               DB    112, 112, 112, 112,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 126,  98,  96
               DB    126,  14,  78, 126,   0,   0,   0,   0
               DB      0,   0,   0,  16,  16,  60,  24,  24
               DB     28,  28,  28,  28,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  98,  98,  98
               DB    114, 114, 114, 126,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 114, 114, 114
               DB    114,  54,  52,  60,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 146, 146, 146
               DB    218, 218, 218, 238,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  98,  98,  98
               DB     60, 114, 114, 114,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 114, 114, 114
               DB    114,  98,  98, 126,   2,   2, 126,   0
               DB      0,   0,   0,   0,   0, 126,  70,   6
               DB    126, 112, 114, 126,   0,   0,   0,   0
               DB      0,   0,  30,  24,  24,  12,   8,  48
               DB      8,  12,  24,  24,  30,   0,   0,   0
               DB      0,   0,  24,  24,  24,  24,  24,   0
               DB     24,  24,  24,  24,  24,   0,   0,   0
               DB      0,   0, 120,  24,  24,  48,  16,  12
               DB     16,  48,  24,  24, 120,   0,   0,   0
               DB      0,   0,   0,   0,   0, 118, 220,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  16,  56, 108
               DB    198, 198, 254,   0,   0,   0,   0,   0
               DB      0,   0,   0, 254, 194, 192, 192, 224
               DB    224, 224, 226, 254,   8,  14,  98, 126
               DB      0,   0, 102,   0,   0,  98,  98,  98
               DB    114, 114, 114, 126,   0,   0,   0,   0
               DB      0,  12,   8,  16,   0, 126,  98,  98
               DB    126, 112, 114, 126,   0,   0,   0,   0
               DB      0,  16,  56, 100,   0, 124,  68,   4
               DB    126, 102, 102, 126,   0,   0,   0,   0
               DB      0,   0, 102,   0,   0, 124,  68,   4
               DB    126, 102, 102, 126,   0,   0,   0,   0
               DB      0,  48,  16,   8,   0, 124,  68,   4
               DB    126, 102, 102, 126,   0,   0,   0,   0
               DB      0, 124, 100, 124,   0, 124,  68,   4
               DB    126, 102, 102, 126,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 126,  98,  96
               DB    112, 112, 114, 126,   8,  14,  98, 126
               DB      0,  16,  56, 100,   0, 126,  98,  98
               DB    126, 112, 114, 126,   0,   0,   0,   0
               DB      0,   0, 102,   0,   0, 126,  98,  98
               DB    126, 112, 114, 126,   0,   0,   0,   0
               DB      0,  48,  16,   8,   0, 126,  98,  98
               DB    126, 112, 114, 126,   0,   0,   0,   0
               DB      0,   0, 102,   0,   0,   0,  16,  16
               DB     24,  24,  24,  24,   0,   0,   0,   0
               DB      0,  16,  56, 100,   0,   0,  16,  16
               DB     24,  24,  24,  24,   0,   0,   0,   0
               DB      0,  48,  16,   8,   0,   0,  16,  16
               DB     24,  24,  24,  24,   0,   0,   0,   0
               DB      0, 204,   0, 124, 100, 100, 254, 226
               DB    226, 226, 226, 226,   0,   0,   0,   0
               DB    124, 100, 124,   0, 124, 100, 100, 254
               DB    226, 226, 226, 226,   0,   0,   0,   0
               DB     12,   8,  16, 254, 192, 192, 192, 254
               DB    224, 224, 224, 254,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 255, 153,  25
               DB    255, 220, 221, 255,   0,   0,   0,   0
               DB      0,   0,   0, 127,  72,  72, 252, 207
               DB    204, 204, 204, 207,   0,   0,   0,   0
               DB      0,  16,  56, 100,   0, 126,  98,  98
               DB    114, 114, 114, 126,   0,   0,   0,   0
               DB      0,   0, 102,   0,   0, 126,  98,  98
               DB    114, 114, 114, 126,   0,   0,   0,   0
               DB      0,  48,  16,   8,   0, 126,  98,  98
               DB    114, 114, 114, 126,   0,   0,   0,   0
               DB      0,  16,  56, 100,   0,  98,  98,  98
               DB    114, 114, 114, 126,   0,   0,   0,   0
               DB      0,  48,  16,   8,   0,  98,  98,  98
               DB    114, 114, 114, 126,   0,   0,   0,   0
               DB      0,   0, 102,   0,   0, 114, 114, 114
               DB    114,  98,  98, 126,   2,   2, 126,   0
               DB      0, 204,   0, 254, 142, 134, 134, 134
               DB    134, 134, 134, 254,   0,   0,   0,   0
               DB      0, 102,   0, 194, 194, 194, 226, 226
               DB    226, 226, 226, 254,   0,   0,   0,   0
               DB      0,   0,  24,  24,  24, 126,  98, 112
               DB    114, 126,  24,  24,  24,   0,   0,   0
               DB      0,   0,   0,  28,  54,  48,  48, 124
               DB     48,  48, 102, 252,   0,   0,   0,   0
               DB      0,   0,   0, 102, 102,  60,  24, 126
               DB     24, 126,  24,  24,   0,   0,   0,   0
               DB      0,   0,   0, 252, 196, 196, 252, 228
               DB    238, 228, 230, 230,   0,   0,   0,   0
               DB      0,  14,  27,  24,  24,  24,  24, 126
               DB     24,  24,  24,  24,  24, 216, 112,   0
               DB      0,  12,   8,  16,   0, 124,  68,   4
               DB    126, 102, 102, 126,   0,   0,   0,   0
               DB      0,  12,   8,  16,   0,   0,  16,  16
               DB     24,  24,  24,  24,   0,   0,   0,   0
               DB      0,  12,   8,  16,   0, 126,  98,  98
               DB    114, 114, 114, 126,   0,   0,   0,   0
               DB      0,  12,   8,  16,   0,  98,  98,  98
               DB    114, 114, 114, 126,   0,   0,   0,   0
               DB      0,   0, 118, 220,   0, 126,  98,  98
               DB    114, 114, 114, 114,   0,   0,   0,   0
               DB    118, 220,   0, 254, 194, 194, 226, 226
               DB    226, 226, 226, 226,   0,   0,   0,   0
               DB      0, 124,  68,   4, 126, 102, 126,   0
               DB    126,   0,   0,   0,   0,   0,   0,   0
               DB      0, 126,  98,  98, 114, 114, 126,   0
               DB    126,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,  28,  28,   0,  28,  28
               DB    252, 192, 194, 254,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0, 254
               DB    192, 192, 192,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0, 254
               DB      6,   6,   6,   0,   0,   0,   0,   0
               DB      0,  48,  49, 113, 113, 113,   1, 255
               DB    224, 239, 227, 239, 236,  15,   0,   0
               DB      0,  48,  49, 113, 113, 113,   1, 255
               DB    224, 235, 235, 235, 239,   3,   0,   0
               DB      0,   0,   0,  56,   0,  56,  56,  56
               DB     24,  24,  24,  24,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  51, 102, 204
               DB    102,  51,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 204, 102,  51
               DB    102, 204,   0,   0,   0,   0,   0,   0
               DB     68,  17,  68,  17,  68,  17,  68,  17
               DB     68,  17,  68,  17,  68,  17,  68,  17
               DB    170,  85, 170,  85, 170,  85, 170,  85
               DB    170,  85, 170,  85, 170,  85, 170,  85
               DB    119, 221, 119, 221, 119, 221, 119, 221
               DB    119, 221, 119, 221, 119, 221, 119, 221
               DB     24,  24,  24,  24,  24,  24,  24,  24
               DB     24,  24,  24,  24,  24,  24,  24,  24
               DB     24,  24,  24,  24,  24,  24,  24, 248
               DB     24,  24,  24,  24,  24,  24,  24,  24
               DB     24,  24,  24,  24,  24,  24, 248,  24
               DB    248,  24,  24,  24,  24,  24,  24,  24
               DB     54,  54,  54,  54,  54,  54,  54, 246
               DB     54,  54,  54,  54,  54,  54,  54,  54
               DB      0,   0,   0,   0,   0,   0,   0, 254
               DB     54,  54,  54,  54,  54,  54,  54,  54
               DB      0,   0,   0,   0,   0,   0, 248,  24
               DB    248,  24,  24,  24,  24,  24,  24,  24
               DB     54,  54,  54,  54,  54,  54, 246,   6
               DB    246,  54,  54,  54,  54,  54,  54,  54
               DB     54,  54,  54,  54,  54,  54,  54,  54
               DB     54,  54,  54,  54,  54,  54,  54,  54
               DB      0,   0,   0,   0,   0,   0, 254,   6
               DB    246,  54,  54,  54,  54,  54,  54,  54
               DB     54,  54,  54,  54,  54,  54, 246,   6
               DB    254,   0,   0,   0,   0,   0,   0,   0
               DB     54,  54,  54,  54,  54,  54,  54, 254
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB     24,  24,  24,  24,  24,  24, 248,  24
               DB    248,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0, 248
               DB     24,  24,  24,  24,  24,  24,  24,  24
               DB     24,  24,  24,  24,  24,  24,  24,  31
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB     24,  24,  24,  24,  24,  24,  24, 255
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0, 255
               DB     24,  24,  24,  24,  24,  24,  24,  24
               DB     24,  24,  24,  24,  24,  24,  24,  31
               DB     24,  24,  24,  24,  24,  24,  24,  24
               DB      0,   0,   0,   0,   0,   0,   0, 255
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB     24,  24,  24,  24,  24,  24,  24, 255
               DB     24,  24,  24,  24,  24,  24,  24,  24
               DB     24,  24,  24,  24,  24,  24,  31,  24
               DB     31,  24,  24,  24,  24,  24,  24,  24
               DB     54,  54,  54,  54,  54,  54,  54,  55
               DB     54,  54,  54,  54,  54,  54,  54,  54
               DB     54,  54,  54,  54,  54,  54,  55,  48
               DB     63,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,  63,  48
               DB     55,  54,  54,  54,  54,  54,  54,  54
               DB     54,  54,  54,  54,  54,  54, 247,   0
               DB    255,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0, 255,   0
               DB    247,  54,  54,  54,  54,  54,  54,  54
               DB     54,  54,  54,  54,  54,  54,  55,  48
               DB     55,  54,  54,  54,  54,  54,  54,  54
               DB      0,   0,   0,   0,   0,   0, 255,   0
               DB    255,   0,   0,   0,   0,   0,   0,   0
               DB     54,  54,  54,  54,  54,  54, 247,   0
               DB    247,  54,  54,  54,  54,  54,  54,  54
               DB     24,  24,  24,  24,  24,  24, 255,   0
               DB    255,   0,   0,   0,   0,   0,   0,   0
               DB     54,  54,  54,  54,  54,  54,  54, 255
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0, 255,   0
               DB    255,  24,  24,  24,  24,  24,  24,  24
               DB      0,   0,   0,   0,   0,   0,   0, 255
               DB     54,  54,  54,  54,  54,  54,  54,  54
               DB     54,  54,  54,  54,  54,  54,  54,  63
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB     24,  24,  24,  24,  24,  24,  31,  24
               DB     31,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,  31,  24
               DB     31,  24,  24,  24,  24,  24,  24,  24
               DB      0,   0,   0,   0,   0,   0,   0,  63
               DB     54,  54,  54,  54,  54,  54,  54,  54
               DB     54,  54,  54,  54,  54,  54,  54, 255
               DB     54,  54,  54,  54,  54,  54,  54,  54
               DB     24,  24,  24,  24,  24,  24, 255,  24
               DB    255,  24,  24,  24,  24,  24,  24,  24
               DB     24,  24,  24,  24,  24,  24,  24, 248
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,  31
               DB     24,  24,  24,  24,  24,  24,  24,  24
               DB    255, 255, 255, 255, 255, 255, 255, 255
               DB    255, 255, 255, 255, 255, 255, 255, 255
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB    255, 255, 255, 255, 255, 255, 255, 255
               DB    240, 240, 240, 240, 240, 240, 240, 240
               DB    240, 240, 240, 240, 240, 240, 240, 240
               DB     15,  15,  15,  15,  15,  15,  15,  15
               DB     15,  15,  15,  15,  15,  15,  15,  15
               DB    255, 255, 255, 255, 255, 255, 255, 255
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0, 115, 222
               DB    204, 204, 222, 115,   0,   0,   0,   0
               DB      0,   0,   0, 252, 196, 196, 206, 226
               DB    226, 226, 234, 238, 128, 128, 128,   0
               DB      0,   0,   0, 126, 102,  96,  96,  96
               DB     96,  96,  96,  96,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 254, 108, 108
               DB    108, 108, 108, 108,   0,   0,   0,   0
               DB      0,   0,   0, 126, 102,  48,  24,  12
               DB     24,  48, 102, 126,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0, 126, 216
               DB    216, 216, 216, 112,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0, 102, 102, 102
               DB    102, 124,  96,  96,  96, 192,   0,   0
               DB      0,   0,   0,   0,   0, 118, 220,  24
               DB     24,  24,  24,  24,   0,   0,   0,   0
               DB      0,   0,   0, 126,  24,  60, 102, 102
               DB    102,  60,  24, 126,   0,   0,   0,   0
               DB      0,   0,   0,  60, 102, 102, 102, 126
               DB    102, 102, 102,  60,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  56, 108, 198
               DB    198, 108, 108, 238,   0,   0,   0,   0
               DB      0,   0,   0,  30,  48,  24,  12,  62
               DB    102, 102, 102,  60,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0, 110, 219
               DB    219, 118,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  12,  56, 108
               DB    124, 108,  56,  96,   0,   0,   0,   0
               DB      0,   0,   0,  28,  48,  96,  96, 120
               DB     96,  96,  48,  28,   0,   0,   0,   0
               DB      0,   0,   0,   0,  60, 102, 102, 102
               DB    102, 102, 102, 102,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0, 126,   0
               DB    126,   0, 126,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  24,  24, 126
               DB     24,  24,   0, 126,   0,   0,   0,   0
               DB      0,   0,   0,  48,  24,  12,   6,  12
               DB     24,  48,   0, 126,   0,   0,   0,   0
               DB      0,   0,   0,  12,  24,  48,  96,  48
               DB     24,  12,   0, 126,   0,   0,   0,   0
               DB      0,   0,   0,  14,  27,  27,  24,  24
               DB     24,  24,  24,  24,  24,  24,  24,  24
               DB     24,  24,  24,  24,  24,  24,  24,  24
               DB     24, 216, 216, 112,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,  24,   0,   0
               DB    126,   0,   0,  24,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0, 118, 220
               DB      0, 118, 220,   0,   0,   0,   0,   0
               DB      0,   0,  56, 108, 108,  56,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,  24
               DB     24,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB     24,   0,   0,   0,   0,   0,   0,   0
               DB      0,  15,  12,  12,  12,  12,  12, 204
               DB    108,  60,  28,  12,   0,   0,   0,   0
               DB      0, 126,  98,  98, 114, 114, 114,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0, 126,  70,   6, 126, 112, 126,   0
               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0,   0,   0,   0,  60,  60
               DB     60,  60,  60,   0,   0,   0,   0,   0
;               DB      0,   0,   0,   0,   0,   0,   0,   0  ; 255 orig.
;               DB      0,   0,   0,   0,   0,   0,   0,   0
               DB      0,   0,   0, 198, 198, 198, 198, 198   ; semi M
               DB    198, 198, 198, 198,   0,   0,   0,   0
_DATA          ENDS

               END
