
/*********************************************************************
*                                                                    *
*     2M-INFMC 1.0  -   Programa para construir el fichero *.FMC     *
*                                                                    *
*     Necesita como entrada el fichero *.GRA con los datos crudos    *
*     de la imagen.  No se trata de cdigo ejemplar ni eficiente;    *
*     simplemente cumple con su funcin y punto :-)                  *
*                                                                    *
*     Este  programa  es  de uso interno y no aparece compilado    *
*     con los ejecutables de la aplicacin.                          *
*                                                                    *
*********************************************************************/


#include <stdlib.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <io.h>
#include "2m-info.h"


void Comprimir (void), GenerarFMC (void);


void main()
{
   Comprimir();
   GenerarFMC();
}


void Comprimir()
{
  FILE *fi, *fo;
  char c;
  long i;
  int  cc, c0, cv;

  printf("\nGenerando 2m-info.p64 a partir de 2m-info.gra ...\n");

  if ((fi=fopen("2m-info.gra", "r+b"))==NULL) {
    printf("\nProblemas para leer 2m-info.gra\n");
    exit(1);
    }
  if ((fo=fopen("2m-info.p64", "w+b"))==NULL) {
    printf("\nProblemas para crear 2m-info.p64\n");
    exit(2);
    }

  fread (&c, 1, 1, fi);
  c0=c; cv=1;

  for (i=0; i<filelength(fileno(fi))-1; i++) {
    fread (&c, 1, 1, fi);
    cc = c;
    if (cc==c0)
        cv++;
      else
        if (cv==1)
            fwrite (&c0, 1, 1, fo);
          else
            switch (cv) {
              case 2:  c0+=64;  fwrite (&c0, 1, 1, fo); cv=1; break;
              case 3:  c0+=128; fwrite (&c0, 1, 1, fo); cv=1; break;
              default: c0+=192; fwrite (&c0, 1, 1, fo);
                                fwrite (&cv, 1, 1, fo); cv=1; break;
              }
    if (cv==255) {
      c0+=192;
      fwrite (&c0, 1, 1, fo);
      fwrite (&cv, 1, 1, fo);
      cv=1;
      }

    c0=cc;
    }

  fwrite (&c, 1, 1, fo);

  fclose (fi); fclose(fo);
}



void GenerarFMC()
{
  FILE *f, *g;
  char cad[FMC_ID_HEAD+1];
  int  i, j;
  long lj, lfs;
  FichMultCiri info;

  printf("Generando 2m-info.fmc a partir de 2m-info.p64 ...\n");

  if ((f=fopen("2m-info.fmc", "w+b"))==NULL) {
    printf("\nProblemas para crear 2m-info.fmc\n");
    exit(3);
    }
  if ((g=fopen("2m-info.p64", "r+b"))==NULL) {
    printf("\nProblemas para leer 2m-info.p64\n");
    exit(4);
    }

  for (i=0; i<=FMC_ID_HEAD; i++) cad[i]=0;
  strcpy (cad, "\r\nFichero Multimedia CiriSOFT v1.0\r\n\CiriSOFT Multimedia File v1.0\r\n\032");
  strcpy (&cad[FMC_ID_OFF], FMC_ID);
  fwrite (cad, 1, FMC_ID_HEAD, f);

  lfs = filelength(fileno(g));

  memset (&info, 0, sizeof (info));

  lj = sizeof (info) + lfs;

  info.lbloque = lj;
  info.tipo = FMC_GRAFICO;
  strcpy (info.nombre, "Galaxia");
  info.atributos = 1;
  info.info.gr.lx = 160;
  info.info.gr.ly = 234;

  fwrite (&info, 1, sizeof (info), f);

  for (i=0; i<lfs; i++) {
    fread  (&j, 1, 1, g);
    fwrite (&j, 1, 1, f);
    }

  fclose(f); fclose(g);
}
