
  /* Constantes */

#define ABRIR       1
#define CERRAR      2
#define SALIR       3
#define LEER        4
#define ESCRIBIR    5
#define FORMATEAR   6

#define PRESERVAR   1
#define RESTAURAR   2
#define MOSTRAR     3
#define BOOT2M     80

#define INICIO      1
#define FIN         2

#define ASCENDENTE  1
#define DESCENDENTE 2

#define FD_DATA   0x3F5   /* registro de datos del 765 */
#define FD_STATUS 0x3F4   /* registro principal de estado del 765 */
#define FD_DOR    0x3F2   /* registro de salida digital */
#define FD_DCR    0x3F7   /* registro de control del disquete */

#define FMC_GRAFICO 0
#define FMC_SONIDO  1
#define FMC_ID      "FFMMCC-1.00"
#define FMC_ID_OFF  112L
#define FMC_ID_HEAD 128L

  /* Estructuras */

typedef struct {                    /* sector arranque disquetes 2M */
  unsigned char Salto[3], IdSis[8];
  short    BytesSect;
  char     SectCluster;
  short    SectReserv;
  char     NumFats;
  short    FichRaiz, NumSect;
  char     MediaId;
  short    SectFat, SectPista, Caras;
  long     Especiales, Sect32;
  char     Unidad, Reservado, Flag;
  long     NumSerie;
  char     Titulo[11], TipoFat[8];
  char     Flags;
  char     CheckSum;
  char     VersionFmt, FlagWr, VelPista0, VelPistaX;
  short    OffsetJmp, OffsetPista0, OffsetPistaX, OffsetListaTam;
  unsigned short FechaF;
  unsigned short HoraF;
  char     Resto[512-BOOT2M];  /* depende del tamao de lo anterior */
  } Boot;

typedef struct {
  int Ayuda;
  int NoDemo;
  int ModoTxt;
  int Modo25;
  int Modo30;
  int Modo765;
  int ModoTest;
  int HazIdx;
  int ModoI;
  int Unidad;
  } Parametros;

typedef struct {
  unsigned int lx;
  unsigned int ly;
  char reservado[5];
  } InfoGrafico;

typedef struct {
  char reservado[9];
  } InfoSonido;

typedef struct {
  unsigned long lbloque;
  char          tipo;
  char          nombre[16];
  unsigned int  atributos;
  union {
    InfoGrafico gr;
    InfoSonido  sn;
    } info;
  } FichMultCiri;
