
extrn _MixInit:dword
;               Initializes sound system
;               in: eax = dac playback frequency
;                   edx = dac sample size (  8,  16 == 8bit,16bit mono
;                                           -8, -16 == 8bit,16bit stereo)
;                   ecx = dac mixer feedback frequency
;                   ebx = wavetable playback frequency
;                   esi = wavetable sample size (same values as dac)
;                   edi = wavetable active channels
;               out: eax,...,edi modified to the nearest values
;                    the current driver can support
;
;               The "dac mixer feedback frequency" is the frequency
;               the mixer system "feeds" a new mixed sound data block
;               to the sound system.
;               Given the current 4k block limit the lowest "feed"
;               frequencies can be:
;               Frequency      8bit   16bit/8bit_stereo  16bit_stereo
;                  8000         2Hz     4Hz               8Hz
;                 11000         3Hz     6Hz              12Hz
;                 22000         6Hz    12Hz              24Hz
;                 44100        11Hz    22Hz              44Hz
;
;               For good "animation/sound feedback" it is better to
;               choose a 30..35Hz feedback frequency.
;
;               DAC "soft channels" and Wavetable "hard channels"
;               are numbered starting from 0.

extrn _MixShutDown:dword
;               Shuts down mixer system (automatically called by _Exit)

extrn _MixSetUp:dword
extrn _MixControls:dword
;               are pointers to menu descriptions useful
                         to customize the sound system.

extrn _SndPlay:dword
;         Play sound
;         in: eax= channel   (-1 = autorotate)
;             edx= sound handle ( 0 = silence)

extrn _SndPlay:dword
;         Set "default" sound to play after the current sound is terminated
;         in: eax= channel   (-1 = set this on ALL autorotating mixer channels)
;             edx= sound handle ( 0 = silence)

extrn _SndLoad:dword
;         Loads a sound file (currently it can only be an 8bit VOC file)
;         in: esi= pointer to filename
;         out: if CARRY CLEAR then eax= sound handle

extrn _SndMark:dword
;         "Marks" the current sound heap
;         out: eax= sound heap mark

extrn _SndRelease:dword
;            "Releases" a slice of the sound heap
;            in: eax= mark (bottom of heap slice to cut)
;                          ( 0 == cut from top to bottom)

extrn _SndVolume:dword
;           Set sound channel volume
;           in:
;           eax= channel ( -1 = set volume of all autorotating channels)
;           edx= volume  (0..200)  (0=silence 200=maximum output)
;           (this function can be ignored if you want)

extrn _SndRotate:dword
;           Sets channel rotation limits
;           in: eax=lowest rotating sound channel, edx=highest rotating channel
;           out: eax=new lowest rot. channel, edx=new highest rot. channel
;           Notice that if the wavetable system has more channels
;           then the "software mixer", the extra wavetable channels
;           can only be used for autorotation.
;           To see how many channels the mixer supports, call this with
;           eax=0 (lowest channel) and edx = 0FFFFFFFFh ( 4 giga channels!!!!)
;           and see what is the new value of edx
;           (edx = highest channel = number_of_channels -1)

extrn _SndReSample:dword
;             Resample sound to add effects and copies the result
;             to a new handle.
;             in:
;               eax=sound handle (this won't be modified)
;               dl,dh = left,right channel volume % (0..200)
;                       (0= nothing, 100 = same volume, 200 = twice the volume)
;               cx, bx = left,right channels sound delay in milliseconds
;               bp = speed % (0..200) ( 100= same speed, 200= twice the speed)
;               UPPER WORDS of edx,ecx,ebx,ebp MUST BE ZERO
;               (they will be used to add more sound control parameters
;                in a future release, i plan to add "real" 3d sound
;                and other nice things)
;             out:
;               eax= handle for resampled sound
;             N.B. If the mixer has "mix on the flight" sound effects
;                  or if it can exploit some sound card features
;                  the new handle points to a different header
;                  but the sound data can be the same
;                  (so instead of copying it, just add a pointer to the
;                   "original" sound data)

; LOW LEVEL DAC DEVICE INTERFACE

extrn _XSDCheck:dword
;                  Called By _MixInit
;                  must return CARRY SET if SOUND CARD IS NOT DETECTED

extrn _XSDOn:dword
;                  Called by _MixInit with the same parameters it received
;                  when called.
;                  This has to set up dma and irq handling and initialize
;                  the sound system.
;                  It includes the mixing routine.

extrn _XSDOff:dword
;       Called by _MixShutDown

extrn _XSDSetup:dword
extrn _XSDControls:dword
;       pointers to menu data for custom configuration

;Wavetable devices and other things needs to hook the upper level functions
;(sorry, i know what a Gravis can do, but i hear the newest wavetable
; synthesis boards have way powerful DSPs and other nice things
; that cannot be "framed" into a fixed low level interface, better let 'em
; hook the upper level functions)

