       
extrn _InstallTimer:dword
; Installs timer code

extrn _TimerShutDown:dword
; Kills the timer functions

extrn _ReadTimer:dword
; read the EXACT time tick count down to a 2 microsecond precision
; in 1193180 Hz cycles  (roughly a little less than a microsecond cycles)
; edx:eax = 64 bit count

extrn _TimerEvent:dword
; installs a timer event routine into the timer list
; in: eax=offset of timed routine
;     edx=timer interval (in 1193180 Hz cycles)
;     ecx=specific data to load into EDI when the routine eax is called
; out:
;       IF carry clear THEN eax=handle of timed routine
;                      ELSE handles exausted
extrn _TimerSlice:dword
; changes time interval of a timed routine
; in: eax=handle of timed routine
;     edx= new timer interval (in 1193180 Hz cycles)
; out:
;     IF carry clear THEN interval changed

extrn _Seconds:dword
; seconds since _InstallTimer has been called

extrn _TimerStop:dword
; Initially set to 1 (timer is stopped)
; It is set to zero by _InstallTimer
; and then set back to 1 by _TimerShutDown
;
; While running BETWEEN _InstallTimer and _TimerShutDown
; it is used as a
; TIMER CRASH FLAG ( 0 = timer ticks good)
; From time to time, check in the main program if this flag is set to 1
; (expecially BEFORE using code interacting with timer event functions)
;
; If this flag is set to 1, you selected a too high timer frequency
; and you'd better reinstall the timed event routines
; using bigger time intervals.
;
; Be careful, this flag is turned on only if THE UNINTERRUPTABLE
; portion of the timer irq handler has overrunned
; (Jeez! If this happens your cpu is running out of steam!).
;
; If this happens, the "automatic protection system" of 386timer
; kills automatically all the timer events except the "good old" 18.2 Hz
; timer tick.
; BUT OVERRUNS CAUSED BY EXECUTION OF TIMED EVENTS ARE NOT DETECTED
; DIRECTLY (well, you detect them because they "halt" the main program
; and sooner or later will cause a stack overflow).
; I choosed not to use automatic detection for them because
; such a strategy may cause more problems than the one it solve.

; Anyway, look into 386timer to see how i used the 'overrun' flag
; to detect overruns in the uninterruptable portion of the irq handler.
; Then use a similar strategy ("inner" flag for overrun detection plus
; "external" flag for overrun alert) to handle possible overrun
; situations
; In the "automatic" overrun detector my only choice
; was to "kill" the timer, but in other situations it is better
; to "discard" the last irq with a specific end of interrupt (SEOI).

; Do you fear this is too confusing? Well, it is!
; But you need overrun detection only in extreme situations.

; My 385/25 can play sound at 8Khz using a timed event but only
; when running with ms-dos (VCPI), if i run the same program under
; Windows (DPMI) the fucking slow irq redirection it uses, causes lots
; of problems and nearly halts the cpu (grrr!).

; So , include overrun detection only in the most cpu intensive
; or frequency intensive tasks.

