include 386sys.inc

extrn _DispX:Dword    ; display size
extrn _DispY:Dword    ; N.B. this is the VIEWABLE display size
                      ;      the display page may be wider
                      ;      but this is _PageFlip0/1 stuff
                      ;      "you don't see it"

extrn _VDispX:Dword     ; display window start inside screen buffer
extrn _VDispY:Dword     ; this is the upper left corner of the portion
                        ; of the screen buffer viewable on the display
                        ; at the next _PageFlip

extrn _ScrX:Dword    ; screen buffer size
extrn _ScrY:Dword    ; the screen buffer is _ScrX*_ScrY bytes wide

extrn _ScrSD:Dword   ; screen size in dwords, useful to some XGE routines

extrn _XSquare:Dword ;  _XSquare/_YSquare == pixel aspect ratio
extrn _YSquare:Dword ;

extrn _XVDTotRam:Dword ; availabe ram on vidoe board in 64k units
extrn _XVDExternal:byte    ; tried to load external driver
extrn _XVDGoodDriver:byte  ; found XVD marker at start of external driver
extrn _XVDBGood:byte       ; check for external driver's bios OK
extrn _XVDCGood:byte       ; check for external driver's chipset OK

extrn _ScrBase :dword ; base offset of NEXT screen buffer
                      ; displayed by _PageFlip
                      ; this MAY change after a _PageFlip

; table of line start offsets (initialized by _SetXVDMode)
extrn _RowStart   :dword

extrn _SetXVDMode: dword
       ; Initialize graphics mode
       ; according to what is set into
       ; _DispX,DispY  (screen resolution)
       ; _ScrX,_ScrY   (screen buffer size)
       ; Those variables are set to the nearest values supported
       ; or _Exit is called if it is not possible to do that
       ; _VDispX,VDispY are set to zero
       ; _ScrSD , _RowStart, _ScrBase are initialized

extrn _RestoreTextMode: dword
       ; Restores default 80x25 color text mode & shuts down video driver
       ; (called automatically by _Exit code
       
extrn _DisplayStart: dword
       ; EAX= x_position 
       ; EBX = y_position 
       ; Sets the new starting position (_VDispX,_VDispY)
       ; of the viewable window inside the display buffer.
       ; USE THIS to change _VDispX,_VDispY because the actual
       ; display start change may need some processing
       
       ; PAGEFLIP ROUTINES
extrn _PageFlip0: dword
extrn _PageFlip1: dword
       ; _PageFlipping routines ... here comes the lightning
       ; they set the "old" active page (screen buffer)
       ; (the one referenced thru _ScrBase)
       ; as the new viewable page (display page)
       ; they can actually copy the bitmap or just change a set of
       ; display start registers, you don't need to know exactly
       ; how they work, just reload the "screen base" offset
       ; from _ScrBase before doing other things.
       ; every driver MUST support three different methods
       ; a) _PageFlip0 (BRUTE FORCE), copies the whole bitmap into _Scrbase
       ;    to "viewable" ram (copying it or changing display start)
       ;    Useful if your card is fast and/or can map lots of video ram
       ;    as directly addressable ram (i.e. a VL-BUS Tseng ET-4000w32).
       ;    USING THIS METHOD, ALL the screen buffer MUST BE "COMPOSED"
       ;    before calling this.
       ;    
       ; b) _PageFlip1 (TOUCHMAP), copy only the pixels "flagged" 
       ;    into the internal touchmap structures.
       ;    Useful when you "know ahead" what portions of bitmap are changed
       ;    and your video ram access is not very fast.
       ;
       
extrn _TouchBlock: dword
        ; eax,edx == (xstart,ystart)
        ; ecx = width in nudgets (4 adiacent pixels blocks)
        ; ebx = height in pixels
        ; marks a portion of the viewable window as "touched"
        ; (modified between two pageflips)
        ; so these pixels will be copied to screen if _PageFLip1
        ; is called at the next pageflip
        
extrn _CompFlip:dword
        ; Compiles a pageflipping mask
        ; (useful when the portions you have to "refresh" are nearly always
        ;  the same)
        ; to do this you have to pass the base and top pointers of the heap
        ; you want to store the pageflip data on.
        ; BEFORE:
        ; Use _TouchBlock to set the current touchmap as you want
        ; the "compiled pageflipper" will act.
        ; IN:
        ; eax = allocation heap base , edx = allocation heap top
        ; OUT:
        ; IF CARRY CLEAR THEN
        ;    eax = NEW allocation heap base, edx = NEW allocation heap top
        ;    edi = pointer to custom pageflipping data/code
        ; ELSE NOTHING HAPPENED
        ;
        ; example:
        ;           <touch pixels here and there using _TouchBlock>
        ;           ; now store store custom flip data on low memory
        ;           mov eax,_LoMemBase
        ;           mov edx,_LoMemTop
        ;           call _CompFlip
        ;           mov _LoMemBase,eax
        ;           mov _LoMemTop,edx
        ;           mov MyCustomFlipper,edi
        
extrn _CustomFlip:dword
        ; Executes a custom pageflipping as compiled from _CompFlip
        ; But doesn't modify the current touchmaps
        ; IN:
        ;    eax= pointer to custom pageflipping data/code      
        
; AND NOW SOME EXPLANATIONS ABOUT HOW TO FLIP PAGES
; (just to let you understand how it currently works
;  and how it will evolve)
; (N.B. The current 386video module supports only
;       video mapping 0 and 1)
;
; video mapping:  0 = buffer on system ram, single display page
;                 1 = buffer on system ram, multiple display pages
;                 2 = buffer on vram,       single display page
;                 3 = buffer on vram,       multiple display pages
;
; page-flip:  0 = _PageFlip0
;             1 = _PageFlip1

; video mapping    page-flip

;                           SINGLE VIDEO PAGE ------------------------------
;            0          0   ; COPY from the _ScrBase buffer to display page
;                           ; maybe using the ram to vram blitter if present
;                           ; (no other way)
;            0          1   ; COPY only the "touched" pixels to display page
;                           ; (no other way)

;                           MULTIPLE VIDEO PAGES ---------------------------
;            1          0   ; COPY from _ScrBase to NEW display page
;                           ; THEN CHANGE DISPLAY PAGE (reducing jitter)
;            1          1   ; IF NO FAST_BLITTING_HARDWARE
;                           ;    COPY only the "touched" pixels to display page
;                           ; ELSE IF FAST_VRAM_BLITTER PRESENT
;                           ;    BLIT the displayed page to the "new" one
;                           ;    COPY the differences to the new one
;                           ;    (reducing jitter)
;                           ; ELSE IF FAST_RAM_TO_VRAM_BLITTER PRESENT
;                           ;    BLIT "raw" from _ScrBase to new page
;                           ;    CHANGE DISPLAY PAGE
;                           ; ENDIF

;                           VRAM MAPPING, SINGLE PAGE ----------------------
;            2          0   ; COPY from the _ScrBase buffer to display page
;            2          1   ; COPY only the "touched" pixels to display page

;                           VRAM MAPPING, MULTIPLE PAGES -------------------
;            3          0   ; CHANGE DISPLAY PAGE, CHANGE _ScrBase
;            3          1   ; COPY only the "touched" pixels to display page

; AS YOU CAN GUESS _PageFlip1 usually is faster than _PageFlip0
; but is not always true, before calling _SetXVDMode set _XVDMappings
; as you'd like it to be, then check what the driver can do
; and use the best "page composition" method that better suits
; the available driver.

; "static" color indexes
;  Windows static colors, i use these because i wanted a wide "standard set"
;  of colors for loadable modules usage and because i plan to add
;  a "connect to WinG" interface if there is no other driver present.

BLACK=0
DARK_RED=1
DARK_GREEN=2
DARK_YELLOW=3
DARK_BLUE=4
DARK_MAGENTA=5
DARK_CYAN=6
GRAY=7
MONEY_GREEN=8
SKY_BLUE=9

CREAM=246
MEDIUM_GRAY=247
GRAY=248
RED=249
GREEN=250
YELLOW=251
BLUE=252
MAGENTA=253
CYAN=254
WHITE=255

; "static text colors", these are set on a per application basis
; to define the standard "shaded" character set.
BRIGHT1_TEXT=10   ; most saturated
BRIGHT6_TEXT=15   ; least saturated , "bright background"

DARK1_TEXT=240 ; most saturated
DARK6_TEXT=245 ; least saturated, "dark background"
;----------------------------------------------------------------------------
; _Set1Pal    in:     al = palette entry to set
;                    edx = bit 0..7   red
;                          bit 8..15  green
;                          bit 16..23 blue 
;                          bit 24..31 non utilizzati
;                    N.B. RGB entries have FULL 8BIT RESOLUTION!!!!
;                         (vga has 6 bits for color entry)
;
extrn  _Set1Pal:dword

;----------------------------------------------------------------------------
; _Get1Pal    in:     al = palette entry to set
;             out:
;                    edx = bit 0..7   red
;                          bit 8..15  green
;                          bit 16..23 blue
;                          bit 24..31 non utilizzati
;                    N.B. RGB entries have FULL 8BIT RESOLUTION!!!!
;                         (vga has 6 bits for color entry)
;

extrn  _Get1Pal:dword
; reads palette entry AL and stores it into EDX

;----------------------------------------------------------------------------
; _Set256Pal  esi=pointer to a table of 256 palette entries
;                 every palette entry is made of three bytes
;                 for Red Green and Blue 24BIT PALETTE values
;
extrn  _Set256Pal:dword
                

