; Tiled background  management routines
; A "tiled" background is a background image made of rectangular bitmaps
; This module uses square shaped bitmaps, due to the x/y aspect ratio
; they are 32x26 pixel wide because of the different aspect ratio
; ( 4/3 for the monitor, 320/200 for the pixel, and another one for
;   the maximum image on the monitor)
;
; I use to call "patterns" these 32x26 tiles, the reason is that i'm 
; a native italian that started designing games when at the high school 
; and never heard the word "tiled background" before reading 
; it on rec.games.programmer.
; So, when i reinvented the wheel i had to give it a name :) .

; 1 nudget     = 4  pixel (plane aligned, one pixel for every plane)
; 1 big nudget = 16 pixel (plane aligned, four nudgets)

; PAT format:
; 2x26 dwords for each 4 planes.
; Given a plane, the 52 dwords have to be blitted as follows:
;         0  1
;         1  2
;         3  4
;        ..  ..
;        48  49
;        50  51
; As you can see a "pattern" is just a "picture" with size 32x26
; with optimized routines to blit it

; reads pattern from screen
extrn _GetPat:near
        ; in:
        ; edi = pic dest
        ; esi = scr source base
        ; eax = x in nudgets
        ; edx = y in pixels
        ; out:
        ; edi = ptr to end of picture

; Writes a pattern to screen using an unrolled loop
; (don't worry for the movsd, the cpu-memory interface
; is stressed to the limit with this and we need "small" opcodes
; to keep the pipeline filled on 386s
; The main speed gain is obtained avoiding the loop
; and thus keeping the pipeline filled even on 386s

extrn _PutPat:near
        ; in:
        ; edi = scr dest
        ; esi = pat source 
        ; eax = x in nudgets
        ; edx = y in pixels
        

extrn _PutHPat:near
        ; in:
        ; edi = scr dest
        ; esi = pat source 
        ; eax = x in nudgets
        ; edx = y in pixels
        ; same as _PutPat but blits a shriked tile bimap 16*13
        
; draws a tiled background map
extrn _PutMap:near
        ; in:
        ; esi = map matrix [YTILES][XTILES]
        ; eax = x in pixels
        ; ebx = y in pixels

