

; Get/Put bitmaps (pictures)
; Compile/Put bitmaps with encoded transparency (sprites)
       .386P
code32 segment para public use32
       assume cs:code32,ds:code32
NOSMART
NOJUMPS
include 386video.inc
include chtil.inc
; 1 nudget     = 4  pixel (plane aligned, one pixel for every plane)
; 1 big nudget = 16 pixel (plane aligned, four nudgets)

; PIC format:
;            offset     size       name   description
;              0          2        WX     Width  of picture in BIG NUDGETS
;              2          2        WY     Height of picture in PIXELS
;              4       WX*WY*4     ----   First plane

	public _GetPic

; reads picture from screen
_GetPic:
        ; in:
        ; edi = pic dest
        ; esi = scr source
        ; eax = x in pixels
        ; edx = y in pixels
        ; ecx = x width  in nudgets
        ; ebx = y height in pixels
        ; out:
        ; edi = ptr to end of picture
        push eax
        push ebx
        push ecx
        push edx
        push esi 
        push ebp
         
        add esi,[edx*4+_RowStart]
        shl ebx,16
        add esi,eax
        mov bx,cx
        mov edx,ecx
        
        mov [edi],ebx   ; registra ampiezza ed altezza
        shl ecx,2       ; from nudgets to pixels
        mov ebp,_ScrX
        add edi,4       ; advance pointer 
        shr ebx,16
        sub ebp,ecx
@getpicline:
        mov ecx,edx
        rep movsd
        add esi,ebp
        dec ebx
        jne @getpicline
        
        ; edi = posizione DOPO la lettura della bitmap
        pop ebp
        pop esi
        pop edx
        pop ecx
        pop ebx
        pop eax
        
	ret


BlastPut macro 
@putpicline:
        mov ecx,edx
        rep movsd
        add edi,ebp
        dec ebx
        jne @putpicline
	endm

BlastRPut macro 
@revpic:        
        mov ecx,edx
@revdword:        
        mov eax,[esi]
        rol  ax,8     ; one for the money
        sub edi,4     ; (interleave this instruction)
        rol  eax,16   ; two for the show
        add esi,4     ; (interleave this instruction)
        rol  ax,8     ; three get ready
        dec ecx       ; interleave counter decrement
        mov [edi],eax ; & let's rock!
        jne @revdword
        add edi,ebp
        dec ebx
        jne @revpic
        endm

	public _PutPic

; blits a picture to screen
; Warning! L' unica opzione valida e' LEFTRIGHT!
_PutPic: 
        ; edi = scr dest
        ; esi = pic ptr
        ; eax =  x in pixels
        ; edx =  y in pixels
        ; bl  =  blit mode flag    1=reverse left-right
        pushad
        add edi,[edx*4+_RowStart]
        xor edx,edx
        add edi,eax
        and bl,LEFTRIGHT
        jnz @pleftright
@pnorm:
        mov ebx,[esi]  ;width & height
        mov dx,bx
        shr ebx,16
        mov ecx,edx
        add esi,4
        shl ecx,2  ; nudgets to pixels
        mov ebp,_ScrX ; incremento di linea
        sub ebp,ecx     ; correggi per avanzamento
        
        BlastPut 
@pgottaut:
        popad
	ret

@pleftright:
	; LEFT TO RIGHT <--> RIGHT TO LEFT
@noinc:
        mov ebx,[esi]  ;width & height
        mov dx,bx
        add esi,4
        shr ebx,16
        mov ecx,edx
        mov ebp,_ScrX ; incremento di linea
        shl ecx,2  ; nudgets to pixels
        add ebp,ecx     ; correggi per avanzamento        
        
        add edi,ecx  ; portati a fine linea

        BlastRPut 
        popad
        ret

; An Spt (encoded SPriTe)
; has a dword header like a PICture
; offset size  significato
;      0    2  width in nudgets
;      2    2  height in pixels
; But the sprite data is contained into "packets"
; with transparent color ( color zero) coded in RLE format

; RLE packet format:   [..] == .. is optional
; RLE_HEADER, [INCR 1byte ], [DATA_HEAD 0..3 byte ],[DATA_DWORD 0..n dwords]


;RLE_HEADER bit 0..1 = data_head lenght (0..3 BYTES)
;           bit    2 = dword data present (use bit 4..7), [DATA_DWORD] present
;           bit    3 = new line AFTER this blit
;           bit 4..7 = dword counter n  (0..15 DWORDS)
;
; a RLE_HEADER 00 (end of sprite) or 08 (newline)
; has no [INCR] field.

crunch macro
        ; decode next packet
        mov eax,[esi] ;read RLE_HEADER, INCR and 2 head bytes
        mov dl,al   ; get jump index bit 0..3
        mov cl,ah   ; get INCR count
        and dl,0Fh  ; select jump index
        add edi,ecx ; skip empty pixels
        mov cl,al   ; get dword count bit 7..4
        shr eax,16  ; get data into lower word
        jmp  [edx*4+offset ETable] ; go to packet decoder
        endm
      
ncrunch macro
        ; newline & decode next packet
        mov eax,[esi]
        mov cl,ah
        lea edi,[ebx+ebp*1] ; newline+line_start
        mov dl,al
        add edi,ecx ; INCR after newline
        and dl,0Fh
        mov cl,al  ; get dword count
        add ebx,ebp  ; newline for line_start register too
        shr eax,16
        jmp [edx*4+ offset ETable] ; perform blit
        endm

; Hndl : Header, n== perform newline,d == dword data, l == data head lenght 

H000: ; END OF PLANE 
        popad
        ret        
      
H001:
      stosb
      add esi,3
      crunch
      
H002: stosw
      add esi,4
      crunch
      
H003: add esi,4
      stosw
      movsb  ; copy last byte of DATA_HEAD
      crunch
      
H010: shr ecx,4  ; get dword count
      add esi,2
      rep movsd
      crunch      
      
H011:
      shr ecx,4
      add esi,3
      stosb
      rep movsd
      crunch
      
H012: add esi,4
      shr ecx,4
      stosw
      rep movsd
      crunch
      
H013: add esi,4
      shr ecx,4
      stosw
      movsb
      rep movsd
      crunch
      
H100: inc esi ; no [incr] field present
      ncrunch
      
H101: add esi,3
      stosb
      ncrunch
      
H102: stosw
      ncrunch
      
H103: add esi,4
      stosw
      movsb
      ncrunch
      
H110: shr ecx,4
      add esi,4
      rep movsd
      ncrunch

H111: add esi,3
      shr ecx,4
      stosb
      rep movsd
      ncrunch
      
H112: 
      stosw
      add esi,4
      shr ecx,4
      rep movsd
      ncrunch
      
H113:
      stosw
      add esi,4
      shr ecx,4
      movsb
      rep movsd
      ncrunch
      
      align dword
ETable: dd offset H000, offset H001, offset H002, offset H003
        dd offset H010, offset H011, offset H012, offset H013    
        dd offset H100, offset H101, offset H102, offset H103
        dd offset H110, offset H111, offset H112, offset H113
        align byte      

rcrunch macro
        ; decode next packet
        lodsd
        mov dl,al   ; jump addr
        mov cl,ah   ; skip count
        and dl,0Fh  ; mask jump index
        sub edi,ecx ; skip empty pixels
        mov cl,al   ; dword count bit 7..4
        shr eax,16  ; data into lower word
        jmp  [edx*4+offset RETable] ; go to packet decoder
        endm
      
reblast macro  @lup,@laap
@lup:   lodsd
        xchg al,ah
        sub edi,4
        rol eax,16
        xchg al,ah
        dec ecx
        mov [edi],eax
        je @laap
        lodsd
        xchg al,ah
        sub edi,4
        rol eax,16
        xchg al,ah
        dec ecx
        mov [edi],eax
        jne @lup
@laap:
        endm
        
rncrunch macro
        ; newline & decode next packet
        lodsd
        mov cl,ah
        lea edi,[ebx+ebp*1] ;newline
        mov dl,al
        sub edi,ecx
        and dl,0Fh
        mov cl,al
        add ebx,ebp  ; perform newline on "line start" pointer
        shr eax,16
        jmp [edx*4+ offset RETable] ; perform blit
        endm
        
rmovsb macro
        mov [edi-1],al
        dec edi
       endm
       
rmovsw macro
        sub edi,2
        xchg al,ah
        mov [edi],ax
       endm       
       
rmovsbw macro
        sub edi,3
        xchg al,al
        mov dl,[esi]
        mov [edi+1],ax
        mov [edi],dl
       endm

ervsb macro
        mov [edi-1],al
        shr ecx,4
        dec edi
       endm
       
ervsw macro
        sub edi,2
        xchg al,ah
        shr ecx,4
        mov [edi],ax
       endm       
       
ervsbw macro
        sub edi,3
        xchg al,al
        mov dl,[esi]
        shr ecx,4
        mov [edi+1],ax
        mov [edi],dl
       endm
        


RH001: rmovsb
       rcrunch
RH002: rmovsw 
       rcrunch
RH003: rmovsbw
       rcrunch
      
RH010: shr ecx,4
       reblast  a0,aa0
       rcrunch

RH011: ervsb
       reblast  a1,aa1
       rcrunch

RH012: ervsw
       reblast  a2,aa2
       rcrunch

RH013: ervsbw
       reblast  a3,aa3
       rcrunch
      
RH100:  sub esi,3 ; no [incr] field present
        rncrunch
      
RH101: rmovsb             
       rncrunch

RH102: rmovsw 
       rncrunch

RH103: rmovsbw
       rncrunch
      
RH110: shr ecx,4
       reblast   a4,aa4
       rncrunch      
RH111: ervsb
       reblast   a5,aa5
       rncrunch
RH112: ervsw
       reblast   a6,aa6
       rncrunch
RH113: ervsbw
       reblast   a7,aa7
       rncrunch
       
       align dword
RETable: dd offset  H000, offset RH001, offset RH002, offset RH003
         dd offset RH010, offset RH011, offset RH012, offset RH013    
         dd offset RH100, offset RH101, offset RH102, offset RH103
         dd offset RH110, offset RH111, offset RH112, offset RH113
       align byte  
       

            
;-----------------------END OF RLE BLIT CODE------------------------

        public _PutSpt
        
_PutSpt:
        ; edi = scr dest
        ; esi = encoded sprite pic ptr
        ; eax =  x in pixels
        ; edx =  y in pixels
        ; bl  =  drawing flags
        pushad
        add edi,[edx*4+_RowStart]
        xor ecx,ecx
        mov ebp,_ScrX
        add edi,eax
        and ebx,LEFTRIGHT ;test bit and reset ebx
        jnz @esleftright
@esnorm:
        add esi,4
        mov ebx,edi  ; set line start
        xor edx,edx
        crunch

@esleftright:
        mov bx,[esi]  ;width
        add esi,4
        lea edi,[edi+ebx]  ; to end of line
        xor edx,edx
        mov ebx,edi
        rcrunch
        
        align dword
plane   dd 0
y       dd 0
yheight dd 0
x       dd 0
        align byte

NO_WAY  db 08   ; marker for "no smart newlines allowed"
       
        public _Pic2Spt
_Pic2Spt:
        ; converter from PIC bitmap format to SPT bitmap format        
        ; 
        ; ESI = pointer to PIC data
        ; EDI = pointer to buffer for SPT data
        ; returns:
        ;  ESI = end of PIC data
        ;  EDI = pointer to end of SPT bitmap data
        ;        If PIC data is too big, EDI is equal to its initial value +2
        push eax
        push ebx
        push ecx
        push edx
        push ebp
        mov ebx,0
        lodsd ; load, set into registers & store bitmap header
        stosd ;
        mov bx,ax
        shr eax,16
        xchg bx,ax
        shl eax,2   ; nudgets to pixels
        cmp eax,256 ; max 256 pixels wide
        jnbe the_end ; PIC too large for this bitmap compiler
        mov x,eax       ; store width for every plane
        mov yheight,ebx ; store line count
        jmp short comp_entry
newline:
        dec y        ;
        jne inplane  ; if NOT decoded last line, do not switch
        ; else switch plane
        mov byte ptr [edi],0 ; store a switch-plane packet
        inc edi              ;
        jmp the_end ; well, we can stop now.

        ; compile this picture
comp_entry:        
        mov eax,yheight       ; get line count
        mov ebx,offset NO_WAY ; lock smart-newlines
        mov y,eax       ; recharge line counter
inplane: ; compile this line
        mov ecx,x   ; reload width counter
        mov ebp,ebx ; store previous packet head position into ebp
skippy_mode:
        mov ebx,edi ; store packet head position
        mov edx,0     ; dh = pix skip counter , dl = pix blit counter
        add edi,2
skip:
        mov al,[esi]
        cmp al,0
        jne xburst
        ; skip this pixels
        inc esi ; to next pix
        inc dh  ; increase skip count
skipped1:        
        dec ecx
        jne skip ; skip if not end of PIC line
        ; END OF PIC LINE WHILE SKIPPING
        test byte ptr [ebp],8 ; had last packet a newline ?
        jnz no_nu
        ; No, we can stuff a newline there
        or byte ptr [ebp],08
        sub edi,2 ; move back this pointer
        jmp newline
no_nu:  ; Yes, it had a newline.
        ; We have to waste one byte
        mov byte ptr [ebx],8 ; newline packet
        dec edi ; we don't need the skip count for a simple newline
        jmp newline
        
burst:  mov al,[esi]
        cmp al,0
        je endburst ; test end of burst
xburst: ; burst of pixels to blit
        inc esi ; to next pix
        mov [edi],al ;store pix
        inc dl  ; increase pixel burst counter
        inc edi ; increase pointer
        dec ecx
        jne burst ; continue bursting pixels if not end ot PIC line
        ; end of line, compose burst packet + newline
        mov al,dl
        and al,3  ; select non-dword count bits
        or al,8   ; set newline bit
        cmp dl,4
        jb blit_d
        or al,4   ; set dword_data bit
blit_d:
        rol dl,2
        and dl,0F0h  ; position dword count into packet
        or dl,al
        mov [ebx],dx ; store packet head
        jmp newline        
endburst:
        ; end of pixel burst, store packet & restart skip counting
        inc esi
        ; compose burst packet without newline
        mov al,dl
        and al,3  ; select non-dword count bits
        ; no newline here, next "skip" can be stuffed here
        cmp dl,4
        jb dblit_d
        or al,4   ; set dword_data bit
dblit_d:
        rol dl,2
        and dl,0F0h  ; position dword count into packet
        or dl,al
        mov [ebx],dx ; store packet head
        
        mov ebp,ebx   ; set previous_packet pointer
        mov edx,0100h ; skip count is already 1
        mov ebx,edi   ; store packet head position
        add edi,2     ; increase data pointer
        jmp skipped1
the_end:
        pop ebp
        pop edx
        pop ecx
        pop ebx
        pop eax
        ret        
                
code32 ends

 END
