

; _Pix
; _Line
; _Block
; _Rectangle
; _ScrClr
        .386P
code32 segment para public use32
       assume cs:code32,ds:code32
NOJUMPS
NOSMART
include 386video.inc


        public _Pix
_Pix:
        ; edi= scr dest
        ; eax= x in pixels
        ; edx= y in pixels
        ; cl= color
        
        push edi 
        add edi,[edx*4+_RowStart]
        add edi,eax
        mov [edi],cl
        pop edi
	ret

; _Line drawing code starts here
;       the _Line routine is based on the Bresenham algorithm
;       with optimized vertical,horizontal and diagonal subcases

vline:  mov ebp,_ScrX
        add edi,[edx*4+_RowStart]
        sub edx,ebx
        jg yypos
        neg ebp
        neg edx
yypos:  mov eax,esi
vlinea: mov [edi],al
        add edi,ebp
        dec edx
        jne vlinea
        popad
        ret

hline:  mov ecx,eax
        mov eax,esi
        inc ecx
        shr ecx,1
        jnc nobyte
        stosb
nobyte: shr ecx,1
        jnc noword
        stosw
noword: jecxz gloom
        rep stosd
gloom:  popad
        ret
diagline:
        inc ebp ; increment x,y
diaglup:
        mov [edi],al
        add edi,ebp
        dec edx
        jne diaglup
        mov [edi],al
        popad
        ret

yline:  mov ebx,edx
        xchg esi,eax
        lea ecx,[edx+1] ; deltay +1
        neg edx ; initial accumulator
        shl ebx,1 ; recharge = deltay*2
xinc:   sub edx,ebx ; recharge
yinc:   mov [edi],al
        add edi,ebp ; newline
        dec ecx
        je end_y
        add edx,esi ; increment
        jl yinc
        inc edi
        jmp short xinc

end_t:  mov [edi+1],ax
end_b:  mov [edi],al
end_y:  popad
        ret
end_w:  mov [edi],ax
        popad
        ret
end_d:  mov [edi],eax
        popad
        ret

        public _Line
_Line:  ; edi =scr dest
        ; eax,edx = x1,y1    signed dwords!!!!!
        ; ecx,ebx = x2,y2
        ; esi = colour
        pushad
        add edi,eax
        mov ebp,_ScrX ;y increment
        ; x increment is always positive
        sub eax,ecx ; delta x
        je vline
        jg xpos
        sub edi,eax
        xchg edx,ebx
        neg eax
xpos:   add edi,[edx*4+_RowStart]
        sub edx,ebx ; delta y
        je hline
        jg ypos
        neg ebp
        neg edx
ypos:   cmp eax,edx
        je diagline ; deltax = deltay
        jl yline  ; y is indipendent var
        ; else x is indipendent var
xline:  mov ebx,eax
        lea ecx,[eax+1]  ; x pixels to blit
        xchg esi,eax
        ; edx = accumulator increment
        shl ebx,1 ; recharge = 2*deltax
        neg esi ; accumulator = -deltax
blitb:  dec ecx
        je end_b
        add esi,edx ;advance
        jge put_b
        dec ecx
        je end_w
        add esi,edx
        jge put_w
        dec ecx
        je end_t
        add esi,edx
        jge put_t
        dec ecx
        je end_d
        add esi,edx
        je put_d
        ; well, 4 dots in a row
        stosd
        jmp short blitb

put_b:  mov [edi],al
        sub esi,ebx ; recharge
        lea edi,[edi+ebp+1]
        jmp short blitb
put_w:  mov [edi],ax
        sub esi,ebx ; recharge
        lea edi,[edi+ebp+2]
        jmp short blitb
put_t:  mov [edi],ax
        mov [edi+2],al
        sub esi,ebx ; recharge
        lea edi,[edi+ebp+3]
        jmp short blitb
put_d:  mov [edi],eax
        sub esi,ebx ; recharge
        lea edi,[edi+ebp+4]
        jmp short blitb

; ==========================================================================
;
; BLOCK BLITTING FUNCTIONS
;
; ==========================================================================

        public _Block

_Block:
        ; blit a single color block on screen
        ;edi = screen base offset
        ;eax = x position in pixels
        ;edx = y position in pixels
        
        ;ecx = block width in nudgets
        ;ebx = block height in pixels
        ;esi = color pattern  (all 4 bytes are used)

        pushad
        
        add edi,eax                   ;
        add edi,[edx*4 + _RowStart]   ; edi = upper-left block corner
        
        mov edx,ecx       ;edx = x width in nudgets
        mov eax,esi
        shl ecx,2
        mov esi,_ScrX
        sub esi,ecx
@zblock:
        mov ecx,edx
        rep stosd ; ZOOM! Thundering speed!
        add edi,esi ; next line
        dec ebx
        jne @zblock
        
        popad
	ret


        public _ScrClr
_ScrClr:
        ; clears screen using the color contained into eax
        push ecx
        push edi
        mov ecx,_ScrSD
        mov edi,_ScrBase
        rep stosd
        pop edi
        pop ecx
        ret


        public _Rectangle

_Rectangle:
        ; blit a single color block on screen
        ;edi = screen base offset
        ;eax = x position in pixels
        ;edx = y position in pixels
        
        ;ecx = block width  in  pixels
        ;ebx = block height in pixels
        ;esi = color pattern  (only lower byte used)

        pushad
        
        add edi,eax                   ;
        add edi,[edx*4 + _RowStart]   ; edi = upper-left block corner
        
        mov edx,ecx       ;edx = x width in nudgets
        mov eax,esi
        mov esi,_ScrX
        sub esi,ecx
@zrec:
        mov ecx,edx
        rep stosb   ; ZOOM! Thundering speed!
        add edi,esi ; next line
        dec ebx
        jne @zrec
        
        popad
	ret

code32 ends

 END

