; 386POWER example program #1.

        .386p
code32 segment para public use32
       assume cs:code32,ds:code32

include 386power.inc
include 386video.inc
include 386keyb.inc
include 386timer.inc
include 386mouse.inc
include 386file.inc
include 386arg.inc
include pix.inc
include pcx.inc
include picture.inc
include chario.inc
include pattern.inc
include chtil.inc
include 386menu.inc

public  _Main
        align byte
Picture dd 0        
Sprite  dd 0
Pattern dd 0
MouPat  dd 0
MouN    dd 0
PatBase dd 0

Pcxname db  'TED.PCX',0
Fntname db  'CHARSET.CBF',0

Tilname  dd offset tilfname
tilfname db  'TILES.TBF',0

NumTiles dd 0  ; number of tiles loaded

flippy dd 0
tiky   dd 0

; map description structure
MAPPA dd (XTILES*YTILES*2) dup(0)

ShowBar:
        ; display "halved" patterns
        pushad
        mov ecx,NumTiles
        sub ecx,MouN
        cmp ecx,10
        jb fullh
        mov ecx,10
fullh:
        mov edi,_ScrBase
        mov esi,MouPat 
        mov eax,156+XBORDER
        mov edx,4+RYHEIGHT+YBORDER
hblit:        
        call _PutHPat
        add eax,16
        add esi,TILESIZE
        dec ecx
        jne hblit
        xor eax,eax
        mov edx,RYHEIGHT
        mov ecx,80
        mov ebx,SCOREBOARD
        call _TouchBlock
        popad
        ret
        
epcx    db 'No TED.PCX file found!',CR,LF,'$'
echar   db 'No GREEN.CBF font file found!',CR,LF,'$'
etile   db 'No TILES.TBF font file found!',CR,LF,'$'
mickey_off db 'Mouse Not Installed!',CR,LF,'$'

inputs  db 12 dup(0)
        
titlepcx  db 'Tiled Background Editor (press a key)',0

TouchAll db 0
test_header db 'T.E.D. menu test',0
test_bar    db 'this is a bar',0
test_int    db 'this is an int entry',0
test_uint   db 'this is an unsigned entry',0
test_key    db 'this is a key entry',0
test_end dd t0,t1,t2
t0       db 'Press ESC to exit this menu',0
t1       db 'use <- -> to inc/dec values',0
t2       db 'or ENTER to select values',0

exit_mn db 'press here to edit map',0
exit_sm db 'press here to exit submenu',0
skuzz  dd  20
skint  dd  0
skuint dd 12
flagg  dd 0
picka   dd 0
picktop= 5
picklist dd p0,p1,p2,p3,p4
test_pick db 'pick-list entry',0
test_flag db 'toggle this entry',0
test_string db 'string entry',0
test_submenu db 'enabled submenu entry',0
test_dsub    db 'disabled submenu entry',0
stringg db 11 dup(0)
kkeyy db 0
p0 db ' ULTRALASER  ',0
p1 db ' MACHINE GUN ',0
p2 db 'PLASMA CANNON',0
p3 db ' EMP CANNON  ',0
p4 db 'SWARM MISSILE',0

dumb_fn: clc ; make sure nothing will produce a full refresh
         ret
         align byte

menutest db M_HEADER,0,38,0
         dd test_header,0,0
         db M_EXIT,0,0,0
         dd exit_mn
         db M_PICK,0,20,13
         dd test_pick,picka,dumb_fn,picklist,picktop
         db M_TOGGLE,2,0,0
         dd test_flag,flagg,dumb_fn
         db M_STRING,0,20,10
         dd test_string,stringg,dumb_fn
         db M_KEY,0,20,0
         dd test_key,kkeyy,dumb_fn
         db M_MENU,0,0,0
         dd test_submenu,submenutest
         db M_MENU,0,0,1
         dd test_dsub,submenutest
         db M_END,1,3,0
         dd test_end

submenutest db M_HEADER,0,38,0
            dd test_header,0,0
            db M_EXIT,0,0,0
            dd exit_sm
            db M_BAR,0,18,10
            dd test_bar,skuzz,dumb_fn,0,200,5
            db M_INT,0,27,10
            dd test_int,skint,dumb_fn,-10000,10000,5
            db M_UNSIGNED,0,27,10
            dd test_uint,skuint,dumb_fn,0,10000,5
            db M_TOGGLE,2,0,0
            dd xvde,_XVDExternal,dumb_fn
            db M_TOGGLE,2,0,0
            dd xvdgd,_XVDGoodDriver,dumb_fn
            db M_TOGGLE,2,0,0
            dd xvdbg,_XVDBGood,dumb_fn
            db M_TOGGLE,2,0,0
            dd xvdcg,_XVDCGood,dumb_fn
            db M_END,1,3,0
            dd test_end

xvde  db 'external driver',0
xvdgd db 'is an xvd driver',0
xvdbg db 'bios ok',0
xvdcg db 'chipset ok',0

_Main:  sti ; enable interrupts and get running
        ; first of all initialize display driver
        mov _DispX,320
        mov _DispY,200
        mov _ScrX,(RXWIDTH+XBORDER)
        mov _ScrY,(VYHEIGHT+(YBORDER*2)+SCOREBOARD+1)
        call _SetXVDMode
        ; position the "view" window into the display buffer
        mov eax,XBORDER
        mov edx,YBORDER
        call _DisplayStart
        
        ; then install the "raw keyboard" driver
        call _KeybInst
        ; initialize COMMAND LINE OPTIONS SCANNER
        call _ArgInit
        
        ; load title screen 
        ; n.b. in ther upper left there is the "pointer" bitmap
        ;      the program will use to show the mouse position
        mov esi,offset Pcxname 
        call _PcxLoad          
        mov _386Return, offset epcx
        cmp _PcxDecoded,0
        je Bye
        call _PageFlip0 ; show image
        
        ; load character font file
        mov _386Return, offset echar
        mov esi,offset Fntname    ; load font into low memory
        call _LoadCharSet         ;
        jc Bye
        
        ; get the mouse cursor image from TED.PCX
        mov esi,_ScrBase
        mov eax,XBORDER
        mov edx,YBORDER
        mov ecx,4  ; 16 pixels = 4 nudget
        mov ebx,13 ; pixels
        mov edi,_LoMemBase
        mov Picture,edi
        call _GetPic
        ; compile it to TRLE bitmap format
        mov  Sprite,edi
        mov  esi,Picture
        call _Pic2Spt
        mov _LoMemBase,edi ; set new _LoMemBase
        
        mov edi,_LoMemBase
        mov _386Return,offset etile
        
        mov PatBase,edi         ; initialize tile control vars
        mov MouPat,edi          ; 
        mov MouN,0              ;
        
        call _ArgFile           ; check if there is a filename into the command
        cmp byte ptr [esi],0    ; line
        je no_tile_override
        mov Tilname,esi         ; default tile file
no_tile_override:        
        mov esi,Tilname         ; Load tile file
        call _LoFLoad           ;
        jc Bye
        mov edi,_LoMemBase      ;
        add edi,eax             ;
        mov _LoMemBase,eax      ;
        
        mov edx,0          ;  How many tiles loaded ?
        mov ebx,TILESIZE   ;
        div ebx            ;
        mov NumTiles,eax   ;
        
        ; initialize TILE MAP
        mov edi,offset MAPPA
        mov ecx,XTILES*YTILES
        mov eax,PatBase ; first pattern is always the "zero pattern"

        
minit:
        mov [edi],eax
        add edi,8
        dec ecx
        jne minit
        
        ; show program name
        mov edi,_ScrBase
        mov eax,XBORDER+2
        mov edx,2+RYHEIGHT+YBORDER
        mov ebx, offset titlepcx
        call _PutString
        call _PageFlip0
        push eax
        call _WaitKey ; here we wait a keypress
        pop eax
        ; set up mouse driver
        pushad
        mov esi,MAIN_MOUSE
        mov dword ptr [esi*4+ _MouseX1],0
        mov dword ptr [esi*4+ _MouseY1],0
        mov dword ptr [esi*4+ _MouseX2],304
        mov dword ptr [esi*4+ _MouseY2],169
        call _MouseReset
        mov _386Return,offset mickey_off
        cmp eax,0FFFFh
        je mickey_good
        jmp _Exit
mickey_good:
        popad

        mov eax,offset menutest
        call _PopMenu
        ; then turn on the timer handling module
        call _InstallTimer
remap:  
        mov edi,_ScrBase
        mov tiky,0
        mov flippy,0
        ; redraw a complete info bar
        mov eax,XBORDER
        mov edx,RYHEIGHT+YBORDER
        mov ecx,80
        mov ebx,SCOREBOARD
        mov esi,02020202h
        call _Block
        call ShowBar
        mov TouchAll,1
        xor edx,edx
        xor eax,eax
        mov esi,offset MAPPA
tiloop: 
        call _PutMap
        push esi
        mov esi,MAIN_MOUSE
        call _MouseRead
        pop esi

        mov ecx,0 ; xincr
        mov ebx,0 ; yincr
        cmp dword ptr _MouseX,2
        jae via
        mov ecx,-8
via:    cmp dword ptr _MouseX,302
        jb col
        mov ecx,8
col:    cmp dword ptr _MouseY,2
        jae vento
        mov ebx,-6
vento:  cmp dword ptr _MouseY,167
        jb film
        mov ebx,6
film:   
        pushad
        mov eax,_MouseX
        mov edx,_MouseY
        mov ecx,4  ; 16 dots wide = 4 dwords
        mov ebx,13 ; 13 dots tall
        call _TouchBlock
        
        add eax,XBORDER
        add edx,YBORDER
        mov esi,Sprite
        mov edi,_ScrBase
        mov ebx,0
        call _PutSpt
        ; now write mouse position
        mov eax,XBORDER+4
        mov edx,9+RYHEIGHT+YBORDER
        mov ebx,_MouseX
        mov ecx,8
        call _PutUnsigned
        add eax,72
        mov ebx,_MouseY
        call _PutUnsigned
        sub eax,XBORDER+72
        sub edx,YBORDER
        mov ecx,34
        mov ebx,8
        call _TouchBlock
        popad
        
        ; now select the page flipping method
        cmp TouchAll,0
        je tflip
        call _PageFlip0
        jmp short flipdone
tflip:
        call _PageFlip1
flipdone:
        mov TouchAll,0                
        
        ; now check if the current position has to be replaced with MouPat
        cmp dword ptr _Buttons,0
        je nomoupress
        pushad
        mov edi,_MouseX
        add eax,edi
        mov esi,_MouseY
        add edx,esi
        mov ecx,eax
        mov ebx,THEIGHT
        mov eax,edx ; y
        shr ecx,5  ; x/32
        mov edx,0
        div ebx
        ;eax = tile row
        mov edx,(XTILES*8)
        mov ebp,MouPat
        mul edx
        mov [eax+ecx*8+ offset MAPPA],ebp
        mov TouchAll,1
        popad
        
nomoupress:
        pushad
        or ecx,ebx
        jz nomoved
        mov TouchAll,1
nomoved:        
        shr eax,5
        mov edx,2+RYHEIGHT+YBORDER
        add eax,XBORDER+156
        mov edi,_ScrBase
        mov cl,0 ; clear pix
        call _Pix
        sub eax,XBORDER
        sub edx,YBORDER
        mov ecx,1
        mov ebx,1
        call _TouchBlock
        popad        
        
        ; change position
        add eax,ecx
        add edx,ebx
        ; check if it's a correct position
        cmp eax,(VXWIDTH-RXWIDTH)
        jl  dnx
        mov eax,(VXWIDTH-RXWIDTH)
        mov ecx,0
        jmp short okx
dnx:    cmp eax,0
        jg  okx
        mov eax,0
        mov ecx,0
okx:    
        cmp edx,(VYHEIGHT-RYHEIGHT)
        jl  dny
        mov edx,(VYHEIGHT-RYHEIGHT)
        mov ebx,0
        jmp short oky
dny:    cmp edx,0
        jg  oky
        mov edx,0
        mov ebx,0
oky:    
        pushad
        shr eax,5
        mov edx,2+RYHEIGHT+YBORDER
        add eax,XBORDER+156
        mov edi,_ScrBase
        mov cl,WHITE
        call _Pix  ;set pix
        sub eax,XBORDER
        sub edx,YBORDER
        mov ecx,1
        mov ebx,1
        call _TouchBlock
        cmp tiky,10
        jb goodtime
        mov tiky,0
        
        call _ReadTimer
        mov ebx,flippy
        mov flippy,eax
        sub eax,ebx
        jg zoks
        mov eax,1
zoks:   mov ebx,eax
        xor edx,edx
        mov eax,11931800
        div ebx
        mov ebx,eax
        mov eax,XBORDER+4
        mov edx,1+RYHEIGHT+YBORDER
        mov ecx,8
        call _PutUnsigned
        push edx
        push eax
        call _ReadTimer
        mov ebx,eax
        pop eax
        pop edx
        add eax,72
        call _PutUnsigned
        sub eax,XBORDER+72
        sub edx,YBORDER
        mov ecx,34
        mov ebx,8
        call _TouchBlock    
        
goodtime:        
        inc tiky
        popad
        
        push eax
        call _ScanKeyb
        mov edi,eax
        pop eax
        
        pushad
        cmp byte ptr [edi+_LEFT],KPRESSED ; has been pressed & released ?
        jne noleft
        mov byte ptr [edi+_LEFT],0 ; reset key
        cmp MouN,0
        je  noleft
        dec MouN
        sub MouPat,TILESIZE
        call ShowBar
        jmp short noright
noleft:
        cmp byte ptr [edi+_RIGHT],KPRESSED ; has been pressed & released ?
        jne noright
        mov byte ptr [edi+_RIGHT],0 ; reset key
        mov eax,NumTiles
        dec eax
        cmp eax,MouN
        jb  noright
        inc MouN
        add MouPat,TILESIZE
        call ShowBar        
noright:popad                

        cmp byte ptr [edi+_F2],KPRESSED
        je mapload
        
        cmp byte ptr [edi+_F3],KPRESSED
        je mapsave
        
        cmp byte ptr [edi+_ESC],KPRESSED
        jne tiloop
        call _RestoreTextMode
        mov _386Return,offset ESCed
Bye:        
        jmp _Exit

mapname db 31 dup(0)

ESCed db 'You pressed ESC to correctly terminate',CR,LF,'$'
load  db 'LOAD FILE?',0
save  db 'SAVE FILE?',0

gimmename:
        push ebx
        mov edi,_ScrBase
        mov eax,XBORDER
        mov edx,RYHEIGHT+YBORDER
        mov ecx,80
        mov ebx,SCOREBOARD
        mov esi,02020202h
        call _Block
        mov eax,XBORDER
        mov edx,4+RYHEIGHT+YBORDER
        pop ebx
        call _PutString
        call _PageFlip0
        mov ecx,30
        mov ebx,offset mapname
        mov eax,((10*8)+XBORDER)
        call _GetString
        call _PageFlip0
        ret
        
mapsave:
        mov byte ptr [edi+_F3],0
        pushad
sretry:        
        mov ebx,offset save
        call gimmename
        mov ecx,XTILES*YTILES
        mov ebx,PatBase
        mov esi,offset MAPPA
        mov edi,TILESIZE
indica:        
        mov eax,[esi]
        mov edx,0
        sub eax,ebx
        div edi
        mov [esi],eax
        add esi,8
        dec ecx
        jne indica
        
        mov eax,XTILES*YTILES*8
        mov edi,offset MAPPA
        mov esi, offset mapname
        call _FSave
        
        jc sretry ; if error, retry
        mov ecx,XTILES*YTILES
        mov ebx,PatBase
        mov esi,offset MAPPA
        mov edi,TILESIZE
punta:        
        mov eax,[esi]
        mul edi
        add eax,ebx
        mov [esi],eax
        add esi,8
        dec ecx
        jne punta
        popad
        jmp remap
        
errload db 'WRONG FILE, PRESS & RELEASE SPACE...',0

ferror: 
        mov edi,_ScrBase
        mov eax,XBORDER
        mov edx,RYHEIGHT+YBORDER
        mov ecx,80
        mov ebx,SCOREBOARD
        mov esi,02020202h
        call _Block
        mov eax,8+XBORDER
        mov edx,4+YBORDER+RYHEIGHT
        mov ebx, offset errload
        call _PutString
        call _PageFlip0
        push eax
        call _ScanKeyb
        mov edi,eax
        mov byte ptr [edi+ _SPACEBAR],0
        pop eax
waitspace:        
        push eax
        call _WaitKey
        mov edi,eax
        pop eax
        cmp byte ptr [edi+ _SPACEBAR],KPRESSED
        jne waitspace
        mov byte ptr [edi+ _SPACEBAR],0        
        popad
        jmp remap
        
mapload:
        mov byte ptr [edi+_F2],0
        pushad
lretry:        
        mov ebx,offset load
        call gimmename

        mov esi, offset mapname
        mov al,0 ; read from file
        call _FOpen
        jc ferror
        call _FSize
        cmp eax,XTILES*YTILES*8
        je okey
        call _FClose
        jmp ferror
okey:        
        mov eax,XTILES*YTILES*8
        mov edi,offset MAPPA
        call _FRead
        call _FClose
        mov ecx,XTILES*YTILES
        mov ebx,PatBase
        mov esi,offset MAPPA
        mov edi,TILESIZE
lpunta:        
        mov eax,[esi]
        mul edi
        add eax,ebx
        mov [esi],eax
        add esi,8
        dec ecx
        jne lpunta
nolretry:        
        popad
        jmp remap
        
code32  ends
        end

