______________________________________________________________________________

BIN8OUT

  Function: This routine accepts an 8-bit binary number in the DL register,
    converts it to ASCII binary form, and sends it to the standard output
    device.

  Input: Upon entry an 8-bit binary number is in the DL register.

  Output: A string of ASCII digits representing a binary number is sent out
    through the standard output device.

  Registers used: No registers are modified. DL is used for input.

  Routines called:  STDOUT
;-----------------------------------------------------------------------------
;Routine to convert from internal 8-bit binary to ASCII binary
;
BIN8OUT   PROC FAR
;
;A binary number is in DL
	  PUSH	 CX		       ;Save registers
	  PUSH	 AX
	  MOV	 CX,8		       ;Loop for a count of 8
BIN8OUT1:
	  ROL	 DL,1		       ;Rotate DL left once
	  MOV	 AL,DL		       ;Move into AL
	  AND	 AL,1		       ;Keep just digit
	  ADD	 AL,30H 	       ;Add 30H to AL
	  CALL	 STDOUT 	       ;Send it out
	  LOOP	 BIN8OUT1
	  POP	 AX		       ;Restore registers
	  POP	 CX
	  RET			       ;Return
BIN8OUT   ENDP

BIN16IN -- Convert from ASCII Binary to 16-bit Binary

  Function: This routine accepts a binary number from the standard input
    device and converts it to internal 16-bit binary form.

  Input: The individual digits of the binary number are received in ASCII
    through a call to a standard I/O routine.  The valid digits are 0 and 1.
    An ASCII code other than for a valid digit will terminatete the routine.

  Output: A 16-bit binary number is returned in the DX register.

  Registers used: Only DX is modified.  It returns the result.

  Routines called: STDIN
;
;Routine to convert from ASCII binary to internal 16-bit binary
;
BIN16IN   PROC	 FAR
	  PUSH	 AX		       ;Save registers
 	  MOV	 DX,0		       ;Initialize DX as 0
BIN16IN1:
	  CALL	 STDIN		       ;Digit comes in through AL
	  SUB	 AL,30H 	       ;Subtract 30H
	  JL	 BIN16IN2	       ;Check if too low
	  CMP	 AL,1
	  JG	 BIN16IN2	       ;Check if too high
	  CBW			       ;Convert to word
	  SAL	 DX,1		       ;Shift DX left once
	  ADD	 DX,AX		       ;Add in digit
	  JMP	 BIN16IN1
BIN16IN2:
	  POP	 AX		       ;Restore registers
	  RET			       ;Return
BIN16IN   ENDP
>----------------------------------------------------------------------- 

BIN16OUT

  Function: This routine accepts a 16-bit binary number in the DX register,
    converts it to ASCII binary form, and sends it to the standard output
    device.

  Input: Upon entry a 16-bit binary number is in the DX register.

  Output: A string of ASCII digits representing a binary number is sent out
    through the standard output device.

  Registers used: No registers are modified. DX is used for input.

  Routines called: STDOUT
;-----------------------------------------------------------------------------
;Routine to convert from internal 16-bit binary to ASCII binary
;
BIN16OUT  PROC	 FAR
;
;A binary number is in DX
	  PUSH	 CX		       ;Save registers
	  PUSH	 AX
	  MOV	 CX,16		       ;Loop for a count of 16
BIN16OUT1:
	  ROL	 DX,1		       ;Rotate DX left once
	  MOV	 AL,DL		       ;Move into AL
	  AND	 AL,1		       ;Keep just digit
	  ADD	 AL,30H 	       ;Add 30H to AL
	  CALL	 STDOUT 	       ;Send it out
	  LOOP	 BIN16OUT1
	  POP	 AX		       ;Restore registers
	  POP	 CX
	  RET			       ;Return
BIN16OUT  ENDP
