;Display byte as two hex digits.
; input: al = value
; output: hex displayed
; This magic was contributed by Mike levis
hexout:
	DB	0D4H,10H	;AAM 16
;        aam  10h
        call xxL
xxL:    xchg al, ah
        cmp  al, 0Ah
        sbb  al, 69h
        das
        int  29h
        ret
;--------------------------------
; display data byte as two hex ascii characters
;  inputs: al=data
;  output: registers ax,dx changed
;
; Note: This code was contributed by Jerzy 
_dbh:   mov     ah,0
        mov     dl,10h
        div     dl
        call    _dnh
        mov     al,dh
_dnh:   cmp     al,0Ah
        sbb     al,69h
        das
        xchg    ax,dx
        mov     ah,2
        int     21h
        ret
______________________________________________________________________________
; display data byte as two hex values
;  inputs: al=data
;  output: registers ax,dx changed
;
conv_byte:
	mov	dx,0210h
        sub     ah,ah           ;clear upper byte
        div     dl              ;divide binary data by 16
        call	xx
        mov     al,ah
xx:	cmp	al,0ah
	sbb	al,69h
	das
	xchg	ax,dx
	int	21h
	xchg	ax,dx
        ret
;********************************************************************

HEX8OUT

  Function:  This routine accepts an 8-bit binary number in the DL register,
    converts it to ASCII hexadecimal form and sends it to the standard output
    device.

  Input: Upon entry an 8-bit binary number is in the DL register.

  Output: A string of ASCII digits representing a hexadecimal number is sent
    out through the standard output device.

  Registers used: No registers are modified. DL is used for input.

  Routines called: STDOUT
;-----------------------------------------------------------------------------
;Routine to convert from internal 8-bit binary to ASCII hexadecimal
;
HEX8OUT   PROC	 FAR
;
;A binary number is in DL
	  PUSH	 CX		       ;Save registers
	  PUSH	 AX
	  MOV	 CX,2		       ;Loop for a count of 2
HEX8OUT1:
	  PUSH	 CX		       ;Save the count
	  MOV	 CL,4		       ;For a count of 4
	  ROL	 DL,CL		       ;Rotate DL left
	  MOV	 AL,DL		       ;Move into AL
	  AND	 AL,00FH	       ;Just digit
	  DAA			       ;Add 6 if A-F  DLP
	  ADD	 AL,0F0H	       ;Bump a carry if A-F
	  ADC	 AL,040H	       ;Here is the ASCII
	  CALL	 STDOUT 	       ;Send it out
	  POP	 CX
	  LOOP	 HEX8OUT1
	  POP	 AX		       ;Restore registers
	  POP	 CX
	  RET			       ;Return
HEX8OUT   ENDP
