;
;
; PROCEDURE: GET_TIME
;
; GET_TIME gets the current date and time and edits the value to ASCII
; characters and places the values in the date and time variables.
;
; INPUT:
;       None
;
; OUTPUT:
;       MONTH, MON, DOW, DAY, CENTURY, YEAR, HOUR, MINUTE, SECOND updated.
;
GET_TIME        PROC                    ;
;
; Save registers used.
;
                PUSH    AX              ;
                PUSH    CX              ;
                PUSH    DX              ;
;
; Get date and convert to ASCII.
;
                MOV     AH,DATE$        ;
                INT     DOS$            ; Get current date
                MOV     AH,3            ; Convert DOW to an index
                MUL     AH              ;
                MOV     DOW,AX          ;
;
; Convert date to MM DD CC YY format.
; Compute month table index.
;
                MOV     AL,DH           ; Month index
                DEC     AL              ; Start index at 0
                MOV     AH,3            ;
                MUL     AH              ;
                MOV     MON,AX          ;
                MOV     AL,DH           ; Do month
                CALL    BTD             ; Convert to ASCII
                MOV     MONTH,AX        ;
                MOV     AL,DL           ; Day
                CALL    BTD             ;
                MOV     DAY,AX          ;
                MOV     AX,CX           ; Year
                MOV     CL,100          ; Separate century
                DIV     CL              ;
                MOV     CL,AH           ; Save year
                CALL    BTD             ;
                MOV     CENTURY,AX      ; Century
                MOV     AL,CL           ; Year
                CALL    BTD             ;
                MOV     YEAR,AX         ;
;
; Get time and convert to hh mm ss.
;
                MOV     AH,TIME$        ;
                INT     DOS$            ; Get current time
                MOV     AL,CH           ; Hour
                CALL    BTD             ;
                MOV     HOUR,AX         ;
                MOV     AL,CL           ; Minutes
                CALL    BTD             ;
                MOV     MINUTE,AX       ;
                ADD     DX,256-50       ; Round up seconds
                MOV     AL,DH           ; Seconds
                CALL    BTD             ;
                MOV     SECOND,AX       ;
                POP     DX              ;
                POP     CX              ;
                POP     AX              ;
                RET                     ;
GET_TIME        ENDP                    ;
