;***********************  CONVERT *******************************
;============================================================================
display_char:	push	bx
		push	ax
		mov	ah,0eh			;tty display
		mov	bh,0			;page
		int	10h
		pop	ax
		pop	bx
		ret				
;-------------------------------------------------------------------------
; inputs al = binary
;
byte_to_decimal:
	push	ax
	aam			;convert byte to bcd
	or	ax,3030h	;add in ascii
	xchg	al,ah
	call	display_char
	xchg	al,ah
	call	display_char
	pop	ax
	ret  
  
;==========================================================================
;  inputs:  ax = binary value
;  outputs: none
;
;  registers destroyed:  ax,dx
;
  
display_binary:	xor	dx,dx
		div	cs:ten			;divide curent binary val by 10
		or	ax,ax			;check if done
		jz	db_display		;  jmp if done
		push	dx			;save remainder
		call	display_binary		;recursion
		pop	dx
db_display:	add	dl,30h			;convert char. to ascii
		mov	ah,2
		int	21h			;display char. in -dl-
		ret

;---------------------------------------------------------------------------
  
;==========================================================================
;  inputs:  dx,ax = binary value
;  outputs: none
;
;  registers destroyed:  ax,dx
;
  
ddisplay_binary:
		push	ax
		mov	ax,dx
		xor	dx,dx
		div	cs:ten
		mov	bx,ax
		pop	ax
		div	cs:ten
		xchg	bx,dx
;
; dx,ax = quotient
;    bx = remainder

		or	ax,ax
		jnz	dd_more
		or	dx,dx
		jnz	dd_more
		mov	dx,bx
		jmp	ddb_display
dd_more:
		push	bx			;save remainder		
	
		call	ddisplay_binary		;recursion
		pop	dx
ddb_display:	add	dl,30h			;convert char. to ascii
		mov	ah,2
		int	21h			;display char. in -dl-
		ret

;---------------------------------------------------------------------------
