	page	70,132
code_seg	segment
	assume	cs:code_seg,ds:code_seg
;------------------------------------------------------------------------
; abstract
;
; PRO will watch 4 areas of memory for activity.  The areas must have the
; same execution segent, and be contigious.  Results will be displayed
; on moncrome monitor at top while programs execute.  PRO must be
; loaded last to catch the execution segment at timer interrupt time.
;
; The variable DISPLAY_SEGMENT can be changed to b800 for color displays.
; The WATCH_SEGMENT can be changed to view a different segment.
; The variables WATCH_OFFSETn can be changed to select capture areas.
;
; Each WATCH_OFFSET selects the start of a capture area.  The variable
; WATCH_OFFSETX selects the end for all capture activity.
;
;--------------------------------------------------------------------
;
; The following makefile can be used to compile PRO.
;
;target:	pro.com
;		
;pro.COM:	pro.OBJ
;		tlink /x /v  pro
;
;pro.OBJ:	pro.ASM
;		tasm /zi pro
;--------------------------------------------------------------------
; variables and constants
;

watch_segment		dw	0d003h

watch_offset1		dw	00000h
hit1_cnt		dd	0		;counter1
watch_offset2		dw	00950h
hit2_cnt		dd	0		;counter2
watch_offset3		dw	009a2h
hit3_cnt		dd	0		;counter3
watch_offset4		dw	00a1dh
hit4_cnt		dd	0		;counter4
watch_offsetx		dw	01249h		;final offset
  
DISPLAY_LINE	db	80 dup (' '),0
DISPLAY_ATTRIBUTE	db	70h		;default = reverse video
DISPLAY_ADDRESS		label	dword
 DISPLAY_OFFSET        	dw	0		;offset of our window
 DISPLAY_SEGMENT	dw	0b800h		;display segment


TIMER_DS		dw	0		;ds save
TIMER_ES		dw	0		;es save
TIMER_AX		dw	0		;ax save
TIMER_BX		dw	0		;bx save
TIMER_CX		dw	0		;cx save
TIMER_DX		dw	0		;dx save
TIMER_SI		dw	0		;di save
TIMER_DI		dw	0		;di save
TIMER_BP		dw	0		;bp save

SS_SAVE			dw	0		;ss save (swap modes)
SP_SAVE			dw	0		;sp save (swap modes)
;
; stack structure at timer interrupt time
;
stk	struc
  exec_off	dw	?
  exec_seg	dw	?
  exec_flg	dw	?
stk	ends

;----------------------------------------------------------------------
; int 08 handler (timer)
;
JMP_TBL		DW	BIN1
		DW	BIN2
		DW	BIN3
		DW	BIN4
		DW	SHOW
		DW	RESTART
JMP_TBL_PTR	DW	JMP_TBL

our_int08:
	mov	cs:TIMER_DS,ds
	mov	cs:TIMER_AX,ax
	mov	cs:TIMER_ES,es
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	mov	TIMER_BX,bx
	mov	TIMER_CX,cx
	mov	TIMER_DX,dx
	mov	TIMER_SI,si
	mov	TIMER_DI,di
	mov	TIMER_BP,bp
;
; get the current execution point from the stack
;
	mov	bp,sp
	mov	ax,[bp.exec_seg]
	cmp	ax,watch_segment
	jne	build_display			;exit if wrong segment
	mov	ax,[bp.exec_off]
	cmp	ax,watch_offset1
	jb	build_display			;exit if out of range
	cmp	ax,watch_offset2
	jb	hit1				;jmp if hit found
	cmp	ax,watch_offset3
	jb	hit2
	cmp	ax,watch_offset4
	jb	hit3
	cmp	ax,watch_offsetx
	jb	hit4
	jmp	build_display			;jmp if out of range


hit1:	add	word ptr hit1_cnt,1
	jnc	build_display
	inc	word ptr hit1_cnt+2
	jmp	build_display
hit2:	add	word ptr hit2_cnt,1
	jnc	build_display
	inc	word ptr hit2_cnt+2
	jmp	build_display
hit3:	add	word ptr hit3_cnt,1
	jnc	build_display
	inc	word ptr hit3_cnt+2
	jmp	build_display
hit4:	add	word ptr hit4_cnt,1
	jnc	build_display
	inc	word ptr hit4_cnt+2
	jmp	build_display

build_display:
	mov	bx,JMP_TBL_PTR
	mov	ax,word ptr [bx]		;get next entry
	add	bx,2				;update
	mov	JMP_TBL_PTR,bx			;  jmp table pointer
	jmp	ax
;
; convert one counter to ascii and store in display buffer
;
bin1:	mov	si,(offset DISPLAY_LINE)+10
	mov	ax,word ptr hit1_cnt
	mov	dx,word ptr hit1_cnt+2
	call	dword_to_decimal_ascii
	jmp	timer_exit
;
; convert one counter to ascii and store in display buffer
;
bin2:	mov	si,(offset DISPLAY_LINE)+30
	mov	ax,word ptr hit2_cnt
	mov	dx,word ptr hit2_cnt+2
	call	dword_to_decimal_ascii
	jmp	timer_exit
;
; convert one counter to ascii and store in display buffer
;
bin3:	mov	si,(offset DISPLAY_LINE)+50
	mov	ax,word ptr hit3_cnt
	mov	dx,word ptr hit3_cnt+2
	call	dword_to_decimal_ascii
	jmp	timer_exit
;
; convert one counter to ascii and store in display buffer
;
bin4:	mov	si,(offset DISPLAY_LINE)+70
	mov	ax,word ptr hit4_cnt
	mov	dx,word ptr hit4_cnt+2
	call	dword_to_decimal_ascii
	jmp	timer_exit
	
show:
	mov	si,offset DISPLAY_LINE
	call	display_string
	jmp	timer_exit
	
restart:cld
	mov	di,offset DISPLAY_LINE
	mov	cx,80
	mov	al,' '
	rep	stosb				;clear display line
	
	mov	ax,offset jmp_tbl
	mov	jmp_tbl_ptr,ax
	
timer_exit:
	mov	bp,TIMER_BP
	mov	di,TIMER_DI
	mov	si,TIMER_SI
	mov	ax,TIMER_AX
	mov	bx,TIMER_BX
	mov	cx,TIMER_CX
	mov	dx,TIMER_DX
	mov	es,TIMER_ES
	mov	ds,TIMER_DS
	db	0eah			;jump far
bios_int08_offset	dw	0
bios_int08_segment	dw	0
;------------------------------------------------------------------------------
; subroutine to display a string terminated with a zero
;  inputs ds:si point at string
;        DISPLAY_ATTRIBUTE db 70h ;default = reverse video
;        DISPLAY_ADDRESS DD 0
;          DISPLAY_OFFSET	dw 0 ;offset of our window
;          DISPLAY_SEGMENT dw 0  ;display segment
;  outputs ds:si point at end of string
;
display_string:
	cld
	les	di,DISPLAY_ADDRESS
	mov	ah,DISPLAY_ATTRIBUTE
mono_string_loop:
	lodsb         			;get next char.
	or	al,al			;check for zero
	jz	mono_text_exit		;jump if end found
	stosw        			;move one char. to display
	jmp	short mono_string_loop	;jump if end not found yet
mono_text_exit:
	ret
;------------------------------------------------------------------------
; convert binary to decimal-ascii
;  inputs AX = binary
;         DS:SI = end of string area padded with blanks
;
binary_to_ascii:
	mov	bx,10
bin_to_asc_loop:
	cmp	ax,10
	jb	last_digit		;jump if done
	xor	dx,dx			;clear dx
	div	bx			;divide number by 10
	or	dl,30h			;convert remainder to ascii
	mov	[si],dl			;store ascii char.
	dec	si			;move towards front of string
	jmp	short bin_to_asc_loop	;loop till done
last_digit:
	or	al,30h			;form last ascii char.
	mov	[si],al			;store last ascii char.
	ret
;----------------------------------------
; binary dword to decimal ascii
;   inputs dx,ax = binary
;   ds:si points to end of stuff area
;
	public	dword_to_decimal_ascii
dword_to_decimal_ascii proc  near
	xchg	bp,dx
	mov	bx,10
	mov	cl,30h
aajj:	xchg	ax,bp
	sub	dx,dx
	div	bx
	xchg	bp,ax
	div	bx
	or	dl,cl
	mov	[si],dl
	dec	si
	cmp	ax,0
	jnz	aajj
	ret
dword_to_decimal_ascii	endp
;-----------------------------------------------------------------------
; subroutine to convert byte to hex ascii
;  inputs   AL  = hex
;         DS:SI = storage point
;
byte_to_hex_ascii:
	mov	ah,al			;save data for later
	and	al,0fh			;isolate low nibble
	add	al,'0'
	cmp	al,'9'
	jle	next_nibble		;jump if conversion ok
	add	al,'A'-'9'-1
next_nibble:
	xchg	ah,al
	shr	al,1			;right
	shr	al,1			;  justify
	shr	al,1			;     high
	shr	al,1			;        nibble
	add	al,'0'
	cmp	al,'9'
	jle	hex_store		;jump if conversion ok
	add	al,'A'-'9'-1
hex_store:
	mov	[si],ax
	add	si,2
	ret
;---------------------------------------------------------------------------
; subroutine to convert word to hex ascii
;  inputs   BX  = hex word
;         DS:SI = store pointer
;
word_to_hex_ascii:
	mov	al,bh			;get high byte
	call	byte_to_hex_ascii	;convert and store one byte
	mov	al,bl			;get low byte
	call	byte_to_hex_ascii	;convert and store one byte
	ret
;---------------------------------------------------------------------
; initialization
;
	assume	cs:code_seg,ds:code_seg
	
start:
; 
; display sign on 
; 
display_msg: 
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	
	mov	ah,9 
	mov	dx,offset SIGN_ON 
	int	21h 
;
; grab int08 vector (timer)
;
	sub	ax,ax
	mov	es,ax
	mov	bx,20h			;offset of int08
	mov	ax,es:[bx]		;get bios offset
	mov	bios_int08_offset,ax	;  and save
	mov	ax,es:[bx+2]		;get bios segment		
	mov	bios_int08_segment,ax	;  and save
	cli
	mov	word ptr es:[bx],offset our_int08 ;take over the
	mov	es:[bx+2],cs		 ;  vector
	sti

;
; exit but stay resident
;
	mov	dx,offset start		;compute pargraphs needed
	mov	cl,4
	shr	dx,cl
	add	dx,17			;add in PSP header size + extra
	mov	ax,3100h
	int	21h
	
sign_on	db	0dh,0ah,'PRO ' 

	db	' (Ver 1.03) installed - Written by Jeff Owens ' 
	db	0dh,0ah,'$'


code_seg	ends
		end	start
