
HEX16OUT

  Function: This routine accepts a 16-bit binary number in the DX register,
    converts it to ASCII hexadecimal form and sends it to the standard output
    device.

  Input: Upon entry a 16-bit binary number is in the DX register.

  Output: A string of ASCII digits representing a hexadecimal number is sent
    out through the standard output device.

  Registers used: No registers are modified. DX is used for input.

  Routines called: STDOUT
;------------------------------------------------------------------------------
;Routine to convert from internal 16-bit binary to ASCII hexadecimal
;
HEX16OUT  PROC FAR
;
;A binary number is in DX
	  PUSH	 CX		       ;Save registers
	  PUSH	 AX
	  MOV	 CX,4		       ;Loop for a count of 4
HEX16OUT1:
	  PUSH	 CX		       ;Save the count
	  MOV	 CL,4		       ;For a count of 4
	  ROL	 DX,CL		       ;Rotate DX left
	  MOV	 AL,DL		       ;Move into AL
	  AND	 AL,00Fh	       ;Just the digit
	  DAA			       ;Add 6 if A-F
	  ADD	 AL,0F0H	       ;Bump a carry if A-F
	  ADC	 AL,040H	       ;Here is the ASCII
	  CALL	 STDOUT 	       ;Send it out
	  POP	 CX
	  LOOP	 HEX16OUT1
	  POP	 AX		       ;Restore registers
	  POP	 CX
	  RET			       ;Return
HEX16OUT  ENDP
