#include "a:printf.h"
#include "a:stdio.h"
#include "as.h"

prcess()
{

/*

 OUTPUT:
       objwc   NUMBER OF WORDS REQUIRED FOR INSTRUCTION

       objbuf  TABLE OF WORDS GENERATED

       prflg   0       ERRORS DETECTED (PRINT LINE AS READ)
               1       NO ERRORS DETECTED (PRINT NORMALLY)
               2       DC.W / DC.L DIRECTIVES
               3       DONT PRINT LINE
               4       DC.B DIRECTIVE
               5       NAM / END / MON DIRECTIVES
               6       EQU / SET DIRECTIVES
               7       ORG / RORG DIRECTIVES
               8       DS DIRECTIVE
               9       PAGE DIRECTIVE

       newpc   NEW VALUE FOR PC

       op1ea   0       NOT REG OR IMMEDIATE DATA
               1       D REG
               2       A REG
               3       (AN)
               4       (AN)+
               5       -(AN)
               6       DATA
               7       SR
               8       CCR
               9       USP
               10      ERROR DETECTED

       imode   0       NO SIZE SPECIFIED (DEFAULT IS WORD)
               1       .B
               2       .W
               3       .L
               4       .S (SHORT BRANCH)

       ERRORS DEFINED...
       400     UNDEFINED OPCODE
       401     OPERAND MISSING FOR OPCODE
       402     LABEL ILLEGAL
       403     ERROR IN DC or ORG OPN VALUE
       406     GENERAL ERROR IN DECODING
       407     UNDEFINED SYMBOL
       408     ERROR IN SIZE OF Y(AX,RX) INDEX
       409     MULT DEFN SYMBOL
*/
	int	  i;
        unsigned  optyp,opidx,opskel,opsk2;

        /* SET UP FLAGS THAT CHANGE EACH TIME THRU */

        newpc = 0l;
	op1ea = op2ea = op1da = op2da = opnwc = 0;

        if (opclen == 0)  {
                symval = pc;
                newpc = 0l;

                if (label[0] == 0)
                        return;

                symtbl(2,symval,label);

                if (symflg[stind] & 8)
                        error(409);

                return;
        }

        /* decode opcode */

        if ((optyp = decopc(&opidx,&opskel,&opsk2)) == 0) {
                error(400);
                return;
        }

        /* skip if no operands */

        if (opnptr) {
                op1ea = eatyp(opnptr,&op1da);

                if (opnpt2)
                        op2ea = eatyp(opnpt2,&op2da);
        }

        /* check for operands */

        if (op1ea == 10 || op2ea == 10)
                where = 3;
        else {
                if (optyp == 1 || optyp == 2 || opnptr != 0)
        
                        /* DEFAULT SIZE IS ONE WORD FOR INSTRUCTIONS */

                        objwc = 1;
                else {
                        error(401);
                        return;
                }

/*
	goto opCODE EVALUATION ROUTINES VIA optyp
*/

                switch (optyp) {
                case 1:         where = pseudo(opidx);
                                break;
                case 2:         where = nop(opskel);
                                break;
                case 3:         where = move();
                                break;
                case 4:         where = add(opskel,opsk2);
                                break;
                case 5:         where = cmp(opskel,opsk2);
                                break;
                case 6:         where = andor(opskel,opsk2);
                                break;
                case 7:         where = eor(opskel,opsk2);
                                break;
                case 8:         where = rotate(opskel);
                                break;
                case 9:         where = branch(opskel);
                                break;
                case 10:        where = bitmod(opskel,opsk2);
                                break;
                case 11:        where = mult(opskel);
                                break;
                case 12:        where = sglea(opidx,opskel);
                                break;
                case 13:        where = decrbr(opskel);
                                break;
                case 14:        where = exg(opskel);
                                break;
                case 15:        where = ext(opidx,opskel);
                                break;
                case 16:        where = lea(opskel);
                                break;
                case 17:        where = link(opskel);
                                break;
                case 18:        where = trap(opskel);
                                break;
                case 19:        where = abcd(opskel);
                                break;
                case 20:        where = unlk(opskel);
                                break;
                case 21:        where = ldmstm(opskel);
                                break;
                case 22:        where = stop(opskel);
                                break;
                default:        where = 3;
                                break;
                }
        }

        switch (where) {
		case 4:
			return;
		case 3:					/* error detected */
			prflg = 0;
			for (i = 1; i <= objwc; ++i)  /* zero object buffer */
				objbuf[i] = 0;
			error(406);
		case 0:

                /*     HANDLE 'NORMAL' SIZE FIELD SPECIFICATIONS
                       USING INFORMATION FROM VARIABLE 'imode'
                
                       SIZE FIELD NORMALLY IS IN BITS 6 AND 7 OF
                       INSTRUCTION WITH THE FOLLOWING DEFINITION
                
                          00=.B  01=.W  10=.L
                
                       INSTRUCTIONS WITH imode=0 DEFAULT TO
                       A SIZE OF 'WORD'
                */

			if (!where) {
				switch (imode) {
					case 1:
						break;
					case 0:
					case 2:
						objbuf[1] |= 0x40;
						break;
					case 3:
						objbuf[1] |= 0x80;
						break;
				}
			}
		case 1:         /* PROCESS label FIELD */
				/* CURRENT PC VAL IS STORED AS SYMBOL VAL */
			symval = pc;
			newpc = (long)objwc * 2;
		case 2:
			if (label[0] == 0)
				return;

			symtbl(2,symval,label);

			if (symflg[stind] & 8)
				error(409);

			return;
	}
}


pseudo(opidx)
unsigned    opidx;
{

/*
	PROCESS PSEUDO opS

	PSEUDO opS NORMALLY DONT GENERATE CODE
	THE EXCEPTION BEING 'DC'
*/

        objwc = 0;
        switch (opidx) {
        case 1:         return psdc();
        case 2:         return psds();
        case 3:         return psorg();
        case 4:         return psend();
        case 5:         return psequ();
        case 6:         return psnam();
        case 7:         return psequ();
        case 8:         return psrorg();
        case 9:         return pspage();
        case 10:        return pslist();
        case 11:        return psnlst();
        default:        return 0;
        }
}

psdc()
{
	/* DC */

        int     right;

        right = 0;
        prflg = 2;
        iflg  = rflg;
        rflg  = 1;

        while (1) {
                procop(&opnptr);
                if (opnwc == 0) {
                        error(403);
                        break;
                }

                if (imode == 3) {
                        objbuf[++objwc] = opnwrd[3];
                        objbuf[++objwc] = opnwrd[2];
                }
                else if (imode == 1) {
                        if (right) {
                                objbuf[objwc] <<= 8;
                                objbuf[objwc] |= opnwrd[2];
                                right = 0;
                        }
                        else {
                                objbuf[++objwc] = opnwrd[2];
                                right = 1;
                        }
                }
                else
                        objbuf[++objwc] = opnwrd[2];

                if (objwc >= OBJMAX && !right) {
                        error(405);
                        break;
                }

                if (srclne[opnptr] != ',')
                        break;
                ++opnptr;
        }

        if (right)
                objbuf[objwc] <<= 8;

        rflg = iflg;
        return 1;
}


psds()
{
	/* DS */

        long    ltemp;

        prflg = 7;
        if (opnptr == 0)
                return 3;

        procop(&opnptr);
        if (opnwc == 7)  {
                error(403);
                return 4;
        }

        ltemp = asn(opnwrd[2],opnwrd[3]);
        if (imode == 1)
                newpc = ltemp;
        else
	if (imode != 3)
                newpc = 2l * ltemp;
        else
                newpc = 4l * ltemp;

        objbuf[2] = (unsigned)(pc & (long)0xffff);
        objbuf[3] = (unsigned)((pc >> 16) & (long)0xffff);
        symval = pc;
        return 2;
}


psorg()
{
	/* ORG */

        long    ltemp;

        if (label[0] != 0) {
                error(402);
                return 4;
        }

        rflg  = 1;
        prflg = 7;

        if (opnptr == 0) {
                newpc = pc = 0l;
                return 4;
        }

        procop(&opnptr);

        if (opnwc == 7) {
                error(403);
                return 4;
        }

        pc = 0l;
        ltemp = asn(opnwrd[2],opnwrd[3]);
        newpc = ltemp;

        if (endval == 0l)
                endval = ltemp;
        return 4;
}


psend()
{

	/* END <STARTING ADR> */

        iserr = TRUE;
        if (label[0] == 0) {
                prflg = 5;
                rflg  = 1;
                if (opnptr) {
                        procop(&opnptr);
                        if (opnwc == 7)
                                return 4;

                        endval = asn(opnwrd[2],opnwrd[3]);
                }
                return 4;
        }
        else {
                error(402);
                return 4;
        }
}


psequ()
{
	/* EQU */

        long    ltemp;

        if (label[0] == 0) {
                error(402);
                return 4;
        }

        prflg = 6;
        if (opnptr == 0)
                return 3;

        procop(&opnptr);

        if (opnwc == 7)
                return 4;

        ltemp = asn(opnwrd[2],opnwrd[3]);
        symtbl(2,ltemp,label);
        if (symflg[stind] & 8)
                error(409);

        symadr[stind] = asn(opnwrd[2],opnwrd[3]);
        objbuf[3] = opnwrd[3];
        objbuf[2] = opnwrd[2];
        symflg[stind] |= 16;
        return 4;
}


psrorg()
{
	/* RORG */

        if (label[0] != 0) {
                error(402);
                return 4;
        }

        prflg = 7;
        if (opnptr == 0) {
                newpc = pc = 0l;
                return 4;
        }

        rflg = 1;
        procop(&opnptr);
        if (opnwc == 7) {
                error(403);
                return 4;
        }

        rflg = 0;
	pc   = 0l;
        newpc = asn(opnwrd[2],opnwrd[3]);

        if (endval == 0l)
                endval = newpc;

        return 4;
}


pspage()
{
	/* PAGE */

        if (label[0] != 0) {
                error(402);
                return 4;
        }

        no_list = TRUE;
        prflg = 9;
        return 4;
}


pslist()
{
	/* LIST */

        if (label[0] != 0) {
                error(402);
                return 4;
        }

        no_list = FALSE;
        prflg = 5;
        return 4;
}


psnlst()
{
	/* NLIST */

        if (label[0] != 0) {
                error(402);
                return 4;
        }

        no_list = TRUE;
        prflg = 5;
        return 4;
}


psnam()
{
	/* NAM */

	int	i, n;

        prflg = 5;
        if (label[0] != 0) {
                error(402);
                return 4;
        }

        for (n = 0, i = opnptr; i < opnptr+8; ++n,++i) {
                name[n] = srclne[i];
                if (!srclne[i])
                        break;
        }

        name[n] = EOS;
        return 4;
}
