#include "a:printf.h"
#include "a:stdio.h"
#include "as.h"


nop(opskel)
unsigned    opskel;
{
	/* Process NOP */

        objbuf[1] = opskel;
        return 1;
}


move()
{

/*
       Process MOVE
       <EA>,<EA> SR,<EA> <EA>,CCR <EA>,SR USP,An An,USP
*/
        long    ltemp;

        /* look for obvious mistakes */

        if (op2ea == 6 || op1ea == 8 || (op1ea == 9 && op2ea != 2) ||
            (op1ea != 2 && op2ea == 9) || opnptr == 0 || opnpt2 == 0)
                return 3;

	/* USP,An */

        if (op1ea == 9) {
                objbuf[1] = 0x4e68 | op2da;
                return 1;
        }

	/* SR,<EA> */

	else
	if (op1ea == 7) {
                if (op2ea == 2)
                        return 3;

                if (op2ea != 0) {
                        objbuf[1] = 0x40C0 | op2da | ((op2ea - 1) * 8);
                        return 1;
                }

                procop(&opnpt2);
                objbuf[2] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[2] = opnwrd[3];
                        objbuf[3] = opnwrd[2];
                }

                objwc += opnwc;
                objbuf[1] = 0x4600 | opnwrd[1];
                return 1;
        }

        /* op1ea = 1 thru 5 */

        else
	if (op1ea >= 1 && op1ea <= 5) {

                /* Process EA types 0-5 for first operand */

                objbuf[1] = (((op1ea - 1) * 8) | op1da);
                return secop();
        }

        /* Process first operand here if complex */

        procop(&opnptr);

        /* check for EA types 7-9 */

        if (op2ea > 6) {
                if (op2ea == 7)
                        objbuf[1] = 0x46c0;
                else
		if (op2ea == 8)
                        objbuf[1] = 0x44c0;
                else
		if (op2ea == 9) {
                        objbuf[1] = 0x4e60 | op1da;
                        return 1;
                }

                if (op1ea == 0 || op1ea == 6) {
                        objbuf[1] |= opnwrd[1];
                        objbuf[2] = opnwrd[2];

                        if (imode == 3) {
                                objbuf[2] = opnwrd[3];
                                objbuf[3] = opnwrd[2];
                        }

                        objwc += opnwc;
                        return 1;
                }
                else
                        return 3;
        }

        /* Check for first operand immediate mode addressing */

        if ((op1ea == 6 && opnflg != 1 && imode == 3) &&
            (opnwrd[3] == 0 || opnwrd[3] == 0xffff)) {

                /* Check if value is within range for MOVEQ (+/- 128)	*/
                /* also check if destination is a data register		*/

                ltemp = asn(opnwrd[2],opnwrd[3]);
                if ((ltemp >= -128l && ltemp <= 127l) && (op2ea == 1)) {
                        objbuf[1] = (opnwrd[2] & 0xff) | 0x7000 | (op2da * 0x200);
                        return 1;
                }
        }

        /* add in opcode size bits */

        objbuf[1] |= 0x3000;

        if (imode == 1)
                objbuf[1] &= 0x1FFF;

        if (imode == 3)
                objbuf[1] &= 0x2FFF;

        /* move in numbers for 1st and 2nd ext words */

        objwc += opnwc;
        objbuf[2] = opnwrd[2];
        objbuf[1] = opnwrd[1];

        if (opnwc == 2) {
                objbuf[2] = opnwrd[3];
                objbuf[3] = opnwrd[2];
        }

        return secop();
}


secop()
{
	int	i, j;

        /* check for simple second operands */

        if (op2ea == 0) {

                /* calculate complex second operand */

                procop(&opnpt2);
                objbuf[objwc + 1] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[objwc + 2] = opnwrd[2];
                        objbuf[objwc + 1] = opnwrd[3];
                }

                objwc += opnwc;
                i = (opnwrd[1] & 7) * 8;
                j = (opnwrd[1] & 0x38) / 8;
                objbuf[1] = objbuf[1] | ((i + j) * 0x40) | 0x3000;

                /* add in the size bits */

                if (imode == 1)
                        objbuf[1] &= 0x1FFF;

                if (imode == 3)
                        objbuf[1] &= 0x2FFF;

                return 1;
        }

        /* check for SR,CCR,USP */

        else
	if (op2ea > 6) {
                if (op2ea == 7)
                        objbuf[1] = 0x46C0;

		if (op2ea == 8)
                        objbuf[1] = 0x44C0;

		if (op2ea == 9) {
                        objbuf[1] = 0x4E60 | op1da;
                        return 1;
                }

                /* get non-register EA'S if 0 or 6 */

                if (op1ea == 0 || op1ea == 6) {

                        /* handle stuff for EA'S 0 and 6 */

                        objbuf[1] |= opnwrd[1];
                        objbuf[2] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[2] = opnwrd[3];
                                objbuf[3] = opnwrd[2];
                        }

                        objwc += opnwc;

                        return 1;
                }
                else {
                        objbuf[1] = objbuf[1] | op1da | ((op1ea - 1) * 8);
                        return 1;
                }
        }

        /* process EA types 0-5 for second operand */

        else {
                objbuf[1] = objbuf[1] + (((op2ea - 1) | (op2da * 8)) * 0x40) | 0x3000;

                /* add in size bits */

                if (imode == 1)
                        objbuf[1] &= 0x1FFF;

                if (imode == 3)
                        objbuf[1] &= 0x2FFF;

                return 1;
        }
}


cmp(opskel,opsk2)
unsigned    opskel,opsk2;
{

/*
       process CMP
       <EA>,DN <EA>,AN DATA,<EA> (AY)+,(AX)+
*/

        if ((op1ea == 6) && (op2ea != 2)) {

                /* CMPI instruction */
                /* evaluate the immediate part */

                procop(&opnptr);
                objwc += opnwc;
                objbuf[2] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[2] = opnwrd[3];
                        objbuf[3] = opnwrd[2];
                }

                /* check for simple destination EA */

                if ((op2ea > 0) && (op2ea < 6)) {

                        /* second EA is not complex */

                        objbuf[1] = opsk2 | op2da | ((op2ea - 1) * 8);
                        return 0;
                }

                if (op2ea > 6)
                        return 3;

                procop(&opnpt2);
                objbuf[1] = opsk2 | (opnwrd[1] & 0x3F);
                objbuf[objwc + 1] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[objwc + 1] = opnwrd[3];
                        objbuf[objwc + 2] = opnwrd[2];
                }

                objwc += opnwc;

                return 0;
        }

        if ((op1ea == 5) && (op2ea == 5)) {

                /* CMPM (AY)+,(AX)+ */

                objbuf[1] = opskel + ((op2da * 0x200) + op1da);
                return 0;
        }

        if ((op2ea == 1) || (op2ea == 2)) {

                /* process <EA>,DN <EA>,AN */

                if (op2ea == 2 && imode == 1)
                        return 3;

                if (op2ea == 2)
                        if (imode == 3)
                                opskel |= 0x140;
                        else
                                opskel |= 0x80;

                if ((op1ea != 0) && (op1ea != 6)) {

                        /* process for REG operands */

                        objbuf[1] = opskel | (op2da * 0x200) |
                                        ((op1ea - 1) * 8) | op1da;

                        return 0;
                }

                /* process for complex 1st operands */

                procop(&opnptr);
                objbuf[1] = opskel | (op2da * 0x200) | (opnwrd[1] & 0x3F);
                objbuf[2] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[2] = opnwrd[3];
                        objbuf[3] = opnwrd[2];
                }

                objwc += opnwc;

                return 0;
        }

        return 3;
}


add(opskel,opsk2)
unsigned    opskel,opsk2;
{

/*
       process ADD,SUB
       <EA>,DN <EA>,AN DN,<EA> DATA,<EA>
*/

        if (op2ea == 2) {

                /* generate <EA>,AN */

                if (imode == 1)
			return 3;

                if (imode == 3)
			opskel |= 0x1c0;

                if ((imode == 2) || (imode == 0))
			opskel |= 0xc0;

                opskel |= (op2da * 0x200);

                if (op1ea == 6) {
                        procop(&opnptr);
                        if (opnflg == 1) {
                                objbuf[2] = opnwrd[2];

                                if (opnwc == 2) {
                                        objbuf[2] = opnwrd[3];
                                        objbuf[3] = opnwrd[2];
                                }

                                objwc += opnwc;
                                objbuf[1] = opskel | opnwrd[1];

                                return 0;
                        }

                        if (opnwrd[3] == 0 && opnwrd[2] >= 1 && opnwrd[2] <= 8) {
                                if (opnwrd[2] == 8)
					opnwrd[2] = 0;

                                if (opsk2 == 0x400)
					opsk2 = 0x5100;

                                if (opsk2 == 0x600)
					opsk2 = 0x5000;

                                opsk2 |= opnwrd[2] * 0x200;
                                objbuf[1] = opsk2 | ((op2ea - 1) * 8) | op2da;

                                return 0;
                        }

                        objbuf[2] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[2] = opnwrd[3];
                                objbuf[3] = opnwrd[2];
                        }

                        objwc += opnwc;
                        objbuf[1] = opskel | opnwrd[1];

                        return 0;
                }

                if (op1ea == 0) {
                        procop(&opnptr);
                        objbuf[2] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[2] = opnwrd[3];
                                objbuf[3] = opnwrd[2];
                        }

                        objwc += opnwc;
                        objbuf[1] = opskel | opnwrd[1];

                        return 0;
                }

                objbuf[1] = opskel | ((op1ea - 1) * 8) | op1da;

                return 0;
        }

        if (op1ea == 6) {

                /* generate xxxI */

                if (op2ea > 6)
                        return 3;

                /* evaluate immediate expression */

                procop(&opnptr);

                /* try to generate the short form of instruction */
                /* after checking to see if operand was fwd ref  */

                if (opnflg == 1) {

                        /* generate extension words    */
                        /* length of operand depends   */
                        /* on the imode of instruction */

                        objbuf[2] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[2] = opnwrd[3];
                                objbuf[3] = opnwrd[2];
                        }

                        objwc += opnwc;

                        /* if destination thru REG evaluate it here */

                        if (op2ea != 0) {
                                objbuf[1] = opsk2 | ((op2ea - 1) * 8) | op2da;
                                return 0;
                        }

                        /* evaluate non-REG destination */

                        procop(&opnpt2);
                        objbuf[1] = opsk2 | opnwrd[1];
                        objbuf[objwc + 1] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[objwc + 1] = opnwrd[3];
                                objbuf[objwc + 2] = opnwrd[2];
                        }

                        objwc += opnwc;

                        return 0;
                }

                if (opnwrd[3] == 0 && opnwrd[2] >= 1 && opnwrd[2] <= 8) {

                        /* generate xxxQ */

                        if (opnwrd[2] == 8)
				opnwrd[2] = 0;

                        if (opsk2 == 0x400)
				opsk2 = 0x5100;

                        if (opsk2 == 0x600)
				opsk2 = 0x5000;

                        opsk2 |= (opnwrd[2]*0x200);
                }
                else {
                        objbuf[2] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[2] = opnwrd[3];
                                objbuf[3] = opnwrd[2];
                        }

                        objwc += opnwc;
                }

                if (op2ea != 0) {
                        objbuf[1] = opsk2 | ((op2ea - 1) * 8) | op2da;
                        return 0;
                }

                /* evaluate non-REG destination */

                procop(&opnpt2);
                objbuf[1] = opsk2 | opnwrd[1];
                objbuf[objwc + 1] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[objwc + 1] = opnwrd[3];
                        objbuf[objwc + 2] = opnwrd[2];
                }

                objwc += opnwc;

                return 0;
        }

        if (op1ea == 1 || op2ea == 1) {
                if (op2ea != 1) {
                        opskel |= 0x100;

                        /* generate DN,<EA> */

                        opskel |= (op1da * 0x200);

                        if (op2ea != 0) {
                                objbuf[1] = opskel | ((op2ea - 1) * 8) | op2da;
                                return 0;
                        }

                        procop(&opnpt2);
                        objbuf[2] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[2] = opnwrd[3];
                                objbuf[3] = opnwrd[2];
                        }

                        objwc += opnwc;
                        objbuf[1] = opskel | opnwrd[1];

                        return 0;
                }

                /* generate <EA>,DN */

                opskel |= (op2da * 0x200);

                if (op1ea == 0) {
                        procop(&opnptr);
                        objbuf[2] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[2] = opnwrd[3];
                                objbuf[3] = opnwrd[2];
                        }

                        objwc += opnwc;
                        objbuf[1] = opskel | opnwrd[1];
                        return 0;
                }

                objbuf[1] = opskel | ((op1ea - 1) * 8) | op1da;

                return 0;
        }

        return 3;
}
