PAGE 60,132 ;
TITLE BASIC SUBROUTINE : DSK(A,B)
;------------------------------------------------------
;
; Returns the number of free sectors on a disk.
; Called form BASIC. Used with a PC-TALK patch.
;
;------------------------------------------------------

.RADIX 16
	;BASIC machine lang. subroutine: CALL DSK(A,B)
	;A=Drive to check- 0,1,2 or 3.	0=default drv, 1=A:, etc.
	;B=# of free sectors (returned).
	;Jack Wright  Nov 1983
CSEG	SEGMENT PARA PUBLIC 'CODE'
	ASSUME CS:CSEG
	PUBLIC DSK
	;DS=ES=SS=default DEF SEG (BASIC's data segment)
	;All seg. regs. & SP must be saved & restored.
	;BIOS interrupts preserve all seg. regs. & BX,CX,DX.
	;DOS 2.0
	ORG	100
DSK	PROC	FAR
	PUSH	BP
	MOV	BP,SP
	MOV	SI,[BP+08]	;Addr. of arg. A->SI.
	MOV	DX,[SI] 	;A->DX (A=drive # to check)
	CLI			;Disable maskable interrupts
	MOV	AX,CS
	MOV	SS,AX		;Set up new stack for INT 21 s
	MOV	SP,100
	STI
	MOV	AH,36		;DL=drive to check
	INT	21		;Returns AX=# of sectors/alloc. unit,
	MUL	BX		;BX=# of avail. alloc. units
				;after MUL, DX,AX=no. of avail. sectors
	CLI
	MOV	BX,ES		;SS was saved in ES
	MOV	SS,BX
	MOV	SP,BP		;SP was saved in BP
	STI
	;Must restore SS (above) before checking [BP+06] (below):
	MOV	DI,[BP+06]	;Point DI to B
	MOV	[DI],AX 	;Transfer AX to last arg. (B)
EXIT:	POP	BP
	RET	4
DSK	ENDP
CSEG	ENDS
	END	DSK ;
