
;---------------------------------------------------------------
;
; Scroll the screen by telling the 6845 that the screen
; begins a line later.
;
;  FUNCTION:
;		This is a test program, which scrolls the screen
;
;  Author: Malcolm McCorquodale III.  Summer 1983.
;	   3470 Locke Lane
;	   Houston, Texas 77027
;	   713 - 626 - 4979
; Copyright 1983.
;
;---------------------------------------------------------------
	PAGE	,132
DATA	SEGMENT AT 40H
	org	4ah
CRT_COLS	DW	?
	org	4eh
CRT_START	DW	?
	org	50h
CURSOR_POSN	DW	8 DUP(?)
	org	63h
ADDR_6845	DW	?
DATA	ENDS

CODE	SEGMENT 'CODE'
	ASSUME	CS:CODE,DS:DATA

MAIN	PROC	FAR
	PUSH	DS	; DOS linkage.
	XOR	AX,AX
	PUSH	AX
	MOV	AX,DATA    ; Establish addressibility for low memory.
	MOV	DS,AX
	MOV	CX,10
LP:
	PUSH	CX
	CALL	SCROLL
	POP	CX
	LOOP	LP

	RET
MAIN	ENDP

;------------------------------------------------------------------------
;
; This routine outputs the CX register to the 6845
; registers at [AH] and [AH+1].
;
;------------------------------------------------------------------------
OUTPUT_TO_6845	PROC	NEAR
	MOV	DX,ADDR_6845	; Address of 6845 Address register to DX.
	MOV	AL,AH		; Get register number into AL.
	OUT	DX,AL		; Tell 6845 what register to write to.

	INC	DX		; Point to Data Register
	MOV	AL,CH		; Output <CH> to 6845 register addressed
	OUT	DX,AL		;    by DX.

	DEC	DX
	MOV	AL,AH
	INC	AL		; Point to other data register.
	OUT	DX,AL		; Tell 6845 what register to write to.

	INC	DX		; Point to data register.
	MOV	AL,CL		; Output <CL> to register addressed
	OUT	DX,AL		;    by DX.

	RET
OUTPUT_TO_6845	ENDP

;------------------------------------------------------------------------
;
; Set cursor position,
; INPUT: AX has ROW/COLUMN for cursor.
;
;------------------------------------------------------------------------
SET_CURSOR	PROC	NEAR
	MOV	CX,AX		; Save Row / Col.
	MOV	AL,AH
	MUL	BYTE PTR CRT_COLS	; Determine bytes per row.
	XOR	CH,CH		; Zap 'saved' rows.
	ADD	CX,AX		; Add in column value.
	SHR	CX,1		; *2 for attribute bytes.
	ADD	CX,CRT_START	; Add offset to begining of screen to offset
				;   into screen.
	SAR	CX,1		; /2 for attribute bytes.
	MOV	AH,14
	CALL	OUTPUT_TO_6845
	RET
SET_CURSOR	ENDP

;----------------------------------------------------------------
; SCROLL
;	This routine scrolls the screen by telling the 6845 that the
;	screen begins a line later.
; INPUT
;	None.
; OUTPUT
;	The 6845 is reset to display a new page starting one line
;	later.
;------------------------------------------------------------------------
SCROLL	PROC	NEAR

	MOV	AX,CRT_START	; Get start of screen.
	ADD	AX,CRT_COLS	; Increment by number of columns.
	MOV	CRT_START,AX	; Save screen start address.
	SAR	CX,1		; Divide columns by 2 for 6845 handling.
	MOV	AH,12		; 6845 register 12 = start address.
	CALL	OUTPUT_TO_6845	; Output screen starting address to 6845.

	MOV	AX,[OFFSET CURSOR_POSN]     ; Get cursor for this page.
	CALL	SET_CURSOR	; Set the cursor position.
	RET
SCROLL	ENDP
CODE	ENDS
	END
