
COMMENT^ *** CASE.COM *** Last Rev. 10/08/83 *** Vincent T. Bly ***
 -------------------------------------------------------------------
|								    |
| PURPOSE:  Provide a resident utility to aid assembly language     |
|	    programmers who wish to write their source code in	    |
|	    ALL CAPS and their comments in lower case.		    |
|								    |
| FUNCTION: Change the cursor shape to indicate the present state   |
|	    of the "Caps Lock" key (block cursor for caps lock and  |
|	    underline cursor for upper/lower case).		    |
|	    Shift to upper/lower case for comments whenever the ";" |
|	    key is pressed.					    |
|	    Shift to caps lock for source code whenever the "Enter" |
|	    key is pressed.					    |
|	    Toggle the ";"/"Enter" case switching off or on when-   |
|	    ever both shift keys are pressed simultaneously.	    |
|								    |
| TO USE:   From DOS, type CASE and press the "Enter" key.          |
|								    |
| NOTES:    This version works with either the color graphics or    |
|	    monochrome card.  The DOS utilities (DIR, DEBUG, etc.)  |
|	    do not turn off the cursor during printing.  If you     |
|	    find the effect with the block cursor objectionable,    |
|	    you can temporarily turn off the case switching by	    |
|	    pressing both shift keys simultaneously or you can	    |
|	    change the DWs defining the cursor shapes.		    |
|								    |
 -------------------------------------------------------------------^

INTERRUPTS	SEGMENT AT 00H	;*********** Interrupt vector table **
		ORG	09H*4
KB_INT		LABEL	DWORD		; keyboard hardware interrupt
		ORG	16H*4
KEYBRD_INT	LABEL	DWORD		; keyboard software interrupt
INTERRUPTS	ENDS

BIOS_DATA	SEGMENT AT 40H	;*********** BIOS data segment *******
		ORG	10H
EQUIP_FLAG	LABEL	WORD		; bits 4 & 5 indicate CRT board type
		ORG	17H
KYBD_FLAG	LABEL	BYTE		; primary keyboard status flag
		ORG	63H
ADDR_6845	LABEL	WORD		; port address of 6845 index register
BIOS_DATA	ENDS

CSEG		SEGMENT
		ORG	100H		; necessary for a .COM file
		ASSUME	CS:CSEG
START:		JMP	INITIALIZE	; jump to initilization routine
CAP_CURSOR_C	DW	0006H		; caps lock cursor type (color board)
CAP_CURSOR_M	DW	000BH		;     as above, for monochrome board
LOW_CURSOR_C	DW	0607H		; upper/lower case cursor type (color)
LOW_CURSOR_M	DW	0B0CH		;     as above, for monochrome board
ROM_KEY_INT	DD			; ROM keyb'rd hardware interrupt addr.
ROM_KYBD_IO	DD			; ROM keyb'rd software interrupt addr.
CASE_FLAG	DB	0FFH		; case switching flag (FF=on, 00=off)
OLD_KYF 	DB	040H		; old value of KYBD_FLAG



;===========================================================================;
@HARD_KYBD_INT	PROC	FAR		    ; Keyboard hardware interrupts  ;
		ASSUME CS:CSEG,DS:BIOS_DATA ; (09H) are re-vectored to here ;
		STI			    ;-------------------------------;
		PUSHF			; set-up to call like an interrupt
		CALL	ROM_KEY_INT	; call ROM BIOS, but return here
		PUSH	AX		; save regs
		PUSH	DS
		MOV	AX,BIOS_DATA	; point DS to BIOS data seg
		MOV	DS,AX
		MOV	AL,[KYBD_FLAG]	; get BIOS keyboard status flag
		CMP	AL,CS:[OLD_KYF] ; has status flag changed?
		JE	GO_BACK 	; if not, go back
		MOV	CS:[OLD_KYF],AL ; refresh old status flag value
		CALL	SET_CURSOR	; go set proper cursor type
		AND	AL,3		; mask all but shift keys
		CMP	AL,3		; check for both shift keys down
		JNE	GO_BACK 	; if not both shifts, skip toggle
		MOV	AL,CS:[CASE_FLAG] ; get case switch flag
		NOT	AL		; toggle flag
		MOV	CS:[CASE_FLAG],AL ; replace flag
GO_BACK:	POP	DS
		POP	AX
		IRET			; back to program
@HARD_KYBD_INT	ENDP

;============================================================================;
SET_CURSOR	PROC	NEAR	; Set cursor for uppr/lowr case or caps lock ;
		ASSUME	CS:CSEG,DS:BIOS_DATA ;-------------------------------;
		PUSH	AX		; save regs
		PUSH	BX
		PUSH	DX
		LEA	BX,LOW_CURSOR_C ; load upper/lower case cursor
		TEST	AL,40H		; is caps lock on?
		JZ	CHK_BOARD	; if not, go check board type
		LEA	BX,CAP_CURSOR_C ; load caps lock cursor
CHK_BOARD:	MOV	AX,EQUIP_FLAG	; get equipment flag
		AND	AX,30H		; isolate CRT board type bits
		CMP	AX,30H		; is it monochrome board?
		JNE	CG_SET		; if not, skip ahead
		ADD	BX,2		; bump BX to mono cursor type
CG_SET: 	MOV	BX,CS:[BX]	; get proper cursor into BX
		MOV	DX,ADDR_6845	; point to 6845 index reg
		MOV	AL,10D		; point to cursor start reg
		OUT	DX,AL		; select cursor start reg
		INC	DX		;     point to 6845 data reg
		MOV	AL,BH		;     data into AL
		OUT	DX,AL		;     data to cursor start reg
		DEC	DX		; point to 6845 index reg
		MOV	AL,11D		; point to cursor end reg
		OUT	DX,AL		; select cursor end reg
		INC	DX		;     point to 6845 data reg
		MOV	AL,BL		;     next data into AL
		OUT	DX,AL		;     data to cursor end reg
		POP	DX		; restore regs
		POP	BX
		POP	AX
		RET
SET_CURSOR	ENDP


;============================================================================;
@SOFT_KYBD_INT	PROC	FAR		     ; Keyboard software interrupts  ;
		ASSUME	CS:CSEG,DS:BIOS_DATA ; (16H) are re-vectored to here ;
		STI			     ;-------------------------------;
		OR	AH,AH		; is it wait for keyboard input?
		JZ	THIS_ROUTINE	; if so, do this routine
		JMP	ROM_KYBD_IO	; else go to ROM & back to caller
THIS_ROUTINE:	PUSHF			; set-up to CALL like an interrupt
		CALL	ROM_KYBD_IO	; call ROM BIOS, but return here
		PUSH	AX		; save caller's registers
		PUSH	DS		;	"
		TEST	CS:[CASE_FLAG],1 ; is case switching flag on?
		JZ	BACK_TO_CALLER	; if case flag off, skip the rest
		CMP	AL,";"          ; is the character a semicolon?
		JE	CAPS_OFF	; if so, go turn caps lock off
		CMP	AL,0DH		; is the character a carriage return?
		JE	CAPS_ON 	; if so, go turn caps lock on
BACK_TO_CALLER: POP	DS		; restore caller's registers
		POP	AX		;	"
		IRET			; return to the caller
;--- Toggle caps lock for ";" or "Enter" ----------------------------------
CAPS_ON:	STC			; set carry to indicate caps on
CAPS_OFF:	MOV	AX,BIOS_DATA	; point to BIOS data segment
		MOV	DS,AX
		MOV	AL,[KYBD_FLAG]	; get keyboard state flag
		JC	SET_ON		; if caps should be set on, skip ahead
		AND	AL,NOT 40H	; turn off caps lock
		JMP	REPLACE_FLAG
SET_ON: 	OR	AL,40H		; turn caps lock on
REPLACE_FLAG:	MOV	[KYBD_FLAG],AL	; replace keyboard state flag
		CALL	SET_CURSOR	; go set proper cursor type
		JMP	BACK_TO_CALLER
@SOFT_KYBD_INT	ENDP

;============================================================================;
INITIALIZE	PROC	NEAR		      ; Re-vector keyb'rd interrupts ;
		ASSUME	CS:CSEG,DS:INTERRUPTS ;------------------------------;
		MOV	AX,INTERRUPTS	; point to interrupt vector segment
		MOV	DS,AX
;--- Set intercept for software keyboard interrupt -------------------------
		MOV	AX,KEYBRD_INT	; save old keyboard interrupt vector
		MOV	ROM_KYBD_IO,AX
		MOV	AX,KEYBRD_INT[2]
		MOV	ROM_KYBD_IO[2],AX
		MOV	AX,OFFSET @SOFT_KYBD_INT ; reset keyboard interrupt
		MOV	KEYBRD_INT,AX	; vector to point to this routine
		MOV	KEYBRD_INT[2],CS
;--- Set intercept for hardware keyboard interrupt -------------------------
		MOV	AX,KB_INT	; save old keyboard interrupt vector
		MOV	ROM_KEY_INT,AX
		MOV	AX,KB_INT[2]
		MOV	ROM_KEY_INT[2],AX
		MOV	AX,OFFSET @HARD_KYBD_INT ; reset keyboard interrupt
		MOV	KB_INT,AX	; vector to point to this routine
		MOV	KB_INT[2],CS
		MOV	DX,OFFSET INITIALIZE ; point to end of resident code
		INT	27H		; terminate but stay resident
INITIALIZE	ENDP

CSEG		ENDS
		END	START
