         NAME      HELLO
         PAGE      55,132
         TITLE     'HELLO --- PRINT HELLO ON TERMINAL'
;
; HELLO UTILITY TO DEMONSTRATE VARIOUS PARTS
; OF A FUNCTIONAL ASSEMBLY LANGUAGE PROGRAM,
; USE OF SEGMENTS, AND A PC-DOS FUNCTION CALL.
;
; RAY DUNCAN, SEPTEMBER 1983
;
                             ;SHOW USE OF SOME EQUATES:
CR       EQU       0DH       ;ASCII CARRIAGE RETURN
LF       EQU       0AH       ;ASCII LINE FEED
                             ;
;
                             ;BEGIN THE "CODE" SEGMENT
                             ;CONTAINING EXECUTABLE
                             ;MACHINE CODE
CSEG     SEGMENT   PARA PUBLIC 'CODE'
;
         ASSUME    CS:CSEG,DS:DSEG,SS:STACK
;
PRINT    PROC      FAR       ;ACTUAL PROGRAM CODE
                             ;IS COMPLETELY CONTAINED
                             ;IN THE "PROCEDURE" NAMED
                             ;"PRINT".
                             ;
         PUSH      DS        ;SAVE DS:0000 ON STACK
         XOR       AX,AX     ;FOR FINAL EXIT TO PC-DOS.
         PUSH      AX
                             ;SET DATA SEGMENT REGISTER
                             ;TO POINT TO THE DATA SEGMENT
                             ;OF THIS PROGRAM, SO THAT THE
                             ;MESSAGE WE WANT TO PRINT IS
                             ;ADDRESSABLE.
         MOV       AX,SEG DSEG
         MOV       DS,AX
                             ;NOW PUT THE OFFSET OF THE
                             ;MESSAGE TEXT INTO DX,
         MOV       DX,OFFSET MESSAGE
                             ;NOW DS:DX SPECIFIES THE
                             ;FULL ADDRESS OF THE MESSAGE.
         MOV       AH,9      ;USE THE PC-DOS FUNCTION 9
         INT       21H       ;TO PRINT THE STRING.
                             ;
         RET                 ;NOW RETURN TO PC-DOS USING
                             ;THE ADDRESSES WE PUSHED ON
                             ;THE STACK AT ENTRY.
                             ;
PRINT    ENDP                ;END OF THE "PROCEDURE"
                             ;NAMED "PRINT"
                             ;
CSEG     ENDS                ;END OF THE CODE SEGMENT
                             ;CONTAINING EXECUTABLE
                             ;PROGRAM.
                             ;
                             ;NOW WE DEFINE A DATA SEGMENT
                             ;CONTAINING OUR PROGRAM'S
                             ;CONSTANTS AND VARIABLES.
DSEG     SEGMENT   PARA 'DATA'
                             ;
MESSAGE  DB        CR,LF,'HELLO!',CR,LF,'$'
                             ;
DSEG     ENDS
                             ;
                             ;LASTLY, WE DEFINE A STACK
                             ;SEGMENT WHICH CONTAINS
                             ;A SCRATCH AREA OF MEMORY
                             ;FOR USE BY OUR PROGRAM'S STACK
STACK    SEGMENT   PARA STACK 'STACK'
                             ;ALLOW 64 BYTES IN THIS CASE
         DB        64 DUP (?)
                             ;
STACK    ENDS
                             ;THE FINAL "END" STATEMENT
                             ;SIGNALS THE END OF THIS
                             ;PROGRAM SOURCE FILE, AND GIVES
                             ;THE STARTING ADDRESS OF
                             ;THE EXECUTABLE PROGRAM
         END       PRINT
