		TITLE		STDBOOT
		PAGE		66,132
;-----------------------------------------------------------------------;
;									;
;		DEFINE IBMBIO ENTRY POINT FOR DOS 2.0 (FAR ENTRY)	;
;									;
;	DOS VERSION	IBMBIO ENTRY POINT				;
;	-----------	------------------				;
;									;
;	   1.1		SEGMENT AT 60H					;
;	   2.0		SEGMENT AT 70H					;
;									;
;-----------------------------------------------------------------------;
CSEG		SEGMENT 	AT 70H
BIOENT		LABEL		FAR
CSEG		ENDS
;-----------------------------------------------------------------------;
;									;
;		START OF THE CODE SEGMENT (BOOT RECORD) 		;
;									;
;-----------------------------------------------------------------------;
CODE		SEGMENT 	BYTE PUBLIC 'CODE'
		ASSUME		CS:CODE,DS:CODE,ES:CODE
;-----------------------------------------------------------------------;
;									;
;		INCLUDE BIOS MACROS					;
;									;
;-----------------------------------------------------------------------;
		INCLUDE 	BIOS.MAC
;-----------------------------------------------------------------------;
;									;
;		INCLUDE DOS STRUCTURES					;
;									;
;-----------------------------------------------------------------------;
		INCLUDE 	DOS.STR
		PAGE
;-----------------------------------------------------------------------;
;									;
;		DEFINE ALL THE EQUATES NEEDED BY THIS PROGRAM		;
;									;
;-----------------------------------------------------------------------;
LOAD_OFFSET	EQU		7C00H		;LOAD OFFSET
ATTR_PAGE	EQU		0007H		;ATTRIBUTE BYTE AND PAGE NUMBER
PARITY_MASK	EQU		7FH		;PARITY MASK
WRITE_TTY	EQU		0EH		;BIOS WRITE TTY CODE
WAIT_KEY	EQU		00H		;BIOS WAIT FOR KEY CODE
CRLF		EQU		0A0DH		;CARRIAGE RETURN, LINE FEED
TERM		EQU		00H		;MESSAGE TERMINATOR
READ_CODE	EQU		02H		;BIOS READ DISK COMMAND CODE
READ_COMMAND	EQU		0201H		;READ ONE SECTOR COMMAND
LEN		EQU		0BH		;FILENAME LENGTH (PLUS EXT.)
CONVERT 	EQU		20H		;CONVERSION BYTE
MSG_PTR 	EQU		BYTE PTR [SI]	;MESSAGE POINTER
BIO_PTR 	EQU		BYTE PTR [DI]	;IBMBIO POINTER
DOS_PTR 	EQU		BYTE PTR [DI+32];IBMDOS POINTER
DISK_SEGMENT	EQU		7AH		;DISK TABLE SEGMENT POINTER
DISK_OFFSET	EQU		78H		;DISK TABLE OFFSET POINTER
ENTRY_SIZE	EQU		20H		;DIRECTORY ENTRY SIZE (BYTES)
ROUND_DIR	EQU		1FFH		;ROUND UP VALUE FOR DIR. SIZE
NUM_BYTES	EQU		200H		;BYTES PER SECTOR
DIR_SEG 	EQU		50H		;DIRECTORY SEGMENT VALUE
DIR_OFF 	EQU		00H		;DIRECTORY OFFSET VALUE
DISK_MASK	EQU		03H		;DISK COUNT MASK
HARD_MASK	EQU		80H		;HARD DISK TEST MASK
SHIFT_COUNT	EQU		06H		;SHIFT COUNT
		PAGE
;-----------------------------------------------------------------------;
;									;
;		START OF THE BOOT RECORD				;
;									;
;-----------------------------------------------------------------------;
ENTRY		PROC		NEAR
;-----------------------------------------------------------------------;
;									;
;		SET UP JUMP TO START OF CODE AND OEM NAME AND VERSION	;
;									;
;	DOS VERSION	OEM NAME AND VERSION NUMBER			;
;	-----------	---------------------------			;
;									;
;	   1.1		IBM  1.1					;
;	   2.0		IBM  2.0					;
;									;	;									;
;-----------------------------------------------------------------------;
		JMP		START
DIR_OFFSET	EQU		$+LOAD_OFFSET
TRACK_NUMBER	EQU		$+5+LOAD_OFFSET
OEM		DB		"IBM  2.0"
		PAGE
;-----------------------------------------------------------------------;
;									;
;		SET UP THE BIOS PARAMETER BLOCK AND OPTION BLOCK FOR 2.0;
;									;
;	DOS VERSION	DISK FORMAT	BPB BLOCK			;
;	-----------	-----------	---------			;
;									;
;	   1.1		SINGLE SIDED	<512,1,1,2,64,320,0FEH,1>	;
;	   1.1		DOUBLE SIDED	<512,2,1,2,112,640,0FFH,1>	;
;	   2.0		SINGLE SIDED	<512,1,1,2,64,360,0FCH,2>	;
;	   2.0		DOUBLE SIDED	<512,2,1,2,112,720,0FDH,2>	;
;									;
;	DOS VERSION	DISK FORMAT	BPB OPTION BLOCK		;
;	-----------	-----------	----------------		;
;									;
;	   1.1		SINGLE SIDED	<8,1,0> 			;
;	   1.1		DOUBLE SIDED	<8,2,0> 			;
;	   2.0		SINGLE SIDED	<9,1,0> 			;
;	   2.0		DOUBLE SIDED	<9,2,0> 			;
;									;
;-----------------------------------------------------------------------;
BPB		EQU		$+LOAD_OFFSET
IBMBIO_OFFSET	EQU		$+8+LOAD_OFFSET
SECTOR_NUMBER	EQU		$+10+LOAD_OFFSET
		BPB_BLOCK	<512,2,1,2,112,720,0FDH,2>
OPT		EQU		$+LOAD_OFFSET
SECTORS 	EQU		BYTE PTR $+LOAD_OFFSET
		BPB_OPTION	<9,2,0>
		PAGE
;-----------------------------------------------------------------------;
;									;
;		SET UP DISK READ FROM, HEAD NUM., AND NUMBER OF SECTORS ;
;									;
;	DOS VERSION	SECTORS TO READ 				;
;	-----------	--------------- 				;
;									;
;	   1.1		14H (DECIMAL 20)				;
;	   2.0		0AH (DECIMAL 20)				;
;									;
;		NOTE - THE DISK READ FROM IS AS FOLLOWS:		;
;									;
;		       00H - 03H = FLOPPY DISK 0 - 3			;
;		       80H - 83H = HARD DISK 0 - 3			;
;									;
;-----------------------------------------------------------------------;
DISK_AND_HEAD	EQU		WORD PTR $+LOAD_OFFSET
DISK_READ_FROM	EQU		BYTE PTR $+LOAD_OFFSET
		DB		00H
HEAD_NUMBER	EQU		BYTE PTR $+LOAD_OFFSET
		DB		00H
NUM_SECTORS	EQU		BYTE PTR $+LOAD_OFFSET
		DB		0AH
;-----------------------------------------------------------------------;
;									;
;		SET UP THE DISK PARAMETER TABLE FOR 2.0 		;
;									;
;  DOS VERSION		    DISK PARAMETER TABLE			;
;  -----------		    --------------------			;
;									;
;     1.1		<0DFH,2H,25H,2H,8H,2AH,0FFH,50H,0F6H,0H,4H>	;
;     2.0		<0DFH,2H,25H,2H,9H,2AH,0FFH,50H,0F6H,0H,2H>	;
;									;
;-----------------------------------------------------------------------;
DISK_TABLE	EQU		$+LOAD_OFFSET
		DSK_PRM_TABLE	<0DFH,2H,25H,2H,9H,2AH,0FFH,50H,0F6H,0H,2H>
;-----------------------------------------------------------------------;
;									;
;		RE-TRY CODE (COME HERE TO RE-TRY THE BOOT)		;
;									;
;-----------------------------------------------------------------------;
RETRY		LABEL		NEAR
		BOOT
		PAGE
START		LABEL		NEAR
;-----------------------------------------------------------------------;
;									;
;		TURN OFF INTERRUPTS AND SET UP THE STACK		;
;									;
;-----------------------------------------------------------------------;
		CLI
		XOR		AX,AX
		MOV		SS,AX
		MOV		SP,LOAD_OFFSET
;-----------------------------------------------------------------------;
;									;
;		SET UP THE NEW DISK PARAMETER TABLE			;
;									;
;-----------------------------------------------------------------------;
		MOV		DS,AX
		MOV		[DS:DISK_SEGMENT],AX
		MOV		[DS:DISK_OFFSET],OFFSET DISK_TABLE
;-----------------------------------------------------------------------;
;									;
;		ALLOW INTERRUPTS AND RESET DISK SYSTEM, JUMP IF ERROR	;
;									;
;-----------------------------------------------------------------------;
		STI
		DISK
		JNC		RESET_OK
		JMP		BOOT_ERROR
		PAGE
;-----------------------------------------------------------------------;
;									;
;		COMPUTE NUMBER OF SECTORS USED BY THE FAT TABLES	;
;									;
;-----------------------------------------------------------------------;
RESET_OK	LABEL		NEAR
		PUSH		CS
		POP		DS
		MOV		AL,[DS:BPB].NUM_FATS
		CBW
		MUL		WORD PTR [DS:BPB].SECTORS_PER_FAT
;-----------------------------------------------------------------------;
;									;
;		ADD IN THE NUMBER OF HIDDEN AND RESERVED SECTORS	;
;									;
;-----------------------------------------------------------------------;
		ADD		AX,[DS:OPT].HIDDEN_SECTORS
		ADD		AX,[DS:BPB].RES_SECTORS
;-----------------------------------------------------------------------;
;									;
;		SAVE THE COMPUTED SECTOR OFFSET 			;
;									;
;-----------------------------------------------------------------------;
		MOV		[DS:DIR_OFFSET],AX
		MOV		[DS:IBMBIO_OFFSET],AX
;-----------------------------------------------------------------------;
;									;
;		COMPUTE DIRECTORY SIZE IN SECTORS			;
;									;
;-----------------------------------------------------------------------;
		MOV		AX,ENTRY_SIZE
		MUL		WORD PTR [DS:BPB].ROOT_DIR_ENTRIES
		ADD		AX,ROUND_DIR
		MOV		BX,NUM_BYTES
		DIV		BX
;-----------------------------------------------------------------------;
;									;
;		UPDATE THE SAVED OFFSET VALUE				;
;									;
;-----------------------------------------------------------------------;
		ADD		[DS:IBMBIO_OFFSET],AX
;-----------------------------------------------------------------------;
;									;
;		CALL ROUTINE TO CHECK FOR SYSTEM DISK, JUMP IF ERROR	;
;									;
;-----------------------------------------------------------------------;
		CALL		DISK_CHECK
		JC		RETRY
		PAGE
;-----------------------------------------------------------------------;
;									;
;		SET UP TO READ IBMBIO AND IBMDOS INTO MEMORY		;
;									;
;-----------------------------------------------------------------------;
		MOV		AX,[DS:IBMBIO_OFFSET]
		MOV		[DS:SAVE_OFFSET],AX
		MOV		AX,SEG BIOENT
		MOV		ES,AX
		MOV		DS,AX
		MOV		BX,OFFSET BIOENT
;-----------------------------------------------------------------------;
;									;
;		READ A SECTION INTO MEMORY (WHOLE OR PARTIAL TRACK)	;
;									;
;-----------------------------------------------------------------------;
READ_LOOP	LABEL		NEAR
		MOV		AX,[CS:IBMBIO_OFFSET]
		CALL		COMPUTE_ADDRESS
		MOV		AL,[CS:SECTORS]
		SUB		AL,[CS:SECTOR_NUMBER]
		INC		AL
		XOR		AH,AH
		PUSH		AX
		MOV		AH,READ_CODE
		CALL		READ_DISK
		POP		AX
		JC		BOOT_ERROR
;-----------------------------------------------------------------------;
;									;
;		CHECK FOR MORE LEFT TO READ, JUMP IF ALL READ IN	;
;									;
;-----------------------------------------------------------------------;
		SUB		[CS:NUM_SECTORS],AL
		JBE		READ_DONE
;-----------------------------------------------------------------------;
;									;
;		UPDATE SECTOR OFFSET AND TRANSFER OFFSET AND READ AGAIN ;
;									;
;-----------------------------------------------------------------------;
		ADD		[CS:IBMBIO_OFFSET],AX
		MUL		WORD PTR [CS:BPB].BYTES_PER_SECTOR
		ADD		BX,AX
		JMP		READ_LOOP
		PAGE
;-----------------------------------------------------------------------;
;									;
;		SET UP REGISTERS AS FOLLOWS AND JUMP TO IBMBIO		;
;									;
;		AX - IF 0 THEN FLOPPY BOOT, IF NOT 0 THEN HARD DISK BOOT;
;		BX - SECTOR OFFSET TO IBMBIO AND IBMDOS 		;
;		CX - NUMBER OF FLOPPY DRIVES (STILL 2 IF ONLY 1 DRIVE)	;
;									;
;-----------------------------------------------------------------------;
READ_DONE	LABEL		NEAR
		PUSH		CS
		POP		DS
		EQUIP
		ROL		AL,1
		ROL		AL,1
		AND		AX,DISK_MASK
		JNZ		MULTIPLE_DISK
		INC		AX
MULTIPLE_DISK	LABEL		NEAR
		INC		AX
		MOV		CX,AX
		TEST		BYTE PTR [DS:DISK_READ_FROM],HARD_MASK
		JNZ		HARD_DISK_BOOT
		XOR		AX,AX
HARD_DISK_BOOT	LABEL		NEAR
		MOV		BX,[DS:SAVE_OFFSET]
		JMP		BIOENT
		PAGE
;-----------------------------------------------------------------------;
;									;
;		BOOT ERROR ROUTINE, PRINT MESSAGE AND LOOP FOREVER	;
;									;
;-----------------------------------------------------------------------;
BOOT_ERROR	LABEL		NEAR
		MOV		SI,OFFSET MSG2
		CALL		PRINT_MESSAGE
DEAD_END	LABEL		NEAR
		JMP		DEAD_END
;-----------------------------------------------------------------------;
;									;
;		PRINT MESSAGE ROUTINE, PRINT MESSAGE AND RETURN 	;
;									;
;-----------------------------------------------------------------------;
PRINT_MESSAGE	LABEL		NEAR
		LODS		CS:MSG_PTR
		AND		AL,PARITY_MASK
		JZ		RETURN_INST
		MOV		AH,WRITE_TTY
		MOV		BX,ATTR_PAGE
		VIDEO
		JMP		PRINT_MESSAGE
;-----------------------------------------------------------------------;
;									;
;		ROUTINE TO CHECK FOR SYSTEM DISK, FIRST SET UP REGS.	;
;									;
;-----------------------------------------------------------------------;
DISK_CHECK	LABEL		NEAR
		MOV		AX,DIR_SEG
		MOV		ES,AX
		PUSH		CS
		POP		DS
;-----------------------------------------------------------------------;
;									;
;		GET SECTOR OFFSET TO DIRECTORY AND COMPUTE DISK ADDR.	;
;									;
;-----------------------------------------------------------------------;
		MOV		AX,[CS:DIR_OFFSET]
		CALL		COMPUTE_ADDRESS
;-----------------------------------------------------------------------;
;									;
;		READ IN FIRST SECTOR OF DIRECTORY, JUMP IF ERROR	;
;									;
;-----------------------------------------------------------------------;
		MOV		BX,DIR_OFF
		MOV		AX,READ_COMMAND
		CALL		READ_DISK
		JC		DISK_ERROR
		PAGE
;-----------------------------------------------------------------------;
;									;
;		CONVERT FIRST TO ENTRIES TO LOWERCASE WITH BLANKS	;
;									;
;-----------------------------------------------------------------------;
		XOR		DI,DI
		MOV		CX,LEN
CONVERSION_LOOP LABEL		NEAR
		OR		ES:BIO_PTR,CONVERT
		OR		ES:DOS_PTR,CONVERT
		INC		DI
		LOOP		CONVERSION_LOOP
;-----------------------------------------------------------------------;
;									;
;		CHECK FIRST ENTRY FOR IBMBIO, JUMP IF NO MATCH		;
;									;
;-----------------------------------------------------------------------;
		XOR		DI,DI
		MOV		SI,OFFSET IBMBIO
		MOV		CX,LEN
		CLD
		REPZ		CMPSB
		JNZ		DISK_ERROR
;-----------------------------------------------------------------------;
;									;
;		CHECK SECOND ENTRY FOR IBMDOS, JUMP IF NO MATCH 	;
;									;
;-----------------------------------------------------------------------;
		MOV		DI,ENTRY_SIZE
		MOV		SI,OFFSET IBMDOS
		MOV		CX,LEN
		REPZ		CMPSB
		JNZ		DISK_ERROR
RETURN_INST	LABEL		NEAR
		RET
		PAGE
;-----------------------------------------------------------------------;
;									;
;		DISK ERROR ROUTINE, PRINT MESSAGE AND WAIT FOR KEY	;
;									;
;-----------------------------------------------------------------------;
DISK_ERROR	LABEL		NEAR
		MOV		SI,OFFSET MSG1
		CALL		PRINT_MESSAGE
		MOV		AH,WAIT_KEY
		KEYBOARD
;-----------------------------------------------------------------------;
;									;
;		SET THE ERROR FLAG AND RETURN (WILL TRY TO REBOOT)	;
;									;
;-----------------------------------------------------------------------;
		STC
		RET
;-----------------------------------------------------------------------;
;									;
;		COMPUTE DISK ADDRESS ROUTINE, SET UP THE REGISTERS	;
;									;
;-----------------------------------------------------------------------;
COMPUTE_ADDRESS LABEL		NEAR
		PUSH		DS
		PUSH		CS
		POP		DS
		XOR		DX,DX
;-----------------------------------------------------------------------;
;									;
;		COMPUTE CYLINDER NUMBER WITH SECTOR REMAINDER		;
;									;
;-----------------------------------------------------------------------;
		DIV		[DS:OPT].SECTORS_PER_TRACK
		INC		DL
		MOV		[DS:SECTOR_NUMBER],DL
;-----------------------------------------------------------------------;
;									;
;		COMPUTE TRACK NUMBER WITH HEAD NUMBER REMAINDER 	;
;									;
;-----------------------------------------------------------------------;
		XOR		DX,DX
		DIV		[DS:OPT].NUMBER_OF_HEADS
		MOV		[DS:HEAD_NUMBER],DL
		MOV		[DS:TRACK_NUMBER],AX
;-----------------------------------------------------------------------;
;									;
;		RESTORE ORIGINAL DS REGISTER AND RETURN TO CALLER	;
;									;
;-----------------------------------------------------------------------;
		POP		DS
		RET
		PAGE
;-----------------------------------------------------------------------;
;									;
;		READ THE DISK ROUTINE, SET UP TRACK NUMBER		;
;									;
;-----------------------------------------------------------------------;
READ_DISK	LABEL		NEAR
		MOV		DX,[CS:TRACK_NUMBER]
		MOV		CL,SHIFT_COUNT
		SHL		DH,CL
;-----------------------------------------------------------------------;
;									;
;		SET UP THE SECTOR NUMBER				;
;									;
;-----------------------------------------------------------------------;
		OR		DH,[CS:SECTOR_NUMBER]
		MOV		CX,DX
		XCHG		CH,CL
;-----------------------------------------------------------------------;
;									;
;		SET UP HEAD AND DRIVE NUMBER THEN READ DISK AND RETURN	;
;									;
;-----------------------------------------------------------------------;
		MOV		DX,[CS:DISK_AND_HEAD]
		DISK
		RET
		PAGE
;-----------------------------------------------------------------------;
;									;
;		SET UP A SAVE AREA FOR IBMBIO OFFSET			;
;									;
;-----------------------------------------------------------------------;
SAVE_OFFSET	EQU		WORD PTR $+LOAD_OFFSET
		DW		0
MSG1		EQU		$+LOAD_OFFSET
		DW		CRLF
		DB		"Non-System disk or disk error"
		DW		CRLF
		DB		"Replace and strike any key when ready"
		DW		CRLF
		DB		TERM
MSG2		EQU		$+LOAD_OFFSET
		DW		CRLF
		DB		"Disk Boot failure"
		DW		CRLF
		DB		TERM
IBMBIO		EQU		$+LOAD_OFFSET
		DB		"ibmbio  com0"
IBMDOS		EQU		$+LOAD_OFFSET
		DB		"ibmdos  com0"
ENTRY		ENDP
CODE		ENDS
		END		ENTRY
