	PAGE	60,132
	TITLE	SWPTR - SWAP LPT1: AND LPT2: POINTERS
	COMMENT \

		COPYRIGHT 1983 by	Thomas M. Rowlett
					11296 Windsor Court
					Ijamsville, Maryland  21754
					(301) 831-9382

		This program exchanges the printer addresses for LPT1: and
		LPT2: in the BIOS Data Area (see page 3-7 of the IBM
		Personal Computer Technical Reference Manual for further
		information).

		This program is made available to all members of the Capital
		PC Users Group for their own personal use and not for resale
		in any manner.	The program may be modified and distributed
		but it is requested that the original copyright remain in the
		program.

		\
;
INTPTR	MACRO	PTRID			;Call to DOS to initialize the printer
	XOR	DX,DX			;Clear DX register
	MOV	DX,PTRID-1		;Setup printer ID in register DX
	MOV	AH,01H			;Set high-order byte of accumulator to
;					 initialize  the printer specified by DX
	INT	17H			;printer interrupt call to BIOS in ROM
;
	ENDM
;
PRINT	MACRO	MESSAGE
	MOV	DX,OFFSET MESSAGE	;pointer to message
	MOV	AH,09H			;set screen function
	INT	21H			;go to DOS
;
	ENDM
;
DATA	SEGMENT AT 40H
RS232	DW	4 DUP (?)		;ADDRESSES OF RS-232 POINTERS
LPT1	DW	?			;ADDRESS OF LPT1: POINTER
LPT2	DW	?			;ADDRESS OF LPT2: POINTER
DATA	ENDS
SUBTTL	MAIN PROGRAM SECTION
	PAGE
CSEG	SEGMENT PARA PUBLIC 'CODE'
START	PROC	FAR
	ASSUME	CS:CSEG,DS:CSEG,ES:DATA
	ORG	5DH			;ESTABLISH ADDRESS TO GET INPUT PARMS
PARM	DB	?			;PARM TO INSPECT SETTING
	ORG	100H			;BEGIN CODING SECTION
BEGIN:	MOV	AX,DATA 		;INITIALIZE 'ES' REGISTER
	MOV	ES,AX
;
	PRINT	MSG1			;PRINT INTRODUCTORY MESSAGE/HEADER
	MOV	AL,PARM 		;GET INPUT PARAMETER
	CMP	AL,'I'                  ;TEST FOR INSPECT
	JNE	SWAPTM			;GO TO SWAP THE POINTERS
	PRINT	MSG5			;PRINT INSPECT TITLE
	CALL	PTMSG2			;GO PRINT POINTER VALUES
	PRINT	INSPMSG 		;ALL DONE - Print inspect end message
	INT	20H			;Return to DOS
;
SWAPTM: PRINT	MSG3			;Print 'before -' on screen
	CALL	PTMSG2			;DISPLAY BEGINNIG STATUS OF POINTERS
;
;	SWAP POINTERS
;
	MOV	DX,LPT1 		;move pointer for LPT1: to DX register
	MOV	AX,LPT2 		;move pointer for LPT2: to AX register
	MOV	LPT1,AX 		;move old LPT2: pointer to LPT1: pointer
	MOV	LPT2,DX 		;move old LPT1: pointer to LPT2: pointer
;
	OR	AX,AX			;TEST FOR LPT1: PRESENT
	JZ	SWPT01			;BYPASS INITIALIZATION IF NOT PRESENT
	INTPTR	1			;INITIALIZE printer LPT1:
SWPT01: MOV	AX,LPT2 		;TEST FOR LPT2: PRESENT
	JZ	SWPT02			;BYPASS INITIALIZATION IF NOT PRESENT
	INTPTR	2			;Initialize printer LPT2:
SWPT02: PRINT	MSG4			;Print 'after -' on screen
	CALL	PTMSG2			;DISPLAY RESULT OF SWAP
	PRINT	ENDMSG			;DISPLAY SALUTATION
;
;
EXIT:	INT	20H			;RETURN TO DOS
;
;
PTMSG2	PROC	NEAR
;
;	SUBROUTINE TO PRINT STATUS OF POINTERS
;
	MOV	BX,LPT1
	MOV	AL,BH			;CONVERT HIGH-ORDER BYTE OF LPT1:
	CALL	HEXCHAR
	MOV	PL1,AX
	MOV	AL,BL			;CONVERT LOW-ORDER BYTE OF LPT1:
	CALL	HEXCHAR
	MOV	PL2,AX
	MOV	BX,LPT2
	MOV	AL,BH			;CONVERT HIGH-ORDER BYTE OF LPT2:
	CALL	HEXCHAR
	MOV	PL3,AX
	MOV	AL,BL			;CONVERT LOW-ORDER BYTE OF LPT2:
	CALL	HEXCHAR
	MOV	PL4,AX
	PRINT	MSG2			;PRINT ADDRESSES TO DISPLAY
	RET
PTMSG2	ENDP
;
;
HEXCHAR PROC	NEAR
;
;	SUBROUTINE TO CONVERT ONE BYTE TO 2 HEX CHARACTERS
;	Characters are returned in AX register in reverse order so that
;	a MOV x,AX will store the characters in their proper order in 'x'
;
	XOR	AH,AH			;Clear work register (high-order byte)
	CALL	HXBYTE			;Convert first four bits to hex char and
;					 store in AH
	MOV	DH,AH			;Save high-order character in DH
;					 temporarily
	XOR	AH,AH			;Clear AH again
	CALL	HXBYTE			;Convert low-order four bits and
;					 save in AH
	MOV	AL,DH			;move high-order character back
;					 into low-order of AX
	RET				;return with AX set LLHH
HEXCHAR ENDP
;
;
HXBYTE	PROC	NEAR
;
;	SUBROUTINE TO CONVERT HEX CHAR IN AL TO DISPLAY HEX IN AH
;
	MOV	CL,04H			;set shift count register
	SHL	AX,CL			; shift ax left 4 bits or positions
	OR	AH,30H			; make it an ASCII number (e.g. 30 - 3F)
	CMP	AH,3AH			;check for less than a hex 3A
	JB	HXCEX			;it is -- get out
	ADD	AH,07H			;make it an ASCII 'A' to 'F' then
HXCEX:	RET				;exit
HXBYTE	ENDP
;
;
MSG1:	DB	'SWAP LPT1: AND LPT2: ADDRESS POINTERS IN BIOS DATA AREA'
	DB	13,10,10
	DB	'               LPT1:     LPT2:',13,10,'$'
MSG2	DB	'      '
PL1:	DW	'XX'
PL2:	DW	'XX'
	DB	'      '
PL3:	DW	'XX'
PL4:	DW	'XX'
	DB	13,10,'$'
MSG3:	DB	'Before - ','$'
MSG4:	DB	'After  - ','$'
MSG5:	DB	'Inspect  ','$'
ENDMSG	DB	10,'LPT1: and LPT2: POINTERS SWAPPED',13,10,'$'
INSPMSG DB	10,'$'
START	ENDP
CSEG	ENDS
	END	BEGIN
                                                                                                      