include	asm.inc

public	mymain
extrn	syshard:proc, syssoft:proc, runprog:proc
extrn	textdemo:proc, mwdemo:proc
extrn	curvefit:proc, bargraph:proc

extrn	pickstr:proc
extrn	pulldown:proc
extrn	tfill:proc, wframe:proc, wclear:proc
extrn	ansicolor:proc, getkey:proc
extrn	screenmem:proc, getscreen:proc, putscreen:proc
extrn	dosalloc:proc
extrn	ansicolor:proc, tclear:proc
extrn	tprint:proc, tprintce:proc, crtinfo:proc
extrn	cursoroff:proc, ucursoron:proc

.data
menudata	db 'System',0
		db 'Hardware',0
		db 'Software',0
		db 'Run another program',0
		db 0
		db 'Text mode',0
		db 'Scrolling',0
		db 'Pop-up windows',0
		db 0
		db 'Graphics',0
		db 'Bar Graph',0
		db 'Curve fitting',0
		db 0
		db 'Quit',0
		dw 0

text_table	dw textdemo
		dw mwdemo
proc_table	dw demo0
		dw demo1
		dw graphdemo
		dw demo3
sys_table	dw sys_hard
		dw sys_soft
		dw run_program
gdemo_table	dw bar_graph
		dw curve_fit
saved_bx	dw 0
screen_seg	dw 0

box_corners	dw 5,5,20,70

intro_msg	db ' Welcome to the ASMLIB interactive demonstration program  ',0
intro2_msg	db ' ASMDEMO will give you a few examples of ASMLIB programming ',0
intro3_msg	db ' Note that ASMDEMO has not been optimized, but it will ',0
intro4_msg	db " give you a flavor for some of the library's functions. ",0
intro5_msg	db ' ASMDEMO was written with MASM 5.1 and ASMLIB.  No other ',0
intro6_msg	db ' software tools were used. ',0
press_key	db ' Press any key to continue',0
escape_msg	db ' Press ESC for main menu',0

.code
mymain	proc
	call	cursoroff
	call	ansicolor
	mov	al,''
	call	tfill
	lea	bx,box_corners
	mov	ah,7
	call	wclear
	mov	al,''
	call	wframe
	lea	si,intro_msg
	mov	dh,byte ptr box_corners
	inc	dh
	mov	dl,byte ptr box_corners+2
	inc	dl
	mov	ah,15
	call	tprint
	lea	si,intro2_msg
	inc	dh
	call	tprint
	lea	si,intro3_msg
	inc	dh
	call	tprint
	lea	si,intro4_msg
	inc	dh
	call	tprint
	lea	si,intro5_msg
	inc	dh
	call	tprint
	lea	si,intro6_msg
	inc	dh
	call	tprint
	lea	si,press_key
	add	dh,2
	mov	ah,14
	call	tprint
	call	getkey

	xor	bx,bx
	mov	saved_bx,bx
again:	lea	si,menudata
	mov	bx,saved_bx
	call	pulldown
	mov	saved_bx,bx
	cmp	ax,13
	je	demo
	cmp	al,0
	jne	again

demo:	mov	bl,bh
	xor	bh,bh
	shl	bx,1
	jmp	proc_table[bx]

;;
;; SYSTEM demos
;;
demo0:	mov	bx,saved_bx
	xor	bh,bh		; BX = submenu index
	shl	bx,1		; convert to an offset
	jmp	sys_table[bx]
sys_soft:
	call	syssoft
	jmp	again
sys_hard:
	call	syshard
	jmp	again
run_program:
	call	save_screen
	call	runprog
	call	restore_screen
	jmp	again

demo1:	mov	bx,saved_bx
	xor	bh,bh
	or	bx,bx
	jz	demo1a
	call	mwdemo
	jmp	again
demo1a:	call	textdemo
	jmp	again

;;
;; graph mode demos
;; includes: bargraph, curvefit
;;
graphdemo:
	call	save_screen
gdemo0:	mov	bx,saved_bx
	xor	bh,bh
	shl	bx,1
	jmp	gdemo_table[bx]

curve_fit:
	call	curvefit
	jmp	short gdemo9
bar_graph:
	call	bargraph

; restore text-mode screen
gdemo9:	call	restore_screen
	jmp	again

demo3:
exit:	call	ansicolor
	call	tclear
	xor	dx,dx
	call	ucursoron
	ret
mymain	endp

save_screen:
	call	screenmem	; returns screen size in bytes
	xor	dx,dx		; DX:AX = screen size
	mov	screen_seg,dx	; default: memory not available
	call	dosalloc	; allocate memory block
	jc	ss9		; don't save screen if no memory available
	mov	screen_seg,ax	; save base address of memory block

; copy screen to memory block
	push	ds
	mov	ds,ax
	xor	si,si
	call	getscreen
	pop	ds

ss9:	ret

restore_screen:
	mov	ax,screen_seg
	or	ax,ax		; was screen saved?
	jz	rs9		;  nope, exit
	push	ds
	mov	ds,ax
	xor	si,si
	call	putscreen
	pop	ds

; release memory block
	mov	es,ax		; memory block base address
	mov	ah,49h
	int	21h
rs9:	ret

	end
