; BARGRAPH.ASM - Sample program for ASMLIB
; Programmer: Douglas Herr
; date: 5/24/1992
;
; BARGRAPH displays a simple bar graph on the screen, then waits
; for any keypress to return to DOS.
; BARGRAPH has not been optimized particularly, so it's likely
; that much could be done to make it smaller and/or faster.
; BARGRAPH is intended as an illustration of ASMLIB use.

include	asm.inc

public  bargraph

; non-library external subroutines
extrn	graphmode:proc, textmode:proc

; standard library external subroutines
extrn   ucinit:proc, uc2sys:proc, viewlimit:proc
extrn   drawline:proc, drawbox:proc, fillbox:proc
extrn	gcenter:proc, gprintup:proc, smalltext:proc
extrn	getkey:proc, gcolor:proc, fillpattern:proc
extrn	maxi2:proc, mini2:proc, strlen:proc

.data
extrn	x0:word		; xmin
extrn	y0:word		; ymin
extrn	x1:word		; xmax
extrn	y1:word		; ymax

color	dw 1


; bar graph data for y-axis
; any integers from -32768 to 32767 may be used
bardata	dw 7,3,5,2,6,10,17,18,19,21
npoints	equ ($-bardata) shr 1

; ten fill patterns defined, all 8 bytes long plus NUL
pattern	db 8 dup (10101010b),0

	db 10000001b,01000010b,00100100b,00011000b
	db 00011000b,00100100b,01000010b,10000001b,0

	db 8 dup (10001000b),0

	db 01111110b,10111101b,11011011b,11100111b
	db 11100111b,11011011b,10111101b,01111110b,0

	db 4 dup (0FFh,1),0

	db 0FFh,1,1,1,1,1,0,0,0

	db 8 dup (11001100b),0
	db 8 dup (11110000b),0

	db 11000000b,01100000b,00110000b,00011000b
	db 00001100b,00000110b,00000011b,10000001b,0

	db 10001000b,10001000b,01000100b,01000100b
	db 00100010b,00100010b,00010001b,00010001b,0

; titles

extrn	teenager:byte
extrn	subtitle:byte
extrn	xaxis:byte
extrn	cost:byte

.code
bargraph	proc
	call	graphmode
	jnc	b0		; continue if no error
	mov	ah,9		; else use DOS to write error message
	int	21h
	jmp	exit		; & exit

b0:	push	ds
	pop	es
	lea	di,bardata
	mov	cx,npoints
	call	maxi2
	shl	ax,1
	mov	bx,di
	add	bx,ax
	mov	ax,[bx]		; get maximum value
	mov	y1,ax

	call	mini2
	shl	ax,1
	mov	bx,di
	add	bx,ax
	mov	ax,[bx]		; get minimum value
	or	ax,ax		; use 0 if min > 0
	js	b1
	xor	ax,ax
b1:	mov	y0,ax

	mov	x0,0
	mov	x1,npoints

	push	x0
	push	y0
	push	x1
	push	y1

; establish coordinates, leaving room at edges for titles
	mov	cl,3
	call	set_coordinates

        lea     bx,x0
        call    ucinit

; draw the bars
	mov	color,1
	mov	x0,0
	mov	x1,1
	mov	y0,0
	lea	si,bardata
	lea	dx,pattern
	cld
	mov	cx,npoints	; number of data points
bar:	mov	ax,color
	call	gcolor
	mov	bx,dx		; point to next pattern
	add	dx,9
	call	fillpattern
	lodsw
	mov	y1,ax
	lea	bx,x0
	call	uc2sys

; provide clearance between bars
	inc	word ptr [bx]
	call	fillbox
	mov	ax,color
	or	ax,8		; bright color for bar outline
	call	gcolor
	call	drawbox
	inc	x0
	inc	x1

; update color attribute; limit fill color to 1-7
	inc	color
	and	color,7
	jnz	bar9
	mov	color,1
bar9:	loop	bar

	pop	y1
	pop	x1
	pop	y0
	pop	x0

; draw the graph axes
	mov	ax,15
	call	gcolor
	push	y0
	push	y1
	mov	ax,0
	mov	y0,ax
	mov	y1,ax
	lea	bx,x0
	call	uc2sys
	call	drawline
	pop	y1
	pop	y0
	mov	ax,x0
	mov	x1,ax
	lea	bx,x0
	call	uc2sys
	call	drawline

; print main title
	mov	y0,0
	lea	dx,x0
	lea	si,teenager
	call	gcenter

; print subtitle
	call	smalltext
	lea	si,subtitle
	mov	y0,16
	call	gcenter

; print x-axis label
	call	viewlimit
	mov	ax,2[bx]	; maximum y
	push	ax
	sub	ax,10
	mov	y0,ax
	lea	si,xaxis
	call	gcenter

; print y-axis label
	lea	bx,cost
	call	strlen
	mov	si,bx
	mov	bx,cx
	mov	cl,3
	shl	bx,cl		; length of string in pixels
	pop	ax		; maximum y
	add	ax,bx		; maximum y plus len(string)
	shr	ax,1
	mov	y0,ax
	mov	x0,0
	call	gprintup

; wait for any keypress, then return to text mode
	call	getkey
	call	textmode
exit:	ret

bargraph	endp

; SET_COORDINATES is outside BARGRAPH because it'a always a near call
set_coordinates:
	lea	si,x0		; adjust x-coordinates
	call	s0
	add	si,2		; now do it for y
s0:	mov	ax,4[si]
	sub	ax,[si]		; delta x
	shr	ax,cl
	sub	[si],ax
	add	4[si],ax
	ret

	end
