include	asm.inc

; library functions
extrn	random:proc, putdot:proc, getkey:proc, smalltext:proc
extrn	gprint2x:proc, gcolor:proc, keywaiting:proc, clearkey:proc
extrn	gprintdown2x:proc, gprint:proc

extrn	graphmode:proc
extrn	textmode:proc

.data
extrn	drawmode:byte
extrn	maxx:word, maxy:word
xfactor	dw 0			; scale factor for x-dimension
yfactor	dw 0			; scale factor for y-dimension
x	dw 0			; x-coordinate
y	dw 0			; y-coordinate
count	db 10			; do 10*64k dots
msg	db '640 k random dots',0
escape	db 'press any key to stop',0

.code
public	randomdots
randomdots	proc
; save all registers used by the subroutine
	push	ax
	push	bx
	push	cx
	push	dx
	push	si

; kick it into graphics mode
	call	graphmode

	mov	ax,7
	call	gcolor
	mov	x,0
	mov	y,0
	lea	dx,x
	lea	si,msg
	call	smalltext
	call	gprint2x
	add	x+2,16
	lea	si,escape
	call	gprint

	mov	count,10
	xor	dx,dx
	mov	ax,65535
	mov	bx,maxx
	div	bx
	mov	xfactor,ax
	mov	ax,65535
	xor	dx,dx
	mov	bx,maxy
	div	bx
	mov	yfactor,ax

	mov	drawmode,0
	mov	cx,0

s1:	call	random			; returns AX = random number
	call	gcolor			; so I get a random color
	call	random			; for a random x
	mov	bx,xfactor
	xor	dx,dx
	div	bx
	mov	x,ax
	call	random			; for a random y
	mov	bx,yfactor
	xor	dx,dx
	div	bx
	mov	y,ax
	lea	bx,x
	call	putdot			; update the pixel
	call	keywaiting		; exit loop if a key has been pressed
	or	ax,ax
	jnz	s3
	loop	s1
	dec	count
	jnz	s1

s3:	mov	drawmode,1
	call	clearkey
	call	getkey
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	jmp	textmode
randomdots	endp
	end
