; TEXTDEMO.ASM - Demonstration program for ASMLIB
;  Programmer: Doug Herr
;  date: 6/10/1992


include	asm.inc

public	textdemo
extrn	wframe:proc, getkey:proc, wfill:proc
extrn	wsave:proc, wsize:proc, allocdos:proc
extrn	wrestore:proc, tprint:proc
extrn	hscroll:proc, vscroll:proc
extrn	ansicolor:proc
extrn	crtinfo:proc
extrn	tcopy:proc, usetpage:proc

.data
wseg		dw ?
r0		dw 0
c0		dw 0
r1		dw 0
c1		dw 0
frame_type	db 0
frame_color	db 8Fh
last_col	dw 79
last_row	dw 24
move_box	db ' Use ,,, to move box ',0
scroll_box	db ' Use ,,, to scroll box ',0

.code
textdemo	proc
	call	crtinfo
	dec	al
	mov	byte ptr last_row,al
	dec	ch
	mov	byte ptr last_col,ch

	mov	frame_type,0
	or	frame_color,80h
	mov	r0,5
	mov	c0,5
	mov	r1,20
	mov	c1,50
	mov	bx,0001h	; copy page 0 to page 1
	call	tcopy
	call	usetpage
td01:	lea	bx,r0
	call	wsize
	xor	dx,dx
	push	bx
	call	allocdos
	mov	ax,bx
	pop	bx
	mov	wseg,ax		; save segment address
	mov	es,ax
	xor	di,di		; ES:[DI] points to buffer
	call	wsave
	mov	al,''
	mov	ah,7
	call	wfill
	mov	ax,word ptr frame_type
	call	wframe
	lea	si,move_box
	mov	dh,byte ptr r0
	inc	dh
	mov	dl,byte ptr c0
	inc	dl
	mov	ah,14
	call	tprint
	mov	bx,0100h
	call	tcopy
	call	getkey
	shr	ah,1
	jnc	td02
	jmp	extended
td02:	cmp	al,27
	je	td99
	cmp	al,13
	jne	td01

; ENTER was pressed
	xor	bl,bl
	call	usetpage
	and	frame_color,0Fh
	mov	frame_type,0FFh

	lea	bx,r0
	mov	es,wseg
	xor	di,di
	call	wrestore
	mov	ah,49h
	int	21h
	mov	ax,word ptr frame_type
	call	wframe
	lea	si,scroll_box
	mov	ah,14
	mov	dh,byte ptr r0
	inc	dh
	mov	dl,byte ptr c0
	inc	dl
	call	tprint
td11:	call	getkey
	cmp	ax,13
	je	td99
	shr	ah,1
	jc	td110
	jmp	td11

td99:	ret

textdemo	endp

td110:	cmp	al,72
	je	up2
	cmp	al,80
	je	down2
	sub	al,76
	cmp	al,1
	je	td12
	cmp	al,0FFH
	jne	td11
td12:	cbw
	mov	cx,ax
	neg	cx
	call	ansicolor
	lea	bx,r0
	call	hscroll
	jmp	td11
up2:	mov	cx,1
	jmp	short scroll_updown
down2:	mov	cx,-1
scroll_updown:
	call	ansicolor
	lea	bx,r0
	call	vscroll
	jmp	td11

extended:
	lea	bx,r0
	mov	es,wseg
	xor	di,di
	call	wrestore
	push	ax
	mov	ah,49h
	int	21h
	pop	ax
	cmp	al,72
	je	up
	cmp	al,80
	je	down
	cmp	al,75
	je	left
	cmp	al,77
	je	right
e9:	jmp	td01

up:	dec	r0
	js	no_up
	dec	r1
	jmp	e9
no_up:	inc	r0
	jmp	e9

down:	inc	r1
	mov	ax,r1
	cmp	ax,last_row
	ja	no_down
	inc	r0
	jmp	e9
no_down:dec	r1
	jmp	e9

left:	dec	c0
	js	no_left
	dec	c1
	jmp	e9
no_left:inc	c0
	jmp	e9

right:	inc	c1
	mov	ax,c1
	cmp	ax,last_col
	ja	no_right
	inc	c0
	jmp	e9
no_right:
	dec	c1
	jmp	e9

	end
