; CRT_SAVE VERSION 1.4 03/15/88
;
CSEG     SEGMENT para public 'CODE'
         ASSUME  CS:CSEG,DS:CSEG
;
         ORG   100H
;
START:   JMP   INIT
;
CR             EQU  0DH
LF             EQU  0AH
BEL            EQU  07H
COPYRIGHT DB "CRT_Save 1.4 (c) 1988 RAMSYS MicroSystems$",1Ah
          DB "By Radu V. Metea"
;
TIMER_BIOS     DD   0             ;timer interrupt address    1C
KBD_BIOS       DD   0             ;keyboard interrupt address 09
VIDEO_BIOS     DD   0             ;video interrupt address    10
;
SWFLAG         DB   0             ;video on (1 if off)
KEYFLAG        DB   0             ;no kbd/video since video off
COUNT          DW   0             ;timer count
UPP_FLAG       DB   0             ;save caps lock status
EGA_FLAG       DB   0             ;if EGA adapter
TIME           dw   2200H         ;minutes to blank screen
;                                  18.2 * 60 * 8 = 8 minutes
;
TIMER_INT      EQU  01CH          ;timer interrupt
KBD_INT        EQU  009H          ;keyboard interrupt
VIDEO_INT      EQU  010H          ;video interrupt
;
ADDR_6845      EQU  063H          ;video adapter port base address
CRT_MODE_SET   EQU  065H          ;current state of CRT mode register
seventeen      equ  0017H         ;Keyboard flag 0 offset
forty          equ  0040H         ;caps lock flag
PAGE
;
;         <EGA Screen on/off procedure>
;
         EVEN
SCREEN_ON:         MOV    AL,20h
                   JMP    Short SCREEN_IO

SCREEN_OFF:        MOV    AL,0

SCREEN_IO:         PUSH   DX
                   PUSH   AX
                   MOV    DX,03BAh
                   IN     AL,DX                ; Reset mono flip-flop
                   MOV    DL,0DAh
                   IN     AL,DX                ; Reset color flip-flop
                   MOV    DL,0C0h              ; Attribute port
                   POP    AX                   ; Get on/off pattern
                   OUT    DX,AL                ; Turn screen on or off
                   POP    DX
                   RET
;
;        INT 1CH (TIMER TICK)
;
         EVEN
TIMER_TICK:
;
         sti
         push  AX
         push  DS
         push  CS
         pop   DS
         cmp   swflag,0
         JNE   T01
         inc   count
         mov   ax,time
         cmp   AX,count           ;time to blank out?
         JG    T02
         mov   count,0
         cmp   CS:ega_flag,1
         JNE   T0
         CALL  SCREEN_OFF
         JMP   T1
T0:
         push  DX
         push  ES
         mov   AX,0040H
         mov   ES,AX
         mov   DX,ES:ADDR_6845
         add   DX,4
         mov   AL,ES:CRT_MODE_SET
         and   AL,11110111B
         out   DX,AL
         pop   ES
         pop   DX
T1:
         mov   swflag,1
         JMP   SHORT T02
;
T01:
         cmp   keyflag,0
         JE    T02
         cmp   CS:ega_flag,1
         JNE   T010
         CALL  SCREEN_ON
         JMP   T011
T010:
         push  DX
         push  ES
         mov   AX,0040H
         mov   ES,AX
         mov   DX,ES:ADDR_6845
         add   DX,4
         mov   AL,ES:CRT_MODE_SET
         out   DX,AL
         pop   ES
         pop   DX
T011:
         mov   keyflag,0
         mov   swflag,0
         mov   count,0
;
T02:
         pop   DS
         pop   AX
         pushf
         CLI
         CALL  CS:TIMER_BIOS
         IRET
;
PAGE
;
;        INT 09H (KEYBOARD)
;
         EVEN
KEYBOARD:
         sti
         push  AX
         push  DS
         push  CS
         pop   DS
         push  AX
         push  BX
         push  CX
         push  DS
;
         mov   AX,forty                        ;BIOS flags segment
         mov   DS,AX                           ;kbd status flag segment
         mov   AL,BYTE PTR DS:seventeen        ;kbd flags
         and   AL,forty                        ;turn off other
         cmp   BYTE PTR CS:upp_flag,AL         ;did it change?
         mov   BYTE PTR CS:upp_flag,AL         ;save new value
         JE    DONT_BEEP                       ;no, don't beep
         test  BYTE PTR DS:seventeen,forty     ;caps on?
         JZ    DONT_BEEP                       ;no, don't beep
;
         IN    AL,61H
         MOV   BX,0020H
;
LP1:     AND   AL,0FCH
         OR    AL,02H
         OUT   61H,AL
         MOV   CX,0100H
LP2:     NOP
         LOOP  LP2
         AND   AL,0FCH
         OUT   61H,AL
         MOV   CX,0100H
LP3:     NOP
         LOOP  LP3
         DEC   BX
         JNE   LP1
         AND   AL,0FCH
         OUT   61H,AL
;
DONT_BEEP:
;
         pop   DS
         pop   CX
         pop   BX
         pop   AX
;
         cmp   swflag,0
         JE    K01
         mov   keyflag,1
         CLI
         INT   TIMER_INT
;
K01:
         mov   count,0
         pop   DS
         pop   AX
         pushf
         CLI
         CALL  CS:KBD_BIOS
         IRET
;
PAGE
;
;        INT 10H (VIDEO)
;
         EVEN
VIDEO:
         sti
         push  AX
         push  DS
         push  CS
         pop   DS
         cmp   swflag,0
         JE    V01
         mov   keyflag,1
         CLI
         INT   TIMER_INT
;
V01:
         mov   count,0
         pop   DS
         pop   AX
         pushf
         CLI
         CALL  CS:VIDEO_BIOS
         IRET
;
END_RESIDENT:
;
;        INITIALIZATION LOGIC
;
INIT:
         mov   DX,OFFSET copyright
         mov   AH,9
         INT   21H
;
         MOV     AH,30H                     ;Requires DOS 2.0 or later
         INT     21H

         CMP     AL,02
         JAE     VER_OK

         MOV     DX,OFFSET NO_DOS
         MOV     AH,9
         INT     21H
         INT     20H
;
VER_OK:  push  DS
         xor   AX,AX
         push  AX
; CHECK IF ALREADY LOADED IN MEMORY
         mov   WORD PTR [copyright+0],0     ;only match on executed copy
         mov   WORD PTR [copyright+2],0     ;original may be in DOS buff
         xor   BX,BX                        ;segment to compare
         push  CS
         pop   AX
CHECK_LOOP:
         inc   BX                           ;Next paragraph
         cmp   AX,BX                        ;If in this copy of CRT_SAVE
         mov   ES,BX                        ;Set for search
         JE    CHECK_EGA                    ;                 then stop
         mov   SI,OFFSET COPYRIGHT          ;String to compare
         mov   DI,SI                        ;same offset
         mov   CX,16                        ;Compare 16 bytes
     REP cmpsb
         or    CX,CX                        ;All matched?
         JNZ   CHECK_LOOP                   ;No
         mov   DX,OFFSET no_load            ;can't load again
         mov   AH,9
         INT   21H
         RET                                ;quit
CHECK_EGA:
         mov   AH,12H                       ;prepare for call to int 10H
         mov   BL,10H                       ;function - request EGA info
         INT   10H
         cmp   BL,10H                       ;BL=10H?
         JE    NO_EGA                       ;yes, then no EGA installed
         mov   CS:ega_flag,1
         JMP   VIDEO_SET
NO_EGA:
         mov   AH,15                        ;get video mode
         INT   10H
         cmp   AL,7                         ;is it mode 7?
         JNE   VIDEO_SET                    ;no, it's color
         mov   CX,0B0CH                     ;fix cursor
         mov   AH,1                         ;set cursor
         INT   10H                          ;do it
VIDEO_SET:
         xor   AX,AX
         mov   ES,AX                        ;base address
;
         mov   SI,timer_int*4               ;timer INT 1C vector
         lods  WORD PTR ES:[SI]
         mov   WORD PTR TIMER_BIOS,AX       ;save
         lods  WORD PTR ES:[SI]
         mov   WORD PTR TIMER_BIOS+2,AX     ;save
;
         mov   SI,kbd_int*4                 ;kbd INT 09 vector
         lods  WORD PTR ES:[SI]
         mov   WORD PTR KBD_BIOS,AX         ;save
         lods  WORD PTR ES:[SI]
         mov   WORD PTR KBD_BIOS+2,AX       ;save
;
         mov   SI,video_int*4               ;video INT 10 vector
         lods  WORD PTR ES:[SI]
         mov   WORD PTR VIDEO_BIOS,AX       ;save
         lods  WORD PTR ES:[SI]
         mov   WORD PTR VIDEO_BIOS+2,AX     ;save
;
         push  CS
         pop   DS
         mov   DX,OFFSET TIMER_TICK
         mov   AH,25H
         mov   AL,1CH
         INT   21H
;
         mov   DX,OFFSET KEYBOARD
         mov   AH,25H
         mov   AL,09H
         INT   21H
;
         mov   DX,OFFSET VIDEO
         mov   AH,25H
         mov   AL,10H
         INT   21H
;
         cmp   BYTE PTR DS:[80H],0          ;Any parameters?
         JZ    ALL_DONE                     ;no
         mov   SI,82H                       ;point at parm
         cmp   BYTE PTR [SI-1],"/"
         JNE   ALL_DONE
         cmp   BYTE PTR [SI],"0"
         JB    ALL_DONE
         cmp   BYTE PTR [SI],"9"
         JA    ALL_DONE
         xor   CX,CX
         mov   CL,[SI]
         and   CL,0FH
         xor   AX,AX
TIME_LOOP:
         add   AX,0444H
         LOOP  TIME_LOOP
         mov   time,AX
;
ALL_DONE:
         pop   DS
         push  ES
         MOV   AX,WORD PTR DS:[2CH]    ;Address of environment
         MOV   ES,AX                   ;In ES register
         MOV   AH,49H                  ;Release allocated memory
         INT   21H                     ;Thru DOS
         pop   ES
         pop   AX
         lea   DX,END_RESIDENT
         INT   27H
;
NO_LOAD  DB    CR,LF,"Already running...$"
NO_DOS   DB    CR,LF,"Sorry, DOS 2.0 or above required...$"
;
CSEG     ENDS
         END   START
