;
;
CSEG     segment para public 'code'
         assume cs:cseg,ds:cseg,ss:cseg,es:cseg
         org     100h                    
BEGIN:   jmp     PR_MAIN                 
         COPYRIGHT       db      'PRint (C) 1985, Dickinson Associates'
                         db      13,10,'$'
         VALID_IN        db      '/abcdefghijklmnopqrstuvwxyz,;=',9
         VALID_OUT       db      '\ABCDEFGHIJKLMNOPQRSTUVWXYZ',4 dup(32)
         VALID_NUM       equ     $ - VALID_OUT + 1
         FN_AREA         db      77 dup (0)
         FN_LOC          dw      offset FN_AREA ;Initialize at FN_AREA
         PRN             equ     4              ;PC-DOS printer device 
         MAX_LINES       equ     55
         MAX_CHARS       equ     80
         FILE_HANDLE     dw      0
         READ_LENGTH     equ     256
         READ_BUFFER     db      READ_LENGTH dup (0),0
         READ_PTR        dw      offset READ_BUFFER
         PRINT_LENGTH    equ     256
         PRINT_BUFFER    db      PRINT_LENGTH dup (0)
         PRINT_PTR       dw      offset PRINT_BUFFER
         EOF_FOUND       db      0
         CHAR_COUNT      dw      0
         LINE_COUNT      db      0
         PAGE_COUNT      db      0
         BIN_ASC         db      10
         HEAD_1          db      13,10,13,10,'*',78 dup ('-'),'*',13,10
         HEAD_2A         db      '|  File: '
         HEAD_2B         db      70 dup (' '),'|',13,10
         HEAD_3A         db      '| Saved: '
         HEAD_3B         db      '00-00-00 at '
         HEAD_3C         db      '00:00:00 '
         HEAD_3D         db      '0m',39 dup (' '),'Page '
         HEAD_3E         db      '00 |',13,10
         HEAD_4          db      '*',78 dup ('-'),'*',13,10,13,10
         HEAD_LGTH       dw      $ - HEAD_1
         ERR_HEAD        db      10,13,'Print Error - $'   
         NO_FILE         db      'Correct Syntax is:',13,10,10
                         db      'PR [d:][path]filename[.ext]$'
         FILE_NOT_FOUND  db      'File Not Found$'
         OPEN_FAILURE    db      'File Open Failure$'
         READ_FAILURE    db      'File Read Failure$'
         ERR_TAIL        db      10,10,13,' . . . Aborting',10,13,13,'$'
;
PR_MAIN          proc    near            
         lea     dx,COPYRIGHT            
         mov     ah,9h                   
         int     21h                     
         mov     si,80h                   
         lea     di,FN_AREA               
         mov     cl,byte ptr [si]        
         xor     ch,ch                   
         jcxz    NONE                     
         cld                             
         inc     si                      
         mov     dx,0                    
CLEAN:   lodsb                           
         push    di                      
         mov     di,offset VALID_IN      
         push    cx                      
         mov     cx,VALID_NUM             
repne    scasb                             
         jcxz    CLEAND
         mov     bx,VALID_NUM
         sub     bx,cx    
         mov     al,VALID_OUT [bx - 1]    
CLEAND:  pop     cx                      
         pop     di                      
         cmp     dx,1                     
         je      CLEANC                   
         cmp     al,' '                  
         je      CLEANX                  
CLEANC:  mov     dx,1                     
         cmp     al,':'
         je      DELIM
         cmp     al,'\'
         jne     DELIMX
DELIM:   mov     FN_LOC,di
         inc     FN_LOC
DELIMX:  stosb
CLEANX:  loop    CLEAN
         jmp     FINDF
NONE:    lea     dx,NO_FILE
         jmp     EREXIT
FINDF:   mov     ah,4eh
         mov     cx,0
         lea     dx,FN_AREA
         int     21h
         jnc     FOUNDF
         lea     dx,FILE_NOT_FOUND
         jmp     EREXIT
FOUNDF:  mov     EOF_FOUND,0
         mov     PAGE_COUNT,0
         mov     FILE_HANDLE,0
         mov     di,FN_LOC
         mov     si,9eh
         mov     cx,13
rep      movsb
         mov     ah,3dh
         mov     al,0
         lea     dx,FN_AREA
         int     21h
         mov     FILE_HANDLE,ax
         jnc     DO_PR
         lea     dx,OPEN_FAILURE
         jmp     EREXIT
DO_PR:   call    STAMP
         call    PAGE_HEAD
         mov     di,PRINT_PTR
PRLOOP:  call    READ_FILE
         jc      EREXIT
         jcxz    FINISH
         call    PRINT
         cmp     EOF_FOUND,0
         je      PRLOOP
FINISH:  call    NEW_PAGE
         call    CLOSE_FILE
         mov     ah,4fh
         mov     cx,0
         int     21h
         jnc     FOUNDF
EXIT:    ret
EREXIT:  push    dx
         mov     dx,offset ERR_HEAD
         mov     ah,9
         int     21h
         pop     dx
         mov     ah,9
         int     21h
         mov     dx,offset ERR_TAIL
         mov     ah,9
         int     21h
         call    CLOSE_FILE
         jmp     EXIT
PR_MAIN          endp
READ_FILE        proc    near
         mov     bx,FILE_HANDLE
         mov     dx,READ_PTR
         mov     cx,READ_LENGTH
         mov     ah,3fh
         int     21h
         jnc     RD_OK
         lea     dx,READ_FAILURE
         jmp     EX_RD
RD_OK:   cmp     cx,ax
         je      NO_EOF
         mov     EOF_FOUND,1
NO_EOF:  mov     cx,ax
EX_RD:   ret
READ_FILE        endp
PRINT    proc    near
         mov     si,READ_PTR
FORMAT:  cmp     LINE_COUNT,MAX_LINES
         jb      LOAD
         call    NEW_PAGE
         call    PAGE_HEAD
LOAD:    lodsb
         cmp     al,26
         je      AGAIN
         cmp     al,9
         jne     PUT_IT
         mov     al,32
TAB_X:   stosb
         inc     CHAR_COUNT
         test    CHAR_COUNT,7
         jnz     TAB_X
         jmp     WDTH
PUT_IT:  stosb
         inc     CHAR_COUNT
         cmp     al,13
         je      AGAIN
         cmp     al,10
         jne     FF
         call    PRINT_LINE
         jmp     AGAIN
FF:      cmp     al,12
         jne     WDTH
         call    NEW_PAGE
         call    PAGE_HEAD
         jmp     AGAIN
WDTH:    cmp     CHAR_COUNT,MAX_CHARS
         jb      AGAIN
         cmp     byte ptr [si],13
         je      AGAIN
         mov     ah,10
         mov     al,13
         stosw
         add     CHAR_COUNT,2
         call    PRINT_LINE
AGAIN:   loop    FORMAT
         ret
PRINT    endp
PRINT_LINE       proc    near
         push    ax
         push    cx
         mov     dx,PRINT_PTR
         mov     cx,CHAR_COUNT
         mov     bx,PRN
         mov     ah,40h
         int     21h
         mov     di,PRINT_PTR
         mov     CHAR_COUNT,0
         inc     LINE_COUNT
         pop     cx
         pop     ax
         ret
PRINT_LINE       endp
NEW_PAGE         proc    near
         cmp     al,12
         je      FF_OK
         mov     al,12
         stosb
         inc     CHAR_COUNT
FF_OK:   call    PRINT_LINE
         mov     LINE_COUNT,0
         ret
NEW_PAGE         endp
PAGE_HEAD        proc    near
         push    di
         inc     PAGE_COUNT
         mov     al,PAGE_COUNT
         lea     di,HEAD_3E
         call    BIN_2_ASC
         pop     di
         cmp     HEAD_3E[0],'0'
         jne     NOT_0
         mov     HEAD_3E[0],' '
NOT_0:   push    cx
         mov     ah,40h
         mov     bx,PRN
         lea     dx,HEAD_1
         mov     cx,HEAD_LGTH
         int     21h
         pop     cx
         ret
PAGE_HEAD        endp
STAMP            proc    near
         lea     si,FN_AREA
         lea     di,HEAD_2B
         mov     cx,70
LD_FN1:  lodsb
         cmp     al,0
         je      LD_FN2
         stosb
         loop    LD_FN1
         jcxz    DATE
LD_FN2:  mov     al,32
rep      stosb
DATE:    mov     si,98h
         lea     di,HEAD_3B
         lodsw
         mov     bx,ax
         and     ax,01e0h
         mov     cl,5
         shr     ax,cl
         call    BIN_2_ASC
         mov     ax,bx
         and     ax,1fh
         inc     di
         call    BIN_2_ASC
         mov     ax,bx
         and     ax,0fe00h
         shr     ah,1
         add     ah,80
         mov     al,ah
         inc     di
         call    BIN_2_ASC
TIME:    mov     si,96h
         lea     di,HEAD_3C
         lodsw
         mov     bx,ax
         and     ax,0f800h
         mov     cl,11
         shr     ax,cl
         mov     HEAD_3D[0],'a'
         cmp     al,12
         jb      AM_OK
         je      PM_OK
         sub     al,12
PM_OK:   mov     HEAD_3D[0],'p'
AM_OK:   call    BIN_2_ASC
         mov     ax,bx
         and     ax,7e0h
         mov     cl,5
         shr     ax,cl
         inc     di
         call    BIN_2_ASC
         mov     ax,bx
         and     ax,1fh
         inc     di
         call    BIN_2_ASC
         ret
STAMP    endp
BIN_2_ASC        proc    near
         cbw
         div     BIN_ASC
         add     al,48
         stosb
         add     ah,48
         mov     al,ah
         stosb
         ret
BIN_2_ASC        endp
CLOSE_FILE       proc    near
         cmp     FILE_HANDLE,0
         je      CLOSEX
         mov     bx,FILE_HANDLE
         mov     ah,3eh
         int     21h
CLOSEX:  ret
CLOSE_FILE       endp
CSEG     ends
         end     BEGIN




                                           