
        TITLE   PTIMER.ASM (or CPU.ASM)

;
;       Programmer: Unknown
;       DisAssembled by Dave Hoo    09-25-85
;

LF      EQU     0AH
CR      EQU     0DH

code    SEGMENT
        ASSUME  CS:code,DS:code,ES:code
        ORG     100H
start:  MOV     AH,9
        MOV     DX,OFFSET banner
        INT     21H
        MOV     AH,2CH
        INT     21H
;                                     clocks needed
;--------------------------------------------------
        MOV  OldSec,DX ; 19              =       19
        XOR  AX,AX     ;  3              =        3
        MOV  DX,10     ;  4              =        4
outer:  MOV  CX,47227  ;  4         * 10 =       40
inner:  AAM            ; 83 * 47227 * 10 = 39198410   (  1.98 % )
        DEC  CX        ;  2 * 47227 * 10 =   944540   (  1.98 % )
        JNZ  inner     ; 16 * 47226 * 10 +
                       ;  4         * 10 =  7556200   ( 15.84 % )
        DEC  DX        ;  2         * 10 =       20
        JNZ  outer     ; 16         *  9 +
                       ;  4              =      148
        MOV  AH,2CH    ;  4              =        4
        INT     21H
;--------------------------------------------------
;                        T O T A L       = 47699388 + INT GetTime
;                        or                4.77E+06 * 10

;
;If following statements is for NEC V-20 running 4.77 Mhz, then it means
;NEC V-20 only needs 15980000 clocks instead of 47699388.
;
;   "Actual execution time here was 03.35 seconds
;    Effective clock speed = >.23 Mhz"
;                          (14.23 Mhz)
;
;It will not surprise me if NEC V-20 had reduced the clocks
;needed for AAM instruction to 20.
;
;But AAM is a rarely used insturction, even in this program when there
;is a chance to really use AAM the programmer chose IDIV instead. (see EX:)
;
        MOV     AX,100
        IMUL    DH
        MOV     DH,0
        ADD     AX,DX                  ;seconds(after)  * 100  [0..5999]
        MOV     BX,AX
        MOV     DX,OldSec
        MOV     AX,100
        IMUL    DH
        MOV     DH,0
        ADD     AX,DX                  ;seconds(before) * 100  [0..5999]
        SUB     BX,AX
        JNB     SameM                  ;within same minute, no adjustment
        ADD     BX,6000                ;otherwise add 1 minute
SameM:  MOV     AX,BX
        MOV     DifSec,BX
        MOV     BP,offset ACTsec
        MOV     BX,1000
        CWD
        IDIV    BX                     ;dx:ax / 1000
        CALL    ToASC                  ;get first digit
        MOV     BX,100
        MOV     AX,DX
        CWD
        IDIV    BX
        CALL    ToASC                  ;get second digit
        INC     BP                     ;skip decimal point
        MOV     BX,10
        MOV     AX,DX
        CWD
EX:     IDIV    BX
        CALL    ToASC                  ;first digit after decimal point
        MOV     AX,DX
        CALL    ToASC                  ;last digit after decimal point
        MOV     AH,9
        MOV     DX,OFFSET EXCmsg
        INT     21H
        MOV     AX,4770
        CWD
        MOV     BX,DifSec
        DIV     BX
        MOV     BP,offset EFFclk
        CALL    ToASC                  ;get one digit
        INC     BP                     ;skip decimal point
        MOV     AX,DX
        MOV     CX,10
        MUL     CX                     ;remainder * 10
        DIV     BX
        CALL    ToASC
        MOV     AX,DX
        MUL     CX                     ;remainder * 10
        DIV     BX
        CALL    ToASC
        MOV     AH,9
        MOV     DX,OFFSET EFFmsg
        INT     21H
        MOV     AH,4CH                 ;terminate with '$'
        INT     21H                    ;as return code

ToASC   proc    near
        OR      AL,30H
        MOV     [BP],AL
        INC     BP
        ret
ToASC   endp

OldSec  DW      0
DifSec  DW      0

Banner  DB      'CLOCK SPEED CHECKER (minimal RAM access), please wait...'
        DB      CR,LF,'$'
EXCmsg  DB      'Execution time should be 10.00 secs if 4.77 Mhz clock'
        DB      ' & no WAITs on RAM access',CR,LF
        DB      'Actual execution time here was '
ACTsec  DB      '00.00 seconds',CR,LF,'$'
EFFmsg  DB      'Effective clock speed = '
EFFclk  DB      '0.00 Mhz',CR,LF,'$'

code    ENDS
;
        END   start
END OF TRANSFER - PRESS ENTER TO RETURN TO MENU
