':*********************************** ':* PROGRAM CHASM      Version 1.9  * 
$':*                                 * 9
.':* CHeap ASseMbler for the IBM PC. * d
8':*                                 * 
B':* Begun 6/15/82 by Dave Whitman   * 
L':*********************************** 
V': 
`':main program 
j'    P   :initialize t'  :wipe out transient code =~'    "chasm.ovl",',ALL, Pr _'   M   :set up sym table '   '   :pass 1: build sym table '   (   :pass 2: generate obj code & listing '   "L   :clean up ' ':******************************************* D':* SUBROUTINE PASSONE                      * w':* Adds user-defined symbols to sym table. * ':******************************************* ': 'PASS   'LOCTR      :0-255 reserved for p.s. prefix  (LINENUM   
(  () 6( :get source line, initialize P(    |)   :getline a(( :parse it x2(    )  :parse <( :if label, enter in sym table F(    LABEL$  ""   x-  :newentry P( :if op, decode, & update loctr Z(    OP$  ""   0   :update_loctr 3d( :progress report @n(    M Gx(  M( v(:********************************* (:* SUBROUTINE PASSTWO            * (:* Generates obj code & listing. * (:********************************* (: ( K  :pass2_init (: )(  () M( :get source line, initialize g(    |)   :getline z( :parse line (    )   :parse ) :phase error? )    LABEL$  ""   .  :check_phase ) :if op, update loctr, generate obj. code 2")    OP$  ""   0   :update_loctr Z,) :output obj. code & listing line r6)    LJ  :output @) :progess report J)    M T)  ^):wipe out msg h)  X  (): Y  :  ,:  O):  Y,X r) |):******************************************** M):* SUBROUTINE GETLINE                       * ):* Gets line of source code for processing. * ):* and initializes for new iteration.       * ):******************************************** ): ) #, INPLINE$ )LINENUM  LINENUM   E)NEEDOFFSET  NONE: DSFLAG  FALSE T)OBJLEN   Z) ):***************************************************** ):* SUBROUTINE PARSE                                  * ):* Parses input line for any label, op, or operands. * N*:***************************************************** V*: t*LINEPTR  : LINEPTR2   &*LABEL$  "": OP$  "": SOURCE$  "": DEST$  "" 0*: :*:set endptr to end of code D*  ENDPTR  (INPLINE$,";")              :just before comment ]N*   ENDPTR    ENDPTR  (INPLINE$)  :no comment, set to eol eX*: ~b*:no code? (return) l*   ENDPTR    p+ v*: *:convert to all caps *   + *: *:label (if any) *   (INPLINE$,)  " "  * "*     ,  :getfield 8*    LABEL$  FLD$ @*: O*:op-code h*   ,  :getfield ~*    FOUND  p+ *    OP$  FLD$ *:save ptr to start of operands +  OPDPTR  LINEPTR +: +:destination operand (if any)  +   ,  :getfield (*+    FOUND  p+ ;4+  DEST$  FLD$ C>+: bH+:source operand (if any) {R+   ,  :getfield \+    FOUND  p+ f+  SOURCE$  FLD$ p+ z+: +:internal subroutine caps +:Scans inpline$ up to comment field, :+:converting l.c. chars. to u.c.. Skips over strings. O+ I    ENDPTR k+  C$  (INPLINE$,I,) +  :skip strings +     C$  "'"  + +      STRGEND  (I,INPLINE$,C$) +       STRGEND    I  STRGEND:  +  +  :convert e+     (C$)  a  (C$)  z  C$  ((C$)   ):                  (INPLINE$,I,)  C$ o+   I u+ ,:*********************************************************** ,:* SUBROUTINE GETFIELD                                     * >,:* Starting at lineptr, trys to return next field in FLD$. * $,:* Sets found if sucessful. Moves lineptr past field.      * .,:*********************************************************** 8,: B,:find next non-delimiter or run off end L,  LINEPTR  ENDPTR FV,    (" ,",(INPLINE$,LINEPTR,))    t, c`,   LINEPTR  LINEPTR   lj,    t,:if past end, not found ~,  LINEPTR  ENDPTR   , ,   FOUND  FALSE ,    ,: ,:strings terminated by ' ,  (INPLINE$,LINEPTR,)  "'"  , E,   STRGEND  (LINEPTR,INPLINE$,"'") `,    STRGEND    , ,     LINEPTR2  STRGEND   ,      2- ,: ,:otherwise, find next delimter or go 1 past end , LINEPTR2  LINEPTR   -  LINEPTR2  ENDPTR 3
-    (" ,",(INPLINE$,LINEPTR2,))    2- R-   LINEPTR2  LINEPTR2   [-    c(-: u2-:copy field <- FLD$  (INPLINE$,LINEPTR,LINEPTR2LINEPTR) F-: P-:move lineptr past field, set found & return Z- LINEPTR  LINEPTR2  d- FOUND  TRUE  n-  I x-:**********************************************  -:* SUBROUTINE NEWENTRY                        *  -:* Adds new symbol to sym table with default  *  -:* attributes. (may be changed by pseudo-ops) * !!-:********************************************** )!-: J!-:already in table? (error) a!-  TARGET$  LABEL$ !-  .     :operand_lookup !-   FOUND  . !-   ERRS  ERRS   !-   #,"****Error: Duplicate definition of ";LABEL$;" in ";LINENUM !-    "-: !".:table full? (error) >".  NUMSYM  MAXSYM  @. U".   ERRS  ERRS   "".   #, "****Error: Too many user symbols in "; LINENUM ",.    "6.: "@.:else make new entry "J. NUMSYM  NUMSYM   "T. SYM$(NUMSYM)  LABEL$ #^. VAL1(NUMSYM)  LOCTR '#h. SYMTYPE(NUMSYM)  NEAR /#r.: 5#|. ^#.:********************************* #.:* SUBROUTINE CHECK_PHASE        * #.:* Label value same both passes? * #.:********************************* #. OP$  "EQU"  . $.TARGET$  LABEL$ #$. .  :operand_lookup +$.: b$. (SYMTYPE(TABLEPTR)  (NEAR  MEM))  FALSE  . $.   VAL1(TABLEPTR)  LOCTR  . $.    ERRS  ERRS  : #, "****Phase Error" $. $.:************************************************* /%/:* SUBROUTINE OPERAND_LOOKUP                     * h%/:* Trys to find TARGET$ in sym table.  If there, * %/:* sets FOUND true, & TABLEPTR to its'position.  * %&/:************************************************* %0/:scan table for symbol &:/   TABLEPTR    NUMSYM G&D/     SYM$(TABLEPTR)  TARGET$  / :found Z&N/     TABLEPTR b&X/: |&b/:failure exit point &l/  FOUND  FALSE &v/   &/:sucess exit point &/  FOUND  TRUE &/   
'/:********************************************************* N'/:* SUBROUTINE LOOKUP_OP                                  * '/:* Given op-code in op$, & operand types in dtype &      * '/:* stype, trys to find op in opcode table. If sucessful, * (/:* sets found true, & opptr to its' position.            * R(/:********************************************************* }(/:binary search for good starting pt. (/ MOVE  NUMOP: ST  MOVE (/  MOVE   (/   MOVE  MOVE )0    OP$  OPCODE$(ST)  ST  ST  MOVE : ST  ST  MOVE )0    ST    ST   ;)0    ST  NUMOP  ST  NUMOP D) 0    L)*0: x)40:scan for entry matching all 3 fields )>0  OPPTR  ST  NUMOP )H0    OPCODE$(OPPTR)  OP$  0   :failed )R0    OPCODE$(OPPTR)  OP$  z0 *\0    (SRCTYPE(OPPTR)  STYPE)  FALSE  z0 G*f0    (DSTTYPE(OPPTR)  DTYPE)  FALSE  z0 ^*p0    0 :found! m*z0    OPPTR *0:failure exit *0 FOUND  FALSE *0  *0:successful exit *0 FOUND  TRUE *0  *0:*************************************** )+0:* SUBROUTINE UPDATE_LOCTR             * X+0:* Decodes operation & advances loctr. * +0:* On pass 2, generates obj. code.     * +0:*************************************** +0: +0:set operand types & values +1  :destination operand -,1   TARGET$  DEST$:  <2   :type_operand E,1   DTYPE  TARGTYPE ],$1   DVAL1  TARGVAL1 u,.1   DVAL2  TARGVAL2 ,81  :source operand ,B1    :special case: RET op ,L1      OP$  "RET"  STYPE  PROCTYPE(STKTOP):  1 ,V1    :normal source 3-`1     TARGET$  SOURCE$:  <2   :type_operand M-j1     STYPE  TARGTYPE g-t1     SVAL1  TARGVAL1 -~1     SVAL2  TARGVAL2 -1: -1:find op in op table (not there: error) -1 TARGET$  OP$ -1  /   :lookup_op -1  FOUND  
2 
.1    PASS     N.1   ERRS  ERRS  : #,"****Syntax Error: ";OP$;DTYPE;STYPE .1    ((ACUM8  ACUM16  REG8  REG16  SEG  CS)                                 (DTYPE  STYPE))   2 .1      (STYPE  (NONE  IMMED8  IMMED16))  FALSE   2 "/1        ("BW",(OP$,))     2 ?/1         DIAG  DIAG   /1         #,"****Diagnostic: Specify word or byte operation" / 2    /
2 FLAG  OFLAG(OPPTR) /2: /2:branch for mach ops & pseudo-ops to update loctr 	0(2  FLAG  MACHOP   8; :  b> 022 P0<2:********************************************************* 0F2:* SUBROUTINE TYPE_OPERAND                               * 0P2:* Sets TARGTYPE to reflect TARGET$'s type.  Sets        * 1Z2:* TARGVAL1 to its' value. If the operand is a register, * T1d2:* sets TARVAL2 to its' val2. If an offset appears,      * 1n2:* NEEDOFFSET gets the its' type, and OFFSET its' value. * 1x2:********************************************************* 12: 12:any operand? 22  (TARGET$)    2 &22   TARGTYPE  NONE /22    D22:in sym table? c22  .   :operand_lookup x22   FOUND  2 22   TARGTYPE  SYMTYPE(TABLEPTR) 22   TARGVAL1  VAL1(TABLEPTR) 22    TABLEPTR  PREDEF  TARGVAL2  VAL2(TABLEPTR) 22    
32:number? )33  4   :test_number >33   FOUND  63 X33   TARGTYPE  NUMTYPE q3"3   TARGVAL1  NUMVAL z3,3    363:direct mem. ref.? 3@3  5   :memref 3J3   FOUND  r3 3T3   TARGTYPE  MEM 3^3   TARGVAL1  MEMADDR 3h3    4r3:offset off register? 74|3  d7   :parse_disp_off_reg L43   FOUND  3 e43   TARGTYPE  MEMREG ~43   TARGVAL1  REGVAL 43    43:offset? 43  9 :offset 43   FOUND  3 43   TARGTYPE  OFFSETYPE 43   TARGVAL1  OFFSETVAL 53    53:charactor? 53  : 353   FOUND  &4 W54    TARGTYPE  IMMED8  IMMED16 r54    TARGVAL1  CHARVAL |54     5&4:string? 504  (TARGET$,)  "'"  X4 5:4   TARGTYPE  STRING 5D4    5N4: 6X4:not found? assume near label or mem ref. (error on pass 2) x6b4  PASS    #,"****Error: Undefined symbol ";TARGET$:                  ERRS  ERRS   6l4 TARGTYPE  NEAR  MEM 6v4 64:******************************************* 64:* SUBROUTINE TEST_NUMBER                  * 274:* Trys to interpret TARGET$ as a number.  * e74:* If sucessful, sets FOUND true, NUMVAL   * 74:* to its' value and NUMTYPE to its' type. * 74:******************************************* 74: 74FOUND  FALSE 84TN$  TARGET$  :working copy 84: #84:hex number? A84  (TN$,)  "H"  z5 T84  :lop off H s85   TN$  (TN$,(TN$)) 85  :scan for non-hex digits (exit) 85   I   8 5    I    (TN$) 8*5     C$  (TN$,I,) 945      ("0123456789ABCDEF",C$)     9>5      I '9H5  :get value F9R5   NUMVAL  ("&H"  TN$) `9\5  :set type, return m9f5    5 u9p5: 9z5:decimal number? 95  :scan for non-dec digits (exit) 95    I    (TN$) 95     C$  (TN$,I,) :5      ("0123456789-+",C$)     :5      I /:5  :get value G:5   NUMVAL  (TN$) O:5: b:5:sucess exit t:5 FOUND  TRUE :5  ((NUMVAL))     NUMTYPE  IMMED16  IMMED8                        : NUMTYPE  IMMED16 :5 ;5:******************************************** F;6:* SUBROUTINE MEMREF                        * z;6:* Trys to interpret target$ as a direct    * ;6:* mem ref.  If sucessful, sets FOUND true, * ;$6:* & MEMADDR to the address referanced.     * <.6:******************************************** <86: ><B6MR$  TARGET$  :save copy F<L6: W<V6:brackets? <`6  (MR$,)  "["  (MR$,)  "]"   <j6: <t6:strip off brackets <~6 TARGET$  (MR$,,(MR$)) <6:try to interpret as addr. =6  :might be number #=6    4   :test_number :=6     FOUND  6 T=6     MEMADDR  NUMVAL k=6      F7 :exit s=6: =6  :or might be symbol =6    .  :operand_lookup =6     FOUND  7 =6      (SYMTYPE(TABLEPTR)  IMMED16)  FALSE  7 !>6       MEMADDR  VAL1(TABLEPTR) :> 7        F7 :exit B>
7: V>7:failure exit i>7 FOUND  FALSE |>(7 TARGET$  MR$ >27  ><7: >F7:sucessful exit >P7 TARGET$  MR$ >Z7  >d7:***************************************************** 5?n7:* SUBROUTINE PARSE_DISP_OFF_REG                     * r?x7:* Trys to parse TARGET$ as an offset off a register * ?7:* If sucessful, sets FOUND true, sets NEEDOFFSET    * ?7:* to the offset's type, and OFFSET to it's value .  * )@7:***************************************************** 1@7: S@7PDOR$  TARGET$  :save copy [@7: o@7:special case @7  TARGET$  "[BP]"  REGVAL  : NEEDOFFSET  IMMED8: OFFSET  :               N9 @7: @7:parse reg spec. A7 :set ptr to candidate  A7  PTR  (TARGET$,"[") IA7   PTR    v9  :no disp, exit cA8 :isolate candidate A8  REG$  (PDOR$,(PDOR$)PTR) A8 :valid reg. spec? A"8   REG$  "[BP]"  REGVAL  :  h8 A,8  TARGET$  REG$ B68   .  :operand_lookup 5B@8    FOUND  SYMTYPE(TABLEPTR)  MEMREG  v9 NBJ8   :save reg value nBT8    REGVAL  VAL1(TABLEPTR) vB^8: Bh8:now parse disp. Br8 :isolate candidate B|8  DISP$  (PDOR$,PTR) B8 :valid disp? B8  TARGET$  DISP$ 	C8   :might be symbol +C8     .   :operand_lookup PC8      FOUND  8   :not sym C8     (SYMTYPE(TABLEPTR)  (IMMED16  IMMED8))  FALSE  8 C8      NEEDOFFSET  SYMTYPE(TABLEPTR) C8      OFFSET  VAL1(TABLEPTR) C8       N9  D8   :or number D8     4   :test_number 7D8      FOUND  9 VD8      NEEDOFFSET  NUMTYPE pD9      OFFSET  NUMVAL D9           N9 D9   :or offset D&9     9 :offset D09      FOUND  v9 D:9      NEEDOFFSET  OFFSETYPE ED9      OFFSET  OFFSETVAL EN9:sucess exit .EX9 TARGET$  PDOR$ @Eb9 FOUND  TRUE GEl9  [Ev9:failure exit pE9 TARGET$  PDOR$ E9 FOUND  FALSE E9  E9:***************************************************  F9:* SUBROUTINE OFFSET                               * ;F9:* Trys to interpret TARGET$ as an offset operand. * vF9:* If sucessful, set FOUND, set OFFSETYPE          * F9:* immed16, and TARGVAL1 to the label's offset.    * F9:*************************************************** F9: G9OS$  TARGET$ G9: >G9 (OS$,)  "OFFSET("  FOUND  FALSE:  SG: PASS    : [G:: pG::isolate label G :  TARGET$  (TARGET$,,(TARGET$)) G*:: G4::look it up G>:   . :operand_lookup GH:: HR: FOUND  (SYMTYPE(TABLEPTR)  (MEM  NEAR))  : )H\:  ERRS  ERRS   jHf:  #, "****Error: Illegal or undefined argument for Offset" ~Hp:  OFFSETVAL   Hz:   : H:: H:OFFSETVAL  VAL1(TABLEPTR) H:: H:FOUND  TRUE H:OFFSETYPE  IMMED16 H:TARGET$  OS$ H: )I::*************************************** XI::* SUBROUTINE CHAR                     * I::* Trys to interpret TARGET$ as a char * I::*************************************** I:FOUND  FALSE I: (TARGET$)     J; (TARGET$,)  "'"   !J; (TARGET$,)  "'"   5J;   FOUND  TRUE ZJ$;   CHARVAL  ((TARGET$,,)) `J.; J8;:************************************* JB;:* SUBROUTINE MACHOP                 * JL;:* Updates loctr based on op length. * KV;:* On pass 2, generates obj. code.   * AK`;:************************************* IKj;: _Kt; =  :op_type gK~;: uK;:opcode K; LOCTR  LOCTR   K;  PASS     >  :build_opcode K;: K;:2nd op byte? L;  (OPVAL(OPPTR)   )  (OPVAL(OPPTR)   )  ; %L;   LOCTR  LOCTR   `L;    PASS    OBJLEN  OBJLEN  : OBJ(OBJLEN)  
  hL;: L;:room for m. byte disp. (must go here, modebyte modifys offset) L;  NEEDOFFSET  NONE  
< 6M;    (NEEDOFFSET  IMMED8)  LOCTR  LOCTR                                    : LOCTR  LOCTR   >M <: wM
<:if direct addr. mode byte, leave room for address M<  (FLAG  (NEEDMODEBYTE  NEEDEXT))  FALSE  2< M<    (DTYPE  STYPE)  MEM  LOCTR  LOCTR   M(<:  N2<:extension byte? &N<<  (FLAG  NEEDEXT)  FALSE  d< ?NF<   LOCTR  LOCTR   hNP<    PASS     ?   :build_ext pNZ<: Nd<:mode byte? Nn<  (FLAG  NEEDMODEBYTE)  FALSE  < Nx<   LOCTR  LOCTR   N<    PASS     L@  :build_modebyte N<: O<:8 bit disp.? 6O<  (FLAG  NEEDISP8)  FALSE  < OO<   LOCTR  LOCTR   yO<    PASS     ^B  :build_disp8 O<: O<:16 bit disp.? O<  (FLAG  NEEDISP16)  FALSE  < O<   LOCTR  LOCTR   P<    PASS     :C :build_disp16 	P<:  P<:immediate byte? IP=  (FLAG  NEEDIMMED8)  FALSE  "= bP=   LOCTR  LOCTR   |P=    PASS     D P"=  WORD  ((FLAG  NEEDIMMED)  FALSE)  J= P,=   LOCTR  LOCTR   P6=    PASS     D   :build_immed8 P@=: QJ=:immediate word(s)? HQT=  (WORD)  ((FLAG  NEEDIMMED)  FALSE)  |= Q^=    DTYPE  IMMED16  LOCTR  LOCTR   : LOCTR  LOCTR   Qh=    PASS     D  :build_immed16 Qr=: Q|=:mem. addr.? Q=  (FLAG  NEEDMEM)  FALSE  = R=   LOCTR  LOCTR   7R=    PASS     BE  :mem_addr ?R=: ER= qR=:************************************ R=:* SUBROUTINE OP_TYPE               * R=:* Decides between word & byte ops. * R=:************************************ R=: 7S= (DTYPE  STYPE)  (REG16  ACUM16  SEG  CS)  > dS= (DTYPE  STYPE)  (REG8  ACUM8)  D> lS=: S> (OP$,)  "B"  D> S>: S>:word S&> WORD  TRUE S0>  S:>: SD>:byte SN> WORD  FALSE SX>  Tb>:********************************************** MTl>:* SUBROUTINE PSEUDO-OP                       * Tv>:* Branches to routines to handle each pseudo * T>:* op using the value field as an index.      * T>:********************************************** T>: )U> OPVAL(OPPTR)  E, F, F, NH, 4I, I nU>:                      EQU    ORG    DB     DS     PROC   ENDP tU> U>:********************************************************** U>:* SUBROUTINE BUILD_OPCODE                                * :V>:* Builds opcode, stores it in obj. Increments objlength. * |V>:********************************************************** V>: V>OBJLEN  OBJLEN   V>OBJ(OBJLEN)  OPVAL(OPPTR) V?: V?:add reg. field if requested W?  (FLAG  ADDREG)  FALSE  f? "W ?   :segment reg. RW*?     DTYPE  (SEG  CS)  R  DVAL2:  R? hW4?   :normal reg. W>?     (FLAG  DIRECTION)  R  SVAL2 : R  DVAL2 WH?: WR?   OBJ(OBJLEN)  OBJ(OBJLEN)  R W\?: Wf?:auto word bit? Xp?  (FLAG  AUTOW)  FALSE  ? ?Xz?    WORD  OBJ(OBJLEN)  OBJ(OBJLEN)   GX?: ^X?:auto count bit? X?  (FLAG  AUTOC)  FALSE  ? X?    STYPE  CL  OBJ(OBJLEN)  OBJ(OBJLEN)   X?: X? X?:************************************************** 8Y?:* SUBROUTINE BUILD_EXTENSION_BYTE                * rY?:* Builds an opcode extension byte.  The ext. val * Y?:* is extracted from bits 3-5 of the flag word.   * Y?:************************************************** Y?: Y?:get ext. Z@ MASK  8  %Z@ EXT  FLAG  MASK -Z@: dZ$@:define proper operand as ext. & build mode byte Z.@   FLAG  DIRECTION  DVAL2  EXT : SVAL2  EXT Z8@   L@  :build_modebyte ZB@ [L@:*************************************************************** M[V@:* SUBROUTINE BUILD_MODE_BYTE                                  * [`@:* Given direction flag, memreg values in dval1 and sval1 and  * [j@:* reg values in dval2 and sval2, builds an addressing mode    * "\t@:* byte.  If necessary, also builds displacement byte(s).      * i\~@:*************************************************************** q\@: \@OBJLEN  OBJLEN   \@: \@:special case: direct mem. addressing? \@  ((DTYPE  STYPE)  MEM)  FALSE  @ ]@    DTYPE  MEM   M  SVAL2 : M  DVAL2 7]@     OBJ(OBJLEN)    M Y]@      BE  :build_mem_addr d]@      l]@: ]@:normal mode byte ]@ :operands in normal or reverse order? ] A   FLAG  DIRECTION  M  SVAL1  DVAL2 : M  DVAL1  SVAL2 ]
A: ^A OBJ(OBJLEN)  M ^A: /^(A:offset byte(s)? 7^2A: U^<A NEEDOFFSET  NONE  A ]^FA: p^PA:8 bit disp. ^ZA OFFSET    OFFSET    A ^dA  OBJ(OBJLEN)  OBJ(OBJLEN)  @  :set mod field ^nA  :crunch neg. offset to 8 bits !_xA     OFFSET    OFFSET  OFFSET    ;_A  OBJLEN  OBJLEN   V_A  OBJ(OBJLEN)  OFFSET ^_A   f_A: z_A:16 bit disp. _A OBJ(OBJLEN)  OBJ(OBJLEN)    :set mod field _A OBJLEN  OBJLEN   _A :convert to hi/low form `A    NUMLOW  OFFSET:  A  :hi/low .`A OBJ(OBJLEN)  NUMLOW I`A OBJ(OBJLEN)  NUMHIGH O`A `A:************************************************ `B:* SUBROUTINE HI/LOW                            * `B:* Splits 16 bit number in numlow, into two     * /aB:* byte-sized componants in numhigh and numlow. * ga"B:************************************************ {a,BH$  (NUMLOW) a6BH$  ((H$),"0")  H$ a@BNUMLOW   ("&H"  (H$,)) aJBNUMHIGH  ("&H"  (H$,)) aTB b^B:********************************************* MbhB:* SUBROUTINE BUILD_DISP8                    * brB:* Calculates the disp. from the present     * b|B:* loc to the loc given as an operand.       * bB:* Prints error message if disp. exceeds 127.* !cB:********************************************* )cB: @cB:calculate disp. WcB D  DVAL1  LOCTR _cB: qcB:check size cB  (D)    B cB   D   cB    PASS    #,"****Error: Too far for short jump":                     ERRS  ERRS   cB: dB:if neg. crunch to 8 bits :dB  D    D  D    BdC: YdC:build obj. code rdC OBJLEN  OBJLEN   d&C OBJ(OBJLEN)  D d0C d:C:******************************************** dDC:* SUBROUTINE BUILD_DISP16                  * )eNC:* Builds 16 bit displacement. Prints error * ]eXC:* msg. for negative disps not on CALL ops. * ebC:******************************************** elC: evC:calculate disp. eC D  DVAL1  LOCTR eC: *fC OP$  "JMP"  D  #, "****Diagnostic: Could use JMPS" :        DIAG  DIAG   2fC: @fC:legal? cfC  D    OP$  "CALL"  C pfC   D   fC    PASS    #,"****Error: Illegal reverse long jump":                  ERRS  ERRS   fC: fC:build obj. code gC NUMLOW  D:  A  :hi/low +gC OBJLEN  OBJLEN   GgC OBJ(OBJLEN)  NUMLOW bgD OBJ(OBJLEN)  NUMHIGH hgD gD:************************************ g D:* SUBROUTINE BUILD_IMMED16         * g*D:* Builds word(s) of immediate data * h4D:************************************  h>D: LhHD DTYPE  IMMED16  IVAL  DVAL1:  fD xhRD STYPE  IMMED16  IVAL  SVAL1:  fD ~h\D hfD:internal subroutine immed16 hpDNUMLOW  IVAL:  A   :hi/low hzDOBJLEN  OBJLEN   hDOBJ(OBJLEN)  NUMLOW iDOBJ(OBJLEN)  NUMHIGH iD CiD:********************************** miD:* SUBROUTINE BUILD_IMMED8        * iD:* Builds byte of immediate data. * iD:********************************** iD: iD DTYPE  IMMED8  IVAL  DVAL1:  D jD STYPE  IMMED8  IVAL  SVAL1:  D %jD =jD:int. sub. immed8 `jD IVAL    IVAL    $E ojE  IVAL   jE   PASS    ERRS  ERRS  : #,"****Error: Data too long" jE: j$EOBJLEN  OBJLEN   j.EOBJ(OBJLEN)  IVAL j8E kBE:********************************* AkLE:* SUBROUTINE MEMREF             * jkVE:* Builds a memory address word. * k`E:********************************* kjE: ktE:get addr. in hi/low form k~E  DTYPE  MEM  NUMLOW  DVAL1 : NUMLOW  SVAL1 kE  A lE:build word 'lE OBJLEN  OBJLEN   ClE OBJ(OBJLEN)  NUMLOW ^lE OBJ(OBJLEN)  NUMHIGH dlE lE:*************************** lE:* SUBROUTINE EQU          * lE:* Handles equ pseudo-op.  * lE:*************************** lE: mE (LABEL$  "")   F Zm F   PASS    ERRS  ERRS: #,"****Error: EQU without symbol" bm
F   jmF: mF PASS    xF m(F: m2F DTYPE  (NEAR  MEM)  dF   :pass 1 default if not found m<F  ERRS  ERRS   nFF  #, "****Error: EQU with forward referance in ";LINENUM 'nPF   /nZF: HndFVAL1(NUMSYM)  DVAL1 dnnFSYMTYPE(NUMSYM)  DTYPE jnxF nF:************************** nF:* SUBROUTINE ORG         * nF:* Handles org pseudo-op. * nF:************************** nF: oF:set loctr to new value +oF LOCTR  DVAL1 1oF RoF:************************* soF:* SUBROUTINE DB         * oF:* Handles db pseudo-op. * oF:************************* oF: oG:label? set type to mem pG  LABEL$  ""  SYMTYPE(NUMSYM)  MEM pG: <p"G:scan operand area, building obj. code ep,G LINEPTR  OPDPTR: LINEPTR2  OPDPTR ~p6G  LINEPTR  ENDPTR p@G  :get operand pJG    ,  :get_field pTG     FOUND  G  :exit p^G  :branch for byte value or string #qhG   TARGET$  FLD$:  4 :test_number WqrG     FOUND  (NUMTYPE  IMMED8)  FALSE  G uq|G      G  :build_byte qG      G qG    (FLD$,)  "'"  G qG      H  :build_stg qG      G rG  :if not byte or string, error on pass 2 brG    PASS    #,"****Error: unrecognized operand ";FLD$:                 ERRS  ERRS   jrG   rGLOCTR  LOCTR  OBJLEN rG rG:subroutine build_byte rGOBJLEN  OBJLEN   rGOBJ(OBJLEN)  NUMVAL rG rH:subroutine build_stg ,sHFLD$  (FLD$,,(FLD$)) :strip off 's CsH I    (FLD$) ]s&H  OBJLEN  OBJLEN   s0H  OBJ(OBJLEN)  ((FLD$,I,)) s:H   I sDH sNH:************************* sXH:* SUBROUTINE DS         * sbH:* Handles ds pseudo-op. * tlH:************************* tvH: HtHDSFLAG  TRUE  :signal this is a ds PtH: ntH:label? set type to mem tH  LABEL$  ""  SYMTYPE(NUMSYM)  MEM tH: tH:set output code tH  STYPE  IMMED8  DSVAL  SVAL1 : DSVAL   tH: "uH:on pass 2, generate obj. code directly 8uH  PASS    I OuH    I    DVAL1 tuH      BYTE$  (DSVAL):  # uH      I uI: uI:advance loctr uI LOCTR  LOCTR  DVAL1 u I: u*I u4I:*************************** 
v>I:* SUBROUTINE PROC         * 0vHI:* Handles proc pseudo-op. * SvRI:*************************** [v\I: wvfI STKTOP  MAXSTK  I vpI   PASS    I vzI    ERRS  ERRS   vI    #, "****Error: Procedures nested too deeply" vI   vI: wI:push new proc type for returns ,wI STKTOP  STKTOP   JwI PROCTYPE(STKTOP)  DTYPE PwI lwI:******************** wI:* SUBROUTINE ENDP  * wI:* Pops proc stack. * wI:******************** wI: wI STKTOP    8J wJ   PASS    $J xJ    ERRS  ERRS   :xJ    #, "****Error: ENDP without PROC" Bx$J   Jx.J: bx8JSTKTOP  STKTOP   hxBJ xLJ:************************************ xVJ:* SUBROUTINE OUTPUT                * x`J:* Outputs obj code & listing line, * yjJ:* given code in obj(objlength).    * DytJ:************************************ Ly~J: yJ DSFLAG  H$  (LOCTRDVAL1) : H$  (LOCTROBJLEN) yJH$  ((H$),"0")  H$ yJ#, ) H$; yJ:first 6 bytes yJ I   yJ #, ) yJ  I   zJ    I  OBJLEN  K 3zJ    BYTE$  (OBJ(I)):  # hzJ   H$  (OBJ(I)):  (H$)    H$  "0"  H$ xzJ   #, H$; zJ   I  I   z K    z
K: zK:source (truncate if necessary) zK #, ) z(K #,  "####"; LINENUM; {2K #, () (INPLINE$, LWIDTH) {<K: 5{FK:rest of obj. code I{PK  I  OBJLEN g{ZK    I      #, ) {dK    BYTE$  (OBJ(I)):  # {nK   H$  (OBJ(I)):  (H$)    H$  "0"  H$ {xK   #, H$; {K   I  I   {K    |K OBJLEN    #, |K +|K:*************************** N|K:* SUBROUTINE PASSTWO_INIT * q|K:*************************** y|K: |K:reset input file |K  #:  SC$   AS # |K: |KPASS   |KLOCTR    |LLINENUM   |L: |L }"L:************************ /},L:* SUBROUTINE FINALPROC * O}6L:* Cleanup              * o}@L:************************ w}JL: }TL STKTOP    ERRS  ERRS  : #,"****Error: missing ENDP" }^L: }hL#,: #,: #, ERRS; "Error(s) detected" ~rL#, DIAG; "Diagnostic(s) offered" -~|L:dump sym table 8~L  L X~L:return printer to normal }~L  L$  "lpt1:"  #, PMODEOFF$ ~L:hang onto screen listing ~L  L$  "scrn:"  L ~L   : :  , ~L    ) "Hit any key to exit" O); L   C$  :  C$  ""  L !L    , 'L LL:***************************** qL:* SUBROUTINE DUMP_SYM_TABLE * L:***************************** M: M#,: #, "SYMBOL TABLE DUMP:" MI  PREDEF    &MF$   "\        \!\  \\  \"  :format 0MPERLINE  LWIDTH  (F$) 1:M I  NUMSYM cDM  H$  (VAL1(I)): H$  ((H$),"0")  H$ NM  #,  F$; SYM$(I); " ";  H$; "    "; XM  I  I   ǀbM   (IPREDEF)  PERLINE    #, πlM   ؀vM#, ހM M:************************************* 8M:* SUBROUTINE PROGESS REPORT         * eM:* Maintains reassuring msg. on scrn * M:************************************* M: MX  (): Y  :  ,:  , M PASS     "First"; :  "Second"; !M " pass in progress. Lines processed = "; LINENUM; ;M O);:  ,:  Y,X AM qM:**************************************** M:* SUBROUTINE SET_UP_SYMBOL_TABLE       * тN:* Sets up sym table, & opens obj. file * N:**************************************** 	N: 7 N#, PREDEF, MAXSYM:  #, C$:  #, C$ w*N SYM$(MAXSYM), VAL1(MAXSYM), VAL2(PREDEF), SYMTYPE(MAXSYM) 4N: >N I    PREDEF  :# of pre-defined syms ߃HN  #, SYM$(I), VAL1(I), VAL2(I), SYMTYPE(I) RN   I \NNUMSYM  PREDEF fN: pN # 4zN O$ AS # :  #, AS BYTE$ :N dP:********************************** Z:* SUBROUTINE INIT                * d:* Initializes all but sym table. * n:********************************** x: í AZ ERRS  : DIAG   : %:title page 0   H:define constants S   e:open files p   :op table    :listing header    Ď :************************************************* $:* SUBROUTINE TITLE                              * ]":* Prints title page, & waits for user response. * ,:************************************************* 6: @ ,,:  P:  : :  ,, ݆Jđ )"";(8,"");" Tđ )""E)" ^đ )"" )"CHASM  version 1.9"E)" 1hđ )""E)" irđ )"")"Cheap Assembler for the IBM PC"E)" }|đ )""E)" Çđ )"      If you have used this program and found it of      	đ )"   value, your $20 contribution will be appreciated.     đ )""E)" Dđ )"")"David Whitman"E)" pđ )"")"Dept. of Chemistry"E)" đ )"")"Dartmouth College"E)" ǈđ )"")"Hanover, NH  03755"E)" ۈđ )""E)" !đ )"   You are encouraged to copy and share this program.    5đ )""E)" Tđ ) "";(8,"");"": đ ) "Hit any key to continue...":: I$  :  I$  ""   :  ɉ:**************************** :* SUBROUTINE SET_CONSTANTS * &:****************************  0:general :: TRUE  : FALSE   BD: UN:flag values ~X:bits 3-5 reserved for ext. values b MACHOP  : AUTOW  : ADDREG  @: NEEDEXT   l NEEDISP8   : NEEDISP16   : NEEDMODEBYTE   : NEEDIMMED8    Av NEEDIMMED   : DIRECTION    : NEEDMEM   @: AUTOC    I: ^:operand types  ACUM8  : ACUM16  : REG8  : REG16  : MEMREG  : CS    勞 SEG  @: MEM  : IMMED8   : IMMED16   : NONE     STRING   : NEAR   : FAR    : CL   @  : .:arrays MMAXOBJ  2:  OBJ(MAXOBJ) }MAXSTK  
:  PROCTYPE(MAXSTK): STKTOP   Ŏ :***************************************************** :* SUBROUTINE OPEN_FILES                             * ::* Prompts user for i/o filenames, then opens files. * w:***************************************************** : ƕ   8  : *:input file ٍ4  ,: "Source code file name? [.asm] ", S$ >  S$  ""  :  4 H :if no extension, add default ߎR     (S$,".")                                                                 SC$  S$  ".asm"                                                          : SC$  S$: S$  (S$,(S$,".")) \    SC$   AS # f  , Dp "Direct listing to Printer (P), Screen (S), or Disk (D)?",L$ ^z  L$  ""  :  f     ("PpSsDd",L$)    :  f  :invalid response ۏ    L$  "P"  L$  "p"  L$  "lpt1:" :    :printer?     L$  "S"  L$  "s"  L$  "scrn:" :    :screen? <      ,:  (O);:  , n     "Name for listing file? [";S$;".lst] ";       "",L$       L$  ""  L$  S$  ".lst"  :default to source name ې    L$  OUTPUT AS # Ƒ#, :test listing device :object file D  ,:  "Name for object file?  [";S$;".com] "; Q  "",O$ y :default to source file name.com     O$  ""  O$  S$  ".com" đ :will open after symtable setup Ǖ      :kill error trapping $ : :  .ǎ 8:**************** ,B:*Error Handler * DL:**************** LV: ``ǋ   5   oj   ,:  t   SC$; " not found.  Press Esc to exit, anything else to continue."; ڒ~  SC$  :  SC$  ""  ~    SC$  ()      ,:  ,:  (O); 7   ,:  (0); :  ,:  4 ?: Sǋ      i    #:  ,:     "Printer not available.  Press any key to continue."; Ǔ   L$   :  L$  ""       ,:  ,:  (O);     ,8:  ();:  ,:  p         ::*********************** Y :* SUBROUTINE OP_TABLE * x
:*********************** : Ⱥ "chasm.dat"   AS # ǔ(:note: c$ used to skip data comments ϔ2: <ȅ#, NUMOP:  #,C$:  #, C$ &FȆ OPCODE$(NUMOP), OPVAL(NUMOP), SRCTYPE(NUMOP) IPȆ DSTTYPE(NUMOP), OFLAG(NUMOP) QZ: edȂ I    NUMOP n  #, OPCODE$(I),OPVAL(I),DSTTYPE(I),SRCTYPE(I),OFLAG(I) x   #, C$    I ÕȎ 䕖:************************* :* SUBROUTINE HEADER     * &:* Prints listing header.* G:************************* O: qLWIDTH  O  :default width y: :title & date Ŗ D$  (,)  "/"  (,,)  "/"   (,)  #, SC$ LWIDTH(D$)) D$:#,:#, : :printer set up? *  L$  "lpt1:"  T p   :for NEC 8023 printer, remove quotes for auto condensed mode "   :similar code may be substituted for other printers. ٗ,: LWIDTH = 131: WIDTH #2, LWIDTH + 1 6: PRINT#2, CHR$(27) + "Q" 'pmodeon %@: PMODEOFF$ = CHR$(27) + "N" -J: DT:column headings v^ #,"LOC")"OBJ")"LINE")"SOURCE":#, ~h: rɎ    PM