TITLE NWS - ASSEMBLER PROGRAM TO STRIP HI-ORDER BITS FROM WORDSTAR FILES
SUBTTL DESCRIPTION OF THE STACK SEGMENT
        PAGE
STACK   SEGMENT PARA STACK 'STACK'
        DB      64 DUP('STACK   ')
STACK   ENDS
SUBTTL DESCRIPTION OF THE DATA SEGMENT
        PAGE
WORKAREA SEGMENT PARA PUBLIC 'DATA'
LOGO    DB      '       ***********************************************************************',10,13
        db      '       *                                                                     *',10,13
        db      '       *                        UN - Wordstar                                *',10,13
        db      '       *   A program to remove the high-order bits from Wordstar data        *',10,13
        db      '       *   files.  You are prompted for the input and output file names.     *',10,13
        db      '       *                                                                     *',10,13
        db      '       *     Written as an assembler language example by Gene Plantz         *',10,13
        db      '       ***********************************************************************',10,10,10,10,13,'$'
donem   db      '-------->    DONE    <-------------',10,13,'$'
eofflag db      0
crlf    db      10,13,'$'       ;issue carriage return-linefeed after input
fcb1    db      40 dup(0)       ;input file  only needs to be 36 (but safe)
fcb2    db      40 dup(0)       ;file control block for output
err0    db      7,7,'--->  ERROR Opening INPUT file  <--------',10,13,'$'
err1    db      7,7,'--->  ERROR.. not enough disk space for output <---',10,13,'$'
err2    db      7,7,'--->  ERROR.... bad file name given. <----',10,13,'$'
parms   db      14              ;max size of reply
repson  db      ?               ;size of what they typed
name1   db      20  dup(' ')    ;this is where the users reply goes
parms2  db      14              ;max size of input
resp2   db      ?               ;size of what they really typed in
name2   db      20  dup(' ')    ;this is where the reply goes
ask1    db      10,10,13,'Please Enter the name of the input file    $'
ask2    db      'Please Enter the name of the output file   $'
buffer  db      128 dup(' ')            ;record  buffer
workarea ends
;
subttl desciption of dos interfaces
cseg    segment para public 'CODE'
start   proc    far
        assume cs:cseg,ds:workarea,ss:stack,es:workarea
        org     100h
        push    ds                      ;set up starting linkage as per dxample
        sub     ax,ax                   ;zero this and place on stack
        push    ax                      ;so that when we do a RET we go to 
        mov     ax,workarea             ;location 0;  point to our workarea
        mov     ds,ax                   ;move the workarea address into DS
        mov     es,ax                   ;also into ES for the function 29H
        call    cls                     ;call subroutine to clear the screen
        mov     dh,3                    ;set cursor to row 8
        mov     dl,0                    ;set cursor to column 0
        mov     bh,0                    ;use screen number 0
        mov     ah,2                    ;function 2 to locate cursor
        int     10h                     ; go do it
        mov     dx,offset logo          ;display the logo where we put cursor
        mov     ah,9                    ;function 9 is print string
        int     21h                     ;call dos to do it
;
        mov     dx,offset ask1          ;point to message to display
        mov     ah,9                    ;tell DOS what function (print string)
        int     21h                     ;call DOS
;
        mov     dx,offset parms         ;point to console input buffer
        mov     ah,10                   ;read console buffer
        int     21h                     ;do it
;
        mov     si,offset name1         ;put address of name1 into SI
        mov     di,offset fcb1          ;put address of file control block DI
        mov     ah,29h                  ;tell DOS to parse filename
        int     21h                     ;do it
;
        mov    dx,offset crlf           ;do a carriage return-line feed
        mov     ah,9                    ;after the reply 
        int     21h                     ;to DOS
;
        mov     al,[di+1]               ;if DI+1 = blank, no file name
        cmp     al,20h                  ;if blank, error
        jnz     isok
        jmp     error2
;
isok:
        mov     dx,offset ask2          ;ask user for name of new file
        mov     ah,9                    ;display question
        int     21h                     ;DOS
;
        mov     dx,offset parms2        ;put address of input buffer into DX
        mov     ah,10                   ;get input from user
        int     21h                     ;DOS
;
        mov     dx,offset crlf          ;another cr,lf
        mov     ah,9
        int     21h
;
        mov     si,offset name2         ;SI = address of field NAME2
        mov     di,offset fcb2          ;DI = address of second file control 
        mov     ah,29h                  ;ask DOS to parse filename
        int     21h                     ;DOS
;
        mov     al,[di+1]               ;if DI+1 = blank, error
        cmp     al,20h                  ;is it blank??
        jz      error2                  ;tell him and leave     yyyyy
;
        mov     dx,offset fcb1          ;point to first fcb
        mov     ah,15                   ;open the input file
        int     21h                     ;call dos to do it 
;
        cmp     al,0                    ;see if ok
        jnz     error0                  ;tell him and leave
;
        mov     dx,offset fcb2          ;address of fcb2
        mov     ah,16h                  ;create out put file
        int     21h                     ;this does open, too
;
        mov     dx,offset buffer        ;point to out record buffer
        mov     ah,1ah                  ;tell DOS to put disk data there
        int     21h                     ;DOS
;
readl:  cmp     eofflag,1               ;see if end-of-file was reached
        jz      closeall                ;yes, wrap it up and leave
        mov     dx,offset fcb1          ;read from file 1
        mov     ah,14h                  ;sequential read from disk
        int     21h                     ;DOS
;
        cmp     al,0                    ;see if normal return
        jz      readok                  ;if zero, ok
        mov     eofflag,1               ;no, set end-of-file flag
        jmp     readl                   ;back to read
;
readok: 
        mov     cx,128                  ;size of logical record
        mov     si,offset buffer        ;SI = address of our buffer
andloop:
                                        ;these 3 lines were used because
                                        ;   AND [SI],7FH    wouldn't assemble
                                        ;
        mov     al,[si]                 ;and out the hi-bit 
        and     al,7fh
        mov     [si],al                 ;put it back
;
        inc     si                      ;bump pointer to next char in buffer
        loop    andloop                 ;do it 128 times (in CX)
;
        mov     dx,offset fcb2          ;point to output fcb
        mov     ah,15h                  ;sequential write
        int     21h
        cmp     al,1                    ;this means disk full
        jz      error1
;
        jmp     readl                   ;do it again
;
closeall:
        mov     dx,offset fcb2          ;close output file
        mov     ah,10h          
        int     21h
;
        mov     dx,offset donem         ;iisue DONE message
        mov     ah,9
        int     21h
        jmp     exit
;
error2: mov     dx,offset err2          ;err mess 2
        jmp     errorm
error1: mov     dx,offset err1          ;point to error mess number 1
        jmp     errorm
error0: mov     dx,offset err0
errorm:
        mov     ah,9                    ;print it
        int     21h
        jmp     closeall
exit:   ret
start   endp
;
;
subttl clear screen routine
cls     proc    near
        mov     cx,0
        mov     dx,2479h
        mov     bh,7
        mov     ax,600h
        int     10h
        ret
cls     endp
;
;
cseg    ends
        end     start
